/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import oracle.javatools.util.NamedThreadFactory;
import oracle.javatools.util.UnexpectedExceptionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Executors {
    private static boolean privilegesChecked;

    private Executors() {
    }

    public static ThreadFactory namedThreadFactory(String baseName) {
        if (baseName == null) {
            throw new NullPointerException("baseName is null");
        }
        return new NamedThreadFactory(baseName);
    }

    public static void shutdown(ExecutorService executor) {
        1 action = new 1(executor);
        Executors.perform(action);
    }

    public static List<Runnable> shutdownNow(ExecutorService executor) {
        2 action = new 2(executor);
        return (List)Executors.perform(action);
    }

    private static <T> T perform(PrivilegedAction<T> action) {
        if (!privilegesChecked) {
            privilegesChecked = true;
            try {
                Class.forName("java.util.concurrent.BlockingDeque");
            }
            catch (ClassNotFoundException e) {
                try {
                    ProtectionDomain d = Executors.class.getProtectionDomain();
                    Permissions permissions = (Permissions)d.getPermissions();
                    Field field = PermissionCollection.class.getDeclaredField("readOnly");
                    field.setAccessible(true);
                    field.setBoolean(permissions, false);
                    permissions.add(new RuntimePermission("modifyThread"));
                    field.setBoolean(permissions, true);
                }
                catch (NoSuchFieldException f) {
                    throw new UnexpectedExceptionError(e);
                }
                catch (IllegalAccessException f) {
                    throw new UnexpectedExceptionError(e);
                }
            }
        }
        return AccessController.doPrivileged(action);
    }

    static final class 1
    implements PrivilegedAction {
        private final /* synthetic */ ExecutorService v$executor;

        public Void run() {
            this.v$executor.shutdown();
            return null;
        }

        public 1(ExecutorService executorService) {
            this.v$executor = executorService;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 2
    implements PrivilegedAction {
        private final /* synthetic */ ExecutorService v$executor;

        public List<Runnable> run() {
            return this.v$executor.shutdownNow();
        }

        public 2(ExecutorService executorService) {
            this.v$executor = executorService;
        }
    }
}

