/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import oracle.javatools.util.UnexpectedExceptionError;

public class Maps {

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractHashMap<K, V, E extends AbstractEntry<K, V>>
    implements Map<K, V>,
    Cloneable,
    Serializable {
        public static final int DEFAULT_INITIAL_CAPACITY = 16;
        public static final int MAXIMUM_CAPACITY = 0x40000000;
        public static final float DEFAULT_LOAD_FACTOR = 0.75f;
        static final /* synthetic */ boolean $assertionsDisabled;
        private int threshold;
        private final float loadFactor;
        private transient E[] table;
        private transient int size;
        private volatile transient int changeCount;
        private transient ReferenceQueue<V> queue;
        private transient boolean purging;
        private volatile transient Set<K> keySet;
        private volatile transient Collection<V> values;
        private transient Set<Map.Entry<K, V>> entrySet;
        private static final long serialVersionUID = 362498820763181265L;

        protected AbstractHashMap(int initialCapacity, float loadFactor, Map<? extends K, ? extends V> map) {
            this.$init$();
            if (initialCapacity < 0) {
                throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
            }
            if (initialCapacity > 0x40000000) {
                initialCapacity = 0x40000000;
            }
            if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
                throw new IllegalArgumentException("Illegal load factor: " + loadFactor);
            }
            int capacity = 1;
            while (capacity < initialCapacity) {
                capacity <<= 1;
            }
            this.loadFactor = loadFactor;
            this.threshold = (int)((float)capacity * loadFactor);
            this.table = this.createTable(capacity);
            this.mapConstructedInternal();
            if (map != null) {
                for (Map.Entry<K, V> e : map.entrySet()) {
                    this.addEntry(e.getKey(), e.getValue());
                }
            }
            this.mapInitializedInternal();
        }

        protected AbstractHashMap(Map<? extends K, ? extends V> map) {
            this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f, AbstractHashMap.notNull(map));
        }

        private static <K, V> Map<? extends K, ? extends V> notNull(Map<? extends K, ? extends V> map) {
            if (map == null) {
                throw new NullPointerException();
            }
            return map;
        }

        protected abstract E createEntry(int var1, K var2, V var3, E var4);

        protected int keyHashCode(Object key) {
            return key.hashCode();
        }

        protected boolean keyEquals(Object key1, Object key2) {
            return key1 == key2 || key1.equals(key2);
        }

        protected int valueHashCode(Object value) {
            return value.hashCode();
        }

        protected boolean valueEquals(Object value1, Object value2) {
            return value1 == value2 || value1.equals(value2);
        }

        protected void purge() {
            if (this.queue != null && !this.purging) {
                try {
                    this.purging = true;
                    Reference<V> entry = this.queue.poll();
                    while (entry != null) {
                        this.purgeEntry((AbstractEntry)((Object)entry));
                        entry = this.queue.poll();
                    }
                }
                finally {
                    this.purging = false;
                }
            }
        }

        protected final ReferenceQueue<V> getQueue() {
            if (this.queue == null) {
                this.queue = new ReferenceQueue();
            }
            return this.queue;
        }

        protected void mapConstructed() {
        }

        protected void mapInitialized() {
        }

        protected void mapChanged() {
        }

        protected void entryAdded(E entry) {
        }

        protected void entryChanged(E oldEntry, V oldValue, E newEntry) {
        }

        protected void entryAccessed(E entry) {
        }

        protected void entryRemoved(E entry) {
        }

        protected void entryPurged(E entry) {
        }

        void mapConstructedInternal() {
            this.changeCount = -1;
            this.mapConstructed();
        }

        static {
            $assertionsDisabled = AbstractHashMap.class.desiredAssertionStatus() ^ true;
        }

        void mapInitializedInternal() {
            if (!$assertionsDisabled && this.changeCount >= 0) {
                throw new AssertionError();
            }
            this.changeCount = 0;
            this.mapInitialized();
        }

        void mapChangedInternal() {
            if (!$assertionsDisabled && this.changeCount < 0) {
                throw new AssertionError();
            }
            this.mapChanged();
        }

        void entryAddedInternal(E entry) {
            this.entryAdded(entry);
        }

        void entryChangedInternal(E oldEntry, V oldValue, E newEntry) {
            this.entryChanged(oldEntry, oldValue, newEntry);
        }

        void entryAccessedInternal(E entry) {
            this.entryAccessed(entry);
        }

        void entryRemovedInternal(E entry) {
            this.entryRemoved(entry);
        }

        void entryPurgedInternal(E entry) {
            this.entryPurged(entry);
        }

        private void $init$() {
            this.changeCount = -1;
        }

        @Override
        public int size() {
            this.purge();
            return this.size;
        }

        @Override
        public boolean isEmpty() {
            return this.size == 0;
        }

        @Override
        public V get(Object key) {
            E entry = this.getEntry(key);
            if (entry != null) {
                this.entryAccessedInternal(entry);
                return entry.getValue();
            }
            return null;
        }

        @Override
        public V put(K key, V value) {
            V oldValue = this.addEntry(key, value);
            if (this.size >= this.threshold) {
                this.resize(2 * this.getTable(true).length);
            }
            return oldValue;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            int sizeToAdd = map.size();
            if (sizeToAdd == 0) {
                return;
            }
            if (sizeToAdd > this.threshold) {
                int targetCapacity = (int)((float)sizeToAdd / this.loadFactor + 1.0f);
                if (targetCapacity > 0x40000000) {
                    targetCapacity = 0x40000000;
                }
                int newCapacity = this.table.length;
                while (newCapacity < targetCapacity) {
                    newCapacity <<= 1;
                }
                if (newCapacity > this.table.length) {
                    this.resize(newCapacity);
                }
            }
            for (Map.Entry<K, V> e : map.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public V remove(Object key) {
            E entry = this.removeKey(key, null);
            return entry != null ? (V)entry.getValue() : null;
        }

        @Override
        public void clear() {
            AbstractEntry[] table = this.getTable(true);
            int i = 0;
            while (i < table.length) {
                table[i] = null;
                ++i;
            }
            this.size = 0;
            this.change();
        }

        @Override
        public boolean containsKey(Object key) {
            if (key != null) {
                int hash = this.keyHashCodeInternal(key);
                AbstractEntry entry = this.getTable(true)[this.tableIndex(hash)];
                while (entry != null) {
                    if (hash == entry.keyHashCode() && this.keyEquals(key, entry.getKey())) {
                        return true;
                    }
                    entry = entry.getNext();
                }
            } else {
                int hash = this.keyHashCodeInternal(key);
                AbstractEntry entry = this.getTable(true)[this.tableIndex(hash)];
                while (entry != null) {
                    if (hash == entry.keyHashCode() && entry.getKey() == null) {
                        return true;
                    }
                    entry = entry.getNext();
                }
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean containsValue(Object value) {
            block2: {
                iterator = this.createEntryIterator();
                if (value != null) ** GOTO lbl11
                while (iterator.hasNext()) {
                    entry = (AbstractEntry)iterator.next();
                    if (entry.getValue() != null) continue;
                    return true;
                }
                break block2;
lbl-1000:
                // 1 sources

                {
                    entry = (AbstractEntry)iterator.next();
                    if (!this.valueEquals(value, entry.getValue())) continue;
                    return true;
lbl11:
                    // 2 sources

                    ** while (iterator.hasNext())
                }
            }
            return false;
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = new KeySet(null);
            }
            return this.keySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = new Values(null);
            }
            return this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new EntrySet(null);
            }
            return this.entrySet;
        }

        public Object clone() {
            try {
                AbstractHashMap clone = (AbstractHashMap)super.clone();
                clone.table = this.createTable(this.table.length);
                clone.entrySet = null;
                clone.size = 0;
                clone.mapConstructedInternal();
                for (Map.Entry<K, V> entry : this.entrySet()) {
                    clone.addEntry(entry.getKey(), entry.getValue());
                }
                AbstractHashMap abstractHashMap = clone;
                return abstractHashMap;
            }
            catch (CloneNotSupportedException e) {
                throw new UnexpectedExceptionError(e);
            }
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Map)) {
                return false;
            }
            Map map = (Map)object;
            if (map.size() != this.size()) {
                return false;
            }
            try {
                for (Map.Entry<K, V> entry : this.entrySet()) {
                    K key = entry.getKey();
                    V value = entry.getValue();
                    if (value == null) {
                        if (map.get(key) == null && map.containsKey(key)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    if (this.valueEquals(value, map.get(key))) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (ClassCastException unused) {
                boolean bl = false;
                return bl;
            }
            catch (NullPointerException unused) {
                boolean bl = false;
                return bl;
            }
            return true;
        }

        @Override
        public int hashCode() {
            return this.entrySet().hashCode();
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Map.Entry<K, V> e = i.next();
                K key = e.getKey();
                V value = e.getValue();
                if (key == this) {
                    buf.append("(this Map)");
                } else {
                    buf.append(key);
                }
                buf.append("=");
                if (value == this) {
                    buf.append("(this Map)");
                } else {
                    buf.append(value);
                }
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("}");
            return buf.toString();
        }

        protected void change() {
            if (this.changeCount >= 0) {
                ++this.changeCount;
                this.mapChangedInternal();
            }
        }

        protected int getChangeCount() {
            return this.changeCount;
        }

        protected Iterator<E> createEntryIterator() {
            return new 1(this);
        }

        protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
            return new 2(this);
        }

        protected Iterator<K> createKeySetIterator() {
            return new 3(this);
        }

        protected Iterator<V> createValuesIterator() {
            return new 4(this);
        }

        protected V addEntry(K key, V value) {
            E newEntry;
            int keyHashCode = this.keyHashCodeInternal(key);
            int index = this.tableIndex(keyHashCode);
            E previous = this.table[index];
            Object e = previous;
            while (e != null) {
                AbstractEntry next = e.getNext();
                if (keyHashCode == e.keyHashCode() && (key != null ? this.keyEquals(key, e.getKey()) : e.getKey() == null)) {
                    Object oldValue = e.getValue();
                    if (e.isMutable()) {
                        e.setValue(value);
                        this.entryChangedInternal(e, oldValue, e);
                    } else {
                        AbstractEntry newEntry2 = this.createEntry(keyHashCode, key, value, next);
                        if (previous == e) {
                            this.table[index] = newEntry2;
                        } else {
                            previous.setNext(newEntry2);
                        }
                        this.entryChangedInternal(e, oldValue, newEntry2);
                    }
                    return oldValue;
                }
                previous = e;
                e = next;
            }
            E oldEntry = this.table[index];
            this.table[index] = newEntry = this.createEntry(keyHashCode, key, value, oldEntry);
            ++this.size;
            this.change();
            this.entryAddedInternal(newEntry);
            return null;
        }

        protected E getEntry(Object key) {
            AbstractEntry[] table = this.getTable(true);
            if (key != null) {
                int hash = this.keyHashCodeInternal(key);
                AbstractEntry entry = table[this.tableIndex(hash)];
                while (!(entry == null || entry.keyHashCode() == hash && this.keyEquals(key, entry.getKey()))) {
                    entry = entry.getNext();
                }
                return (E)entry;
            }
            boolean hash = false;
            AbstractEntry entry = table[this.tableIndex(0)];
            while (entry != null && (entry.keyHashCode() != 0 || entry.getKey() != null)) {
                entry = entry.getNext();
            }
            return (E)entry;
        }

        protected E removeKey(Object key, Map.Entry<K, V> optionalEntryWithValue) {
            AbstractEntry previous;
            AbstractEntry[] table = this.getTable(true);
            int keyHashCode = this.keyHashCodeInternal(key);
            int index = this.tableIndex(keyHashCode);
            AbstractEntry e = previous = table[index];
            while (e != null) {
                AbstractEntry next = e.getNext();
                if (keyHashCode == e.keyHashCode() && (key != null ? this.keyEquals(key, e.getKey()) : e.getKey() == null)) {
                    if (optionalEntryWithValue != null) {
                        V v1 = optionalEntryWithValue.getValue();
                        Object v2 = e.getValue();
                        if (v1 != null ? !this.valueEquals(v1, v2) : v2 != null) {
                            return null;
                        }
                    }
                    --this.size;
                    if (previous == e) {
                        table[index] = next;
                    } else {
                        previous.setNext(next);
                    }
                    this.change();
                    this.entryRemovedInternal(e);
                    return (E)e;
                }
                previous = e;
                e = next;
            }
            return null;
        }

        protected void removeExistingEntry(E entry) {
            if (this.replaceEntryInternal(entry, null, true)) {
                this.change();
                this.entryRemovedInternal(entry);
            }
        }

        protected void purgeEntry(E entry) {
            if (this.replaceEntryInternal(entry, null, false)) {
                this.change();
                this.entryPurgedInternal(entry);
            }
        }

        boolean replaceEntryInternal(E entry, E newEntry, boolean purge) {
            AbstractEntry previous;
            AbstractEntry[] table = this.getTable(purge);
            Object key = entry.getKey();
            int keyHashCode = key != null ? this.keyHashCodeInternal(key) : 0;
            int index = this.tableIndex(keyHashCode);
            AbstractEntry e = previous = table[index];
            while (e != null) {
                AbstractEntry next = e.getNext();
                if (entry == e) {
                    if (newEntry == null) {
                        --this.size;
                        if (previous == e) {
                            table[index] = next;
                        } else {
                            previous.setNext(next);
                        }
                    } else {
                        newEntry.setNext(e.getNext());
                        if (previous == e) {
                            table[index] = newEntry;
                        } else {
                            previous.setNext(newEntry);
                        }
                    }
                    return true;
                }
                previous = e;
                e = next;
            }
            return false;
        }

        private E[] createTable(int size) {
            return (AbstractEntry[])Array.newInstance(AbstractEntry.class, size);
        }

        private E[] getTable(boolean purge) {
            if (purge) {
                this.purge();
            }
            return this.table;
        }

        private int tableIndex(int hashCode) {
            return hashCode & this.table.length - 1;
        }

        private static int tableIndex(int hashCode, int length) {
            return hashCode & length - 1;
        }

        private int keyHashCodeInternal(Object x) {
            if (x == null) {
                return 0;
            }
            int h = this.keyHashCode(x);
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            h ^= h >>> 10;
            return h;
        }

        private void resize(int newCapacity) {
            this.purge();
            E[] oldTable = this.table;
            int oldCapacity = oldTable.length;
            if (oldCapacity == 0x40000000) {
                this.threshold = Integer.MAX_VALUE;
                return;
            }
            AbstractEntry[] newTable = this.createTable(newCapacity);
            Iterator<E> iterator = this.createEntryIterator();
            while (iterator.hasNext()) {
                AbstractEntry entry = (AbstractEntry)iterator.next();
                int index = AbstractHashMap.tableIndex(entry.keyHashCode(), newCapacity);
                entry.setNext(newTable[index]);
                newTable[index] = entry;
            }
            this.table = newTable;
            this.threshold = (int)((float)newCapacity * this.loadFactor);
        }

        private void writeObject(ObjectOutputStream s) throws IOException {
            Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
            s.defaultWriteObject();
            s.writeInt(this.table.length);
            s.writeInt(this.size);
            while (i.hasNext()) {
                Map.Entry<K, V> e = i.next();
                s.writeObject(e.getKey());
                s.writeObject(e.getValue());
            }
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            int tableLength = s.readInt();
            this.table = this.createTable(tableLength);
            this.mapConstructedInternal();
            int size = s.readInt();
            int i = 0;
            while (i < size) {
                this.addEntry(s.readObject(), s.readObject());
                ++i;
            }
            this.mapInitializedInternal();
        }

        protected int capacity() {
            return this.table.length;
        }

        protected float loadFactor() {
            return this.loadFactor;
        }

        static AbstractEntry[] mav$getTable(AbstractHashMap abstractHashMap, boolean bl) {
            return abstractHashMap.getTable(bl);
        }

        static int ra$size(AbstractHashMap abstractHashMap) {
            return abstractHashMap.size;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private abstract class AbstractEntryIterator<T>
        implements Iterator<T> {
            private E lastEntry;
            private E nextEntry;
            private int tableIndexOfNextEntry;
            private int expectedChangeCount;

            protected AbstractEntryIterator() {
                AbstractEntry[] table = AbstractHashMap.mav$getTable(AbstractHashMap.this, true);
                this.expectedChangeCount = AbstractHashMap.this.getChangeCount();
                this.tableIndexOfNextEntry = table.length;
                if (AbstractHashMap.ra$size(AbstractHashMap.this) != 0) {
                    while (this.tableIndexOfNextEntry > 0 && (this.nextEntry = table[--this.tableIndexOfNextEntry]) == null) {
                    }
                }
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }

            protected E nextEntry() {
                if (AbstractHashMap.this.getChangeCount() != this.expectedChangeCount) {
                    throw new ConcurrentModificationException();
                }
                Object result = this.nextEntry;
                if (result == null) {
                    throw new NoSuchElementException();
                }
                AbstractEntry next = result.getNext();
                if (next == null) {
                    AbstractEntry[] table = AbstractHashMap.mav$getTable(AbstractHashMap.this, true);
                    int i = this.tableIndexOfNextEntry;
                    while (next == null && i > 0) {
                        next = table[--i];
                    }
                    this.tableIndexOfNextEntry = i;
                }
                this.nextEntry = next;
                this.lastEntry = result;
                return this.lastEntry;
            }

            @Override
            public void remove() {
                if (this.lastEntry == null) {
                    throw new IllegalStateException();
                }
                if (AbstractHashMap.this.getChangeCount() != this.expectedChangeCount) {
                    throw new ConcurrentModificationException();
                }
                AbstractHashMap.this.removeExistingEntry(this.lastEntry);
                this.lastEntry = null;
                this.expectedChangeCount = AbstractHashMap.this.getChangeCount();
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeySet
        extends AbstractSet<K> {
            @Override
            public Iterator<K> iterator() {
                return AbstractHashMap.this.createKeySetIterator();
            }

            @Override
            public int size() {
                return AbstractHashMap.ra$size(AbstractHashMap.this);
            }

            @Override
            public boolean contains(Object o) {
                return AbstractHashMap.this.containsKey(o);
            }

            @Override
            public boolean remove(Object o) {
                return AbstractHashMap.this.removeKey(o, null) != null;
            }

            @Override
            public void clear() {
                AbstractHashMap.this.clear();
            }

            @Override
            public int hashCode() {
                int hash = 0;
                for (Object key : this) {
                    if (key == null) continue;
                    hash += AbstractHashMap.this.keyHashCode(key);
                }
                return hash;
            }

            private KeySet() {
            }

            KeySet(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class Values
        extends AbstractCollection<V> {
            @Override
            public Iterator<V> iterator() {
                return AbstractHashMap.this.createValuesIterator();
            }

            @Override
            public int size() {
                return AbstractHashMap.ra$size(AbstractHashMap.this);
            }

            @Override
            public boolean contains(Object o) {
                return AbstractHashMap.this.containsValue(o);
            }

            @Override
            public void clear() {
                AbstractHashMap.this.clear();
            }

            @Override
            public int hashCode() {
                int hash = 0;
                for (Object value : this) {
                    if (value == null) continue;
                    hash += AbstractHashMap.this.valueHashCode(value);
                }
                return hash;
            }

            private Values() {
            }

            Values(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return AbstractHashMap.this.createEntrySetIterator();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                Object candidate = AbstractHashMap.this.getEntry(e.getKey());
                return candidate != null && candidate.equals(e);
            }

            @Override
            public boolean remove(Object object) {
                if (object instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)object;
                    return AbstractHashMap.this.removeKey(entry.getKey(), entry) != null;
                }
                return false;
            }

            @Override
            public int size() {
                return AbstractHashMap.ra$size(AbstractHashMap.this);
            }

            @Override
            public void clear() {
                AbstractHashMap.this.clear();
            }

            @Override
            public int hashCode() {
                int hash = 0;
                for (Map.Entry entry : this) {
                    if (entry == null) continue;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    hash += (key == null ? 0 : AbstractHashMap.this.keyHashCode(key)) ^ (value == null ? 0 : AbstractHashMap.this.valueHashCode(value));
                }
                return hash;
            }

            private EntrySet() {
            }

            EntrySet(1 var2_2) {
                this();
            }

            public final class 1 {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 1
        extends AbstractEntryIterator {
            @Override
            public E next() {
                return this.nextEntry();
            }

            public 1(AbstractHashMap abstractHashMap2) {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 2
        extends AbstractEntryIterator {
            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            public 2(AbstractHashMap abstractHashMap2) {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 3
        extends AbstractEntryIterator {
            @Override
            public K next() {
                return this.nextEntry().getKey();
            }

            public 3(AbstractHashMap abstractHashMap2) {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 4
        extends AbstractEntryIterator {
            @Override
            public V next() {
                return this.nextEntry().getValue();
            }

            public 4(AbstractHashMap abstractHashMap2) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractLinkedHashMap<K, V, E extends AbstractLinkedEntry<K, V>>
    extends AbstractHashMap<K, V, E> {
        private transient E before;
        private transient E after;
        private final boolean accessOrder;

        protected AbstractLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder, Map<? extends K, ? extends V> map) {
            super(initialCapacity, loadFactor, map);
            this.accessOrder = accessOrder;
        }

        protected AbstractLinkedHashMap(Map<? extends K, ? extends V> map) {
            super(map);
            this.accessOrder = false;
        }

        @Override
        protected void mapChanged() {
        }

        protected void entryEvicted(E entry) {
        }

        protected E getEldestEntry() {
            if (this.isEmpty()) {
                return null;
            }
            return this.after;
        }

        protected boolean removeEldestEntry(E eldest) {
            return false;
        }

        protected void evictExistingEntry(E entry) {
            if (this.replaceEntryInternal(entry, null, true)) {
                this.change();
                this.entryEvictedInternal(entry);
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.after = null;
            this.before = null;
        }

        @Override
        void entryAddedInternal(E entry) {
            E eldest;
            this.link(entry);
            int count = this.getChangeCount();
            super.entryAddedInternal(entry);
            if (count == this.getChangeCount() && this.removeEldestEntry(eldest = this.getEldestEntry())) {
                this.evictExistingEntry(eldest);
            }
        }

        @Override
        void entryChangedInternal(E oldEntry, V oldValue, E newEntry) {
            if (this.accessOrder) {
                this.change();
                this.unlink(oldEntry);
                this.link(newEntry);
            } else if (oldEntry != newEntry) {
                this.relink(oldEntry, newEntry);
            }
            super.entryChangedInternal(oldEntry, oldValue, newEntry);
        }

        @Override
        void entryAccessedInternal(E entry) {
            if (this.accessOrder) {
                this.change();
                this.unlink(entry);
                this.link(entry);
            }
            super.entryAccessedInternal(entry);
        }

        @Override
        void entryRemovedInternal(E entry) {
            this.unlink(entry);
            super.entryRemovedInternal(entry);
        }

        @Override
        void entryPurgedInternal(E entry) {
            this.unlink(entry);
            super.entryPurgedInternal(entry);
        }

        void entryEvictedInternal(E entry) {
            this.unlink(entry);
            this.entryEvicted(entry);
        }

        @Override
        protected Iterator<E> createEntryIterator() {
            return new 1(this);
        }

        @Override
        protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
            return new 2(this);
        }

        @Override
        protected Iterator<K> createKeySetIterator() {
            return new 3(this);
        }

        @Override
        protected Iterator<V> createValuesIterator() {
            return new 4(this);
        }

        private void link(E entry) {
            if (this.after == null) {
                this.after = entry;
                this.before = this.after;
                entry.setBefore(null);
                entry.setAfter(null);
            } else {
                entry.setBefore(this.before);
                entry.setAfter(null);
                this.before.setAfter(entry);
                this.before = entry;
            }
        }

        private void unlink(E entry) {
            if (this.after == entry) {
                this.after = entry.getAfter();
            } else {
                entry.getBefore().setAfter(entry.getAfter());
            }
            if (this.before == entry) {
                this.before = entry.getBefore();
            } else {
                entry.getAfter().setBefore(entry.getBefore());
            }
            entry.setBefore(null);
            entry.setAfter(null);
        }

        private void relink(E oldEntry, E newEntry) {
            newEntry.setBefore(oldEntry.getBefore());
            newEntry.setAfter(oldEntry.getAfter());
            if (this.after == oldEntry) {
                this.after = newEntry;
            } else {
                oldEntry.getBefore().setAfter(newEntry);
            }
            if (this.before == oldEntry) {
                this.before = newEntry;
            } else {
                oldEntry.getAfter().setBefore(newEntry);
            }
        }

        static AbstractLinkedEntry ra$after(AbstractLinkedHashMap abstractLinkedHashMap) {
            return abstractLinkedHashMap.after;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 1
        extends AbstractLinkedEntryIterator {
            @Override
            public E next() {
                return this.nextEntry();
            }

            public 1(AbstractLinkedHashMap abstractLinkedHashMap2) {
                super((1)null);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 2
        extends AbstractLinkedEntryIterator {
            @Override
            public Map.Entry<K, V> next() {
                return this.nextEntry();
            }

            public 2(AbstractLinkedHashMap abstractLinkedHashMap2) {
                super((2)null);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 3
        extends AbstractLinkedEntryIterator {
            @Override
            public K next() {
                return this.nextEntry().getKey();
            }

            public 3(AbstractLinkedHashMap abstractLinkedHashMap2) {
                super((3)null);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        final class 4
        extends AbstractLinkedEntryIterator {
            @Override
            public V next() {
                return this.nextEntry().getValue();
            }

            public 4(AbstractLinkedHashMap abstractLinkedHashMap2) {
                super((4)null);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private abstract class AbstractLinkedEntryIterator<T>
        implements Iterator<T> {
            private E nextEntry;
            private E lastReturned;
            private int expectedChangeCount;

            private void $init$() {
                this.nextEntry = AbstractLinkedHashMap.ra$after(AbstractLinkedHashMap.this);
                this.lastReturned = null;
                this.expectedChangeCount = AbstractLinkedHashMap.this.getChangeCount();
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != null;
            }

            @Override
            public void remove() {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                if (AbstractLinkedHashMap.this.getChangeCount() != this.expectedChangeCount) {
                    throw new ConcurrentModificationException();
                }
                AbstractLinkedHashMap.this.removeExistingEntry(this.lastReturned);
                this.lastReturned = null;
                this.expectedChangeCount = AbstractLinkedHashMap.this.getChangeCount();
            }

            protected E nextEntry() {
                if (AbstractLinkedHashMap.this.getChangeCount() != this.expectedChangeCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.nextEntry == null) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.nextEntry;
                Object entry = this.lastReturned;
                this.nextEntry = entry.getAfter();
                return entry;
            }

            private AbstractLinkedEntryIterator() {
                this.$init$();
            }

            AbstractLinkedEntryIterator(4 var2_2) {
                this();
            }

            AbstractLinkedEntryIterator(3 var2_2) {
                this();
            }

            AbstractLinkedEntryIterator(2 var2_2) {
                this();
            }

            AbstractLinkedEntryIterator(1 var2_2) {
                this();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultHashMap<K, V>
    extends AbstractHashMap<K, V, DefaultEntry<K, V>> {
        public DefaultHashMap() {
            super(16, 0.75f, null);
        }

        public DefaultHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, null);
        }

        public DefaultHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, null);
        }

        public DefaultHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        @Override
        protected DefaultEntry<K, V> createEntry(int hash, K key, V value, DefaultEntry<K, V> next) {
            return new DefaultEntry<K, V>(hash, key, value, next);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SoftHashMap<K, V>
    extends AbstractHashMap<K, V, SoftEntry<K, V>> {
        public SoftHashMap() {
            super(16, 0.75f, null);
        }

        public SoftHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, null);
        }

        public SoftHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, null);
        }

        public SoftHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        @Override
        protected SoftEntry<K, V> createEntry(int hash, K key, V value, SoftEntry<K, V> next) {
            return new SoftEntry<K, V>(hash, key, value, next, this.getQueue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeakHashMap<K, V>
    extends AbstractHashMap<K, V, WeakEntry<K, V>> {
        public WeakHashMap() {
            super(16, 0.75f, null);
        }

        public WeakHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, null);
        }

        public WeakHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, null);
        }

        public WeakHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        @Override
        protected WeakEntry<K, V> createEntry(int hash, K key, V value, WeakEntry<K, V> next) {
            return new WeakEntry<K, V>(hash, key, value, next, this.getQueue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedHashMap<K, V>
    extends AbstractLinkedHashMap<K, V, DefaultLinkedEntry<K, V>> {
        public LinkedHashMap() {
            super(16, 0.75f, false, null);
        }

        public LinkedHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, false, null);
        }

        public LinkedHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, false, null);
        }

        public LinkedHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder, null);
        }

        @Override
        protected DefaultLinkedEntry<K, V> createEntry(int hash, K key, V value, DefaultLinkedEntry<K, V> next) {
            return new DefaultLinkedEntry<K, V>(hash, key, value, next);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SoftLinkedHashMap<K, V>
    extends AbstractLinkedHashMap<K, V, SoftLinkedEntry<K, V>> {
        public SoftLinkedHashMap() {
            super(16, 0.75f, false, null);
        }

        public SoftLinkedHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, false, null);
        }

        public SoftLinkedHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, false, null);
        }

        public SoftLinkedHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        public SoftLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder, null);
        }

        @Override
        protected SoftLinkedEntry<K, V> createEntry(int hash, K key, V value, SoftLinkedEntry<K, V> next) {
            return new SoftLinkedEntry<K, V>(hash, key, value, next, this.getQueue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeakLinkedHashMap<K, V>
    extends AbstractLinkedHashMap<K, V, WeakLinkedEntry<K, V>> {
        public WeakLinkedHashMap() {
            super(16, 0.75f, false, null);
        }

        public WeakLinkedHashMap(int initialCapacity) {
            super(initialCapacity, 0.75f, false, null);
        }

        public WeakLinkedHashMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor, false, null);
        }

        public WeakLinkedHashMap(Map<? extends K, ? extends V> map) {
            super(map);
        }

        public WeakLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
            super(initialCapacity, loadFactor, accessOrder, null);
        }

        @Override
        protected WeakLinkedEntry<K, V> createEntry(int hash, K key, V value, WeakLinkedEntry<K, V> next) {
            return new WeakLinkedEntry<K, V>(hash, key, value, next, this.getQueue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public interface AbstractEntry<K, V>
    extends Map.Entry<K, V> {
        public AbstractEntry<K, V> getNext();

        public void setNext(AbstractEntry<K, V> var1);

        public int keyHashCode();

        public boolean isMutable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultEntry<K, V>
    implements AbstractEntry<K, V> {
        private final K key;
        private V value;
        private final int keyHashCode;
        private AbstractEntry<K, V> next;

        protected DefaultEntry(int hash, K key, V value, AbstractEntry<K, V> next) {
            this.next = next;
            this.keyHashCode = hash;
            this.value = value;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public AbstractEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(AbstractEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SoftEntry<K, V>
    extends SoftReference<V>
    implements AbstractEntry<K, V> {
        private final int keyHashCode;
        private final K key;
        private AbstractEntry<K, V> next;

        protected SoftEntry(int keyHashCode, K key, V value, SoftEntry<K, V> next, ReferenceQueue<V> queue) {
            super(value, queue);
            this.next = next;
            this.keyHashCode = keyHashCode;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AbstractEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(AbstractEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v1;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            K k1 = this.getKey();
            return (k1 == (k2 = that.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = that.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeakEntry<K, V>
    extends WeakReference<V>
    implements AbstractEntry<K, V> {
        private final int keyHashCode;
        private final K key;
        private AbstractEntry<K, V> next;

        protected WeakEntry(int keyHashCode, K key, V value, WeakEntry<K, V> next, ReferenceQueue<V> queue) {
            super(value, queue);
            this.next = next;
            this.keyHashCode = keyHashCode;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AbstractEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(AbstractEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v1;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            K k1 = this.getKey();
            return (k1 == (k2 = that.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = that.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public interface AbstractLinkedEntry<K, V>
    extends AbstractEntry<K, V> {
        public AbstractLinkedEntry<K, V> getBefore();

        public AbstractLinkedEntry<K, V> getAfter();

        public void setBefore(AbstractLinkedEntry<K, V> var1);

        public void setAfter(AbstractLinkedEntry<K, V> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultLinkedEntry<K, V>
    implements AbstractLinkedEntry<K, V> {
        private final K key;
        private V value;
        private final int keyHashCode;
        private AbstractEntry<K, V> next;
        private AbstractLinkedEntry<K, V> before;
        private AbstractLinkedEntry<K, V> after;

        protected DefaultLinkedEntry(int keyHashCode, K key, V value, AbstractLinkedEntry<K, V> next) {
            this.keyHashCode = keyHashCode;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        @Override
        public AbstractEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(AbstractEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return true;
        }

        @Override
        public final AbstractLinkedEntry<K, V> getBefore() {
            return this.before;
        }

        @Override
        public final AbstractLinkedEntry<K, V> getAfter() {
            return this.after;
        }

        @Override
        public final void setBefore(AbstractLinkedEntry<K, V> before) {
            this.before = before;
        }

        @Override
        public final void setAfter(AbstractLinkedEntry<K, V> after) {
            this.after = after;
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            V v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            K k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SoftLinkedEntry<K, V>
    extends SoftReference<V>
    implements AbstractLinkedEntry<K, V> {
        private final int keyHashCode;
        private final K key;
        private AbstractEntry<K, V> next;
        private AbstractLinkedEntry<K, V> before;
        private AbstractLinkedEntry<K, V> after;

        protected SoftLinkedEntry(int hash, K key, V value, AbstractLinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            super(value, queue);
            this.keyHashCode = hash;
            this.key = key;
            this.next = next;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AbstractEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(AbstractEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public final AbstractLinkedEntry<K, V> getBefore() {
            return this.before;
        }

        @Override
        public final AbstractLinkedEntry<K, V> getAfter() {
            return this.after;
        }

        @Override
        public final void setBefore(AbstractLinkedEntry<K, V> before) {
            this.before = before;
        }

        @Override
        public final void setAfter(AbstractLinkedEntry<K, V> after) {
            this.after = after;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v1;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            K k1 = this.getKey();
            return (k1 == (k2 = that.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = that.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeakLinkedEntry<K, V>
    extends WeakReference<V>
    implements AbstractLinkedEntry<K, V> {
        private final int keyHashCode;
        private final K key;
        private AbstractEntry<K, V> next;
        private AbstractLinkedEntry<K, V> before;
        private AbstractLinkedEntry<K, V> after;

        protected WeakLinkedEntry(int keyHashCode, K key, V value, AbstractLinkedEntry<K, V> next, ReferenceQueue<V> queue) {
            super(value, queue);
            this.next = next;
            this.keyHashCode = keyHashCode;
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return (V)this.get();
        }

        @Override
        public V setValue(V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public AbstractEntry<K, V> getNext() {
            return this.next;
        }

        @Override
        public void setNext(AbstractEntry<K, V> next) {
            this.next = next;
        }

        @Override
        public int keyHashCode() {
            return this.keyHashCode;
        }

        @Override
        public boolean isMutable() {
            return false;
        }

        @Override
        public final AbstractLinkedEntry<K, V> getBefore() {
            return this.before;
        }

        @Override
        public final AbstractLinkedEntry<K, V> getAfter() {
            return this.after;
        }

        @Override
        public final void setBefore(AbstractLinkedEntry<K, V> before) {
            this.before = before;
        }

        @Override
        public final void setAfter(AbstractLinkedEntry<K, V> after) {
            this.after = after;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v1;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)object;
            K k1 = this.getKey();
            return (k1 == (k2 = that.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = that.getValue()) || v1 != null && v1.equals(v2));
        }

        @Override
        public int hashCode() {
            K key = this.getKey();
            V value = this.getValue();
            return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CacheStrategy<K, V, E extends AbstractLinkedEntry<K, V>> {
        public static final int DEFAULT_INITIAL_CAPACITY = 16;
        public static final float DEFAULT_LOAD_FACTOR = 0.75f;
        public static final AbstractCacheMap.ReferenceType HARD = AbstractCacheMap.ReferenceType.HARD;
        public static final AbstractCacheMap.ReferenceType SOFT = AbstractCacheMap.ReferenceType.SOFT;
        public static final AbstractCacheMap.ReferenceType WEAK = AbstractCacheMap.ReferenceType.WEAK;
        public static final AbstractCacheMap.MappingType CANONICAL = AbstractCacheMap.MappingType.CANONICAL;
        public static final AbstractCacheMap.MappingType NONCANONICAL = AbstractCacheMap.MappingType.NONCANONICAL;
        private final int initialCapacity;
        private final float loadFactor;
        private final AbstractCacheMap.ReferenceType valueReferenceType;
        private final AbstractCacheMap.MappingType mappingType;

        protected CacheStrategy(int initialCapacity, float loadFactor, AbstractCacheMap.ReferenceType valueReferenceType, AbstractCacheMap.MappingType mappingType) {
            this.initialCapacity = initialCapacity;
            this.loadFactor = loadFactor;
            this.valueReferenceType = valueReferenceType;
            this.mappingType = mappingType;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public float getLoadFactor() {
            return this.loadFactor;
        }

        public AbstractCacheMap.ReferenceType getValueReferenceType() {
            return this.valueReferenceType;
        }

        public AbstractCacheMap.MappingType getMappingType() {
            return this.mappingType;
        }

        protected void mapChanged(AbstractCacheMap<K, V, E> map) {
        }

        protected void entryAdded(AbstractCacheMap<K, V, E> map, E entry) {
        }

        protected void entryChanged(AbstractCacheMap<K, V, E> map, E oldEntry, V oldValue, E newEntry) {
        }

        protected void entryAccessed(AbstractCacheMap<K, V, E> map, E entry) {
        }

        protected void entryRemoved(AbstractCacheMap<K, V, E> map, E entry) {
        }

        protected void entryPurged(AbstractCacheMap<K, V, E> map, E entry) {
        }

        protected void entryEvicted(AbstractCacheMap<K, V, E> map, E entry) {
        }

        protected boolean evictEldest(AbstractCacheMap<K, V, E> map, E eldest) {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnboundedCacheStrategy<K, V, E extends AbstractLinkedEntry<K, V>>
    extends CacheStrategy<K, V, E> {
        public UnboundedCacheStrategy() {
            super(16, 0.75f, CacheStrategy.HARD, CacheStrategy.NONCANONICAL);
        }

        public UnboundedCacheStrategy(AbstractCacheMap.ReferenceType valueReferenceType) {
            super(16, 0.75f, valueReferenceType, CacheStrategy.NONCANONICAL);
        }

        public UnboundedCacheStrategy(int initialCapacity, float loadFactor, AbstractCacheMap.ReferenceType valueReferenceType, AbstractCacheMap.MappingType mappingType) {
            super(initialCapacity, loadFactor, valueReferenceType, mappingType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BoundedLruCacheStrategy<K, V, E extends AbstractLinkedEntry<K, V>>
    extends CacheStrategy<K, V, E> {
        private int maximumSize;

        public BoundedLruCacheStrategy(int maximumSize) {
            super(maximumSize + 1, 1.0f, CacheStrategy.HARD, CacheStrategy.CANONICAL);
            if (maximumSize < 0) {
                throw new IllegalArgumentException("maximumSize < 0");
            }
            this.maximumSize = maximumSize;
        }

        public BoundedLruCacheStrategy(int maximumSize, int initialCapacity, float loadFactor, AbstractCacheMap.ReferenceType valueReferenceType, AbstractCacheMap.MappingType mappingType) {
            super(initialCapacity, loadFactor, valueReferenceType, mappingType);
            if (maximumSize < 0) {
                throw new IllegalArgumentException("maximumSize < 0");
            }
            this.maximumSize = maximumSize;
        }

        @Override
        protected boolean evictEldest(AbstractCacheMap<K, V, E> map, E eldest) {
            return map.size() > this.maximumSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractCacheMap<K, V, E extends AbstractLinkedEntry<K, V>>
    extends AbstractLinkedHashMap<K, V, E> {
        public static final ReferenceType HARD = ReferenceType.HARD;
        public static final ReferenceType SOFT = ReferenceType.SOFT;
        public static final ReferenceType WEAK = ReferenceType.WEAK;
        private final ReferenceType valueReferenceType;
        public static final MappingType CANONICAL = MappingType.CANONICAL;
        public static final MappingType NONCANONICAL = MappingType.NONCANONICAL;
        private final MappingType mappingType;
        private CacheStrategy<K, V, E> strategy;

        public AbstractCacheMap(CacheStrategy<K, V, E> strategy) {
            super(strategy.getInitialCapacity(), strategy.getLoadFactor(), true, null);
            this.strategy = strategy;
            this.valueReferenceType = strategy.getValueReferenceType();
            this.mappingType = strategy.getMappingType();
        }

        public void setStrategy(CacheStrategy<K, V, E> strategy) {
            this.strategy = strategy;
        }

        public CacheStrategy<K, V, E> getStrategy() {
            return this.strategy;
        }

        public ReferenceType getValueReferenceType() {
            return this.valueReferenceType;
        }

        public MappingType getMappingType() {
            return this.mappingType;
        }

        @Override
        protected final E createEntry(int hashCode, K key, V value, E next) {
            switch (1.$sm$oracle$javatools$util$Maps$AbstractCacheMap$ReferenceType[this.getValueReferenceType().ordinal()]) {
                case 1: {
                    return this.createDefaultEntry(hashCode, key, value, next);
                }
                case 2: {
                    return this.createSoftEntry(hashCode, key, value, next);
                }
                case 3: {
                    return this.createWeakEntry(hashCode, key, value, next);
                }
            }
            throw new IllegalStateException();
        }

        protected abstract E createDefaultEntry(int var1, K var2, V var3, E var4);

        protected abstract E createSoftEntry(int var1, K var2, V var3, E var4);

        protected abstract E createWeakEntry(int var1, K var2, V var3, E var4);

        @Override
        protected final void mapChanged() {
            this.strategy.mapChanged(this);
        }

        @Override
        protected final void entryAdded(E entry) {
            this.strategy.entryAdded(this, entry);
        }

        @Override
        protected final void entryChanged(E oldEntry, V oldValue, E newEntry) {
            this.strategy.entryChanged(this, oldEntry, oldValue, newEntry);
        }

        @Override
        protected final void entryAccessed(E entry) {
            this.strategy.entryAccessed(this, entry);
        }

        @Override
        protected final void entryRemoved(E entry) {
            this.strategy.entryRemoved(this, entry);
        }

        @Override
        protected final void entryPurged(E entry) {
            this.strategy.entryPurged(this, entry);
        }

        @Override
        protected final void entryEvicted(E entry) {
            this.strategy.entryEvicted(this, entry);
        }

        @Override
        protected boolean removeEldestEntry(E eldest) {
            return this.strategy.evictEldest(this, eldest);
        }

        @Override
        protected void evictExistingEntry(E entry) {
            if (this.getMappingType() == CANONICAL) {
                Object newEntry = entry instanceof WeakReference ? entry : this.createWeakEntry(entry.keyHashCode(), entry.getKey(), entry.getValue(), null);
                if (this.replaceEntryInternal(entry, newEntry, true)) {
                    this.entryChangedInternal(entry, entry.getValue(), newEntry);
                }
            } else {
                super.evictExistingEntry(entry);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class ReferenceType
        extends Enum<ReferenceType> {
            private static final /* synthetic */ ReferenceType[] $v;
            public static final /* enum */ ReferenceType HARD;
            public static final /* enum */ ReferenceType SOFT;
            public static final /* enum */ ReferenceType WEAK;

            public static ReferenceType valueOf(String string) {
                return Enum.valueOf(ReferenceType.class, string);
            }

            public static final ReferenceType[] values() {
                return (ReferenceType[])$v.clone();
            }

            static {
                ReferenceType[] referenceTypeArray = new ReferenceType[3];
                referenceTypeArray[2] = WEAK = new ReferenceType("WEAK", 2);
                referenceTypeArray[1] = SOFT = new ReferenceType("SOFT", 1);
                referenceTypeArray[0] = HARD = new ReferenceType("HARD", 0);
                $v = referenceTypeArray;
            }

            private ReferenceType(String string2, int n2) {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static final class MappingType
        extends Enum<MappingType> {
            private static final /* synthetic */ MappingType[] $v;
            public static final /* enum */ MappingType CANONICAL;
            public static final /* enum */ MappingType NONCANONICAL;

            public static MappingType valueOf(String string) {
                return Enum.valueOf(MappingType.class, string);
            }

            public static final MappingType[] values() {
                return (MappingType[])$v.clone();
            }

            static {
                MappingType[] mappingTypeArray = new MappingType[2];
                mappingTypeArray[1] = NONCANONICAL = new MappingType("NONCANONICAL", 1);
                mappingTypeArray[0] = CANONICAL = new MappingType("CANONICAL", 0);
                $v = mappingTypeArray;
            }

            private MappingType(String string2, int n2) {
            }
        }

        static class 1 {
            static final /* synthetic */ int[] $sm$oracle$javatools$util$Maps$AbstractCacheMap$ReferenceType;

            static {
                int[] nArray = new int[ReferenceType.values().length];
                $sm$oracle$javatools$util$Maps$AbstractCacheMap$ReferenceType = nArray;
                try {
                    nArray[ReferenceType.HARD.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$javatools$util$Maps$AbstractCacheMap$ReferenceType[ReferenceType.SOFT.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    1.$sm$oracle$javatools$util$Maps$AbstractCacheMap$ReferenceType[ReferenceType.WEAK.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CacheMap<K, V>
    extends AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> {
        public CacheMap() {
            this(new UnboundedCacheStrategy(16, 0.75f, AbstractCacheMap.HARD, AbstractCacheMap.NONCANONICAL));
        }

        public CacheMap(AbstractCacheMap.ReferenceType valueReferenceType) {
            this(new UnboundedCacheStrategy(16, 0.75f, valueReferenceType, AbstractCacheMap.NONCANONICAL));
        }

        public CacheMap(int bound) {
            this(new BoundedLruCacheStrategy(bound));
        }

        public CacheMap(int bound, AbstractCacheMap.ReferenceType valueReferenceType) {
            this(new BoundedLruCacheStrategy(bound, 16, 0.75f, valueReferenceType, AbstractCacheMap.NONCANONICAL));
        }

        public CacheMap(int bound, AbstractCacheMap.MappingType mappingType) {
            this(new BoundedLruCacheStrategy(bound, 16, 0.75f, AbstractCacheMap.HARD, mappingType));
        }

        public CacheMap(CacheStrategy<K, V, AbstractLinkedEntry<K, V>> strategy) {
            super(strategy);
        }

        @Override
        protected AbstractLinkedEntry<K, V> createDefaultEntry(int hashCode, K key, V value, AbstractLinkedEntry<K, V> next) {
            return new DefaultLinkedEntry<K, V>(hashCode, key, value, next);
        }

        @Override
        protected AbstractLinkedEntry<K, V> createSoftEntry(int hashCode, K key, V value, AbstractLinkedEntry<K, V> next) {
            return new SoftLinkedEntry<K, V>(hashCode, key, value, next, this.getQueue());
        }

        @Override
        protected AbstractLinkedEntry<K, V> createWeakEntry(int hashCode, K key, V value, AbstractLinkedEntry<K, V> next) {
            return new WeakLinkedEntry<K, V>(hashCode, key, value, next, this.getQueue());
        }
    }

    public interface ManagedCacheMapMBean {
        public int getSize();

        public int getMaximumSize();

        public CompositeData getStatistics() throws OpenDataException;

        public void setCollectKeyStatistics(boolean var1);

        public boolean getCollectKeyStatistics();

        public int getTotalKeyCount();

        public TabularData getKeyStatistics() throws OpenDataException;

        public void clearKeyStatistics();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ManagedCacheMap<K, V>
    extends CacheMap<K, V>
    implements ManagedCacheMapMBean {
        private HistoryDecorator history;
        private int maximumSize;
        private static TabularType tabularType;
        private static CompositeType rowType;
        private static String rowTypeName;
        private static String rowTypeDescription;
        private static String[] columnNames;
        private static String[] columnDescriptions;
        private static OpenType[] columnTypes;

        public ManagedCacheMap(String name) {
            this.initialize(name);
        }

        public ManagedCacheMap(AbstractCacheMap.ReferenceType valueReferenceType, String name) {
            super(valueReferenceType);
            this.initialize(name);
        }

        public ManagedCacheMap(int bound, String name) {
            super(bound);
            this.initialize(name);
        }

        public ManagedCacheMap(int bound, AbstractCacheMap.ReferenceType valueReferenceType, String name) {
            super(bound, valueReferenceType);
            this.initialize(name);
        }

        public ManagedCacheMap(int bound, AbstractCacheMap.MappingType mappingType, String name) {
            super(bound, mappingType);
            this.initialize(name);
        }

        public ManagedCacheMap(CacheStrategy<K, V, AbstractLinkedEntry<K, V>> strategy, String name) {
            super(strategy);
            this.initialize(name);
        }

        private void initialize(String name) {
            this.history = new HistoryDecorator(this.getStrategy());
            this.setStrategy(this.history);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            String beanName = "oracle.javatools.cache:type=CacheMap,name=" + name;
            try {
                server.registerMBean(this, new ObjectName(beanName));
            }
            catch (Throwable e) {
                Logger.getLogger("jmx").log(Level.SEVERE, "mbean " + beanName + " not registered", e);
            }
        }

        @Override
        public int getSize() {
            return this.size();
        }

        @Override
        public int getMaximumSize() {
            return this.maximumSize;
        }

        @Override
        public CompositeData getStatistics() throws OpenDataException {
            Statistics statistics = HistoryDecorator.mav$getStatistics(this.history);
            Object[] values = new Object[]{"totals", statistics.adds, statistics.changes, statistics.accesses, statistics.removes, statistics.purges, statistics.evicts};
            return new CompositeDataSupport(ManagedCacheMap.rowType(), columnNames, values);
        }

        @Override
        public void setCollectKeyStatistics(boolean collect) {
            this.history.setCollectKeyStatistics(collect);
        }

        @Override
        public boolean getCollectKeyStatistics() {
            return this.history.getCollectKeyStatistics();
        }

        @Override
        public int getTotalKeyCount() {
            return HistoryDecorator.mav$getTotalKeyCount(this.history);
        }

        @Override
        public TabularData getKeyStatistics() throws OpenDataException {
            TabularDataSupport table = new TabularDataSupport(ManagedCacheMap.tableType());
            for (Map.Entry entry : HistoryDecorator.mav$getKeyStatistics(this.history).entrySet()) {
                Object key = entry.getKey();
                Statistics statistics = (Statistics)entry.getValue();
                Object[] values = new Object[]{String.valueOf(key), statistics.adds, statistics.changes, statistics.accesses, statistics.removes, statistics.purges, statistics.evicts};
                table.put(new CompositeDataSupport(ManagedCacheMap.rowType(), columnNames, values));
            }
            return table;
        }

        @Override
        public void clearKeyStatistics() {
            HistoryDecorator.mav$clearKeyStatistics(this.history);
        }

        private static TabularType tableType() throws OpenDataException {
            if (tabularType == null) {
                tabularType = new TabularType("HistoryTable", "Collected history for a ManagedCacheMap", ManagedCacheMap.rowType(), new String[]{"key"});
            }
            return tabularType;
        }

        private static CompositeType rowType() throws OpenDataException {
            if (rowType == null) {
                rowType = new CompositeType(rowTypeName, rowTypeDescription, columnNames, columnDescriptions, columnTypes);
            }
            return rowType;
        }

        @Override
        void entryAddedInternal(AbstractLinkedEntry<K, V> entry) {
            super.entryAddedInternal(entry);
            int size = this.size();
            if (size > this.maximumSize) {
                this.maximumSize = size;
            }
        }

        static {
            rowTypeName = "History";
            rowTypeDescription = "Collected history for one key in a ManagedCacheMap";
            columnNames = new String[]{"key", "adds", "changes", "accesses", "removes", "purges", "evicts"};
            columnDescriptions = new String[]{"Key of mapping", "Number of times key and value were added (initial, or after removal)", "Number of times value for key changed", "Number of times value for key was accessed", "Number of times key and value were removed", "Number of times value for key was collected", "Number of times key and value were evicted"};
            columnTypes = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER, SimpleType.INTEGER};
        }

        private static class Statistics {
            public int adds;
            public int changes;
            public int accesses;
            public int removes;
            public int purges;
            public int evicts;

            private Statistics() {
            }

            Statistics(1 var1_1) {
                this();
            }

            public final class 1 {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class HistoryDecorator
        extends CacheStrategy<K, V, AbstractLinkedEntry<K, V>> {
            private CacheStrategy<K, V, AbstractLinkedEntry<K, V>> delegate;
            private Statistics statistics;
            private volatile boolean collectKeyStatistics;
            private volatile Map<K, Statistics> keyStatistics;

            private void $init$() {
                this.statistics = new Statistics(null);
                this.collectKeyStatistics = false;
            }

            public HistoryDecorator(CacheStrategy<K, V, AbstractLinkedEntry<K, V>> delegate) {
                super(delegate.getInitialCapacity(), delegate.getLoadFactor(), delegate.getValueReferenceType(), delegate.getMappingType());
                this.$init$();
                this.delegate = delegate;
            }

            private Statistics getStatistics() {
                return this.statistics;
            }

            public boolean getCollectKeyStatistics() {
                return this.collectKeyStatistics;
            }

            public void setCollectKeyStatistics(boolean collect) {
                this.collectKeyStatistics = collect;
                if (collect && this.keyStatistics == null) {
                    this.keyStatistics = new HashMap();
                }
            }

            private int getTotalKeyCount() {
                return this.keyStatistics.size();
            }

            private void clearKeyStatistics() {
                this.statistics = new Statistics(null);
                this.keyStatistics = this.collectKeyStatistics ? new HashMap() : null;
            }

            private Map<K, Statistics> getKeyStatistics() {
                return this.keyStatistics;
            }

            private Statistics getKeyStatistics(AbstractLinkedEntry<K, V> entry) {
                Object key = entry.getKey();
                Statistics statistics = this.keyStatistics.get(key);
                if (statistics == null) {
                    statistics = new Statistics(null);
                    this.keyStatistics.put(key, statistics);
                }
                return statistics;
            }

            @Override
            protected void entryAdded(AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> map, AbstractLinkedEntry<K, V> entry) {
                ++this.statistics.adds;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).adds;
                }
                this.delegate.entryAdded(map, entry);
            }

            @Override
            protected void entryChanged(AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> map, AbstractLinkedEntry<K, V> oldEntry, V oldValue, AbstractLinkedEntry<K, V> newEntry) {
                ++this.statistics.changes;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(oldEntry).changes;
                }
                this.delegate.entryChanged(map, oldEntry, oldValue, newEntry);
            }

            @Override
            protected void entryAccessed(AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> map, AbstractLinkedEntry<K, V> entry) {
                ++this.statistics.accesses;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).accesses;
                }
                this.delegate.entryAccessed(map, entry);
            }

            @Override
            protected void entryRemoved(AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> map, AbstractLinkedEntry<K, V> entry) {
                ++this.statistics.removes;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).removes;
                }
                this.delegate.entryRemoved(map, entry);
            }

            @Override
            protected void entryPurged(AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> map, AbstractLinkedEntry<K, V> entry) {
                ++this.statistics.purges;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).purges;
                }
                this.delegate.entryPurged(map, entry);
            }

            @Override
            protected void entryEvicted(AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> map, AbstractLinkedEntry<K, V> entry) {
                ++this.statistics.evicts;
                if (this.collectKeyStatistics) {
                    ++this.getKeyStatistics(entry).evicts;
                }
                this.delegate.entryEvicted(map, entry);
            }

            @Override
            protected void mapChanged(AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> map) {
                this.delegate.mapChanged(map);
            }

            @Override
            protected boolean evictEldest(AbstractCacheMap<K, V, AbstractLinkedEntry<K, V>> map, AbstractLinkedEntry<K, V> eldest) {
                return this.delegate.evictEldest(map, eldest);
            }

            static void mav$clearKeyStatistics(HistoryDecorator historyDecorator) {
                historyDecorator.clearKeyStatistics();
            }

            static Map mav$getKeyStatistics(HistoryDecorator historyDecorator) {
                return historyDecorator.getKeyStatistics();
            }

            static int mav$getTotalKeyCount(HistoryDecorator historyDecorator) {
                return historyDecorator.getTotalKeyCount();
            }

            static Statistics mav$getStatistics(HistoryDecorator historyDecorator) {
                return historyDecorator.getStatistics();
            }
        }
    }
}

