/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.util;

import java.util.List;
import java.util.Map;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtil {
    public static final boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static final boolean areDifferent(Object o1, Object o2) {
        return ModelUtil.areEqual(o1, o2) ^ true;
    }

    public static final boolean hasNonNullElement(Object[] array) {
        if (array != null) {
            int n = array.length;
            int i = 0;
            while (i < n) {
                if (array[i] != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static final String concat(String[] strs) {
        return ModelUtil.concat(strs, " ");
    }

    public static final String concat(String[] strs, String delim) {
        if (strs != null) {
            StringBuffer buf = new StringBuffer();
            int n = strs.length;
            int i = 0;
            while (i < n) {
                String str = strs[i];
                if (str != null) {
                    buf.append(str).append(delim);
                }
                ++i;
            }
            int length = buf.length();
            if (length > 0) {
                buf.setLength(length - 1);
            }
            return buf.toString();
        }
        return "";
    }

    public static final boolean hasLength(String s) {
        return ModelUtil.hasLength((CharSequence)s);
    }

    public static int hashCodeFor(Object o) {
        return o != null ? o.hashCode() : 0;
    }

    public static final boolean hasLength(CharSequence cs) {
        return cs != null && cs.length() > 0;
    }

    public static final String nullifyIfEmpty(String s) {
        return ModelUtil.hasLength(s) ? s : null;
    }

    public static final void deepCopy(Map src, Map dst) {
        if (src == null || dst == null) {
            return;
        }
        for (Object key : src.keySet()) {
            Object srcValue = src.get(key);
            Object dstValue = dst.get(key);
            Object valueCopy = srcValue == null ? null : (dstValue == null || srcValue.getClass() != dstValue.getClass() ? (Object)(srcValue instanceof Copyable ? ((Copyable)srcValue).copyTo(null) : srcValue) : (Object)(srcValue instanceof Copyable ? ((Copyable)srcValue).copyTo(dstValue) : srcValue));
            dst.put(key, valueCopy);
        }
    }

    public static final void deepCopy(List src, List dst, boolean eliminateDuplicates) {
        if (src == null || dst == null) {
            return;
        }
        int i = 0;
        while (i < src.size()) {
            Object srcValue = src.get(i);
            if (!eliminateDuplicates || !dst.contains(srcValue)) {
                Object valueCopy = srcValue instanceof Copyable ? ((Copyable)srcValue).copyTo(null) : srcValue;
                dst.add(valueCopy);
            }
            ++i;
        }
    }

    public static final void deepCopy(List src, List dst) {
        ModelUtil.deepCopy(src, dst, true);
    }

    public static <T> T as(Object o, Class<T> clazz) {
        if (clazz.isInstance(o)) {
            return clazz.cast(o);
        }
        return null;
    }

    protected ModelUtil() {
    }
}

