/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.validators.ColumnValidator;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.db.validators.IndexValidator;
import oracle.javatools.db.validators.SchemaValidator;
import oracle.javatools.db.validators.TableValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDatabaseDescriptor
extends DatabaseDescriptor {
    public Map<String, DBObjectValidator> getValidators(Class<? extends Database> dbImpl, DBObjectProvider pro) {
        HashMap<String, DBObjectValidator> v = new HashMap<String, DBObjectValidator>();
        v.put("SCHEMA", new SchemaValidator(pro));
        v.put("INDEX", new IndexValidator(pro));
        v.put("CONSTRAINT", new ConstraintValidator(pro));
        v.put("COLUMN", new ColumnValidator(pro));
        v.put("TABLE", new TableValidator(pro));
        return v;
    }

    public void makeNameValidAndUnique(DBObject object, DBObjectProvider pro) throws InvalidNameException {
        String origName = object.getName();
        try {
            pro.validateObjectProperty(null, object, (Object)"name");
            return;
        }
        catch (ValidationException e) {
            String newName = null;
            int baseLength = 0;
            String baseName = object.getName();
            baseLength = baseName.length() < this.getMaxNameLength(object.getType()) ? baseName.length() : this.getMaxNameLength(object.getType()) - 1;
            String chunk = baseName.substring(0, baseLength);
            while (true) {
                try {
                    this.validateName(object.getType(), chunk);
                }
                catch (InvalidNameException e2) {
                    chunk = baseName.substring(0, --baseLength);
                    if (baseLength != 0) continue;
                    chunk = "NAME";
                    baseLength = 4;
                }
                break;
            }
            int suffix = 1;
            while (true) {
                if ((newName = chunk + suffix++).length() > this.getMaxNameLength(object.getType())) {
                    --baseLength;
                    continue;
                }
                if (suffix >= 10000) break;
                try {
                    object.setName(newName);
                    pro.validateObjectProperty(null, object, (Object)"name");
                    return;
                }
                catch (ValidationException e3) {
                    continue;
                }
                break;
            }
            object.setName(origName);
            throw new InvalidNameException(null, null);
        }
    }
}

