/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.ResultSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSequenceExpander
implements SchemaObjectExpander {
    DBObjectProvider m_pro;
    Table _table;
    private String[] _existingSequenceNames;
    private static final String COMMA_SPACE = ", ";
    private static final String NEXTVAL = ".NEXTVAL";
    private static final String CURRVAL = ".CURRVAL";
    private static final String NEW = ":NEW.";
    private static final String INTO = " INTO ";
    private static final String TRIGGER_PROLOG = "BEGIN\n  SELECT ";
    private static final String TRIGGER_EPILOG = " FROM DUAL;\nEND;\n";

    public ColumnSequenceExpander(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void expand(ResultSet rs) {
        ArrayList<SchemaObject> newSeqsAndTriggs = new ArrayList<SchemaObject>();
        for (ResultSet rs2 : rs.getAllObjectsList()) {
            SchemaObject[] sos;
            if (!(rs2.a() instanceof Table)) continue;
            this._table = (Table)rs2.a();
            this._existingSequenceNames = this.getSequenceNames(this._table.getSchema());
            ArrayList<String> rsSeqs = new ArrayList<String>();
            for (ResultSet rs3 : rs.getAllObjectsList()) {
                if (!(rs3.a() instanceof Sequence)) continue;
                Sequence seq = (Sequence)rs3.a();
                if (!this._table.getSchema().equals((Object)seq.getSchema())) continue;
                boolean found = false;
                int i = 0;
                while (i < this._existingSequenceNames.length) {
                    if (this._existingSequenceNames[i].equals(seq.getName())) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (found) continue;
                rsSeqs.add(seq.getName());
            }
            if (rsSeqs.size() > 0) {
                String[] sa = new String[this._existingSequenceNames.length + rsSeqs.size()];
                int i = 0;
                while (i < this._existingSequenceNames.length) {
                    sa[i] = this._existingSequenceNames[i];
                    ++i;
                }
                int i2 = 0;
                while (i2 < rsSeqs.size()) {
                    sa[i2 + this._existingSequenceNames.length] = (String)rsSeqs.get(i2);
                    ++i2;
                }
                this._existingSequenceNames = sa;
            }
            if ((sos = this.getSecondaryObjects()) == null) continue;
            SchemaObject[] schemaObjectArray = sos;
            int n = 0;
            while (n < schemaObjectArray.length) {
                SchemaObject so = schemaObjectArray[n];
                newSeqsAndTriggs.add(so);
                if (TemplateExpander.isPendingObject((SchemaObject)this._table)) {
                    TemplateExpander.copyTemplateProperty((SchemaObject)this._table, (SchemaObject)so);
                }
                ++n;
            }
        }
        if (newSeqsAndTriggs.size() > 0) {
            SchemaObject[] a = (SchemaObject[])rs.a();
            SchemaObject[] b = (SchemaObject[])rs.b();
            Object[] newa = new SchemaObject[a.length + newSeqsAndTriggs.size()];
            Object[] newb = new SchemaObject[a.length + newSeqsAndTriggs.size()];
            int i = 0;
            while (i < a.length) {
                newa[i] = a[i];
                newb[i] = b[i];
                ++i;
            }
            int i3 = 0;
            while (i3 < newSeqsAndTriggs.size()) {
                newa[i3 + a.length] = (SchemaObject)newSeqsAndTriggs.get(i3);
                newb[i3 + a.length] = null;
                ++i3;
            }
            ResultSet rs2 = this.m_pro.getDiffEngine().diff(newa, newb).getResult();
            rs2.copyTo((Object)rs);
        }
    }

    private SchemaObject[] getSecondaryObjects() {
        HashMap<String, DBObject> newSequences = new HashMap<String, DBObject>();
        HashMap<String, List<Column>> triggerColumnsMap = new HashMap<String, List<Column>>();
        Column[] columnArray = this._table.getColumns();
        int n = 0;
        while (n < columnArray.length) {
            DBObjectID trgID;
            Column column = columnArray[n];
            DBObjectID seqID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE");
            if (seqID != null) {
                try {
                    String seqName;
                    DBObject thisSeq = seqID.resolveID();
                    String string = seqName = thisSeq != null ? thisSeq.getName() : null;
                    if (!this.isExistingSequence(seqName) || !(this.m_pro instanceof Database)) {
                        DBObject seq = (DBObject)newSequences.get(seqName);
                        if (seq != null) {
                            column.setProperty("AUTO_GENERATED_SEQUENCE", (Object)seq.getID());
                        } else {
                            newSequences.put(thisSeq.getName(), thisSeq);
                        }
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            if ((trgID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE_TRIGGER")) != null) {
                try {
                    DBObject trg = trgID.resolveID();
                    ArrayList<Column> trgColumns = (ArrayList<Column>)triggerColumnsMap.get(trg.getName());
                    if (trgColumns != null) {
                        trgColumns.add(column);
                    } else {
                        trgColumns = new ArrayList<Column>();
                        trgColumns.add(column);
                        triggerColumnsMap.put(trg.getName(), trgColumns);
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            ++n;
        }
        Set<Trigger> newTriggers = this.createTriggers(triggerColumnsMap);
        if (newSequences.size() > 0 || newTriggers.size() > 0) {
            ArrayList<Object> newObjects = new ArrayList<Object>();
            newObjects.addAll(newSequences.values());
            newObjects.addAll(newTriggers);
            return newObjects.toArray(new SchemaObject[newObjects.size()]);
        }
        return null;
    }

    private Set<Trigger> createTriggers(Map<String, List<Column>> triggerColumnsMap) {
        HashSet<Trigger> triggers = new HashSet<Trigger>();
        for (String trgName : triggerColumnsMap.keySet()) {
            HashMap<DBObjectID, ArrayList<Column>> sequenceColumnsMap = new HashMap<DBObjectID, ArrayList<Column>>();
            for (Column column : triggerColumnsMap.get(trgName)) {
                DBObjectID seqID = (DBObjectID)column.getProperty("AUTO_GENERATED_SEQUENCE");
                ArrayList<Column> seqColumns = (ArrayList<Column>)sequenceColumnsMap.get(seqID);
                if (seqColumns != null) {
                    seqColumns.add(column);
                    continue;
                }
                seqColumns = new ArrayList<Column>();
                seqColumns.add(column);
                sequenceColumnsMap.put(seqID, seqColumns);
            }
            Trigger trigger = new Trigger(this._table.getSchema(), trgName);
            trigger.setTableID(this._table.getID());
            trigger.setTableOwner(this._table.getSchema());
            trigger.setStatementLevel(false);
            trigger.setBaseType(Trigger.BaseType.TABLE);
            trigger.setTiming(Trigger.Timing.BEFORE);
            trigger.setEvents(new String[]{"INSERT"});
            try {
                Trigger existingTrigger = (Trigger)this.m_pro.getObject("TRIGGER", this._table.getSchema(), trgName);
                if (existingTrigger != null) {
                    trigger.setID(existingTrigger.getID());
                }
            }
            catch (DBException e) {
                // empty catch block
            }
            if (trigger.getID() == null) {
                trigger.setID(TemporaryObjectID.createID((DBObject)trigger));
            }
            StringBuffer selectList = new StringBuffer();
            StringBuffer intoList = new StringBuffer();
            for (DBObjectID seqID : sequenceColumnsMap.keySet()) {
                String seqName = this.m_pro.getExternalName(DBUtil.getDBObjectName((DBObjectID)seqID));
                int colCount = 0;
                for (Column column : (List)sequenceColumnsMap.get(seqID)) {
                    column.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)trigger.getID());
                    if (selectList.length() > 0) {
                        selectList.append(COMMA_SPACE);
                        intoList.append(COMMA_SPACE);
                    }
                    selectList.append(seqName).append(colCount++ == 0 ? NEXTVAL : CURRVAL);
                    intoList.append(NEW).append(this.m_pro.getExternalName(column.getName()));
                }
            }
            StringBuffer code = new StringBuffer(TRIGGER_PROLOG).append(selectList).append(INTO).append(intoList).append(TRIGGER_EPILOG);
            trigger.setCode(code.toString());
            DDLGenerator g = this.m_pro.getDescriptor().getDDLGenerator(this.m_pro);
            if (g == null) {
                DBLog.getLogger().warning("Column Sequence support needs support for DDL Generation.");
            } else {
                try {
                    DDL ddl = g.getCreateDDL(new DDLOptions(true, false), new DBObject[]{trigger});
                    String source = ddl.toString(false);
                    trigger.setSource(source);
                }
                catch (Exception e) {
                    DBLog.getLogger().warning("Column Sequence support needs support for Trigger DDL Generation.");
                }
            }
            triggers.add(trigger);
        }
        return triggers;
    }

    private boolean isExistingSequence(String seqName) {
        String[] stringArray = this._existingSequenceNames;
        int n = 0;
        while (n < stringArray.length) {
            String existingSeqName = stringArray[n];
            if (existingSeqName.equals(seqName)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private String[] getSequenceNames(Schema schema) {
        try {
            String[] stringArray = this.m_pro.listObjects("SEQUENCE", schema);
            return stringArray;
        }
        catch (DBException dBException) {
            return null;
        }
    }
}

