/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.ModelUtil;

public class Properties {
    private static HashSet s_ignor;
    private Object m_object;
    private Map m_mapProps;
    private Map m_naturalProps;
    private Map m_children;
    private static NumberFormat formatter;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = Properties.class.desiredAssertionStatus() ^ true;
        s_ignor = new HashSet();
        s_ignor.add("ID");
        s_ignor.add("precision");
        s_ignor.add("scale");
        s_ignor.add("Parent");
        s_ignor.add("Index");
        s_ignor.add("Timestamp");
        formatter = new DecimalFormat("##0.####E0");
    }

    private void $init$() {
        this.m_mapProps = new HashMap();
        this.m_naturalProps = new HashMap();
        this.m_children = new HashMap();
    }

    public Properties(Object o) {
        this.$init$();
        this.m_object = o;
        Iterator pi = PropertyIterator.getPropertyIterator((Object)o);
        while (pi.hasNext()) {
            PropertyInfo propertyInfo = (PropertyInfo)pi.next();
            String propertyName = propertyInfo.getPropertyName();
            Class propertyClass = propertyInfo.getPropertyClass();
            if (s_ignor.contains(propertyName)) continue;
            if (propertyClass.isArray() && !propertyName.equals("referenceNames")) {
                this.m_children.put(propertyName, propertyInfo);
                continue;
            }
            if (propertyClass == Map.class) continue;
            this.m_naturalProps.put(propertyName, propertyInfo);
        }
        Map props = null;
        if (o instanceof DBObject) {
            props = ((DBObject)o).getProperties();
        } else if (o instanceof DynamicPropertySet) {
            props = ((DynamicPropertySet)o).getProperties();
        }
        if (props != null) {
            for (String key : props.keySet()) {
                if (s_ignor.contains(key) || key.equals("referenceNames")) continue;
                this.m_mapProps.put(key, props.get(key));
            }
        }
    }

    public static void ignor(String propertyName) {
        s_ignor.add(propertyName);
    }

    public void set(String property, Object value) {
        if (this.m_naturalProps.containsKey(property)) {
            PropertyInfo pi = (PropertyInfo)this.m_naturalProps.get(property);
            try {
                pi.setPropertyValue(this.m_object, value);
            }
            catch (Exception e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Cant set property: " + property.toString()));
                }
            }
        } else if (this.m_object instanceof DBObject) {
            ((DBObject)this.m_object).setProperty(property, value);
        }
    }

    public Object get(Object key) {
        Object result = null;
        if (this.m_naturalProps.containsKey(key)) {
            result = ((PropertyInfo)this.m_naturalProps.get(key)).getPropertyValue(this.m_object);
        } else if (this.m_children.containsKey(key)) {
            result = ((PropertyInfo)this.m_children.get(key)).getPropertyValue(this.m_object);
        } else if (this.m_object instanceof DBObject && key instanceof String) {
            result = ((DBObject)this.m_object).getProperty((String)key);
        } else if (this.m_mapProps.containsKey(key)) {
            result = this.m_mapProps.get(key);
        }
        return result;
    }

    public String getEVal(Object key) {
        String result = "";
        Object o = this.get(key);
        result = o instanceof BigInteger && ((BigInteger)o).abs().compareTo(new BigInteger("100000000")) > 0 ? formatter.format(o) : this.getStringVal(key);
        return result;
    }

    public String getStringVal(Object key) {
        String result = "";
        Object o = this.get(key);
        if (o != null) {
            if (o instanceof DBObjectID) {
                result = DBUtil.getDBObjectName((DBObjectID)((DBObjectID)o));
            }
            if (!ModelUtil.hasLength((String)result)) {
                result = o.toString();
            }
        }
        return result;
    }

    public boolean containsKey(Object key) {
        return this.m_mapProps.containsKey(key) || this.m_naturalProps.containsKey(key) || this.m_children.containsKey(key);
    }

    public void remove(Object key) {
        if (this.m_mapProps.containsKey(key)) {
            this.m_mapProps.remove(key);
        } else if (this.m_naturalProps.containsKey(key)) {
            this.m_naturalProps.remove(key);
        } else {
            this.m_children.remove(key);
        }
    }

    public Set keySet() {
        HashSet result = new HashSet(this.m_naturalProps.keySet());
        result.addAll(this.m_mapProps.keySet());
        return result;
    }

    public Set childKeySet() {
        return this.m_children.keySet();
    }
}

