/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.InvalidNameException;

public class SQLServerDatabaseDescriptor
extends BaseDatabaseDescriptor {
    public static final int MAX_NAME_LENGTH = 128;
    public static final int MAX_TEMP_NAME_LENGTH = 116;
    public static final char QUOTE_IDENTIFIER = '\"';
    public static final char OPEN_QUOTE_IDENTIFIER = '[';
    public static final char CLOSE_QUOTE_IDENTIFIER = ']';
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BEGIN", "BETWEEN", "BREAK", "BROWSE", "BULK", "BY", "CASCADE", "CASE", "CHECK", "CHECKPOINT", "CLOSE", "CLUSTERED", "COALESCE", "COLLATE", "COLUMN", "COMMIT", "COMPUTE", "CONSTRAINT", "CONTAINS", "CONTAINSTABLE", "CONTINUE", "CONVERT", "CREATE", "CROSS", "CURRENT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "DATABASE", "DBCC", "DEALLOCATE", "DECLARE", "DEFAULT", "DELETE", "DENY", "DESC", "DISK", "DISTINCT", "DISTRIBUTED", "DOUBLE", "DROP", "DUMMY", "DUMP", "ELSE", "END", "ERRLVL", "ESCAPE", "EXCEPT", "EXEC", "EXECUTE", "EXISTS", "EXIT", "FETCH", "FILE", "FILLFACTOR", "FOR", "FOREIGN", "FREETEXT", "FREETEXTTABLE", "FROM", "FULL", "FUNCTION", "GOTO", "GRANT", "GROUP", "HAVING", "HOLDLOCK", "IDENTITY", "IDENTITY_INSERT", "IDENTITYCOL", "IF", "IN", "INDEX", "INNER", "INSERT", "INTERSECT", "INTO", "IS", "JOIN", "KEY", "KILL", "LEFT", "LIKE", "LINENO", "LOAD", "NATIONAL", "NOCHECK", "NONCLUSTERED", "NOT", "NULL", "NULLIF", "OF", "OFF", "OFFSETS", "ON", "OPEN", "OPENDATASOURCE", "OPENQUERY", "OPENROWSET", "OPENXML", "OPTION", "OR", "ORDER", "OUTER", "OVER", "PERCENT", "PLAN", "PRECISION", "PRIMARY", "PRINT", "PROC", "PROCEDURE", "PUBLIC", "RAISERROR", "READ", "READTEXT", "RECONFIGURE", "REFERENCES", "REPLICATION", "RESTORE", "RESTRICT", "RETURN", "REVOKE", "RIGHT", "ROLLBACK", "ROWCOUNT", "ROWGUIDCOL", "RULE", "SAVE", "SCHEMA", "SELECT", "SESION_USER", "SET", "SETUSER", "SHUTDOWN", "SOME", "STATISTICS", "SYSTEM_USER", "TABLE", "TEXTSIZE", "THEN", "TO", "TOP", "TRAN", "TRANSACTION", "TRIGGER", "TRUNCATE", "TSEQUAL", "UNION", "UNIQUE", "UPDATE", "UPDATETEXT", "USE", "USER", "VALUES", "VARYING", "VIEW", "WAITFOR", "WHEN", "WHERE", "WHILE", "WITH", "WRITETEXT"));

    public int getCasePolicy() {
        return 0;
    }

    public int getQuotedNameCasePolicy() {
        return 0;
    }

    public String getIdentifierQuoteString() {
        return String.valueOf('\"');
    }

    public int getMaxNameLength(String type) {
        return 128;
    }

    public void validateName(String type, String name) throws InvalidNameException {
        boolean isValid = true;
        String reason = "";
        try {
            SQLServerDatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)128, (String)"_$#@", (boolean)false, (Set)RESERVED_WORDS, (int)this.getCasePolicy());
        }
        catch (InvalidNameException ine) {
            isValid = false;
            reason = ine.getMessage();
        }
        char firstChar = name.charAt(0);
        if (isValid && firstChar != '\"' && !Character.isLetter(firstChar) && firstChar != '_' && firstChar != '#' && firstChar != '@') {
            throw new InvalidNameException(null, DBArb.getString((int)353));
        }
        if (!isValid && firstChar == '[' && name.indexOf(91, 1) == -1 && name.indexOf(93, 1) == name.length() - 1 && name.length() > 2 && name.length() < 131) {
            isValid = true;
        }
        if (!isValid) {
            throw new InvalidNameException(null, reason);
        }
    }
}

