/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.SQLServer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.SQLServer.SQLServerDatabase;
import oracle.javatools.db.SQLServer.SQLServerDatabaseDescriptor;
import oracle.javatools.db.SQLServer.SQLServerDatabaseImpl;
import oracle.javatools.db.datatypes.DataTypeRegistry;

public class SQLServerDatabaseFactory
extends DatabaseFactory.DatabaseCreator {
    private DatabaseDescriptor m_descriptor;

    public SQLServerDatabaseFactory() {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        dtr.registerProvider((DataTypeRegistry.Registerer)new SQLServerDatabaseImpl.Registerer(), SQLServerDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        if (this.isSQLServerConnection(conn)) {
            return new SQLServerDatabaseImpl(connStore, connName, conn);
        }
        return null;
    }

    protected boolean isSQLServerConnection(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String databaseName = dmd.getDatabaseProductName();
                boolean bl = databaseName.indexOf("Microsoft SQL Server") > -1;
                return bl;
            }
            catch (SQLException sqlx) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (SQLServerDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new SQLServerDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

