/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.util.ModelUtil;

class DB2UniversalDatabaseConstraintValidator
extends ConstraintValidator {
    public DB2UniversalDatabaseConstraintValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected boolean incompatibleDataTypes(DataType fkColDataType, DataType refColDataType) {
        boolean incompatible = ModelUtil.areDifferent((Object)fkColDataType, (Object)refColDataType);
        if (incompatible) {
            if (fkColDataType instanceof NumericDataType && refColDataType instanceof NumericDataType) {
                return false;
            }
            if (this.isCharType(fkColDataType) && this.isCharType(refColDataType)) {
                return false;
            }
        }
        return incompatible;
    }

    private boolean isCharType(DataType dataType) {
        String dataTypeName = dataType.getName();
        return "CHAR".equals(dataTypeName) || "CHAR VARYING".equals(dataTypeName) || "CHARACTER".equals(dataTypeName) || "CHARACTER VARYING".equals(dataTypeName) || "VARCHAR".equals(dataTypeName);
    }
}

