/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.db2;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.db2.DB2DatabaseDescriptor;
import oracle.javatools.db.db2.DB2UniversalDatabase;
import oracle.javatools.db.db2.DB2UniversalDatabaseImpl;

public class DB2UniversalDatabaseFactory
extends DatabaseFactory.DatabaseCreator {
    private DatabaseDescriptor m_descriptor;

    public DB2UniversalDatabaseFactory() {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        dtr.registerProvider((DataTypeRegistry.Registerer)new DB2UniversalDatabaseImpl.Registerer(), DB2UniversalDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        if (this.isDB2UniversalConnection(conn)) {
            return new DB2UniversalDatabaseImpl(connStore, connName, conn);
        }
        return null;
    }

    protected boolean isDB2UniversalConnection(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                if (driverName.indexOf("DB2") > -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sqlx) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (DB2UniversalDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new DB2DatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

