/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.ResultSet;

public class ColumnConstraintDiffer
extends DBObjectDiffer {
    static final /* synthetic */ boolean $assertionsDisabled;

    public boolean diff(Object a, Object b) {
        ResultSet rs = new ResultSet(null, a, b, null, "MAP");
        DiffEngine de = new DiffEngine();
        DiffContext dc = new DiffContext(de, rs);
        return this.diff(a, b, rs, dc);
    }

    static {
        $assertionsDisabled = ColumnConstraintDiffer.class.desiredAssertionStatus() ^ true;
    }

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        if (!$assertionsDisabled && a == null && b == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && a != null && !(a instanceof ColumnConstraint)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && b != null && !(b instanceof ColumnConstraint)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !"MAP".equals(rs.getType())) {
            throw new AssertionError();
        }
        boolean attrsSame = this.diffAttributes((DBObject)a, (DBObject)b, rs, dc);
        Comparator cmp = dc.getEngine().getComparator(Column.class);
        boolean listSame = this.diffColList((ColumnConstraint)a, (ColumnConstraint)b, "columns", rs, dc, cmp);
        rs.setName(b == null ? ((DBObject)a).getName() : ((DBObject)b).getName());
        rs.setSame(attrsSame && listSame);
        return true;
    }

    protected boolean diffColList(ColumnConstraint a, ColumnConstraint b, String listName, ResultSet r, DiffContext dc, Comparator cmp) {
        return this.diffColListForceSame(a, b, listName, r, dc, cmp, false);
    }

    protected boolean diffColListForceSame(ColumnConstraint a, ColumnConstraint b, String listName, ResultSet r, DiffContext dc, Comparator cmp, boolean forceSame) {
        List<Object> aCols = a == null ? new ArrayList() : Arrays.asList(a.getColumns());
        List<Object> bCols = b == null ? new ArrayList() : Arrays.asList(b.getColumns());
        ResultSet rl = new ResultSet(r, (Object)a, (Object)b, listName, "LIST");
        ArrayList blist = new ArrayList(bCols);
        ArrayList<Column> added = new ArrayList<Column>();
        ArrayList<Column> removed = new ArrayList<Column>();
        boolean same = true;
        if (aCols != null) {
            for (Column column : aCols) {
                boolean found = false;
                Iterator bi = blist.iterator();
                while (bi.hasNext()) {
                    Column bo = (Column)bi.next();
                    if (cmp.compare(column, bo) != 0) continue;
                    bi.remove();
                    ResultSet rm = new ResultSet(rl, (Object)column, (Object)bo, aCols.indexOf(column), bCols.indexOf(bo), column.getName(), "MAP");
                    rm.setSame(true);
                    found = true;
                    break;
                }
                if (found) continue;
                removed.add(column);
                ResultSet rm = new ResultSet(rl, (Object)column, null, aCols.indexOf(column), -1, column.getName(), "MAP");
                if (forceSame) {
                    rm.setSame(true);
                }
                same = false;
            }
        }
        for (Column bo : blist) {
            added.add(bo);
            ResultSet rm = new ResultSet(rl, null, (Object)bo, -1, bCols.indexOf(bo), bo.getName(), "MAP");
            if (forceSame) {
                rm.setSame(true);
            }
            same = false;
        }
        int ai = 0;
        int bi = 0;
        while (ai < aCols.size() && bi < bCols.size()) {
            Object bo;
            Object ao = aCols.get(ai);
            if (cmp.compare(ao, bo = bCols.get(bi)) != 0) {
                if (removed.contains(bo)) {
                    while (bo != null && removed.contains(bo)) {
                        Object object = bo = ++bi < bCols.size() ? bCols.get(bi) : null;
                    }
                    --bi;
                } else if (added.contains(ao)) {
                    while (ao != null && added.contains(ao)) {
                        Object object = ao = ++ai < aCols.size() ? (Object)((List)a).get(ai) : null;
                    }
                    --ai;
                } else {
                    rl.setListReordered(true);
                    same = false;
                    break;
                }
            }
            ++ai;
            ++bi;
        }
        rl.setSame(same || forceSame);
        return same;
    }
}

