/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class DataTypeUsageDiffer
implements Differ {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = DataTypeUsageDiffer.class.desiredAssertionStatus() ^ true;
    }

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        if (!$assertionsDisabled && a == null && b == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && a != null && !(a instanceof DataTypeUsage)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && b != null && !(b instanceof DataTypeUsage)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !"MAP".equals(rs.getType())) {
            throw new AssertionError();
        }
        DataTypeUsage dtua = (DataTypeUsage)a;
        DataTypeUsage dtub = (DataTypeUsage)b;
        String ddla = null;
        String ddlb = null;
        if (dtua != null) {
            ddla = DataTypeHelper.getDDL((DataTypeUsage)dtua);
            DisplayProps.setAVal(rs, ddla);
        }
        if (dtub != null) {
            ddlb = DataTypeHelper.getDDL((DataTypeUsage)dtub);
            DisplayProps.setBVal(rs, ddlb);
        }
        Comparator dtuComparator = dc.getEngine().getComparator(DataTypeUsage.class);
        boolean same = true;
        same &= this.diffDatatypeName(dtua, dtub, rs);
        rs.setSame(same &= this.diffDatatypeAttr(dtua, dtub, rs, dc));
        if (!same) {
            for (ResultSet child : rs.getAllObjectsMap().values()) {
                child.setSame(false);
            }
        }
        return true;
    }

    protected boolean diffDatatypeName(DataTypeUsage a, DataTypeUsage b, ResultSet rs) {
        boolean nameSame = false;
        String name = null;
        String aname = this.getDataTypeName(a);
        String abasename = this.getDataTypeBaseName(a);
        String bname = this.getDataTypeName(b);
        String bbasename = this.getDataTypeBaseName(b);
        if (b != null) {
            name = bname;
            if (a != null) {
                nameSame = abasename.equals(bbasename);
            }
        } else {
            nameSame = false;
            name = aname;
        }
        ResultSet rDatatype = new ResultSet(rs, nameSame, (Object)a, (Object)b, "Datatype");
        DisplayProps.setAVal(rDatatype, aname);
        DisplayProps.setBVal(rDatatype, bname);
        return nameSame;
    }

    protected String getDataTypeName(DataTypeUsage dtu) {
        String name = null;
        try {
            if (dtu != null) {
                DBObject dbo = dtu.getDataTypeID().resolveID();
                name = dbo instanceof SchemaObject ? ((SchemaObject)dbo).getSchema().getName() + "." + dbo.getName() : dbo.getName();
            }
        }
        catch (DBException dbe) {
            DBLog.logStackTrace((Throwable)dbe);
        }
        return name;
    }

    private boolean diffDatatypeAttr(DataTypeUsage a, DataTypeUsage b, ResultSet r, DiffContext dc) {
        HashMap copyb;
        boolean result = true;
        DataType dta = null;
        DataType dtb = null;
        try {
            if (a != null) {
                DBObject dbo = a.getDataTypeID().resolveID();
                dta = (DataType)dbo;
            }
            if (b != null) {
                DBObject dbo = b.getDataTypeID().resolveID();
                dtb = (DataType)dbo;
            }
        }
        catch (DBException dbe) {
            // empty catch block
        }
        Map attra = null;
        Map attrb = b == null ? null : b.getAttributeValues();
        HashMap hashMap = copyb = attrb == null ? null : new HashMap(attrb);
        if (a != null && a.getAttributeValues() != null) {
            attra = a.getAttributeValues();
            for (String attrName : attra.keySet()) {
                Object aVal = this.getValueOrDefault(dta, a, attrName);
                Object bVal = null;
                String aValString = DataTypeHelper.getStringAttributeValue((DataTypeUsage)a, (String)attrName);
                if (dtb != null && (dtb.hasDataTypeAttribute(attrName) || aVal == null || attrb != null && attrb.get(attrName) != null)) {
                    bVal = this.getValueOrDefault(dtb, b, attrName);
                    String bValString = DataTypeHelper.getStringAttributeValue((DataTypeUsage)b, (String)attrName);
                    if (bVal != null || !dc.isSrcOffline() || dtb.getDataTypeAttribute(attrName) == null || dtb.getDataTypeAttribute(attrName).isMandatory()) {
                        if (ModelUtil.areEqual((Object)aValString, (Object)bValString) || bVal == null && this.isSynonym(b)) {
                            ResultSet rAttr = new ResultSet(r, true, (Object)a, (Object)b, attrName);
                            DisplayProps.setAVal(rAttr, aValString);
                            DisplayProps.setBVal(rAttr, bValString);
                        } else {
                            ResultSet rAttr = new ResultSet(r, false, (Object)a, (Object)b, attrName);
                            DisplayProps.setAVal(rAttr, aValString);
                            DisplayProps.setBVal(rAttr, bValString);
                            result = false;
                        }
                    }
                    copyb.remove(attrName);
                    continue;
                }
                boolean same = this.isSynonym(b);
                ResultSet rAttr = new ResultSet(r, same, (Object)a, (Object)b, attrName);
                DisplayProps.setAVal(rAttr, aValString);
                result &= same;
            }
        }
        if (copyb != null) {
            for (String attrName : copyb.keySet()) {
                String bValString = DataTypeHelper.getStringAttributeValue((DataTypeUsage)b, (String)attrName);
                Object bVal = this.getValueOrDefault(dtb, b, attrName);
                Object aVal = null;
                if (dta != null && dta.hasDataTypeAttribute(attrName)) {
                    aVal = this.getValueOrDefault(dta, a, attrName);
                    String aValString = DataTypeHelper.getStringAttributeValue((DataTypeUsage)a, (String)attrName);
                    if (ModelUtil.areEqual((Object)aVal, (Object)bVal) || this.isSynonym(a)) {
                        ResultSet rAttr = new ResultSet(r, true, (Object)a, (Object)b, attrName);
                        DisplayProps.setAVal(rAttr, aValString);
                        DisplayProps.setBVal(rAttr, bValString);
                        continue;
                    }
                    ResultSet rAttr = new ResultSet(r, false, (Object)a, (Object)b, attrName);
                    DisplayProps.setAVal(rAttr, aValString);
                    DisplayProps.setBVal(rAttr, bValString);
                    result = false;
                    continue;
                }
                boolean same = this.isSynonym(a);
                ResultSet rAttr = new ResultSet(r, same, (Object)a, (Object)b, attrName);
                DisplayProps.setBVal(rAttr, bValString);
                result &= same;
            }
        }
        return result;
    }

    protected String getDataTypeBaseName(DataTypeUsage dtu) {
        return this.getDataTypeName(dtu);
    }

    protected boolean isSynonym(DataTypeUsage dtu) {
        return false;
    }

    protected Object getValueOrDefault(DataType dt, DataTypeUsage dtu, String aname) {
        Object result = null;
        if (dtu != null && (result = dtu.getAttributeValue(aname)) == null && dt.hasDataTypeAttribute(aname)) {
            DataTypeAttribute dta = dt.getDataTypeAttribute(aname);
            result = dta.getDefaultValue();
        }
        return result;
    }
}

