/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.diff.DataTypeUsageDiffer;

public class DataTypeUsageDifferIgnorSynonyms
extends DataTypeUsageDiffer {
    protected String getDataTypeBaseName(DataTypeUsage dtu) {
        String name = this.getDataTypeName(dtu);
        try {
            DataTypeRegistry dtreg;
            DataType baseType;
            DBObject dbo;
            if (dtu != null && (dbo = dtu.getDataTypeID().resolveID()) instanceof DataType && (baseType = (dtreg = DataTypeRegistry.getInstance()).getBaseType((DataType)dbo)) != null) {
                name = baseType.getName();
            }
        }
        catch (DBException dbe) {
            DBLog.logStackTrace((Throwable)dbe);
        }
        return name;
    }

    protected boolean isSynonym(DataTypeUsage dtu) {
        boolean result = false;
        try {
            DataTypeRegistry dtreg;
            DataType baseType;
            DBObject dbo;
            if (dtu != null && (dbo = dtu.getDataTypeID().resolveID()) instanceof DataType && (baseType = (dtreg = DataTypeRegistry.getInstance()).getBaseType((DataType)dbo)) != null) {
                result = true;
            }
        }
        catch (DBException dbe) {
            DBLog.logStackTrace((Throwable)dbe);
        }
        return result;
    }

    protected Object getValueOrDefault(DataType dt, DataTypeUsage dtu, String aname) {
        Object result = null;
        if (dtu != null && (result = dtu.getAttributeValue(aname)) == null && dt.hasDataTypeAttribute(aname)) {
            DataTypeAttribute dta = dt.getDataTypeAttribute(aname);
            result = dta.getDefaultValue();
        }
        return result;
    }
}

