/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.diff.ColumnConstraintDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.GenericArrayDiffer;
import oracle.javatools.db.diff.ResultSet;

public class FKConstraintDiffer
extends ColumnConstraintDiffer {
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = FKConstraintDiffer.class.desiredAssertionStatus() ^ true;
    }

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        boolean result = super.diff(a, b, rs, dc);
        boolean same = rs.isSame();
        if (!$assertionsDisabled && a != null && !(a instanceof FKConstraint)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && b != null && !(b instanceof FKConstraint)) {
            throw new AssertionError();
        }
        try {
            DBObjectID arefID = null;
            DBObjectID brefID = null;
            UniqueConstraint arefCon = null;
            UniqueConstraint brefCon = null;
            Object arefRel = null;
            Object brefRel = null;
            String arefRelName = "";
            String brefRelName = "";
            String arefSchemaName = "";
            String brefSchemaName = "";
            String arefConName = "";
            String brefConName = "";
            String[] arefColNames = null;
            String[] brefColNames = null;
            if (a != null) {
                arefID = ((FKConstraint)a).getReferenceID();
                if (arefID instanceof ReferenceID) {
                    ReferenceID parentID = (ReferenceID)arefID.getParent();
                    arefSchemaName = parentID == null ? null : parentID.getSchemaName();
                    arefRelName = parentID == null ? null : parentID.getName();
                    arefConName = ((ReferenceID)arefID).getName();
                    arefColNames = ((ReferenceID)arefID).getChildObjectNames();
                } else {
                    arefCon = (UniqueConstraint)arefID.resolveID();
                    if (arefCon != null) {
                        Relation rel = arefCon.getRelation();
                        Schema schema = rel.getSchema();
                        arefSchemaName = schema.getName();
                        arefRelName = rel.getName();
                        arefConName = arefCon.getName();
                        Column[] cols = arefCon.getColumns();
                        arefColNames = new String[cols.length];
                        int i = 0;
                        while (i < cols.length) {
                            arefColNames[i] = cols[i].getName();
                            ++i;
                        }
                    }
                }
            }
            if (b != null) {
                brefID = ((FKConstraint)b).getReferenceID();
                if (brefID instanceof ReferenceID) {
                    ReferenceID parentID = (ReferenceID)brefID.getParent();
                    brefSchemaName = parentID == null ? null : parentID.getSchemaName();
                    brefRelName = parentID == null ? null : parentID.getName();
                    brefConName = ((ReferenceID)brefID).getName();
                    brefColNames = ((ReferenceID)brefID).getChildObjectNames();
                } else {
                    brefCon = (UniqueConstraint)brefID.resolveID();
                    if (brefCon != null) {
                        Relation rel = brefCon.getRelation();
                        Schema schema = rel.getSchema();
                        brefSchemaName = schema.getName();
                        brefRelName = rel.getName();
                        brefConName = brefCon.getName();
                        Column[] cols = brefCon.getColumns();
                        brefColNames = new String[cols.length];
                        int i = 0;
                        while (i < cols.length) {
                            brefColNames[i] = cols[i].getName();
                            ++i;
                        }
                    }
                }
            }
            ResultSet r1 = new ResultSet(rs, arefSchemaName.equals(brefSchemaName), a, b, "ReferencedSchema");
            DisplayProps.setAVal(r1, arefSchemaName);
            DisplayProps.setBVal(r1, brefSchemaName);
            ResultSet r2 = new ResultSet(rs, arefRelName.equals(brefRelName), a, b, "ReferencedRelation");
            DisplayProps.setAVal(r2, arefRelName);
            DisplayProps.setBVal(r2, brefRelName);
            ResultSet r3 = new ResultSet(rs, arefConName.equals(brefConName), a, b, "ReferencedConstraintName");
            DisplayProps.setAVal(r3, arefConName);
            DisplayProps.setBVal(r3, brefConName);
            ResultSet r4 = new ResultSet(rs, a, b, "ReferencedColumn", "LIST");
            GenericArrayDiffer gad = new GenericArrayDiffer();
            boolean diffRes = gad.diff((Object)arefColNames, (Object)brefColNames, r4, dc);
            same = same && r1.isSame() && r2.isSame() && r3.isSame() && r4.isSame();
        }
        catch (DBException dbe) {
            DBLog.logStackTrace((Throwable)dbe);
        }
        rs.setSame(same);
        return result;
    }

    protected boolean isIgnoredProperty(String name) {
        return name.equals("referenceID");
    }
}

