/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Map;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.util.ModelUtil;

public class OracleExternalTableReconcileDiffer
extends DBObjectDiffer {
    private OracleExternalTableProperties _a;
    private OracleExternalTableProperties _b;

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        ResultSet locationSpecificationsRS;
        this._a = (OracleExternalTableProperties)a;
        this._b = (OracleExternalTableProperties)b;
        DisplayProps.setDisplayMapAsFolder(rs, true);
        OracleExternalTableProperties aProps = this._a != null ? (OracleExternalTableProperties)this._a.copyTo(null) : null;
        OracleExternalTableProperties bProps = this._b != null ? (OracleExternalTableProperties)this._b.copyTo(null) : null;
        this.replaceNullLocationSpecifierDirectory(aProps);
        this.replaceNullLocationSpecifierDirectory(bProps);
        boolean res = super.diff(aProps, bProps, rs, dc);
        Map allObjectsMap = rs.getAllObjectsMap();
        if (allObjectsMap != null && (locationSpecificationsRS = (ResultSet)allObjectsMap.get("locationSpecifiers")) != null) {
            for (ResultSet locSpecRS : locationSpecificationsRS.getBList()) {
                OracleExternalTableProperties.LocationSpecifier locSpec = (OracleExternalTableProperties.LocationSpecifier)locSpecRS.b();
                locSpecRS.setName(this.getLocSpecNodeName(locSpec));
            }
            for (ResultSet locSpecRS : locationSpecificationsRS.getAList()) {
                OracleExternalTableProperties.LocationSpecifier locSpec = (OracleExternalTableProperties.LocationSpecifier)locSpecRS.a();
                locSpecRS.setName(this.getLocSpecNodeName(locSpec));
            }
        }
        return res;
    }

    protected boolean isIgnoredProperty(String propertyName) {
        return "name".equals(propertyName);
    }

    private void replaceNullLocationSpecifierDirectory(OracleExternalTableProperties props) {
        OracleExternalTableProperties.LocationSpecifier[] locationSpecifiers;
        OracleExternalTableProperties.LocationSpecifier[] locationSpecifierArray = locationSpecifiers = props != null ? props.getLocationSpecifiers() : null;
        if (locationSpecifiers != null) {
            DBObjectID defaultDir = props.getDefaultDirectory();
            OracleExternalTableProperties.LocationSpecifier[] locationSpecifierArray2 = locationSpecifiers;
            int n = 0;
            while (n < locationSpecifierArray2.length) {
                OracleExternalTableProperties.LocationSpecifier locSpec = locationSpecifierArray2[n];
                if (locSpec.getDirectory() == null) {
                    locSpec.setDirectory(defaultDir);
                }
                ++n;
            }
        }
    }

    private String getLocSpecNodeName(OracleExternalTableProperties.LocationSpecifier locSpec) {
        if (locSpec != null) {
            String dirName = DBUtil.getDBObjectName((DBObjectID)locSpec.getDirectory());
            String locName = ModelUtil.hasLength((String)locSpec.getSpecifier()) ? locSpec.getSpecifier() : "<empty>";
            return dirName + (dirName.length() > 0 ? " : " : "") + locName;
        }
        return "<empty>";
    }
}

