/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Map;
import oracle.javatools.db.Properties;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.util.ModelUtil;

public class OracleIOTPropertiesReconcileDiffer
extends DBObjectDiffer {
    private Properties _aProperties;
    private Properties _bProperties;
    private static final String PROPERTYNAME_OVERFLOW_PROPERTIES = "overflowProperties";
    private static final String PROPERTYNAME_OVERFLOWABLE = "overflowable";
    private static final String PROPERTYNAME_INCLUDE_COLUMN = "includeColumn";
    private static final String PROPERTYNAME_KEY_COMPRESSION = "keyCompression";

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        ResultSet keyCompression;
        this._aProperties = a != null ? new Properties(a) : null;
        this._bProperties = b != null ? new Properties(b) : null;
        DisplayProps.setDisplayMapAsFolder(rs, true);
        boolean res = super.diff(a, b, rs, dc);
        Map allObjectsMap = rs.getAllObjectsMap();
        if (allObjectsMap != null && allObjectsMap.containsKey(PROPERTYNAME_KEY_COMPRESSION) && (keyCompression = (ResultSet)allObjectsMap.get(PROPERTYNAME_KEY_COMPRESSION)) != null) {
            DisplayProps.setAVal(keyCompression, this.getKeyCompression(DisplayProps.getAVal(keyCompression)));
            DisplayProps.setBVal(keyCompression, this.getKeyCompression(DisplayProps.getBVal(keyCompression)));
        }
        return res;
    }

    protected boolean diffSubAttributes(String propertyName) {
        return PROPERTYNAME_OVERFLOW_PROPERTIES.equals(propertyName);
    }

    protected boolean isIgnoredProperty(String propertyName) {
        return "table".equals(propertyName) || this._aProperties == null && this._bProperties == null || this._aProperties == null && this.isIgnoredProperty(propertyName, this._bProperties) || this._bProperties == null && this.isIgnoredProperty(propertyName, this._aProperties) || this._aProperties != null && this._bProperties != null && this.isIgnoredProperty(propertyName, this._bProperties);
    }

    private boolean isIgnoredProperty(String propertyName, Properties p) {
        return p == null || p.get(propertyName) == null && !PROPERTYNAME_KEY_COMPRESSION.equals(propertyName) || this.isDisabledOverflowProperty(propertyName, p);
    }

    private boolean isDisabledOverflowProperty(String propertyName, Properties p) {
        Object overflowable = p != null ? p.get(PROPERTYNAME_OVERFLOWABLE) : null;
        boolean hasOverflow = overflowable != null ? (Boolean)overflowable : false;
        return !hasOverflow && (PROPERTYNAME_OVERFLOW_PROPERTIES.equals(propertyName) || PROPERTYNAME_INCLUDE_COLUMN.equals(propertyName));
    }

    private boolean isDefaultKeyCompression(String propertyName) {
        if (PROPERTYNAME_KEY_COMPRESSION.equals(propertyName)) {
            Object keyCompression = this._bProperties.get(PROPERTYNAME_KEY_COMPRESSION);
            return keyCompression != null && (Integer)keyCompression == 0 && this._aProperties.get(PROPERTYNAME_KEY_COMPRESSION) != null;
        }
        return false;
    }

    private String getKeyCompression(String apiVal) {
        return ModelUtil.hasLength((String)apiVal) ? (apiVal.equals("0") ? "COMPRESS" : "COMPRESS " + apiVal) : "NOCOMPRESS";
    }
}

