/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import oracle.javatools.db.Properties;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.util.ModelUtil;

public class OracleTablePartitionsReconcileDiffer
extends DBObjectDiffer {
    private Stack<OracleTablePartitions> _b;
    private Stack<Properties> _bProperties;
    private Stack<OracleTablePartitions> _a;
    private Stack<Properties> _aProperties;
    private static final String PROPERTY_OBJECT_TYPE = "objectType";
    private static final String PROPERTY_HASH_QUANTITY_TABLESPACES = "hashQuantityTablespaces";
    private static final String PROPERTY_PARTITION_COLUMNS = "partitionColumns";
    private static final String PROPERTY_PARTITIONS = "partitions";
    private static final String PROPERTY_SUBPARTITION_MODEL = "subpartitionModel";

    public OracleTablePartitionsReconcileDiffer() {
        this.$init$();
    }

    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        ResultSet partitionColumnsRS;
        ResultSet partitionsRS;
        this._a.push((OracleTablePartitions)a);
        this._aProperties.push(a != null ? new Properties(a) : null);
        this._b.push((OracleTablePartitions)b);
        this._bProperties.push(b != null ? new Properties(b) : null);
        DisplayProps.setDisplayMapAsFolder(rs, true);
        boolean res = super.diff(a, b, rs, dc);
        Map props = rs.getAllObjectsMap();
        ResultSet objectTypeRS = (ResultSet)props.get(PROPERTY_OBJECT_TYPE);
        if (objectTypeRS != null) {
            DisplayProps.setDisplay(objectTypeRS, false);
        }
        if ((partitionsRS = (ResultSet)props.get(PROPERTY_PARTITIONS)) != null) {
            List partitions = partitionsRS.getAllObjectsList();
            if (partitions == null || partitions.size() == 0) {
                DisplayProps.setDisplay(partitionsRS, false);
            } else if (objectTypeRS != null) {
                String objectType;
                String string = ModelUtil.hasLength((String)DisplayProps.getAVal(objectTypeRS)) ? DisplayProps.getAVal(objectTypeRS) : (objectType = ModelUtil.hasLength((String)DisplayProps.getBVal(objectTypeRS)) ? DisplayProps.getBVal(objectTypeRS) : null);
                if (objectType != null && !OracleTablePartitions.ObjectType.PARTITION.name().equals(objectType)) {
                    partitionsRS.setName("subpartitions");
                }
            }
        }
        if ((partitionColumnsRS = (ResultSet)props.get(PROPERTY_PARTITION_COLUMNS)) != null) {
            List partitionColumns = partitionColumnsRS.getAllObjectsList();
            if (partitionColumns == null || partitionColumns.size() == 0) {
                DisplayProps.setDisplay(partitionColumnsRS, false);
            } else {
                for (ResultSet column : partitionColumns) {
                    Map columnProps = column.getAllObjectsMap();
                    Iterator key = columnProps.keySet().iterator();
                    while (key.hasNext()) {
                        ResultSet value = (ResultSet)columnProps.get(key.next());
                        DisplayProps.setDisplay(value, false);
                    }
                }
            }
        }
        this._a.pop();
        this._aProperties.pop();
        this._b.pop();
        this._bProperties.pop();
        return res;
    }

    protected boolean diffSubAttributes(String propertyName) {
        return PROPERTY_SUBPARTITION_MODEL.equals(propertyName);
    }

    protected boolean isIgnoredProperty(String propertyName) {
        return "name".equals(propertyName) || this._a.peek() == null && this._b.peek() == null || this._a.peek() == null && this.isIgnoredProperty(propertyName, this._bProperties.peek()) || this._b.peek() == null && this.isIgnoredProperty(propertyName, this._aProperties.peek()) || this._a.peek() != null && this._b.peek() != null && this.isIgnoredProperty(propertyName, this._bProperties.peek());
    }

    private boolean isIgnoredProperty(String propertyName, Properties p) {
        return p == null || p.get(propertyName) == null || PROPERTY_HASH_QUANTITY_TABLESPACES.equals(propertyName) && ((Object[])p.get(propertyName)).length == 0;
    }

    private void $init$() {
        this._b = new Stack();
        this._bProperties = new Stack();
        this._a = new Stack();
        this._aProperties = new Stack();
    }
}

