/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Map;
import oracle.javatools.db.diff.DBObjectReconcileDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;

public class TableReconcileDiffer
extends DBObjectReconcileDiffer {
    public boolean diff(Object a, Object b, ResultSet rs, DiffContext dc) {
        ResultSet parRS;
        ResultSet compRs;
        ResultSet schema;
        boolean res = super.diff(a, b, rs, dc);
        Map allObjectsMap = rs.getAllObjectsMap();
        if (allObjectsMap != null && allObjectsMap.containsKey("schema") && (schema = (ResultSet)allObjectsMap.get("schema")) != null) {
            DisplayProps.setDisplayMapAsFolder(schema, true);
        }
        if (allObjectsMap != null && allObjectsMap.containsKey("compression") && (compRs = (ResultSet)allObjectsMap.get("compression")) != null) {
            if (DisplayProps.getAVal(compRs) == null) {
                DisplayProps.setAVal(compRs, Boolean.FALSE.toString());
            }
            if (DisplayProps.getBVal(compRs) == null) {
                DisplayProps.setBVal(compRs, Boolean.FALSE.toString());
            }
        }
        if (allObjectsMap != null && allObjectsMap.containsKey("parallel") && (parRS = (ResultSet)allObjectsMap.get("parallel")) != null) {
            DisplayProps.setAVal(parRS, this.getParallelDisplayVal(DisplayProps.getAVal(parRS)));
            DisplayProps.setBVal(parRS, this.getParallelDisplayVal(DisplayProps.getBVal(parRS)));
        }
        return res;
    }

    protected boolean diffSubAttributes(String propertyName) {
        return "OracleStorageProperties".equals(propertyName) || "OracleIndexOrganizedTableProperties".equals(propertyName) || "OracleExternalTableProperties".equals(propertyName) || "OracleTablePartitions".equals(propertyName);
    }

    private String getParallelDisplayVal(String parallel) {
        if (parallel == null) {
            return "1";
        }
        return parallel;
    }
}

