/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.validators.ConstraintValidator;
import oracle.javatools.util.ModelUtil;

class InformixConstraintValidator
extends ConstraintValidator {
    private static HashMap compatibleTypesMap;

    public InformixConstraintValidator(DBObjectProvider prov) {
        super(prov);
    }

    protected boolean incompatibleDataTypes(DataType fkColDataType, DataType refColDataType) {
        boolean incompatible = ModelUtil.areDifferent((Object)fkColDataType, (Object)refColDataType);
        if (incompatible) {
            ArrayList compatibleRefTypes;
            if (compatibleTypesMap == null) {
                InformixConstraintValidator.initialiseCompatibleTypesMap();
            }
            if ((compatibleRefTypes = (ArrayList)compatibleTypesMap.get(fkColDataType.getName())) != null && compatibleRefTypes.contains(refColDataType.getName())) {
                incompatible = false;
            }
        }
        return incompatible;
    }

    protected boolean isValidConstraintDatatype(String dataTypeName, DataTypeUsage dataTypeUsage) {
        return (dataTypeName.equals("BYTE") || dataTypeName.equals("TEXT")) ^ true;
    }

    private static void initialiseCompatibleTypesMap() {
        compatibleTypesMap = new HashMap();
        String[] INT = new String[]{"INTEGER", "SERIAL"};
        String[] INTEGER = new String[]{"INT", "SERIAL"};
        String[] SERIAL = new String[]{"INT", "INTEGER"};
        String[] INT8 = new String[]{"SERIAL8"};
        String[] SERIAL8 = new String[]{"INT8"};
        compatibleTypesMap.put("INT", new ArrayList<String>(Arrays.asList(INT)));
        compatibleTypesMap.put("INTEGER", new ArrayList<String>(Arrays.asList(INTEGER)));
        compatibleTypesMap.put("SERIAL", new ArrayList<String>(Arrays.asList(SERIAL)));
        compatibleTypesMap.put("INT8", new ArrayList<String>(Arrays.asList(INT8)));
        compatibleTypesMap.put("SERIAL8", new ArrayList<String>(Arrays.asList(SERIAL8)));
    }
}

