/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.JdbcDatabaseImpl;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDecimalDatatype;
import oracle.javatools.db.informix.InformixTimeDatatype;
import oracle.javatools.db.informix.InformixVarcharDatatype;

public abstract class InformixDatabaseImpl
extends JdbcDatabaseImpl
implements InformixDatabase {
    static final Long LONG_0 = new Long(0L);
    static final Long LONG_1 = new Long(1L);
    static final Long LONG_2 = new Long(2);
    static final Long LONG_16 = new Long(16);
    private String _driverName;
    private static final String IBM_INFORMIX_JDBC_DRIVER = "IBM Informix JDBC Driver";

    protected InformixDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    public DataType getDataType(String typeName) {
        return super.getDataType(typeName.trim().toUpperCase());
    }

    public String normaliseDataTypeName(String dmdDataTypeName) {
        String typeName = dmdDataTypeName.trim().replaceAll("\\s", " ");
        return typeName.compareToIgnoreCase("INT") == 0 ? "INTEGER" : typeName;
    }

    public String normaliseDefaultValue(DataType dataType, String defaultValue) {
        if (dataType instanceof CharacterDataType) {
            defaultValue = defaultValue.replaceAll("'", "''");
            defaultValue = "'" + defaultValue + "'";
        }
        return defaultValue;
    }

    public String getNameForDriver(String name) {
        if (name != null && this._getDriverName() != null && this._getDriverName().startsWith(IBM_INFORMIX_JDBC_DRIVER)) {
            String lc = name.toLowerCase();
            return name.equals(lc) ? name : null;
        }
        return name;
    }

    private String _getDriverName() {
        if (this._driverName == null) {
            try {
                this._driverName = this.getConnection().getMetaData().getDriverName();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this._driverName;
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dtr) {
            DataTypeAttribute BLOBSPACE = new DataTypeAttribute("blobspace", 18, new String[]{"TABLE"}, null, true, false);
            DataTypeAttribute BYTE_TEXT_SIZE = new DataTypeAttribute("size", 1L, Integer.MAX_VALUE);
            DataTypeAttribute SERIAL_START = new DataTypeAttribute("start", 247, 1L, new Long(Integer.MAX_VALUE), LONG_1, false);
            DataTypeAttribute SERIAL8_START = new DataTypeAttribute("start", 247, 1L, new Long(Long.MAX_VALUE), LONG_1, false);
            NumericDataType.MinMaxValue MIN_MAX_INT8 = new NumericDataType.MinMaxValue("-9223372036854775807", "9223372036854775807", 0);
            NumericDataType.MinMaxValue MIN_MAX_INT = new NumericDataType.MinMaxValue("-2147483647", "2147483647", 0);
            NumericDataType.MinMaxValue MIN_MAX_SMALLINT = new NumericDataType.MinMaxValue("-32767", "32767", 0);
            NumericDataType.MinMaxValue MIN_MAX_SERIAL = new NumericDataType.MinMaxValue("1", "2147483647", 1);
            NumericDataType.MinMaxValue MIN_MAX_SERIAL8 = new NumericDataType.MinMaxValue("1", "9223372036854775807", 1);
            NumericDataType INT8 = new NumericDataType(65535, "INT8", MIN_MAX_INT8);
            NumericDataType INTEGER = new NumericDataType(65535, "INTEGER", MIN_MAX_INT);
            NumericDataType SMALLINT = new NumericDataType(65535, "SMALLINT", MIN_MAX_SMALLINT);
            NumericDataType SERIAL = new NumericDataType(65535, "SERIAL", "SERIAL[(<start>)]", new DataTypeAttribute[]{SERIAL_START}, MIN_MAX_SERIAL);
            NumericDataType SERIAL8 = new NumericDataType(65535, "SERIAL8", "SERIAL8[(<start>)]", new DataTypeAttribute[]{SERIAL8_START}, MIN_MAX_SERIAL8);
            InformixDecimalDatatype DECIMAL = new InformixDecimalDatatype(65535);
            NumericDataType MONEY = new NumericDataType(65535, "MONEY", "MONEY[(<precision>[, <scale>])]", 1L, (long)32, LONG_16, false, 0L, null, LONG_2, false, null, null);
            NumericDataType FLOAT = new NumericDataType(65535, "FLOAT", "FLOAT[(<precision>)]", 1L, (long)14, null, false, null, null);
            NumericDataType DOUBLE_PRECISION = new NumericDataType(65535, "DOUBLE PRECISION", null);
            NumericDataType SMALLFLOAT = new NumericDataType(65535, "SMALLFLOAT", null);
            PredefinedDataType DATE = new PredefinedDataType(65535, "DATE");
            InformixTimeDatatype DATETIME = new InformixTimeDatatype(65535, "DATETIME");
            InformixTimeDatatype INTERVAL = new InformixTimeDatatype(65535, "INTERVAL");
            CharacterDataType CHAR = new CharacterDataType(65535, "CHAR", "CHAR[(<size>)]", 1L, 32767L, 1L, false, null);
            CharacterDataType NCHAR = new CharacterDataType(65535, "NCHAR", "NCHAR[(<size>)]", 1L, 32767L, 1L, false, null);
            InformixVarcharDatatype VARCHAR = new InformixVarcharDatatype(65533, "VARCHAR");
            InformixVarcharDatatype NVARCHAR = new InformixVarcharDatatype(65533, "NVARCHAR");
            CharacterDataType TEXT = new CharacterDataType(65535, "TEXT", "TEXT[ IN <blobspace>]", new DataTypeAttribute[]{BLOBSPACE, BYTE_TEXT_SIZE});
            BinaryDataType BYTE = new BinaryDataType(65535, "BYTE", "BYTE[ IN <blobspace>]", new DataTypeAttribute[]{BLOBSPACE, BYTE_TEXT_SIZE});
            dtr.registerDataType((DataType)INT8, InformixDatabaseImpl.class, JdbcDatabase.ANSI_BIGINT);
            dtr.registerDataType((DataType)INTEGER, InformixDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dtr.registerDataType((DataType)SMALLINT, InformixDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dtr.registerDataType((DataType)SERIAL, InformixDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dtr.registerDataType((DataType)SERIAL8, InformixDatabaseImpl.class, JdbcDatabase.ANSI_BIGINT);
            dtr.registerDataType((DataType)DECIMAL, InformixDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)MONEY, InformixDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)FLOAT, InformixDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)SMALLFLOAT, InformixDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)DOUBLE_PRECISION, InformixDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)DATE, InformixDatabaseImpl.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)DATETIME, InformixDatabaseImpl.class, JdbcDatabase.ANSI_INTERVAL);
            dtr.registerDataType((DataType)INTERVAL, InformixDatabaseImpl.class, JdbcDatabase.ANSI_INTERVAL);
            dtr.registerDataType((DataType)CHAR, InformixDatabaseImpl.class, JdbcDatabase.ANSI_CHAR);
            dtr.registerDataType((DataType)NCHAR, InformixDatabaseImpl.class, JdbcDatabase.ANSI_NCHAR);
            dtr.registerDataType((DataType)VARCHAR, InformixDatabaseImpl.class, JdbcDatabase.ANSI_VARCHAR);
            dtr.registerDataType((DataType)NVARCHAR, InformixDatabaseImpl.class, JdbcDatabase.ANSI_NCHAR_VARYING);
            dtr.registerDataType((DataType)TEXT, InformixDatabaseImpl.class, JdbcDatabase.ANSI_CLOB);
            dtr.registerDataType((DataType)BYTE, InformixDatabaseImpl.class, JdbcDatabase.ANSI_BLOB);
            dtr.registerSynonym("CHARACTER", (DataType)CHAR, InformixDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER VARYING", (DataType)VARCHAR, InformixDatabaseImpl.class);
            dtr.registerSynonym("DEC", (DataType)DECIMAL, InformixDatabaseImpl.class);
            dtr.registerSynonym("INT", (DataType)INTEGER, InformixDatabaseImpl.class);
            dtr.registerSynonym("NUMERIC", (DataType)DECIMAL, InformixDatabaseImpl.class);
            dtr.registerSynonym("REAL", (DataType)SMALLFLOAT, InformixDatabaseImpl.class);
        }

        Registerer() {
        }
    }
}

