/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.informix.InformixDatabase;
import oracle.javatools.db.informix.InformixDatabaseImpl;
import oracle.javatools.db.informix.InformixDynamicServerDescriptor;
import oracle.javatools.db.informix.InformixDynamicServerImpl;

public class InformixDynamicServerFactory
extends DatabaseFactory.DatabaseCreator {
    private DatabaseDescriptor m_descriptor;

    public InformixDynamicServerFactory() {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        dtr.registerProvider((DataTypeRegistry.Registerer)new InformixDatabaseImpl.Registerer(), InformixDatabaseImpl.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new InformixDynamicServerImpl.Registerer(), InformixDynamicServerImpl.class);
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        if (this.isInformixConnection(conn)) {
            return new InformixDynamicServerImpl(connStore, connName, conn);
        }
        return null;
    }

    protected boolean isInformixConnection(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String driverName = dmd.getDriverName();
                if (driverName.indexOf("Informix") > -1) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (SQLException sqlx) {
                // empty catch block
            }
        }
        return false;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (InformixDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new InformixDynamicServerDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

