/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InformixTimeDatatype
extends PredefinedDataType {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final Long LONG_3;
    private static final Long LONG_4;
    private static final Long LONG_5;
    private static final Long LONG_9;
    private static final String[] m_timeUnits;

    public InformixTimeDatatype() {
    }

    public InformixTimeDatatype(int domain, String name) {
        super(domain, name, name.equals("DATETIME") ? "DATETIME[ <from> TO <to>[(<scale>)]]" : "INTERVAL[ <from>[(<precision>)] TO <to>[(<scale>)]]", null);
        int idx = 0;
        this.addAttribute(new DataTypeAttribute("from", 342, m_timeUnits, null, false, false), idx++);
        if (name.equals("INTERVAL")) {
            this.addAttribute(new DataTypeAttribute("precision", 301, 1L, LONG_9, LONG_4, false), idx++);
        }
        this.addAttribute(new DataTypeAttribute("to", 299, m_timeUnits, null, false, false), idx++);
        this.addAttribute(new DataTypeAttribute("scale", 368, 1L, LONG_5, LONG_3, false), idx++);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        InformixTimeDatatype copy = target != null ? (InformixTimeDatatype)target : new InformixTimeDatatype();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object obj) {
        return obj instanceof InformixTimeDatatype && this.equalsImpl((InformixTimeDatatype)((Object)obj));
    }

    static {
        $assertionsDisabled = InformixTimeDatatype.class.desiredAssertionStatus() ^ true;
        LONG_3 = new Long(3);
        LONG_4 = new Long(4);
        LONG_5 = new Long(5);
        LONG_9 = new Long(9);
        m_timeUnits = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "FRACTION"};
    }

    public DataTypeUsage createUsage(Map<String, Object> attributeValues) {
        if (!$assertionsDisabled && attributeValues == null) {
            throw new AssertionError();
        }
        String dataType = (String)attributeValues.get("name");
        Long size = DataTypeHelper.toLong((Object)attributeValues.get("size"));
        if (dataType != null && size != null) {
            int precision = size.intValue() / 256;
            int fromType = (size.intValue() - precision * 256) / 16;
            int toType = size.intValue() - precision * 256 - fromType * 16;
            attributeValues.put("from", this.getTypeName(fromType));
            attributeValues.put("to", this.getTypeName(toType));
            attributeValues.put("precision", new Long(precision));
            if (toType > 10) {
                attributeValues.put("scale", new Long(toType - 10));
            } else {
                attributeValues.remove("scale");
            }
        }
        return super.createUsage(attributeValues);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dbObject);
        String from = (String)dataTypeUsage.getAttributeValue("from");
        String to = (String)dataTypeUsage.getAttributeValue("to");
        Long scale = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
        if (from != null && to == null || from == null && to != null) {
            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.getString((int)45));
        }
        if (scale != null && to != null && to.compareToIgnoreCase("FRACTION") != 0) {
            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.getString((int)318));
        }
        if (from != null) {
            to = to.toUpperCase();
            from = from.toUpperCase();
            if (this.indexOf(to) < this.indexOf(from)) {
                throw new DataTypeValidationException(dbObject, this.getName(), DBArb.getString((int)222));
            }
            if (this.getName().equals("INTERVAL")) {
                if ((from.equals("YEAR") || from.equals("MONTH")) && !to.equals("YEAR") && !to.equals("MONTH")) {
                    throw new DataTypeValidationException(dbObject, this.getName(), DBArb.getString((int)194));
                }
                Long precision = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"precision");
                if (from.equals("FRACTION") && precision != null && precision.compareTo(LONG_5) > 0) {
                    throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format((int)327, (Object)DBArb.getString((int)301).replaceAll("&", ""), (Object)LONG_5));
                }
            }
        }
    }

    private int indexOf(String timeUnit) {
        int idx = 0;
        while (!m_timeUnits[idx].equals(timeUnit)) {
            ++idx;
        }
        return idx;
    }

    private String getTypeName(int typeCode) {
        return typeCode > 10 ? m_timeUnits[6] : m_timeUnits[typeCode / 2];
    }
}

