/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.informix;

import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InformixVarcharDatatype
extends PredefinedDataType {
    static final /* synthetic */ boolean $assertionsDisabled;

    public InformixVarcharDatatype() {
    }

    public InformixVarcharDatatype(int domain, String name) {
        super(domain, name, domain == 2 ? name + "[(<size>[, <reserve>])]" : name + "(<size>[, <reserve>])", null);
        this.addAttribute(new DataTypeAttribute("size", 325, 1L, new Long(255L), new Long(1L), domain == 2 ^ true), 0);
        this.addAttribute(new DataTypeAttribute("reserve", 345, 0L, null, new Long(0L), false), 1);
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        InformixVarcharDatatype copy = target != null ? (InformixVarcharDatatype)target : new InformixVarcharDatatype();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object obj) {
        return obj instanceof InformixVarcharDatatype && this.equalsImpl((InformixVarcharDatatype)((Object)obj));
    }

    static {
        $assertionsDisabled = InformixVarcharDatatype.class.desiredAssertionStatus() ^ true;
    }

    public DataTypeUsage createUsage(Map<String, Object> attributeValues) {
        if (!$assertionsDisabled && attributeValues == null) {
            throw new AssertionError();
        }
        String dataType = (String)attributeValues.get("name");
        Long size = DataTypeHelper.toLong((Object)attributeValues.get("size"));
        if (dataType != null && size != null) {
            long length = size < 0L ? size + 65536L : size;
            long reserve = length / 256L;
            attributeValues.put("size", new Long(length - reserve * 256L));
            attributeValues.put("reserve", new Long(reserve));
        }
        return super.createUsage(attributeValues);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dbObject);
        Long size = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"size");
        Long reserve = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"reserve");
        if (reserve != null && size != null && reserve.compareTo(size) > 0) {
            throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format((int)327, (Object)DBArb.getString((int)345).replaceAll("&", ""), (Object)size));
        }
    }
}

