/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

public abstract class DMDBuilder
extends AbstractDBObjectBuilder {
    private String m_catalog;
    private String m_driverName;

    protected DMDBuilder(JdbcDatabase db, String catalog, String type) {
        super((AbstractDBObjectProvider)db, type);
        this.m_catalog = catalog;
    }

    public JdbcDatabase getDatabase() {
        return (JdbcDatabase)this.getProvider();
    }

    public Connection getConnection() {
        return this.getDatabase().getConnection();
    }

    public boolean isUseSchema() {
        return this.getDatabase().isUseSchema();
    }

    public String getCatalog() {
        return this.m_catalog;
    }

    public String _getDriverName() {
        if (this.m_driverName == null) {
            try {
                this.m_driverName = this.getConnection().getMetaData().getDriverName();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.m_driverName;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
    }

    protected String[] getCatalogAndSchema(Schema schema) {
        String schemaName;
        String cat;
        if (schema != null) {
            try {
                schema = this.getDatabase().getSchema(schema.getName());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        if ((cat = (String)schema.getProperty("DMD_CATALOG_NAME")) == null) {
            cat = this.getCatalog();
        }
        String string = schemaName = schema == null ? null : (String)schema.getProperty("DMD_SCHEMA_NAME");
        if (schemaName == null) {
            schemaName = this.isUseSchema() && schema != null ? schema.getName() : null;
        } else if (schemaName == "<null>") {
            schemaName = null;
        }
        return new String[]{cat, this.getNameForDriver(schemaName)};
    }

    protected String getNameForDriver(String name) {
        return this.getDatabase().getNameForDriver(name);
    }
}

