/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.jdbc.JdbcSynonymBuilder;
import oracle.javatools.db.jdbc.JdbcTableBuilder;
import oracle.javatools.db.jdbc.JdbcViewBuilder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDDLDatabase
extends DDLDatabase
implements JdbcDatabase {
    private static final String ODBC_NOT_IMPLEMENTED = "IM001";
    protected static final String DMD_SCHEMA_NAME = "DMD_SCHEMA_NAME";
    protected static final String DMD_CATALOG_NAME = "DMD_CATALOG_NAME";
    protected static final String DMD_NULL_SCHEMA = "<null>";
    private Map<String, Schema> m_schemas;
    private boolean m_supportsSchemas;
    private String m_catalog;
    private String m_quoteString;

    public JdbcDDLDatabase(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    public DataType[] listSupportedDataTypes() {
        if (this.getClass() == JdbcDDLDatabase.class) {
            return DataTypeRegistry.getInstance().getAnsiTypes();
        }
        return super.listSupportedDataTypes();
    }

    protected String getCatalog() {
        block4: {
            if (this.m_catalog == null) {
                try {
                    Connection conn = this.getConnection();
                    this.m_catalog = conn.getCatalog();
                    if (this.m_catalog == null) {
                        this.m_catalog = "";
                    }
                }
                catch (SQLException ex) {
                    if (JdbcDDLDatabase.isUnsupportedOperation(ex)) break block4;
                    DBLog.getLogger().log(Level.WARNING, "Error accessing jdbc database metadata", ex);
                    this.m_catalog = null;
                }
            }
        }
        return this.m_catalog;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Collection<SchemaObject> listObjectsImpl(String[] objectTypes, Schema schema, String ref) throws DBException {
        ArrayList<SchemaObject> l = new ArrayList<SchemaObject>();
        boolean moreRows = false;
        ResultSet rs = null;
        DatabaseMetaData dmd = null;
        String schemaName = this.isUseSchema() && schema != null ? schema.getName() : null;
        String catalogName = this.catalogIsSchema() ? schemaName : this.m_catalog;
        String tableName = this.getNameForDriver(ref);
        try {
            try {
                dmd = this.getConnection().getMetaData();
                String dbProductName = dmd.getDatabaseProductName();
                if ("EXCEL".equals(dbProductName)) {
                    objectTypes = null;
                    if ("%".equals(ref)) {
                        tableName = null;
                    }
                }
                try {
                    rs = dmd.getTables(catalogName, this.getNameForDriver(schemaName), tableName, objectTypes);
                    moreRows = rs.next();
                    if (!moreRows) {
                        this.close(rs);
                        rs = dmd.getTables(catalogName, null, tableName, objectTypes);
                        moreRows = rs.next();
                    }
                }
                catch (SQLException ex) {
                    if (JdbcDDLDatabase.isUnsupportedOperation(ex)) {
                        throw ex;
                    }
                    this.close(rs);
                    rs = dmd.getTables(catalogName, null, null, objectTypes);
                    moreRows = rs.next();
                }
                while (moreRows) {
                    DBObjectBuilder builder;
                    AbstractSchemaObject object = null;
                    String rsCat = rs.getString(1);
                    String rsSchema = this.catalogIsSchema() ? rsCat : rs.getString(2);
                    String rsName = rs.getString(3);
                    String rsType = rs.getString(4);
                    if ("EXCEL".equals(dbProductName) && "SYSTEM TABLE".equals(rsType)) {
                        rsType = "TABLE";
                    }
                    if (this.catalogMatches(catalogName, rsCat) && this.schemaMatches(schemaName, rsSchema) && this.tableMatches(ref, rsName) && (builder = this.getBuilderForType(rsType)) != null) {
                        Schema objSchema = rsSchema == null ? schema : this.getSchema(rsSchema);
                        NameBasedID id = new NameBasedID(rsType, JdbcDDLDatabase.convertObject((DBObject)objSchema), rsName, (AbstractDBObjectProvider)this);
                        object = (AbstractSchemaObject)builder.createObject(rsName, objSchema, (DBObjectID)id);
                    }
                    if (object != null) {
                        this.markForLazyInit(object);
                        l.add((SchemaObject)object);
                    }
                    moreRows = rs.next();
                }
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            throw throwable;
        }
        this.close(rs);
        return l;
    }

    private void close(ResultSet ... rss) {
        if (rss != null) {
            ResultSet[] resultSetArray = rss;
            int n = 0;
            while (n < resultSetArray.length) {
                ResultSet rs = resultSetArray[n];
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }

    public String getUserName() throws DBException {
        String name = null;
        try {
            DatabaseMetaData dmd = this.getConnection().getMetaData();
            name = dmd.getUserName();
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
        return name;
    }

    public String getIdentifierQuoteString() {
        DatabaseDescriptor desc = this.getDescriptor();
        if (desc == null) {
            if (this.m_quoteString == null) {
                try {
                    DatabaseMetaData dmd = this.getConnection().getMetaData();
                    this.m_quoteString = dmd.getIdentifierQuoteString();
                }
                catch (SQLException ex) {
                    this.m_quoteString = "";
                }
            }
            return this.m_quoteString;
        }
        return super.getIdentifierQuoteString();
    }

    public String getDatabaseType() {
        return "Generic JDBC";
    }

    protected void registerExpanders() {
        this.registerSchemaObjectExpander((SchemaObjectExpander)new TemplateExpander((DBObjectProvider)this));
    }

    protected void registerBuilders() {
        HashSet<String> types = new HashSet<String>();
        ResultSet rs = null;
        try {
            try {
                DatabaseMetaData dmd = this.getConnection().getMetaData();
                rs = dmd.getTableTypes();
                while (rs.next()) {
                    types.add(rs.getString(1).trim());
                }
            }
            catch (SQLException ex) {
                types.clear();
                types.add("TABLE");
            }
        }
        catch (Throwable throwable) {
            this.close(rs);
            throw throwable;
        }
        this.close(rs);
        String catalog = this.getCatalog();
        this.registerBuilders(types, catalog);
    }

    protected void registerBuilders(Collection<String> types, String catalog) {
        if (types.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new JdbcTableBuilder(this, catalog));
        }
        if (types.contains("VIEW")) {
            this.registerBuilder("VIEW", (DBObjectBuilder)new JdbcViewBuilder(this, catalog));
        }
        if (types.contains("SYNONYM")) {
            this.registerBuilder("SYNONYM", (DBObjectBuilder)new JdbcSynonymBuilder(this, catalog));
        }
    }

    public String normaliseDefaultValue(DataType type, String value) {
        return value;
    }

    public String normaliseDataTypeName(String name) {
        String testName = name;
        while (ModelUtil.hasLength((String)testName) && Character.isDigit(testName.charAt(testName.length() - 1))) {
            testName = testName.substring(0, testName.length() - 1);
        }
        if (ModelUtil.hasLength((String)testName) && !testName.equals(name) && this.getDataType(testName) != null) {
            return testName;
        }
        return name;
    }

    public boolean isUseSchema() {
        try {
            this.loadSchemasImpl();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return this.m_supportsSchemas;
    }

    public String getNameForDriver(String name) {
        return name;
    }

    public boolean catalogIsSchema() {
        return true;
    }

    protected Map<String, Schema> loadSchemasImpl() throws DBException {
        if (this.m_schemas == null) {
            this.m_supportsSchemas = true;
            this.m_schemas = new TreeMap<String, Schema>();
            ResultSet srs = null;
            ResultSet crs = null;
            try {
                try {
                    DatabaseMetaData dmd = this.getConnection().getMetaData();
                    srs = dmd.getSchemas();
                    while (srs.next()) {
                        String name = srs.getString(1);
                        this.m_schemas.put(name, this.createSchema(name));
                    }
                    if (this.catalogIsSchema()) {
                        crs = dmd.getCatalogs();
                        while (crs.next()) {
                            String name = crs.getString(1);
                            Schema s = this.createSchema(name);
                            s.setProperty(DMD_SCHEMA_NAME, (Object)DMD_NULL_SCHEMA);
                            s.setProperty(DMD_CATALOG_NAME, (Object)name);
                            this.m_schemas.put(name, s);
                        }
                    }
                }
                catch (SQLException ex) {
                    if (!JdbcDDLDatabase.isUnsupportedOperation(ex)) {
                        throw new DBException((Throwable)ex);
                    }
                }
            }
            catch (Throwable throwable) {
                this.close(srs, crs);
                throw throwable;
            }
            this.close(srs, crs);
            if (this.m_schemas.size() == 0) {
                this.m_supportsSchemas = false;
                String cat = this.getDefaultSchemaName();
                Schema defaultSchema = this.createSchema(cat);
                defaultSchema.setProperty("isDefaultSchema", (Object)Boolean.TRUE);
                this.m_schemas.put(cat, defaultSchema);
            }
        }
        return this.m_schemas;
    }

    protected String getDefaultSchemaName() {
        String cat = this.getCatalog();
        return cat == null ? "" : cat;
    }

    public Schema getDefaultSchema() throws DBException {
        Schema def = super.getDefaultSchema();
        if (def == null) {
            def = this.getSchema(this.getDefaultSchemaName());
        }
        return def;
    }

    private boolean catalogMatches(String requestedCatalog, String returnedCatalog) {
        return !ModelUtil.hasLength((String)requestedCatalog) || !ModelUtil.hasLength((String)returnedCatalog) || this.nameMatches(requestedCatalog, returnedCatalog);
    }

    private boolean schemaMatches(String requestedSchema, String returnedSchema) {
        try {
            this.loadSchemasImpl();
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return !this.m_supportsSchemas || !ModelUtil.hasLength((String)requestedSchema) || !ModelUtil.hasLength((String)returnedSchema) || this.nameMatches(requestedSchema, returnedSchema);
    }

    private boolean nameMatches(String requestedName, String returnedName) {
        if (!ModelUtil.hasLength((String)returnedName) || !ModelUtil.hasLength((String)requestedName)) {
            return false;
        }
        return this.getCasePolicy() == 3 || this.getQuotedNameCasePolicy() == 3 ? ModelUtil.areEqual((Object)requestedName, (Object)returnedName) : ModelUtil.areEqual((Object)requestedName.toLowerCase(), (Object)returnedName.toLowerCase());
    }

    private boolean tableMatches(String ref, String rsName) {
        String regEx = ref == null ? ".*" : ref.replaceAll("%", ".*");
        return this.nameMatches(ref, rsName) || rsName.matches(regEx);
    }

    static void checkUnsupportedOperation(SQLException ex) throws SQLException {
        if (!JdbcDDLDatabase.isUnsupportedOperation(ex)) {
            throw ex;
        }
    }

    public static boolean isUnsupportedOperation(SQLException ex) {
        String state = ex.getSQLState();
        return ModelUtil.areEqual((Object)state, (Object)"S1C00") || ModelUtil.areEqual((Object)state, (Object)ODBC_NOT_IMPLEMENTED);
    }
}

