/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.jdbc.JdbcColumnValidator;
import oracle.javatools.db.jdbc.JdbcDDLGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcDatabaseDescriptor
extends BaseDatabaseDescriptor {
    private static final int MAX_NAME_LENGTH = 500;
    private static final char QUOTE_IDENTIFIER = '\"';
    private JdbcDatabase m_db;
    private String m_quoteIdent;
    private int m_casePolicy;

    private void $init$() {
        this.m_casePolicy = -1;
    }

    public JdbcDatabaseDescriptor() {
        this.$init$();
    }

    public JdbcDatabaseDescriptor(JdbcDatabase db) {
        this.$init$();
        this.m_db = db;
    }

    public int getCasePolicy() {
        Connection c;
        if (this.m_casePolicy < 0 && (c = this.m_db.getConnection()) != null) {
            try {
                DatabaseMetaData dm = c.getMetaData();
                boolean lower = dm.storesLowerCaseIdentifiers();
                boolean lowerQuoted = dm.storesLowerCaseQuotedIdentifiers();
                boolean mixed = dm.storesMixedCaseIdentifiers();
                boolean mixedQuoted = dm.storesMixedCaseQuotedIdentifiers();
                boolean upper = dm.storesUpperCaseIdentifiers();
                boolean upperQuoted = dm.storesUpperCaseQuotedIdentifiers();
                this.m_casePolicy = lower ? 1 : (upper ? 2 : 0);
            }
            catch (SQLException e) {
                DBLog.getLogger().log(Level.WARNING, "couldn't get case policy for " + this.m_db.getConnectionName(), e);
            }
        }
        return this.m_casePolicy < 0 ? 0 : this.m_casePolicy;
    }

    public String getIdentifierQuoteString() {
        Connection c;
        if (this.m_db != null && this.m_quoteIdent == null && (c = this.m_db.getConnection()) != null) {
            try {
                DatabaseMetaData dm = c.getMetaData();
                this.m_quoteIdent = dm.getIdentifierQuoteString();
            }
            catch (SQLException e) {
                DBLog.getLogger().log(Level.WARNING, "couldn't get quote string for " + this.m_db.getConnectionName(), e);
            }
        }
        return this.m_quoteIdent == null ? String.valueOf('\"') : this.m_quoteIdent;
    }

    public int getMaxNameLength(String type) {
        return 500;
    }

    public void validateName(String type, String name) throws InvalidNameException {
        JdbcDatabaseDescriptor.validateIdentifier((String)name, (char)'\"', (int)500, null, (boolean)true, null, (int)this.getCasePolicy());
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(Class<? extends Database> dbImpl, DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(dbImpl, pro);
        v.put("COLUMN", new JdbcColumnValidator(pro));
        return v;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return new JdbcDDLGenerator(pro);
    }
}

