/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.jdbc.DMDBuilder;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.util.ModelUtil;

public abstract class JdbcRelationBuilder
extends DMDBuilder {
    protected JdbcRelationBuilder(JdbcDatabase db, String catalog, String type) {
        super(db, catalog, type);
    }

    protected abstract Relation createRelation(Schema var1, String var2);

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        Relation rel = this.createRelation(schema, name);
        rel.setID(id);
        return rel;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        Relation rel = (Relation)object;
        try {
            Connection conn = this.getConnection();
            DatabaseMetaData dmd = conn.getMetaData();
            this.fillInColumns(rel, dmd);
            this.fillInConstraints(rel, dmd);
        }
        catch (SQLException ex) {
            throw new DBException((Throwable)ex);
        }
    }

    protected void fillInColumns(Relation rel, DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = null;
        ArrayList<Column> list = new ArrayList<Column>(20);
        try {
            try {
                JdbcDatabase db = this.getDatabase();
                String relationName = this.getNameForDriver(rel.getName());
                String[] catAndSchema = this.getCatalogAndSchema(rel.getSchema());
                String dbProductName = dmd.getDatabaseProductName();
                rs = "EXCEL".equals(dbProductName) ? dmd.getColumns(catAndSchema[0], null, relationName, null) : dmd.getColumns(catAndSchema[0], catAndSchema[1], relationName, "%");
                int columnCount = 0;
                while (rs.next()) {
                    if (relationName == null && !rs.getString(3).equals(rel.getName())) continue;
                    ++columnCount;
                    String colName = rs.getString(4);
                    Column column = new Column(colName);
                    column.setID((DBObjectID)new NameBasedID((DBObject)column, rel.getID()));
                    list.add(column);
                    column.setRelation(rel);
                    String remark = rs.getString(12);
                    if (ModelUtil.hasLength((String)remark)) {
                        column.setProperty("Comment", (Object)remark);
                    }
                    column.setNotNull(rs.getString(18).trim().equals("NO"));
                    String dataTypeName = db.normaliseDataTypeName(rs.getString(6));
                    DataType dataType = db.getDataType(dataTypeName);
                    if (dataType == null) continue;
                    long attr = rs.getLong(7);
                    Long size = rs.wasNull() ? null : new Long(attr);
                    attr = rs.getLong(9);
                    Long scale = rs.wasNull() ? null : new Long(attr);
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("name", dataTypeName);
                    attributes.put("size", DataTypeHelper.getAttributeValue((Object)size, (DataType)dataType, (String)"size"));
                    attributes.put("precision", DataTypeHelper.getAttributeValue((Object)size, (DataType)dataType, (String)"precision"));
                    attributes.put("scale", DataTypeHelper.getAttributeValue((Object)scale, (DataType)dataType, (String)"scale"));
                    column.setDataTypeUsage(dataType.createUsage(attributes));
                    String defaultValue = rs.getString(13);
                    if (!ModelUtil.hasLength((String)defaultValue)) continue;
                    column.setDefault((Object)db.normaliseDefaultValue(dataType, defaultValue));
                }
                DBLog.log((String)(">>fillInColumns : " + columnCount + " columns returned for " + rel.getName()), (Object[])new Object[0]);
                rel.setColumns(list.toArray(new Column[list.size()]));
            }
            catch (SQLException ex) {
                String m = ex.getMessage();
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    protected void fillInConstraints(Relation rel, DatabaseMetaData dmd) throws SQLException {
        ArrayList<Object> list = new ArrayList<Object>();
        ResultSet rs = null;
        String schemaName = this.isUseSchema() && rel.getSchema() != null ? rel.getSchema().getName() : null;
        String catalogName = this.getDatabase().catalogIsSchema() ? schemaName : this.getCatalog();
        String relationName = this.getNameForDriver(rel.getName());
        try {
            try {
                rs = dmd.getPrimaryKeys(catalogName, this.getNameForDriver(schemaName), relationName);
                boolean pkFound = false;
                while (!pkFound && rs.next()) {
                    if (relationName == null && !rs.getString(3).equals(rel.getName())) continue;
                    pkFound = true;
                    TreeSet<PKCol> cols = new TreeSet<PKCol>();
                    String pkName = rs.getString(6);
                    pkName = ModelUtil.hasLength((String)pkName) ? pkName : this.makePKName(rs.getString(2), rs.getString(3));
                    PKConstraint con = new PKConstraint(pkName, rel);
                    con.setID((DBObjectID)new NameBasedID("CONSTRAINT", pkName, rel.getID()));
                    String colName = rs.getString(4);
                    short seq = rs.getShort(5);
                    cols.add(new PKCol(seq, colName));
                    while (rs.next()) {
                        if (relationName == null && !rs.getString(3).equals(rel.getName())) continue;
                        colName = rs.getString(4);
                        seq = rs.getShort(5);
                        cols.add(new PKCol(seq, colName));
                    }
                    for (PKCol col : cols) {
                        Column column = rel.getColumn(col._colName);
                        if (column == null) continue;
                        column.setNotNull(true);
                        con.addColumn(column);
                    }
                    if (con.getColumns().length <= 0) continue;
                    rel.addConstraint((Constraint)con);
                    list.add(con);
                }
                rs.close();
            }
            catch (SQLException ex) {
                JdbcDDLDatabase.checkUnsupportedOperation(ex);
            }
            Map importedKeysMap = this.getImportedKeys(dmd, rel, catalogName, schemaName, relationName);
            HashMap<String, FKConstraint> keys = new HashMap<String, FKConstraint>();
            JdbcDatabase db = this.getDatabase();
            FKConstraint lastFk = null;
            Column[] fkColumns = null;
            Column[] refConColumns = null;
            Iterator it = importedKeysMap.keySet().iterator();
            while (it.hasNext()) {
                List currentPkData = (List)importedKeysMap.get(it.next());
                int i = 0;
                while (i < currentPkData.size()) {
                    short keyDelete;
                    ImportedKeyData keyData = (ImportedKeyData)currentPkData.get(i);
                    String pkSchemaName = keyData.pkSchemaName;
                    String pkTableName = keyData.pkTableName;
                    String pkColName = keyData.pkColName;
                    String fkSchemaName = keyData.fkSchemaName;
                    String fkTableName = keyData.fkTableName;
                    String fkColName = keyData.fkColName;
                    short seq = keyData.seq;
                    short del = keyData.del;
                    String fkName = keyData.fkName;
                    String pkName = keyData.pkName;
                    Schema pkSchema = null;
                    try {
                        pkSchema = db.getSchema(pkSchemaName);
                    }
                    catch (DBException ex) {
                        // empty catch block
                    }
                    pkName = ModelUtil.hasLength((String)pkName) ? pkName : this.makePKName(pkSchemaName, pkTableName);
                    String fkLookupName = ModelUtil.hasLength((String)fkName) ? fkName : pkTableName;
                    FKConstraint fk = (FKConstraint)keys.get(fkLookupName);
                    if (fk == null) {
                        if (lastFk != null && fkColumns != null) {
                            lastFk.setColumns(fkColumns);
                        }
                        fk = new FKConstraint(fkName, rel);
                        NameBasedID fkID = new NameBasedID((DBObject)fk, rel.getID());
                        fk.setID((DBObjectID)fkID);
                        NameBasedID pkParentID = new NameBasedID("TABLE", pkSchema.getName(), pkTableName, (AbstractDBObjectProvider)this.getDatabase());
                        NameBasedID pkID = new NameBasedID("CONSTRAINT", pkName, (DBObjectID)pkParentID);
                        fk.setReferenceID((DBObjectID)pkID);
                        keys.put(fkLookupName, fk);
                        try {
                            UniqueConstraint refCon = (UniqueConstraint)pkID.resolveID();
                            if (refCon == null) {
                                Table refTable = (Table)pkID.getParent().resolveID();
                                Constraint[] constraints = refTable.getConstraints();
                                int j = 0;
                                while (j < constraints.length) {
                                    if (constraints[j] instanceof PKConstraint) {
                                        refCon = (PKConstraint)constraints[j];
                                        fk.setReferenceID(refCon.getID());
                                        break;
                                    }
                                    ++j;
                                }
                            }
                            if (refCon == null) {
                                DBLog.log((String)("Unable to recover unique key " + pkSchemaName + "." + pkTableName + "." + pkName + " referenced by foreign key " + fkSchemaName + "." + fkTableName + "." + fkName), (Object[])new Object[0]);
                            } else {
                                refConColumns = refCon.getColumns();
                                fkColumns = new Column[refConColumns.length];
                            }
                        }
                        catch (DBException dbe) {
                            // empty catch block
                        }
                    }
                    lastFk = fk;
                    if (fkColumns != null) {
                        fkColumns[this.getColumnPosition((String)pkColName, refConColumns)] = rel.getColumn(fkColName);
                    }
                    int onDelete = (keyDelete = del) == 0 ? 1 : (keyDelete == 2 ? 2 : 0);
                    fk.setDeleteMode(onDelete);
                    ++i;
                }
            }
            if (lastFk != null && fkColumns != null) {
                lastFk.setColumns(fkColumns);
            }
            Iterator iter = keys.values().iterator();
            while (iter.hasNext()) {
                list.add(iter.next());
            }
            rel.setConstraints(list.toArray(new Constraint[list.size()]));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    protected String makePKName(String pkSchemaName, String pkTableName) {
        StringBuffer buf = new StringBuffer();
        if (ModelUtil.hasLength((String)pkSchemaName)) {
            buf.append(pkSchemaName + '#');
        }
        buf.append(pkTableName + "#PK");
        return buf.toString();
    }

    private int getColumnPosition(String colName, Column[] columns) {
        int i = 0;
        while (i < columns.length) {
            if (colName.equals(columns[i].getName())) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private Map getImportedKeys(DatabaseMetaData dmd, Relation relation, String catalogName, String schemaName, String relationName) throws SQLException {
        HashMap<String, ArrayList<ImportedKeyData>> importedKeys = new HashMap<String, ArrayList<ImportedKeyData>>();
        ResultSet rs = null;
        try {
            try {
                rs = dmd.getImportedKeys(catalogName, this.getNameForDriver(schemaName), relationName);
                while (rs.next()) {
                    if (relationName == null && !rs.getString(7).equals(relation.getName())) continue;
                    ImportedKeyData importedKeyData = new ImportedKeyData();
                    importedKeyData.pkSchemaName = this.getDatabase().catalogIsSchema() ? rs.getString(1) : rs.getString(2);
                    importedKeyData.pkTableName = rs.getString(3);
                    importedKeyData.pkColName = rs.getString(4);
                    importedKeyData.fkSchemaName = this.getDatabase().catalogIsSchema() ? rs.getString(5) : rs.getString(6);
                    importedKeyData.fkTableName = rs.getString(7);
                    importedKeyData.fkColName = rs.getString(8);
                    importedKeyData.seq = rs.getShort(9);
                    importedKeyData.del = rs.getShort(11);
                    importedKeyData.fkName = rs.getString(12);
                    importedKeyData.pkName = rs.getString(13);
                    String keyName = importedKeyData.pkTableName + '_' + importedKeyData.fkName;
                    ArrayList<ImportedKeyData> currentPkData = (ArrayList<ImportedKeyData>)importedKeys.get(keyName);
                    if (currentPkData == null) {
                        currentPkData = new ArrayList<ImportedKeyData>();
                        importedKeys.put(keyName, currentPkData);
                    }
                    currentPkData.add(importedKeyData);
                }
            }
            catch (SQLException ex) {
                JdbcDDLDatabase.checkUnsupportedOperation(ex);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception ex) {}
            }
        }
        return importedKeys;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PKCol
    implements Comparable {
        short _seq;
        String _colName;

        PKCol(short seq, String colName) {
            this._seq = seq;
            this._colName = colName;
        }

        public int compareTo(Object o) {
            return this._seq - ((PKCol)o)._seq;
        }
    }

    private static class ImportedKeyData {
        String pkSchemaName;
        String pkTableName;
        String pkColName;
        String fkSchemaName;
        String fkTableName;
        String fkColName;
        short seq;
        short del;
        String fkName;
        String pkName;

        ImportedKeyData() {
        }
    }
}

