/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.marshal.DBObjectSAXHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObject2XML {
    private static final String ENCODING = "UTF-8";
    private static final String HEADER = "<?xml version = '1.0' encoding = 'UTF-8'?>\n";
    private static final String INDENT = "  ";
    static final String ENTRY = "entry";
    static final String KEY = "key";
    static final String VALUE = "value";
    static final String CLASS = "class";
    private String m_namespace;

    public DBObject2XML() {
    }

    public DBObject2XML(String namespace) {
        this.m_namespace = namespace;
    }

    public void write(DBObject obj, OutputStream out) throws IOException {
        this.write(obj, new OutputStreamWriter(out, ENCODING));
    }

    public void write(DBObject obj, Writer writer) throws IOException {
        writer.write(HEADER);
        this.writeObject(obj, "", writer);
        writer.close();
    }

    private void writeObject(Object obj, String indent, Writer writer) throws IOException {
        String tagName = this.getDefaultTagName(obj);
        this.writeObject(obj, tagName, null, indent, writer);
    }

    private String getDefaultTagName(Object obj) {
        if (obj instanceof DBObject) {
            return DBObject2XML.convertType(((DBObject)obj).getType());
        }
        return obj.getClass().getName();
    }

    private void writeObject(Object obj, String tagName, Class defaultClass, String indent, Writer writer) throws IOException {
        StringBuffer openTag = new StringBuffer();
        openTag.append(indent).append("<").append(tagName);
        if (defaultClass != null && defaultClass != Map.class && obj.getClass() != ToStringManager.wrapPrimitive((Class)defaultClass)) {
            openTag.append(" ").append(CLASS).append("=\"").append(obj.getClass().getName()).append("\"");
        }
        if (!ModelUtil.hasLength((String)indent) && ModelUtil.hasLength((String)this.m_namespace)) {
            openTag.append(" xmlns=\"").append(this.m_namespace).append("\"");
        }
        openTag.append(">");
        if (ToStringManager.converterAvailable((Object)obj)) {
            String string = obj instanceof String ? "<![CDATA[" + obj + "]]>" : ToStringManager.toString((Object)obj);
            if (string != null) {
                writer.write(openTag.toString());
                writer.write(string);
                this.writeEndTag(tagName, "", writer);
            }
        } else {
            openTag.append("\n");
            if (obj instanceof Map) {
                Map map = (Map)obj;
                if (map.size() > 0) {
                    writer.write(openTag.toString());
                    this.writeEntries(map, indent + INDENT, writer);
                    this.writeEndTag(tagName, indent, writer);
                }
            } else if (obj instanceof Object[]) {
                Object[] valueA = (Object[])obj;
                if (ModelUtil.hasNonNullElement((Object[])valueA)) {
                    writer.write(openTag.toString());
                    int i = 0;
                    while (i < valueA.length) {
                        Class<?> compClz = defaultClass.getComponentType();
                        String childTag = tagName;
                        childTag = childTag.endsWith("s") ? childTag.substring(0, childTag.length() - 1) : childTag + "Item";
                        if (valueA[i] != null) {
                            this.writeObject(valueA[i], childTag, compClz, indent + INDENT, writer);
                        }
                        ++i;
                    }
                    this.writeEndTag(tagName, indent, writer);
                }
            } else {
                writer.write(openTag.toString());
                this.writeProperties(obj, indent + INDENT, writer);
                this.writeEndTag(tagName, indent, writer);
            }
        }
    }

    private void writeProperties(Object obj, String indent, Writer writer) throws IOException {
        if (obj instanceof TemporaryObjectID) {
            DBLog.getLogger().log(Level.WARNING, "DBObject2XML TemporaryObjectID Warning", new IllegalStateException("trying to save TemporaryObjectID to XML"));
        }
        Iterator props = PropertyIterator.getPropertyIterator((Object)obj);
        while (props.hasNext()) {
            PropertyInfo prop = (PropertyInfo)props.next();
            String name = prop.getPropertyName();
            Object value = prop.getPropertyValue(obj);
            if (value == null) continue;
            this.writeObject(value, name, prop.getPropertyClass(), indent, writer);
        }
    }

    private void writeEntries(Map<Object, Object> map, String indent, Writer writer) throws IOException {
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.writeStartTag(ENTRY, indent, true, writer);
            Object key = entry.getKey();
            if (key instanceof String) {
                String newIndent = indent + INDENT;
                this.writeStartTag(KEY, newIndent, false, writer);
                writer.write((String)key);
                this.writeEndTag(KEY, "", writer);
                Object value = entry.getValue();
                if (value != null) {
                    this.writeObject(value, VALUE, Object.class, newIndent, writer);
                }
            } else {
                new UnsupportedOperationException("map keys must be strings").printStackTrace();
            }
            this.writeEndTag(ENTRY, indent, writer);
        }
    }

    private void writeStartTag(String name, String indent, boolean newline, Writer writer) throws IOException {
        writer.write(indent);
        writer.write("<" + name + ">");
        if (newline) {
            writer.write("\n");
        }
    }

    private void writeEndTag(String name, String indent, Writer writer) throws IOException {
        writer.write(indent);
        writer.write("</" + name + ">\n");
    }

    public DBObject readInfo(InputStream in) throws IOException {
        return this.read(new InputStreamReader(in, ENCODING), true);
    }

    public DBObject read(InputStream in) throws IOException {
        return this.read(new InputStreamReader(in, ENCODING), false);
    }

    public DBObject read(Reader reader) throws IOException {
        return this.read(reader, false);
    }

    private DBObject read(Reader reader, boolean idNameOnly) throws IOException {
        DBObjectSAXHelper helper = new DBObjectSAXHelper(this.m_namespace, idNameOnly);
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            SAXParser parser = f.newSAXParser();
            parser.parse(new InputSource(reader), (DefaultHandler)helper);
            DBObject dBObject = helper.getDBObject();
            return dBObject;
        }
        catch (DBObjectSAXHelper.NameAndIDCompleteException e) {
            if (idNameOnly) {
                DBObject dBObject = helper.getDBObject();
                return dBObject;
            }
            throw new IllegalStateException("parser quit after name and id but we didn't request that.");
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Error parsing file: " + e.getMessage());
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Error parsing file: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    static String convertType(String type) {
        boolean upper = DBObject2XML.isUpperCase(type);
        StringBuffer buff = new StringBuffer(upper ? type.toLowerCase() : type);
        if (!upper) {
            DBObject2XML.changeCase(buff, 0);
        }
        int i = buff.indexOf(" ");
        while (i > -1) {
            buff.deleteCharAt(i);
            DBObject2XML.changeCase(buff, i);
            i = buff.indexOf(" ", i);
        }
        return buff.toString();
    }

    private static boolean isUpperCase(String str) {
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isLowerCase(c) && c != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void changeCase(StringBuffer buff, int index) {
        char c = buff.charAt(index);
        if (Character.isUpperCase(c)) {
            buff.setCharAt(index, Character.toLowerCase(c));
        } else {
            buff.setCharAt(index, Character.toUpperCase(c));
        }
    }
}

