/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.marshal;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.marshal.DBObject2XML;
import oracle.javatools.db.marshal.InvalidNamespaceException;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBObjectSAXHelper
extends DefaultHandler {
    private static final String NULL = "null";
    private final Map EMPTY_INFO_MAP;
    private String m_namespace;
    private boolean m_idNameOnly;
    private DBObject m_obj;
    private List m_stack;
    private Map<Class, Map<String, PropertyInfo>> m_infos;
    private Map<String, Class<? extends DBObject>> m_types;

    private void $init$() {
        this.EMPTY_INFO_MAP = new HashMap();
        this.m_infos = new HashMap<Class, Map<String, PropertyInfo>>();
    }

    public DBObjectSAXHelper(String namespace, boolean idNameOnly) {
        this.$init$();
        this.m_namespace = namespace;
        this.m_idNameOnly = idNameOnly;
    }

    public DBObject getDBObject() {
        return this.m_obj;
    }

    private Map<String, PropertyInfo> getPropertyInfos(Object bean) {
        Class<?> clz = bean.getClass();
        if (this.m_infos.containsKey(clz)) {
            return this.m_infos.get(clz);
        }
        PropertyIterator iter = new PropertyIterator(clz, null);
        Map infos = iter.getPropertyInfos(true, false, true);
        this.m_infos.put(clz, infos);
        return infos;
    }

    @Override
    public void startDocument() throws SAXException {
        this.m_stack = new ArrayList();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String name = ModelUtil.hasLength((String)localName) ? localName : qName;
        int ssize = this.m_stack.size();
        if (ssize == 0) {
            if (ModelUtil.hasLength((String)this.m_namespace) && ModelUtil.areDifferent((Object)this.m_namespace, (Object)uri)) {
                throw new InvalidNamespaceException(uri, this.m_namespace);
            }
            Class clz = this.getObjectClass(name);
            this.m_obj = (DBObject)this.createObject(clz);
        } else {
            Object current = this.getCurrentObject();
            if (current != NULL) {
                if (current instanceof Map) {
                    this.m_stack.add(new Object[2]);
                } else if (current instanceof Object[]) {
                    if (name.equals("key")) {
                        this.m_stack.add("key");
                    } else if (name.equals("value")) {
                        Class clz = this.getAttributeClass(attributes);
                        if (clz == null) {
                            this.m_stack.add("value");
                        } else if (ToStringManager.converterAvailable((Class)clz)) {
                            this.m_stack.add(clz);
                        } else {
                            this.createObject(clz);
                        }
                    }
                } else if (current instanceof List) {
                    Class<?> clz = this.getAttributeClass(attributes);
                    if (clz == null) {
                        Class propClz;
                        Object par = this.getCurrentParent();
                        if (par instanceof PropertyInfo && (propClz = ((PropertyInfo)par).getPropertyClass()).isArray()) {
                            clz = propClz.getComponentType();
                        }
                        if (clz == null) {
                            clz = this.getObjectClass(name);
                        }
                    }
                    if (ToStringManager.converterAvailable((Class)clz)) {
                        this.m_stack.add(clz);
                    } else {
                        this.createObject(clz);
                    }
                } else {
                    PropertyInfo info = this.getPropertyInfos(current).get(name);
                    if (info == null) {
                        Map allinfos = null;
                        if (current instanceof Copyable) {
                            PropertyIterator iter = new PropertyIterator(((Copyable)current).getClass(), null);
                            allinfos = iter.getPropertyInfos(false, false, false);
                        }
                        if (allinfos != null && allinfos.containsKey(name)) {
                            this.getLogger().info("ignoring property \"" + name + "\" as it has been deprecated.");
                        } else {
                            this.logConversionError(new SAXNotRecognizedException("unknown property \"" + name + "\" on " + current.getClass()));
                        }
                        this.m_stack.add(NULL);
                    } else {
                        this.m_stack.add(info);
                        Class clz = info.getPropertyClass();
                        if (clz == Map.class) {
                            this.m_stack.add(new HashMap());
                        } else if (clz.isArray()) {
                            this.m_stack.add(new ArrayList());
                        } else {
                            Class newClass = this.getAttributeClass(attributes);
                            if (newClass == null) {
                                newClass = clz;
                            }
                            if (clz != newClass && ToStringManager.converterAvailable((Class)newClass)) {
                                this.m_stack.add(newClass);
                            } else if (!ToStringManager.converterAvailable((Class)newClass)) {
                                try {
                                    this.createObject(newClass);
                                }
                                catch (SAXException e) {
                                    this.logConversionError(e);
                                    this.m_stack.add(NULL);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private Class getObjectClass(String localName) throws SAXNotRecognizedException {
        Class<? extends DBObject> clz;
        if (this.m_types == null) {
            this.m_types = new HashMap<String, Class<? extends DBObject>>();
            Map map = Metadata.getInstance().getDBObjectClasses();
            for (String type : map.keySet()) {
                this.m_types.put(DBObject2XML.convertType(type), (Class)map.get(type));
            }
        }
        if ((clz = this.m_types.get(localName)) == null) {
            throw new SAXNotRecognizedException("unknown object type " + localName);
        }
        return clz;
    }

    private Class getAttributeClass(Attributes attributes) throws SAXNotRecognizedException {
        String classAttr = attributes.getValue("class");
        if (ModelUtil.hasLength((String)classAttr)) {
            try {
                Class<?> clazz = Class.forName(classAttr);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                throw new SAXNotRecognizedException(e.getMessage());
            }
        }
        return null;
    }

    private Object createObject(Class clz) throws SAXException {
        try {
            Object obj = clz.newInstance();
            this.m_stack.add(obj);
            Object t = obj;
            return t;
        }
        catch (Exception e) {
            if (e.getCause() instanceof Exception) {
                e = (Exception)e.getCause();
            }
            throw new SAXException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Object[] done = this.pop();
        if (done == NULL) {
            if (this.getCurrentObject() instanceof PropertyInfo) {
                this.pop();
            }
        } else if (!(done instanceof PropertyInfo) && done != "key" && done != "value") {
            if (done instanceof Class) {
                if (this.getCurrentObject() instanceof PropertyInfo) {
                    this.pop();
                }
            } else if (done instanceof Object[]) {
                Map map = (Map)this.getCurrentObject();
                map.put(((Object[])done)[0], ((Object[])done)[1]);
            } else if (this.m_stack.size() > 0) {
                Object parent = this.getCurrentObject();
                if (parent instanceof PropertyInfo) {
                    Object[] value;
                    PropertyInfo info = (PropertyInfo)this.pop();
                    if (done instanceof List) {
                        Class arrayClz = info.getPropertyClass();
                        if (arrayClz.isArray()) {
                            value = Array.newInstance(arrayClz.getComponentType(), ((List)done).size());
                            value = ((List)done).toArray((Object[])value);
                        } else {
                            value = done;
                        }
                    } else {
                        value = done;
                    }
                    try {
                        info.setPropertyValue(this.getCurrentObject(), (Object)value);
                    }
                    catch (Exception e) {
                        this.logConversionError(e);
                    }
                } else if (parent instanceof Object[]) {
                    ((Object[])parent)[1] = done;
                } else if (parent instanceof List) {
                    ((List)parent).add(done);
                }
            }
        }
        this.checkObject();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        Object par;
        String str = new String(ch, start, length);
        Object obj = this.getCurrentObject();
        Class clz = null;
        if (obj instanceof Class && (par = this.getCurrentParent()) instanceof PropertyInfo) {
            clz = (Class)this.pop();
            obj = par;
        }
        if (obj instanceof PropertyInfo) {
            PropertyInfo info = (PropertyInfo)obj;
            Class clazz = clz = clz == null ? info.getPropertyClass() : clz;
            if (ToStringManager.converterAvailable((Class)clz)) {
                try {
                    Object value;
                    block21: {
                        value = null;
                        try {
                            value = ToStringManager.fromString((String)str, (Class)clz);
                        }
                        catch (IllegalArgumentException iae) {
                            if (clz.isEnum()) {
                                Method m = clz.getMethod("migrate", String.class);
                                if (m == null || !m.getReturnType().equals(clz)) break block21;
                                try {
                                    value = m.invoke((Object)clz, str);
                                }
                                catch (Exception ex) {
                                    throw iae;
                                }
                            }
                            throw iae;
                        }
                    }
                    info.setPropertyValue(this.getCurrentParent(), value);
                }
                catch (Exception e) {
                    this.logConversionError(e);
                }
            }
        } else if (obj == "key") {
            ((Object[])this.getCurrentParent())[0] = str;
        } else if (obj instanceof Class) {
            Object parent = this.getCurrentParent();
            try {
                if (parent instanceof Object[]) {
                    ((Object[])parent)[1] = ToStringManager.fromString((String)str, (Class)((Class)obj));
                } else if (parent instanceof List) {
                    this.m_stack.add(ToStringManager.fromString((String)str, (Class)((Class)this.pop())));
                }
            }
            catch (Exception e) {
                this.logConversionError(e);
            }
        } else if (obj == "value") {
            ((Object[])this.getCurrentParent())[1] = str;
        }
    }

    private void logConversionError(Exception e) {
        this.getLogger().warning("couldn't parse XML element: " + e.getMessage());
    }

    private Logger getLogger() {
        return DBLog.getLogger();
    }

    private Object pop() {
        if (this.m_stack.size() > 0) {
            return this.m_stack.remove(this.m_stack.size() - 1);
        }
        return null;
    }

    private Object getCurrentObject() {
        return this.m_stack.get(this.m_stack.size() - 1);
    }

    private Object getCurrentParent() {
        return this.m_stack.get(this.m_stack.size() - 2);
    }

    private void checkObject() throws SAXException {
        if (this.m_idNameOnly && this.m_obj != null && ModelUtil.hasLength((String)this.m_obj.getName()) && this.m_obj.getID() != null) {
            throw new NameAndIDCompleteException();
        }
    }

    static class NameAndIDCompleteException
    extends SAXException {
        NameAndIDCompleteException() {
        }
    }
}

