/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.mysql.MySQL5;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLDatabaseDescriptor;
import oracle.javatools.db.mysql.MySQLDatabaseImpl;

public class MySQLDatabaseFactory
extends DatabaseFactory.DatabaseCreator {
    private DatabaseDescriptor m_descriptor;

    public MySQLDatabaseFactory() {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        dtr.registerProvider((DataTypeRegistry.Registerer)new MySQLDatabaseImpl.Registerer(), MySQLDatabaseImpl.class);
    }

    protected Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        int t = this.getType(conn);
        switch (t) {
            case 0: {
                return new MySQLDatabaseImpl(connStore, connName, conn);
            }
            case 1: {
                return new MySQL5(connStore, connName, conn);
            }
        }
        return null;
    }

    protected int getType(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (dbName.startsWith("MySQL")) {
                    int v = dmd.getDatabaseMajorVersion();
                    if (v >= 5) {
                        int n = 1;
                        return n;
                    }
                    int n = 0;
                    return n;
                }
            }
            catch (SQLException sqlx) {
                // empty catch block
            }
        }
        return -1;
    }

    protected DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (MySQLDatabase.class.isAssignableFrom(providerClass)) {
            if (this.m_descriptor == null) {
                this.m_descriptor = new MySQLDatabaseDescriptor();
            }
            return this.m_descriptor;
        }
        return null;
    }
}

