/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.mysql.MySQLDatabase;
import oracle.javatools.db.mysql.MySQLFloatDatatype;
import oracle.javatools.db.mysql.MySQLTableBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLDatabaseImpl
extends JdbcDDLDatabase
implements MySQLDatabase {
    protected MySQLDatabaseImpl(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    @Override
    protected void registerBuilders(Collection<String> types, String catalog) {
        super.registerBuilders(types, catalog);
        if (types.contains("TABLE")) {
            this.registerBuilder("TABLE", (DBObjectBuilder)new MySQLTableBuilder(this, catalog));
        }
    }

    public Schema getSchema(String name) throws DBException {
        Schema schema = super.getSchema(name);
        if (schema == null) {
            schema = super.getSchema(this.getCatalog());
        }
        return schema;
    }

    public DataType getDataType(String typeName) {
        String[] tokens = typeName.trim().toUpperCase().replaceAll("\\s", " ").split("\\b");
        if ((typeName = tokens[1]).equals("NATIONAL")) {
            typeName = typeName + tokens[2] + tokens[3];
            if (tokens.length > 5 && tokens[5].equals("VARYING")) {
                typeName = typeName + tokens[4] + tokens[5];
            }
        } else if (tokens.length > 3 && (typeName.equals("CHARACTER") && tokens[3].equals("VARYING") || typeName.equals("DOUBLE") && tokens[3].equals("PRECISION") || typeName.equals("LONG"))) {
            typeName = typeName + tokens[2] + tokens[3];
        }
        return super.getDataType(typeName);
    }

    @Override
    public String normaliseDefaultValue(DataType dataType, String defaultValue) {
        if (dataType instanceof CharacterDataType) {
            defaultValue = defaultValue.replaceAll("'", "''");
            defaultValue = "'" + defaultValue + "'";
        }
        return defaultValue;
    }

    @Override
    public boolean catalogIsSchema() {
        return true;
    }

    protected boolean isUsernameCaseInsensitive() {
        return false;
    }

    protected void processDeleteException(DBException dbe, SchemaObject obj) throws DBException {
        int code;
        Throwable cause = dbe.getCause();
        if (cause instanceof SQLException && ((code = ((SQLException)cause).getErrorCode()) == 1217 || code == 1091)) {
            throw new CascadeRequiredException((DBObject)obj, ((SQLException)cause).getMessage());
        }
        throw dbe;
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dtr) {
            DataTypeAttribute INTEGER_DISPLAY_WIDTH = new DataTypeAttribute("size", 101, 0L, new Long(255L), null, false);
            DataTypeAttribute DECIMAL_DISPLAY_WIDTH = new DataTypeAttribute("size", 101, 0L, new Long(255L), new Long(10), false);
            DataTypeAttribute DOUBLE_DISPLAY_WIDTH = new DataTypeAttribute("size", 101, 0L, new Long(255L), new Long(22), false);
            DataTypeAttribute SCALE = new DataTypeAttribute("scale", 68, 0L, null, new Long(0L), false);
            NumericDataType.MinMaxValue MIN_MAX_DOUBLE = new NumericDataType.MinMaxValue("2.2250738585072014E-308", "1.7976931348623157E+308", 2);
            NumericDataType DATATYPE_BIGINT = new NumericDataType(65535, "BIGINT", "BIGINT[(<size>)][ <unsigned>]", new DataTypeAttribute[]{INTEGER_DISPLAY_WIDTH, NumericDataType.UNSIGNED}, NumericDataType.MIN_MAX_BIGINT);
            NumericDataType DATATYPE_INT = new NumericDataType(65535, "INT", "INT[(<size>)][ <unsigned>]", new DataTypeAttribute[]{INTEGER_DISPLAY_WIDTH, NumericDataType.UNSIGNED}, NumericDataType.MIN_MAX_INT);
            NumericDataType DATATYPE_MEDIUMINT = new NumericDataType(65535, "MEDIUMINT", "MEDIUMINT[(<size>)][ <unsigned>]", new DataTypeAttribute[]{INTEGER_DISPLAY_WIDTH, NumericDataType.UNSIGNED}, NumericDataType.MIN_MAX_MEDIUMINT);
            NumericDataType DATATYPE_SMALLINT = new NumericDataType(65535, "SMALLINT", "SMALLINT[(<size>)][ <unsigned>]", new DataTypeAttribute[]{INTEGER_DISPLAY_WIDTH, NumericDataType.UNSIGNED}, NumericDataType.MIN_MAX_SMALLINT);
            NumericDataType DATATYPE_TINYINT = new NumericDataType(65535, "TINYINT", "TINYINT[(<size>)][ <unsigned>]", new DataTypeAttribute[]{INTEGER_DISPLAY_WIDTH, NumericDataType.UNSIGNED}, NumericDataType.MIN_MAX_SIGNED_TINYINT);
            NumericDataType DATATYPE_DECIMAL = new NumericDataType(65535, "DECIMAL", "DECIMAL[(<size>[, <scale>])][ <unsigned>]", new DataTypeAttribute[]{DECIMAL_DISPLAY_WIDTH, SCALE, NumericDataType.UNSIGNED}, MIN_MAX_DOUBLE);
            MySQLFloatDatatype DATATYPE_FLOAT = new MySQLFloatDatatype(65535);
            NumericDataType DATATYPE_DOUBLE = new NumericDataType(65535, "DOUBLE", "DOUBLE[(<size>, <scale>)][ <unsigned>]", new DataTypeAttribute[]{DOUBLE_DISPLAY_WIDTH, SCALE, NumericDataType.UNSIGNED}, MIN_MAX_DOUBLE);
            DataTypeAttribute YEAR_PRECISION = new DataTypeAttribute("precision", 64, new String[]{"2", "4"}, "4", false, false);
            PredefinedDataType DATATYPE_DATE = new PredefinedDataType(65535, "DATE");
            PredefinedDataType DATATYPE_DATETIME = new PredefinedDataType(65535, "DATETIME");
            PredefinedDataType DATATYPE_TIME = new PredefinedDataType(65535, "TIME");
            PredefinedDataType DATATYPE_TIMESTAMP = new PredefinedDataType(65535, "TIMESTAMP");
            PredefinedDataType DATATYPE_YEAR = new PredefinedDataType(65535, "YEAR", "YEAR[(<precision>)]", new DataTypeAttribute[]{YEAR_PRECISION});
            DataTypeAttribute CHARSET = new DataTypeAttribute("charset", 256, new String[]{"ASCII", "BINARY", "UNICODE"}, null, false, false);
            DataTypeAttribute CHAR_DISPLAY_WIDTH = new DataTypeAttribute("size", 101, 0L, new Long(255L), new Long(255L), true);
            DataTypeAttribute OPTIONAL_CHAR_DISPLAY_WIDTH = new DataTypeAttribute("size", 101, 0L, new Long(255L), new Long(1L), false);
            CharacterDataType DATATYPE_CHAR = new CharacterDataType(65535, "CHAR", "CHAR[(<size>)][ <charset>]", new DataTypeAttribute[]{OPTIONAL_CHAR_DISPLAY_WIDTH, CHARSET});
            CharacterDataType DATATYPE_VARCHAR = new CharacterDataType(65535, "VARCHAR", "VARCHAR(<size>)[ <charset>]", new DataTypeAttribute[]{CHAR_DISPLAY_WIDTH, CHARSET});
            BinaryDataType DATATYPE_BINARY = new BinaryDataType(65535, "BINARY", "BINARY(<size>)", new DataTypeAttribute[]{CHAR_DISPLAY_WIDTH});
            BinaryDataType DATATYPE_VARBINARY = new BinaryDataType(65535, "VARBINARY", "VARBINARY(<size>)", new DataTypeAttribute[]{CHAR_DISPLAY_WIDTH});
            BinaryDataType DATATYPE_LONGBLOB = new BinaryDataType(65535, "LONGBLOB", 1L, 0x100000000L);
            BinaryDataType DATATYPE_LONGTEXT = new BinaryDataType(65535, "LONGTEXT", 1L, 0x100000000L);
            BinaryDataType DATATYPE_MEDIUMBLOB = new BinaryDataType(65535, "MEDIUMBLOB", 1L, 0xFFFFFFL);
            BinaryDataType DATATYPE_MEDIUMTEXT = new BinaryDataType(65535, "MEDIUMTEXT", 1L, 0xFFFFFFL);
            BinaryDataType DATATYPE_BLOB = new BinaryDataType(65535, "BLOB", 1L, 65535L);
            BinaryDataType DATATYPE_TEXT = new BinaryDataType(65535, "TEXT", 1L, 65535L);
            BinaryDataType DATATYPE_TINYBLOB = new BinaryDataType(65535, "TINYBLOB", 1L, 255L);
            BinaryDataType DATATYPE_TINYTEXT = new BinaryDataType(65535, "TINYTEXT", 1L, 255L);
            NumericDataType DATATYPE_BIT = new NumericDataType(65535, "BIT", NumericDataType.MIN_MAX_SIGNED_TINYINT);
            DataTypeAttribute VALUE_LIST = new DataTypeAttribute("value_list", 282, null, true);
            PredefinedDataType DATATYPE_SET = new PredefinedDataType(65535, "SET");
            PredefinedDataType DATATYPE_ENUM = new PredefinedDataType(65535, "ENUM");
            NumericDataType SYNONYM_BOOL = new NumericDataType(65535, "BOOL", NumericDataType.MIN_MAX_SIGNED_TINYINT);
            NumericDataType SYNONYM_BOOLEAN = new NumericDataType(65535, "BOOLEAN", NumericDataType.MIN_MAX_SIGNED_TINYINT);
            dtr.registerDataType((DataType)DATATYPE_BIGINT, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_BIGINT);
            dtr.registerDataType((DataType)DATATYPE_INT, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dtr.registerDataType((DataType)DATATYPE_MEDIUMINT, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_INT);
            dtr.registerDataType((DataType)DATATYPE_SMALLINT, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dtr.registerDataType((DataType)DATATYPE_TINYINT, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_SMALLINT);
            dtr.registerDataType((DataType)DATATYPE_DECIMAL, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)DATATYPE_FLOAT, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)DATATYPE_DOUBLE, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_DOUBLE_PRECISION);
            dtr.registerDataType((DataType)DATATYPE_DATE, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_DATE);
            dtr.registerDataType((DataType)DATATYPE_DATETIME, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_TIME, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_TIME);
            dtr.registerDataType((DataType)DATATYPE_TIMESTAMP, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_YEAR, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_CHAR, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_VARCHAR, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_CHAR_VARYING);
            dtr.registerDataType((DataType)DATATYPE_BINARY, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_VARBINARY, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dtr.registerDataType((DataType)DATATYPE_LONGBLOB, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_LONGTEXT, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_BLOB, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_TEXT, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_MEDIUMBLOB, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_MEDIUMTEXT, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_TINYBLOB, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_TINYTEXT, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_SET, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_ENUM, MySQLDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_BIT, MySQLDatabaseImpl.class, JdbcDatabase.ANSI_BIT);
            dtr.registerSynonym("CHARACTER", (DataType)DATATYPE_CHAR, MySQLDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER VARYING", (DataType)DATATYPE_VARCHAR, MySQLDatabaseImpl.class);
            dtr.registerSynonym("NCHAR", (DataType)DATATYPE_CHAR, MySQLDatabaseImpl.class);
            dtr.registerSynonym("NATIONAL CHAR", (DataType)DATATYPE_CHAR, MySQLDatabaseImpl.class);
            dtr.registerSynonym("NATIONAL VARCHAR", (DataType)DATATYPE_VARCHAR, MySQLDatabaseImpl.class);
            dtr.registerSynonym("NATIONAL CHARACTER VARYING", (DataType)DATATYPE_VARCHAR, MySQLDatabaseImpl.class);
            dtr.registerSynonym("LONG VARCHAR", (DataType)DATATYPE_MEDIUMTEXT, MySQLDatabaseImpl.class);
            dtr.registerSynonym("LONG VARBINARY", (DataType)DATATYPE_MEDIUMBLOB, MySQLDatabaseImpl.class);
            dtr.registerSynonym("DEC", (DataType)DATATYPE_DECIMAL, MySQLDatabaseImpl.class);
            dtr.registerSynonym("DOUBLE PRECISION", (DataType)DATATYPE_DOUBLE, MySQLDatabaseImpl.class);
            dtr.registerSynonym("FIXED", (DataType)DATATYPE_DECIMAL, MySQLDatabaseImpl.class);
            dtr.registerSynonym("INTEGER", (DataType)DATATYPE_INT, MySQLDatabaseImpl.class);
            dtr.registerSynonym("NUMERIC", (DataType)DATATYPE_DECIMAL, MySQLDatabaseImpl.class);
            dtr.registerSynonym("REAL", (DataType)DATATYPE_DOUBLE, MySQLDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_BOOL, (DataType)DATATYPE_TINYINT, MySQLDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_BOOLEAN, (DataType)DATATYPE_TINYINT, MySQLDatabaseImpl.class);
        }

        Registerer() {
        }
    }
}

