/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.mysql;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.NumericDataType;

class MySQLFloatDatatype
extends NumericDataType {
    private static final DataTypeAttribute FLOAT_DISPLAY_WIDTH = new DataTypeAttribute("size", 101, 0L, new Long(255L), new Long(12), false);
    private static final DataTypeAttribute SCALE = new DataTypeAttribute("scale", 68, 0L, null, new Long(0L), false);
    private static final DataTypeAttribute FLOAT_PRECISION = new DataTypeAttribute("size", 101, 0L, new Long(53), null, false);
    private static final NumericDataType ANSI_FLOAT = new NumericDataType(65535, "FLOAT", "FLOAT(<size>)[ <unsigned>]", new DataTypeAttribute[]{FLOAT_PRECISION, NumericDataType.UNSIGNED}, new NumericDataType.MinMaxValue("2.2250738585072014E-308", "1.7976931348623157E+308", 2));

    public MySQLFloatDatatype() {
    }

    public MySQLFloatDatatype(int domain) {
        super(domain, "FLOAT", "FLOAT[(<size>[, <scale>])][ <unsigned>]", new DataTypeAttribute[]{FLOAT_DISPLAY_WIDTH, SCALE, NumericDataType.UNSIGNED}, new NumericDataType.MinMaxValue("1.175494351E-38", "3.402823466E+38", 2));
    }

    public DBObject copyTo(DBObject target, DBObject copyParent, IDPolicy idPolicy) {
        MySQLFloatDatatype copy = target != null ? (MySQLFloatDatatype)target : new MySQLFloatDatatype();
        this.copyToImpl(copy, copyParent, idPolicy);
        return copy;
    }

    public boolean equals(Object obj) {
        return obj instanceof MySQLFloatDatatype && this.equalsImpl((MySQLFloatDatatype)((Object)obj));
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        if (dataTypeUsage != null) {
            Long scaleVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
            if (scaleVal == null) {
                Long size = (Long)dataTypeUsage.getAttributeValue("size");
                if (size != null) {
                    if (size.compareTo(FLOAT_PRECISION.getMinValue()) < 0) {
                        throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format((int)328, (Object)DataTypeHelper.getNameFromLabel((String)FLOAT_PRECISION.getLabel()), (Object)FLOAT_PRECISION.getMinValue()));
                    }
                    if (size.compareTo(FLOAT_PRECISION.getMaxValue()) > 0) {
                        throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format((int)361, (Object)DataTypeHelper.getNameFromLabel((String)FLOAT_PRECISION.getLabel()), (Object)FLOAT_PRECISION.getMaxValue()));
                    }
                }
            } else {
                super.validateUsage(dataTypeUsage, dbObject);
            }
        }
    }

    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        if (dataTypeUsage != null && defaultValue != null) {
            Long scaleVal = DataTypeHelper.getLongAttributeValue((DataTypeUsage)dataTypeUsage, (String)"scale");
            if (scaleVal == null) {
                ANSI_FLOAT.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
            } else {
                super.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
            }
        }
    }
}

