/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.CascadeRequiredException;
import oracle.javatools.db.ColumnSequenceExpander;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.dictionary.DictionaryDatabase;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.ReconcileHelper;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDictionaryQueries;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleQueryWrapper;
import oracle.javatools.db.ora.OracleSchemaProperties;
import oracle.javatools.db.ora.OracleSequenceBuilder;
import oracle.javatools.db.ora.OracleSynonymBuilder;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleViewBuilder;
import oracle.javatools.parser.Lexer;
import oracle.javatools.parser.LexerToken;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

public abstract class BaseOracleDatabase
extends DictionaryDatabase
implements OracleDatabase {
    private static final String PUBLIC_NAME = "PUBLIC";
    private static final String LOCAL_TRANSACTION_QUERY = "SELECT dbms_transaction.local_transaction_id FROM DUAL";
    private static final String QUERY_TABLESPACES = "SELECT /*BaseOracleDatabase.ALL_QUERY_TABLESPACES*/ TABLESPACE_NAME FROM SYS.USER_TABLESPACES WHERE CONTENTS = 'PERMANENT'";
    private static final String VISIBLE_USERS_QUERY = "SELECT /*BaseOracleDatabase.ALL_VISIBLE_USERS_QUERY*/ \n       U.USERNAME\nFROM   SYS.ALL_USERS U\nWHERE  EXISTS (SELECT 1 \n               FROM SYS.ALL_OBJECTS O \n               WHERE O.OWNER = U.USERNAME\n               AND ROWNUM < 2)\n";
    private static final String CURR_USER_QUERY = "SELECT /*BaseOracleDatabase.ALL_CURR_USER_QUERY*/ \n       USERNAME\n,      DEFAULT_TABLESPACE\n,      TEMPORARY_TABLESPACE\nFROM   SYS.USER_USERS";
    private Schema m_public;
    private Schema m_currSchema;
    private OracleDictionaryQueries m_dictionary;
    private static final List s_supportedObjectTypes = Arrays.asList("SEQUENCE", "SYNONYM", "TABLE", "VIEW", "MATERIALIZED VIEW", "MATERIALIZED VIEW LOG", "TRIGGER", "PACKAGE", "FUNCTION", "PROCEDURE", "TYPE", "DATABASE LINK", "INDEX", "DIRECTORY", "XML SCHEMA");
    private String m_databaseLinkNameSuffix;
    static final Long LONG_0 = new Long(0L);
    static final Long LONG_1 = new Long(1L);
    static final Long LONG_2 = new Long(2);
    static final Long LONG_6 = new Long(6);
    static final Long LONG_9 = new Long(9);
    static final Long LONG_4000 = new Long(4000L);
    static final Long LONG_2000 = new Long(2000L);

    private void $init$() {
        this.m_public = new Schema(PUBLIC_NAME);
        this.m_dictionary = new OracleDictionaryQueries(this);
        this.m_databaseLinkNameSuffix = null;
    }

    BaseOracleDatabase(String storeName, String connName, Connection conn) {
        super(storeName, connName, conn);
        this.$init$();
        this.m_currSchema = this.createSchema(conn);
        this.cacheSchema(this.m_currSchema.getName(), this.m_currSchema, true);
    }

    public DictionaryQueries getDictionaryQueries() {
        return this.m_dictionary;
    }

    public void disableDBAViews() {
        this.m_dictionary.disableDBAViews();
    }

    protected QueryWrapper newQueryWrapper(String query, List params) {
        return new OracleQueryWrapper(this, query, params);
    }

    protected final Schema getCurrentSchema() {
        return this.m_currSchema;
    }

    protected final Schema getPublicSchema() {
        return this.m_public;
    }

    protected String getAliveTestStatement() {
        return "/** TESTING CONNECTION IS ALIVE */ SELECT 1 FROM DUAL";
    }

    protected String getTransactionTestQuery() {
        return LOCAL_TRANSACTION_QUERY;
    }

    protected void registerBuilders() {
        this.registerBuilder("SYNONYM", (DBObjectBuilder)new OracleSynonymBuilder(this));
        this.registerBuilder("SEQUENCE", (DBObjectBuilder)new OracleSequenceBuilder(this));
        this.registerBuilder("TABLE", (DBObjectBuilder)new OracleTableBuilder(this));
        this.registerBuilder("INDEX", (DBObjectBuilder)new OracleIndexBuilder(this));
        this.registerBuilder("VIEW", (DBObjectBuilder)new OracleViewBuilder(this));
    }

    protected void registerExpanders() {
        super.registerExpanders();
        if (this.getDescriptor().supportsFeature("COLUMN SEQUENCES")) {
            this.registerSchemaObjectExpander(new ColumnSequenceExpander((DBObjectProvider)this));
        }
    }

    public String getUserName() {
        return this.m_currSchema != null ? this.m_currSchema.getName() : null;
    }

    public abstract String getDatabaseType();

    public boolean supportsDebugging() {
        return false;
    }

    protected DBObjectBuilder getBuilderForType(String type) {
        return super.getBuilderForType(type);
    }

    protected final SchemaObject findObject(String type, Schema schema, String name) {
        return super.findObject(type, schema, name);
    }

    protected void cacheObject(SchemaObject object, boolean loadOperation) {
        super.cacheObject(object, loadOperation);
    }

    protected DBObject findByID(DBObjectID id) throws DBException {
        return super.findByID(id);
    }

    public boolean hasPriviledge(String type, Schema schema, String priv) {
        return !ModelUtil.areEqual((Object)"CREATE", (Object)priv) && super.hasPriviledge(type, schema, priv);
    }

    public void validateUniqueName(String type, DBObject contextObject, String name) throws NameInUseException {
        if (ModelUtil.hasLength((String)name)) {
            Schema schema = DBUtil.getSchema((DBObject)contextObject);
            if ("DATABASE LINK".equals(type)) {
                NameInUseException nameInUseException = null;
                this.getDatabaseLinkNameSuffix(schema);
                try {
                    String[] stringArray = this.listObjects("DATABASE LINK", schema, name);
                    int n = 0;
                    while (n < stringArray.length) {
                        String dbLinkName = stringArray[n];
                        if (dbLinkName.equals(name) || dbLinkName.equals(name + this.m_databaseLinkNameSuffix)) {
                            nameInUseException = new NameInUseException(name, dbLinkName, "DATABASE LINK");
                        }
                        ++n;
                    }
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (nameInUseException != null) {
                    throw nameInUseException;
                }
            } else {
                type = this.normaliseType(type);
                Holder found = new Holder();
                String query = this.m_dictionary.getValidateNamespaceQuery(type);
                List params = this.getParameters(this.m_dictionary.getValidateNamespaceQueryParams(type), BaseOracleDatabase.convertObject((DBObject)schema), name, new String[]{type});
                QueryWrapper wrap = this.newQueryWrapper(query, params);
                1 r = new 1(this, found, wrap, contextObject);
                try {
                    wrap.executeQuery((QueryWrapper.QueryRunnable)r);
                }
                catch (DBException dbe) {
                    DBLog.logStackTrace((Throwable)dbe);
                }
                String[] existing = (String[])found.get();
                if (existing != null) {
                    throw new NameInUseException(name, existing[0], existing[1]);
                }
            }
        }
    }

    public String getUniqueName(String type, DBObject contextObject, String baseName) {
        Schema schema = DBUtil.getSchema((DBObject)contextObject);
        if ("DATABASE LINK".equals(type)) {
            if (!ModelUtil.hasLength((String)baseName)) {
                baseName = "DBLINK";
            }
            try {
                this.getDatabaseLinkNameSuffix(schema);
                String namePart1 = baseName.split("\\.")[0];
                String namePart2 = baseName.replaceFirst(baseName, "");
                HashSet<String> names = new HashSet<String>();
                boolean nameSeen = false;
                String[] stringArray = this.listObjects("DATABASE LINK", schema);
                int n = 0;
                while (n < stringArray.length) {
                    String dbLinkName = stringArray[n];
                    if (dbLinkName.equals(baseName) || dbLinkName.equals(baseName + this.m_databaseLinkNameSuffix)) {
                        nameSeen = true;
                    }
                    names.add(dbLinkName.split("\\.")[0]);
                    ++n;
                }
                String string = nameSeen ? DBUtil.getUniqueName(names, (String)namePart1) + namePart2 : baseName;
                return string;
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        HashSet names = new HashSet();
        Connection conn = this.getConnection();
        type = this.normaliseType(type);
        if (!ModelUtil.hasLength((String)baseName)) {
            baseName = type + 1;
        }
        String objectNameLike = baseName.replaceAll("\\d*$", "") + '%';
        String query = this.m_dictionary.getNamespaceQuery(type);
        List params = this.getParameters(this.m_dictionary.getNamespaceQueryParams(type), BaseOracleDatabase.convertObject((DBObject)schema), objectNameLike, new String[]{type});
        QueryWrapper wrap = this.newQueryWrapper(query, params);
        2 r = new 2(this, names);
        try {
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        }
        catch (DBException dbe) {
            DBLog.logStackTrace((Throwable)dbe);
        }
        return DBUtil.getUniqueName(names, (String)baseName);
    }

    public boolean isObjectValid(String objectType, String schema, String objectName) {
        String query = this.m_dictionary.getObjectStatusQuery();
        List params = this.getParameters(this.m_dictionary.getObjectStatusQueryParams(), schema, objectName, new String[]{objectType});
        QueryWrapper wrap = this.newQueryWrapper(query, params);
        Holder valid = new Holder((Object)false);
        3 r = new 3(this, valid, wrap);
        try {
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        }
        catch (DBException dbe) {
            DBLog.logStackTrace((Throwable)dbe);
        }
        return (Boolean)valid.get();
    }

    public DataType getDataType(String typeName) {
        if ((typeName = typeName.trim()).startsWith("TIMESTAMP")) {
            typeName = "TIMESTAMP";
        } else if (typeName.startsWith("INTERVAL YEAR")) {
            typeName = "INTERVAL YEAR";
        } else if (typeName.startsWith("INTERVAL DAY")) {
            typeName = "INTERVAL DAY";
        }
        return super.getDataType(typeName.toUpperCase().trim());
    }

    public Schema[] listSchemas(boolean restrictVisible) throws DBException {
        if (!restrictVisible) {
            return this.listSchemas();
        }
        ArrayList l = new ArrayList();
        QueryWrapper wrap = this.newQueryWrapper(VISIBLE_USERS_QUERY, new Object[0]);
        4 r = new 4(this, l, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        return l.toArray(new Schema[l.size()]);
    }

    public boolean canRestrictSchemaList() {
        return true;
    }

    public Schema getSchema(String name) throws DBException {
        if (!ModelUtil.hasLength((String)name)) {
            return null;
        }
        if (PUBLIC_NAME.equals(name)) {
            return this.m_public;
        }
        if (ModelUtil.areEqual((Object)this.m_currSchema.getName(), (Object)name)) {
            return this.m_currSchema;
        }
        return super.getSchema(name);
    }

    public String[] listTablespaces() {
        ArrayList list = new ArrayList();
        QueryWrapper wrap = this.newQueryWrapper(QUERY_TABLESPACES, new Object[0]);
        5 r = new 5(this, list, wrap);
        try {
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "could not query tablespaces from " + this.getConnectionName(), dbe);
        }
        return list.toArray(new String[list.size()]);
    }

    public DiffEngine getDiffEngine() {
        return ReconcileHelper.getDiffEngine();
    }

    protected boolean isCauseNameInUse(DBException dbe) {
        int errorCode;
        Throwable cause = dbe.getCause();
        return cause instanceof SQLException && ((errorCode = ((SQLException)cause).getErrorCode()) == 955 || errorCode == 12000 || errorCode == 12006);
    }

    protected void processDeleteException(DBException dbe, SchemaObject obj) throws DBException {
        Throwable cause = dbe.getCause();
        if (cause instanceof SQLException) {
            int code = ((SQLException)cause).getErrorCode();
            if (code == 2441 || code == 2442 || code == 2443) {
                return;
            }
            if (code == 2449) {
                throw new CascadeRequiredException((DBObject)obj, ((SQLException)cause).getMessage());
            }
        }
        throw dbe;
    }

    public String getDatabaseSource(String objectType, Schema schema, String objectName, String sourceType) throws DBException {
        String source = null;
        SchemaObject object = this.getObject(objectType, schema, objectName);
        if (object instanceof Trigger) {
            source = this.getTriggerSource((Trigger)object);
        } else if (object instanceof SpecPlSql) {
            if ("Spec".equals(sourceType)) {
                source = ((SpecPlSql)object).getSource();
            } else if ("Body".equals(sourceType)) {
                source = ((SpecPlSql)object).getBodySource();
            }
        } else if (object instanceof SourceObject) {
            source = ((SourceObject)object).getSource();
        }
        if (source == null) {
            return null;
        }
        if (source.indexOf("CREATE OR REPLACE") == 0) {
            return source;
        }
        return "CREATE OR REPLACE \n" + source;
    }

    public String getDatabaseSource(String objectType, Schema schema, String objectName) throws DBException {
        return this.getDatabaseSource(objectType, schema, objectName, null);
    }

    private String getTriggerSource(Trigger trigger) {
        String src = null;
        DDLGenerator gen = this.getDDLGenerator2();
        DDL ddl = gen.getCreateDDL(new DDLOptions(false, false), new DBObject[]{trigger});
        if (ddl != null && ddl.size() > 0 && ModelUtil.hasLength((String)(src = ddl.toString()))) {
            Lexer lexer = PlsqlParser.createSqlLexer();
            ReadTextBuffer buf = TextBufferFactory.createReadTextBuffer((String)src);
            lexer.setTextBuffer(buf);
            LexerToken token = lexer.createLexerToken();
            int start = 0;
            block4: while (true) {
                int tk = lexer.lex(token);
                switch (tk) {
                    case 0: {
                        break block4;
                    }
                    case 1112: {
                        start = token.getStartOffset();
                        break block4;
                    }
                    default: {
                        continue block4;
                    }
                }
                break;
            }
            src = buf.getString(start, buf.getLength() - start);
        }
        return src;
    }

    protected SchemaObject getCreatedObject(String type, Schema schema, String name) throws DBException {
        Collection possibles;
        SchemaObject retval = super.getCreatedObject(type, schema, name);
        if (retval == null && type.equals("DATABASE LINK") && (possibles = this.listObjectsImpl(new String[]{"DATABASE LINK"}, schema, name + "%")) != null & possibles.size() == 1) {
            retval = (SchemaObject)possibles.iterator().next();
        }
        return retval;
    }

    protected Schema createSchema(Connection conn) {
        Holder holder = new Holder();
        QueryWrapper wrap = new QueryWrapper((Database)this, CURR_USER_QUERY);
        6 r = new 6(this, holder, wrap);
        Schema currSchema = null;
        try {
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
            currSchema = (Schema)holder.get();
        }
        catch (DBException dbe) {
            try {
                currSchema = this.createSchema(conn.getMetaData().getUserName());
            }
            catch (SQLException x) {
                // empty catch block
            }
        }
        return currSchema;
    }

    protected boolean isRequestedObject(SchemaObject object, String type, Schema schema, String name) {
        boolean matches = super.isRequestedObject(object, type, schema, name);
        if (!matches && "DATABASE LINK".equals(type) && "DATABASE LINK".equals(object.getType()) && schema != null && object.getSchema().getName().equals(schema.getName())) {
            matches = object.getName().equals(name + this.getDatabaseLinkNameSuffix(schema));
        }
        return matches;
    }

    private String getDatabaseLinkNameSuffix(Schema schema) {
        if (this.m_databaseLinkNameSuffix == null) {
            this.m_databaseLinkNameSuffix = "";
            try {
                String baseName = "DBLINKTESTNAME";
                int baseNameSuffix = 1;
                while (this.listObjects("DATABASE LINK", schema, baseName).length > 0) {
                    baseName = "DBLINKTESTNAME" + baseNameSuffix++;
                }
                DatabaseLink dbLink = new DatabaseLink();
                dbLink.setName(baseName);
                dbLink.setSchema(schema);
                this.createObject((SchemaObject)dbLink, false);
                String[] names = this.listObjects("DATABASE LINK", schema, baseName);
                this.m_databaseLinkNameSuffix = names[0].replaceFirst(baseName, "");
                this.deleteObject((SchemaObject)dbLink, false);
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        return this.m_databaseLinkNameSuffix;
    }

    static Schema mav$createSchema(BaseOracleDatabase baseOracleDatabase, String string) {
        return baseOracleDatabase.createSchema(string);
    }

    static Schema mav$getCachedSchema(BaseOracleDatabase baseOracleDatabase, String string) {
        return baseOracleDatabase.getCachedSchema(string);
    }

    static void mav$cacheSchema(BaseOracleDatabase baseOracleDatabase, String string, Schema schema) {
        baseOracleDatabase.cacheSchema(string, schema);
    }

    static Schema ra$m_currSchema(BaseOracleDatabase baseOracleDatabase) {
        return baseOracleDatabase.m_currSchema;
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$found;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ DBObject v$contextObject;
        final /* synthetic */ BaseOracleDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$found.set((Object)new String[]{rs.getString(1), rs.getString(2)});
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException(this.v$contextObject, sqe);
            }
        }

        public 1(BaseOracleDatabase baseOracleDatabase, Holder holder, QueryWrapper queryWrapper, DBObject dBObject) {
            this.v$contextObject = dBObject;
            this.v$wrap = queryWrapper;
            this.v$found = holder;
            this.this$0 = baseOracleDatabase;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Set v$names;
        final /* synthetic */ BaseOracleDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    this.v$names.add(rs.getString(1));
                }
            }
            catch (SQLException sqe) {
                DBLog.logStackTrace((Throwable)sqe);
            }
        }

        public 2(BaseOracleDatabase baseOracleDatabase, Set set) {
            this.v$names = set;
            this.this$0 = baseOracleDatabase;
        }
    }

    final class 3
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$valid;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ BaseOracleDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    String state = rs.getString(1);
                    this.v$valid.set((Object)"VALID".equalsIgnoreCase(state));
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException(sqe);
            }
        }

        public 3(BaseOracleDatabase baseOracleDatabase, Holder holder, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$valid = holder;
            this.this$0 = baseOracleDatabase;
        }
    }

    final class 4
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ List v$l;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ BaseOracleDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String name = rs.getString(1);
                    if (!ModelUtil.areDifferent((Object)BaseOracleDatabase.PUBLIC_NAME, (Object)name)) continue;
                    Schema schema = BaseOracleDatabase.mav$getCachedSchema(this.this$0, name);
                    if (schema == null) {
                        schema = BaseOracleDatabase.mav$createSchema(this.this$0, name);
                        BaseOracleDatabase.mav$cacheSchema(this.this$0, name, schema);
                    }
                    this.v$l.add(schema);
                }
                if (!this.v$l.contains(BaseOracleDatabase.ra$m_currSchema(this.this$0))) {
                    this.v$l.add(BaseOracleDatabase.ra$m_currSchema(this.this$0));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException(ex);
            }
        }

        public 4(BaseOracleDatabase baseOracleDatabase, List list, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$l = list;
            this.this$0 = baseOracleDatabase;
        }
    }

    final class 5
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ List v$list;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ BaseOracleDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    this.v$list.add(rs.getString(1));
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException(sqe);
            }
        }

        public 5(BaseOracleDatabase baseOracleDatabase, List list, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$list = list;
            this.this$0 = baseOracleDatabase;
        }
    }

    final class 6
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$holder;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ BaseOracleDatabase this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    Schema currSchema = BaseOracleDatabase.mav$createSchema(this.this$0, rs.getString(1));
                    OracleSchemaProperties props = new OracleSchemaProperties();
                    props.setDefaultTablespace(rs.getString(2));
                    props.setTemporaryTablespace(rs.getString(3));
                    currSchema.setProperty("OracleSchemaProperties", (Object)props);
                    this.v$holder.set((Object)currSchema);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException(ex);
            }
        }

        public 6(BaseOracleDatabase baseOracleDatabase, Holder holder, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$holder = holder;
            this.this$0 = baseOracleDatabase;
        }
    }
}

