/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.util.ModelUtil;

class DatabaseLinkBuilder
extends OracleDBObjectBuilder {
    DatabaseLinkBuilder(BaseOracleDatabase db) {
        super(db, "DATABASE LINK");
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        DatabaseLink dbl = new DatabaseLink(name, schema, id);
        dbl.setPublic(ModelUtil.areEqual((Object)this.getDatabase().getPublicSchema(), (Object)schema));
        return dbl;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        DatabaseLink dblink = (DatabaseLink)object;
        QueryWrapper wrap = this.newQueryWrapper(this.getQuery(), dblink.getSchema(), dblink);
        1 r = new 1(this, dblink, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private String getQuery() {
        return "SELECT /*OracleDictionaryQueries.ALL_DATABASE_LINK_OBJECT_QUERY*/\n       USERNAME, HOST, CREATED   FROM SYS.ALL_DB_LINKS  WHERE OWNER = ? AND DB_LINK = ? ";
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ DatabaseLink v$dblink;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ DatabaseLinkBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    String username = rs.getString(1);
                    if ("CURRENT_USER".equals(username)) {
                        this.v$dblink.setCurrentUser(true);
                    } else {
                        this.v$dblink.setUsername(username);
                    }
                    String host = rs.getString(2);
                    this.v$dblink.setHost(host);
                    String created = rs.getString(3);
                    this.v$dblink.setCreated(created);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$dblink, ex);
            }
        }

        public 1(DatabaseLinkBuilder databaseLinkBuilder, DatabaseLink databaseLink, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$dblink = databaseLink;
            this.this$0 = databaseLinkBuilder;
        }
    }
}

