/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

class DirectoryBuilder
extends OracleDBObjectBuilder {
    DirectoryBuilder(Oracle8 db) {
        super(db, "DIRECTORY");
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        Directory dir = new Directory(name, schema);
        dir.setID(id);
        return dir;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        this.fillInPath((Directory)object);
    }

    private void fillInPath(Directory dir) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_DIRECTORY_QUERY*/\n       DIRECTORY_PATH FROM ALL_DIRECTORIES WHERE OWNER = ? AND DIRECTORY_NAME = ? ", dir.getSchema(), dir);
        1 r = new 1(this, dir, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Directory v$dir;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ DirectoryBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$dir.setPath(rs.getString(1));
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$dir, sqe);
            }
        }

        public 1(DirectoryBuilder directoryBuilder, Directory directory, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$dir = directory;
            this.this$0 = directoryBuilder;
        }
    }
}

