/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.DataInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BinaryObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.JavaClass;
import oracle.javatools.db.JavaResource;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.jdbc.OracleCallableStatement;
import oracle.sql.BLOB;

final class JavaBinaryBuilder
extends OracleDBObjectBuilder {
    private static final String CLASS_QUERY = "declare   v_shortname varchar2(30);   lob BLOB; begin   v_shortname := dbms_java.shortname( ? );   dbms_lob.createtemporary(lob, true, dbms_lob.SESSION);   dbms_java.export_class(v_shortname, ?, lob);   ? := lob; end; ";
    private static final String RESOURCE_QUERY = "declare   v_shortname varchar2(30);   lob BLOB; begin   v_shortname := dbms_java.shortname( ? );   dbms_lob.createtemporary(lob, true, dbms_lob.SESSION);   dbms_java.export_resource(v_shortname, ?, lob);   ? := lob; end; ";
    private static final String FREE_BLOB = "call dbms_lob.freetemporary(?)";

    JavaBinaryBuilder(BaseOracleDatabase db, String dbObjectType) {
        super(db, dbObjectType);
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        BinaryObject result = "JAVA CLASS".equals(this.getObjectType()) ? (BinaryObject)new JavaClass(name, schema) : (BinaryObject)new JavaResource(name, schema);
        result.setID(id);
        return result;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        BinaryObject result = (BinaryObject)object;
        Schema schema = result.getSchema();
        String name = result.getName();
        Connection conn = this.getConnection();
        OracleCallableStatement ocs = null;
        try {
            try {
                String schemaName = AbstractDBObjectProvider.convertObject((DBObject)schema);
                ocs = (OracleCallableStatement)conn.prepareCall(this._getSQL());
                ocs.setString(1, name);
                ocs.setString(2, schemaName);
                ocs.registerOutParameter(3, 2004);
                ocs.execute();
                BLOB b = ocs.getBLOB(3);
                DataInputStream dataStream = new DataInputStream(b.getBinaryStream());
                byte[] byteArray = new byte[(int)b.length()];
                byteArray = b.getBytes(1L, byteArray.length);
                result.setBytes(byteArray);
                ocs.close();
                ocs = (OracleCallableStatement)conn.prepareCall(FREE_BLOB);
                ocs.setBLOB(1, b);
                ocs.execute();
            }
            catch (SQLException ex) {
                throw new DBException((Throwable)ex);
            }
        }
        finally {
            if (ocs != null) {
                try {
                    ocs.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private String _getSQL() {
        return "JAVA CLASS".equals(this.getObjectType()) ? CLASS_QUERY : RESOURCE_QUERY;
    }
}

