/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleIndexBuilder;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.ora.OracleViewBuilder;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

class MaterializedViewBuilder
extends OracleTableBuilder {
    private static String TENG_REPLACE_COL = "A.UNKNOWN_TRUSTED_FD";
    private static String NON_TENG_REPLACE_COL = "'NULL'";
    private String m_usingIndexIndexName;

    private void $init$() {
        this.m_usingIndexIndexName = null;
    }

    MaterializedViewBuilder(BaseOracleDatabase db) {
        super(db, "MATERIALIZED VIEW");
        this.$init$();
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        MaterializedView mview = new MaterializedView(name, schema);
        mview.setID(id);
        return mview;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        MaterializedView mview = (MaterializedView)object;
        this.fillInColumns((Relation)mview);
        this.fillInProperties(mview);
        this.fillInQuery(mview);
        this.fillInIndexes(mview);
        this.fillInComment((Relation)mview);
    }

    private void fillInProperties(MaterializedView mview) throws DBException {
        this.fillInBaseProperties(mview);
        this.fillInIndexProperties(mview);
    }

    private void fillInIndexes(MaterializedView mview) throws DBException {
        OracleIndexBuilder ib = (OracleIndexBuilder)this.getDatabase().getBuilderForType("INDEX");
        ib.setMatViewUsingIndexIndexName(this.m_usingIndexIndexName);
        ib.fillInIndexes((SchemaObject)mview);
    }

    private void fillInBaseProperties(MaterializedView mview) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper(this.getQuery(this.getDatabase().getOracleDatabaseType()), mview.getSchema(), mview);
        1 r = new 1(this, mview, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        QueryWrapper wrap2 = this.newQueryWrapper(this.getTableQuery(), mview.getSchema(), mview);
        2 r2 = new 2(this, mview, wrap2);
        wrap2.executeQuery((QueryWrapper.QueryRunnable)r2);
    }

    private void fillInQuery(MaterializedView mview) throws DBException {
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_MVIEW_QUERY_QUERY*/\n       A.QUERY\nFROM SYS.ALL_MVIEWS A\nWHERE A.OWNER = ? AND A.MVIEW_NAME = ? \n", mview.getSchema(), mview);
        3 r = new 3(this, mview, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private void fillInIndexProperties(MaterializedView mview) throws DBException {
        this.m_usingIndexIndexName = null;
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_MVIEW_INDEX_QUERY*/\n       I.INDEX_NAME \n,      I.TABLESPACE_NAME \n,      I.PCT_FREE \n,      NULL PCT_USED \n,      I.INI_TRANS \n,      I.MAX_TRANS \n,      I.INITIAL_EXTENT \n,      I.NEXT_EXTENT \n,      I.MIN_EXTENTS \n,      I.MAX_EXTENTS \n,      I.PCT_INCREASE \n,      I.FREELISTS \n,      I.FREELIST_GROUPS \n,      I.LOGGING \n,      I.BUFFER_POOL \nFROM   SYS.ALL_MVIEWS A \n,      SYS.ALL_INDEXES I \n,      SYS.ALL_CONSTRAINTS C \nWHERE  A.MVIEW_NAME = I.TABLE_NAME \nAND    C.OWNER = A.OWNER \nAND    C.TABLE_NAME = A.MVIEW_NAME \nAND    C.CONSTRAINT_TYPE = 'P' \nAND    C.INDEX_NAME = I.INDEX_NAME\nAND    A.OWNER = ? \nAND    A.MVIEW_NAME = ? \n", mview.getSchema(), mview);
        4 r = new 4(this, mview, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private String getQuery(int databaseType) {
        String toFormat = "SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n       A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \nA.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \nA.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \nA.UNKNOWN_PREBUILT, A.USE_NO_INDEX, %1$S, E.REFRESH_METHOD KEY_TYPE, \nC.DEGREE, C.CACHE, C.PARTITIONED, %2$S, D.NEXT_DATE, D.INTERVAL, \nB.DETAILOBJ_OWNER, B.DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A, SYS.ALL_MVIEW_DETAIL_RELATIONS B, \nSYS.ALL_TABLES C, SYS.ALL_REFRESH D, \nSYS.ALL_SNAPSHOTS E\nWHERE A.OWNER = B.OWNER(+) AND A.MVIEW_NAME = B.MVIEW_NAME(+) \nAND A.MVIEW_NAME = C.TABLE_NAME AND A.OWNER = C.OWNER \nAND A.OWNER = D.ROWNER(+) AND A.MVIEW_NAME = D.RNAME(+) \nAND A.OWNER = ? AND A.MVIEW_NAME = ? \nAND A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME";
        String qry = databaseType >= 5 ? String.format("SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n       A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \nA.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \nA.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \nA.UNKNOWN_PREBUILT, A.USE_NO_INDEX, %1$S, E.REFRESH_METHOD KEY_TYPE, \nC.DEGREE, C.CACHE, C.PARTITIONED, %2$S, D.NEXT_DATE, D.INTERVAL, \nB.DETAILOBJ_OWNER, B.DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A, SYS.ALL_MVIEW_DETAIL_RELATIONS B, \nSYS.ALL_TABLES C, SYS.ALL_REFRESH D, \nSYS.ALL_SNAPSHOTS E\nWHERE A.OWNER = B.OWNER(+) AND A.MVIEW_NAME = B.MVIEW_NAME(+) \nAND A.MVIEW_NAME = C.TABLE_NAME AND A.OWNER = C.OWNER \nAND A.OWNER = D.ROWNER(+) AND A.MVIEW_NAME = D.RNAME(+) \nAND A.OWNER = ? AND A.MVIEW_NAME = ? \nAND A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME", TENG_REPLACE_COL, "C.COMPRESSION") : String.format("SELECT /*OracleDictionaryQueries.ALL_MVIEW_PROPERTIES_QUERY*/\n       A.UPDATABLE, A.REWRITE_ENABLED, A.REWRITE_CAPABILITY, \nA.REFRESH_MODE, A.REFRESH_METHOD, A.FAST_REFRESHABLE, \nA.LAST_REFRESH_TYPE, A.LAST_REFRESH_DATE, A.STALENESS, A.BUILD_MODE, \nA.UNKNOWN_PREBUILT, A.USE_NO_INDEX, %1$S, E.REFRESH_METHOD KEY_TYPE, \nC.DEGREE, C.CACHE, C.PARTITIONED, %2$S, D.NEXT_DATE, D.INTERVAL, \nB.DETAILOBJ_OWNER, B.DETAILOBJ_NAME \nFROM SYS.ALL_MVIEWS A, SYS.ALL_MVIEW_DETAIL_RELATIONS B, \nSYS.ALL_TABLES C, SYS.ALL_REFRESH D, \nSYS.ALL_SNAPSHOTS E\nWHERE A.OWNER = B.OWNER(+) AND A.MVIEW_NAME = B.MVIEW_NAME(+) \nAND A.MVIEW_NAME = C.TABLE_NAME AND A.OWNER = C.OWNER \nAND A.OWNER = D.ROWNER(+) AND A.MVIEW_NAME = D.RNAME(+) \nAND A.OWNER = ? AND A.MVIEW_NAME = ? \nAND A.OWNER = E.OWNER AND A.MVIEW_NAME = E.NAME", NON_TENG_REPLACE_COL, "NULL COMPRESSION");
        return qry;
    }

    private boolean parseYNBoolean(String s) {
        return "Y".equals(s.trim());
    }

    private MaterializedView.UsingConstraints parseUsingConstraints(String s) {
        Boolean boo = this.parseYNNullBoolean(s);
        if (boo != null) {
            return boo != false ? MaterializedView.UsingConstraints.TRUSTED : MaterializedView.UsingConstraints.ENFORCED;
        }
        return null;
    }

    private MaterializedView.RefreshWith parseKeyType(String s) {
        MaterializedView.RefreshWith ret = null;
        if (s != null) {
            s = s.trim();
            s = s.replace(" ", "_");
            try {
                ret = MaterializedView.RefreshWith.valueOf((String)s);
            }
            catch (IllegalArgumentException e) {
                ret = MaterializedView.RefreshWith.UNSPECIFIED;
            }
        }
        return ret;
    }

    private Boolean parseYNNullBoolean(String s) {
        String trim = s.trim();
        if ("Y".equals(trim) || "YES".equals(trim)) {
            return Boolean.TRUE;
        }
        if ("N".equals(trim) || "NO".equals(trim)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private int parseParallel(String s) {
        int ret = 1;
        try {
            Integer i = new Integer(s.trim());
            ret = i;
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        return ret;
    }

    private MaterializedView.RewriteCapability parseRewriteCapability(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.RewriteCapability.valueOf((String)s) : null;
    }

    private MaterializedView.RefreshMode parseRefreshMode(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.RefreshMode.valueOf((String)s) : null;
    }

    private MaterializedView.RefreshMethod parseRefreshMethod(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.RefreshMethod.valueOf((String)s) : null;
    }

    private MaterializedView.FastRefreshable parseFastRefreshable(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.FastRefreshable.valueOf((String)s) : null;
    }

    private MaterializedView.PrebuiltType parsePrebuilt(String s) {
        MaterializedView.PrebuiltType result = MaterializedView.PrebuiltType.NONE;
        if ("Y".equals(s)) {
            result = MaterializedView.PrebuiltType.UNSPECIFIED_PRECISION;
        }
        return result;
    }

    private MaterializedView.Staleness parseStaleness(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.Staleness.valueOf((String)s) : null;
    }

    private MaterializedView.BuildType parseBuildType(String s) {
        return ModelUtil.hasLength((String)s) ? MaterializedView.BuildType.valueOf((String)s) : null;
    }

    private String parseMasterName(String schema, String name) {
        StringBuffer buf = new StringBuffer(64);
        if (ModelUtil.hasLength((String)schema)) {
            buf.append(schema);
        }
        if (ModelUtil.hasLength((String)name)) {
            if (buf.length() > 0) {
                buf.append('.');
            }
            buf.append(name);
        }
        return buf.toString();
    }

    protected void fillInObjectComponent(SchemaObject object, String key) throws DBException {
        MaterializedView mview = (MaterializedView)object;
        if (key.equals("MATERIALIZED VIEW")) {
            this.fillInProperties(mview);
        } else if (key.equals("SQLQuery")) {
            this.fillInQuery(mview);
        } else {
            super.fillInObjectComponent(object, key);
        }
    }

    static void wa$m_usingIndexIndexName(MaterializedViewBuilder materializedViewBuilder, String string) {
        materializedViewBuilder.m_usingIndexIndexName = string;
    }

    static boolean mav$parseYNBoolean(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseYNBoolean(string);
    }

    static MaterializedView.RewriteCapability mav$parseRewriteCapability(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseRewriteCapability(string);
    }

    static MaterializedView.RefreshMode mav$parseRefreshMode(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseRefreshMode(string);
    }

    static MaterializedView.RefreshMethod mav$parseRefreshMethod(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseRefreshMethod(string);
    }

    static MaterializedView.FastRefreshable mav$parseFastRefreshable(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseFastRefreshable(string);
    }

    static MaterializedView.Staleness mav$parseStaleness(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseStaleness(string);
    }

    static MaterializedView.BuildType mav$parseBuildType(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseBuildType(string);
    }

    static MaterializedView.PrebuiltType mav$parsePrebuilt(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parsePrebuilt(string);
    }

    static MaterializedView.UsingConstraints mav$parseUsingConstraints(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseUsingConstraints(string);
    }

    static MaterializedView.RefreshWith mav$parseKeyType(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseKeyType(string);
    }

    static int mav$parseParallel(MaterializedViewBuilder materializedViewBuilder, String string) {
        return materializedViewBuilder.parseParallel(string);
    }

    static String mav$parseMasterName(MaterializedViewBuilder materializedViewBuilder, String string, String string2) {
        return materializedViewBuilder.parseMasterName(string, string2);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ MaterializedView v$mview;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ MaterializedViewBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    int index = 1;
                    this.v$mview.setUpdatable(MaterializedViewBuilder.mav$parseYNBoolean(this.this$0, rs.getString(index++)));
                    this.v$mview.setRewrite(MaterializedViewBuilder.mav$parseYNBoolean(this.this$0, rs.getString(index++)));
                    this.v$mview.setRewriteType(MaterializedViewBuilder.mav$parseRewriteCapability(this.this$0, rs.getString(index++)));
                    this.v$mview.setRefreshMode(MaterializedViewBuilder.mav$parseRefreshMode(this.this$0, rs.getString(index++)));
                    this.v$mview.setRefreshMethod(MaterializedViewBuilder.mav$parseRefreshMethod(this.this$0, rs.getString(index++)));
                    this.v$mview.setFastRefresh(MaterializedViewBuilder.mav$parseFastRefreshable(this.this$0, rs.getString(index++)));
                    this.v$mview.setLastRefreshType(MaterializedViewBuilder.mav$parseRefreshMethod(this.this$0, rs.getString(index++)));
                    Timestamp timestamp = rs.getTimestamp(index++);
                    Date date = timestamp == null ? null : new Date(timestamp.getTime());
                    this.v$mview.setLastRefreshDate(date);
                    this.v$mview.setStaleness(MaterializedViewBuilder.mav$parseStaleness(this.this$0, rs.getString(index++)));
                    this.v$mview.setBuildType(MaterializedViewBuilder.mav$parseBuildType(this.this$0, rs.getString(index++)));
                    this.v$mview.setOnPrebuilt(MaterializedViewBuilder.mav$parsePrebuilt(this.this$0, rs.getString(index++)));
                    this.v$mview.setUseNoIndex(MaterializedViewBuilder.mav$parseYNBoolean(this.this$0, rs.getString(index++)));
                    this.v$mview.setUsingConstraints(MaterializedViewBuilder.mav$parseUsingConstraints(this.this$0, rs.getString(index++)));
                    this.v$mview.setKeyType(MaterializedViewBuilder.mav$parseKeyType(this.this$0, rs.getString(index++)));
                    this.v$mview.setParallel(MaterializedViewBuilder.mav$parseParallel(this.this$0, rs.getString(index++)));
                    this.v$mview.setCache(MaterializedViewBuilder.mav$parseYNBoolean(this.this$0, rs.getString(index++)));
                    if ("YES".equals(rs.getString(index++))) {
                        this.v$mview.setProperty("PARTITIONED TABLE", (Object)Boolean.TRUE);
                        this.v$mview.setProperty("OracleTablePartitions", (Object)this.this$0.getOracleTablePartitions((Table)this.v$mview));
                    }
                    this.v$mview.setCompression("ENABLED".equals(rs.getString(index++)));
                    timestamp = rs.getTimestamp(index++);
                    date = timestamp == null ? null : new Date(timestamp.getTime());
                    this.v$mview.setNextRefreshDate(date);
                    this.v$mview.setInterval(rs.getString(index++));
                    ArrayList<String> masters = new ArrayList<String>();
                    String master = MaterializedViewBuilder.mav$parseMasterName(this.this$0, rs.getString(index), rs.getString(index + 1));
                    while (master != null) {
                        if (master.length() > 0) {
                            masters.add(master);
                        }
                        String string = master = rs.next() ? MaterializedViewBuilder.mav$parseMasterName(this.this$0, rs.getString(index), rs.getString(index + 1)) : null;
                    }
                    this.v$mview.setMasters(masters.toArray(new String[masters.size()]));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$mview, ex);
            }
        }

        public 1(MaterializedViewBuilder materializedViewBuilder, MaterializedView materializedView, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$mview = materializedView;
            this.this$0 = materializedViewBuilder;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ MaterializedView v$mview;
        private final /* synthetic */ QueryWrapper v$wrap2;
        final /* synthetic */ MaterializedViewBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs);
                    this.v$mview.setProperty("OracleStorageProperties", (Object)osp);
                }
            }
            catch (SQLException ex) {
                this.v$wrap2.throwDBException((DBObject)this.v$mview, ex);
            }
        }

        public 2(MaterializedViewBuilder materializedViewBuilder, MaterializedView materializedView, QueryWrapper queryWrapper) {
            this.v$wrap2 = queryWrapper;
            this.v$mview = materializedView;
            this.this$0 = materializedViewBuilder;
        }
    }

    final class 3
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ MaterializedView v$mview;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ MaterializedViewBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    SQLQuery query = OracleViewBuilder.buildQuery(this.this$0.getDatabase(), this.v$mview.getSchema(), rs.getString(1));
                    this.v$mview.setSQLQuery(query);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException(ex);
            }
        }

        public 3(MaterializedViewBuilder materializedViewBuilder, MaterializedView materializedView, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$mview = materializedView;
            this.this$0 = materializedViewBuilder;
        }
    }

    final class 4
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ MaterializedView v$mview;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ MaterializedViewBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    MaterializedViewBuilder.wa$m_usingIndexIndexName(this.this$0, rs.getString(1));
                    OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs);
                    this.v$mview.setProperty("MatViewIndexStorageProperties", (Object)osp);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$mview, ex);
            }
        }

        public 4(MaterializedViewBuilder materializedViewBuilder, MaterializedView materializedView, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$mview = materializedView;
            this.this$0 = materializedViewBuilder;
        }
    }
}

