/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ora.Oracle10gDDLAlterTable;
import oracle.javatools.db.ora.Oracle9iR2DDLGenerator;
import oracle.javatools.db.ora.RecycledObject;
import oracle.javatools.db.ora.ddlgen.Oracle10gAlterDDLIndex;
import oracle.javatools.db.ora.ddlgen.Oracle10gMatViewDDLGenerator;
import oracle.javatools.util.ModelUtil;

@Deprecated
public class Oracle10gDDLGenerator
extends Oracle9iR2DDLGenerator {
    public static final String PURGE = "PURGE";

    public Oracle10gDDLGenerator(DBObjectProvider db) {
        super(db);
        this.registerAlterDDLGenerator("TABLE", (DDLGenerator)new Oracle10gDDLAlterTable(db, null));
        this.registerAlterDDLGenerator("INDEX", (DDLGenerator)new Oracle10gAlterDDLIndex(db, null));
        this.registerDDLGenerator("RECYCLEBIN", (DDLGenerator)this);
        this.registerDDLGenerator("MATERIALIZED VIEW", (DDLGenerator)new Oracle10gMatViewDDLGenerator(db));
    }

    public Ddl getPurgeDDL(RecycledObject obj) {
        Ddl ddl = new Ddl();
        if (obj == null) {
            StringBuffer buff = new StringBuffer();
            buff.append(PURGE).append(" ");
            buff.append("RECYCLEBIN");
            ddl.put("DROP", buff.toString());
        } else {
            String type = obj.getOriginalType();
            if (ModelUtil.hasLength((String)type)) {
                StringBuffer buff = new StringBuffer();
                buff.append(PURGE).append(" ");
                if (type.equals("TABLE")) {
                    buff.append("TABLE").append(" ");
                    buff.append(this.m_prov.getExternalName(obj.getName()));
                    ddl.put("DROP", buff.toString());
                }
            }
        }
        return ddl;
    }

    public Ddl getUndeleteDDL(SchemaObject[] dbObjects) {
        Ddl undropDdl = new Ddl();
        int i = 0;
        while (i < dbObjects.length) {
            SchemaObject dbObject = dbObjects[i];
            String type = dbObject.getType();
            if ("RECYCLEBIN".equals(type)) {
                undropDdl.append(this.getUndropDDL((RecycledObject)dbObject));
            }
            ++i;
        }
        undropDdl.append(this.generateSpoolCommands());
        return undropDdl;
    }

    public Ddl getUndropDDL(RecycledObject recycled) {
        Ddl ddl = new Ddl();
        if (recycled.canUndrop()) {
            String sysName = recycled.getName();
            String origName = recycled.getOriginalName();
            StringBuffer flashback = new StringBuffer();
            this.addPrompt(flashback, "FLASHBACK", "RECYCLE", origName);
            flashback.append("FLASHBACK").append(" ").append("TABLE").append(" ").append("\"").append(sysName).append("\"").append(" ").append("TO BEFORE DROP");
            ddl.put("FLASHBACK", flashback.toString());
        }
        return ddl;
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        if (dbObject instanceof RecycledObject) {
            return this.getPurgeDDL((RecycledObject)dbObject);
        }
        return super.getDeleteDDL(dbObject, cascade);
    }
}

