/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.DatabaseLinkBuilder;
import oracle.javatools.db.ora.JavaBinaryBuilder;
import oracle.javatools.db.ora.JavaSourceBuilder;
import oracle.javatools.db.ora.MaterializedViewBuilder;
import oracle.javatools.db.ora.MaterializedViewLogBuilder;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleTypesArb;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.OracleConnection;

public class Oracle8i
extends Oracle8 {
    public static final String BUILT_IN_SCHEMA = "OfflineDBConstants.BUILT_IN_SCHEMA";
    private static final String CREATE_PRIV = "CREATE {0}";
    private static final String CREATE_ANY_PRIV = "CREATE ANY {0}";
    private static final String CREATE_PUBLIC_PRIV = "CREATE PUBLIC {0}";
    private static final String ALTER_ANY_PRIV = "ALTER ANY {0}";
    private static final String DROP_ANY_PRIV = "DROP ANY {0}";
    private static final String DROP_PUBLIC_PRIV = "DROP PUBLIC {0}";
    private static final HashMap s_buitInSchemas = new HashMap();
    protected static final String SYS = "SYS";
    protected static final String MDSYS = "MDSYS";
    protected static final String ORDSYS = "ORDSYS";

    Oracle8i(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
        if (conn instanceof OracleConnection) {
            Oracle8i.initOC((OracleConnection)conn);
        }
    }

    public int getOracleDatabaseType() {
        return 2;
    }

    protected void registerBuilders() {
        super.registerBuilders();
        if (this.supportsJava()) {
            this.registerBuilder("JAVA SOURCE", (DBObjectBuilder)new JavaSourceBuilder(this));
            this.registerBuilder("JAVA CLASS", (DBObjectBuilder)new JavaBinaryBuilder(this, "JAVA CLASS"));
            this.registerBuilder("JAVA RESOURCE", (DBObjectBuilder)new JavaBinaryBuilder(this, "JAVA RESOURCE"));
        }
        this.registerBuilder("MATERIALIZED VIEW", (DBObjectBuilder)new MaterializedViewBuilder(this));
        this.registerBuilder("MATERIALIZED VIEW LOG", (DBObjectBuilder)new MaterializedViewLogBuilder(this));
        this.registerBuilder("DATABASE LINK", (DBObjectBuilder)new DatabaseLinkBuilder(this));
    }

    public boolean supportsJava() {
        return true;
    }

    public boolean hasPriviledge(String type, Schema schema, String priv) {
        String dbType = type;
        if ("MATERIALIZED VIEW".equals(type) && this.getOracleDatabaseType() < 5) {
            dbType = "SNAPSHOT";
        } else if ("PACKAGE".equals(type) || "FUNCTION".equals(type)) {
            dbType = "PROCEDURE";
        } else if ("MATERIALIZED VIEW LOG".equals(type)) {
            dbType = "TABLE";
        } else if ("SCHEMA".equals(type)) {
            dbType = "USER";
        }
        if (ModelUtil.areEqual((Object)"CREATE", (Object)priv)) {
            if ("INDEX".equals(type) && (schema == null || ModelUtil.areEqual((Object)this.getCurrentSchema(), (Object)schema))) {
                return true;
            }
            if ("XML SCHEMA".equals(type)) {
                return true;
            }
            Object[] args = new Object[]{dbType};
            boolean can = this.hasPrivilege(MessageFormat.format(CREATE_ANY_PRIV, args));
            if (!can) {
                if (schema == null || ModelUtil.areEqual((Object)this.getCurrentSchema(), (Object)schema)) {
                    can = this.hasPrivilege(MessageFormat.format(CREATE_PRIV, args));
                } else if (schema != null && ModelUtil.areEqual((Object)this.getPublicSchema(), (Object)schema)) {
                    can = this.hasPrivilege(MessageFormat.format(CREATE_PUBLIC_PRIV, args));
                }
            }
            return can;
        }
        if (ModelUtil.areEqual((Object)"MODIFY", (Object)priv)) {
            return ModelUtil.areEqual((Object)this.getCurrentSchema(), (Object)schema) || this.hasPrivilege(MessageFormat.format(ALTER_ANY_PRIV, dbType));
        }
        if (ModelUtil.areEqual((Object)"DELETE", (Object)priv)) {
            if ("SCHEMA".equals(type)) {
                return ModelUtil.areDifferent((Object)schema, (Object)this.getCurrentSchema()) && ModelUtil.areDifferent((Object)schema, (Object)this.getPublicSchema()) && this.hasPrivilege("DROP USER");
            }
            Object[] args = new Object[]{dbType};
            boolean can = true;
            if (!ModelUtil.areEqual((Object)this.getCurrentSchema(), (Object)schema)) {
                can = false;
                if (ModelUtil.areEqual((Object)this.getPublicSchema(), (Object)schema)) {
                    can = this.hasPrivilege(MessageFormat.format(DROP_PUBLIC_PRIV, args));
                }
                if (!can) {
                    can = this.hasPrivilege(MessageFormat.format(DROP_ANY_PRIV, args));
                }
            }
            return can;
        }
        return super.hasPriviledge(type, schema, priv);
    }

    static void initOC(OracleConnection oc) {
        if (oc.getSessionTimeZone() == null) {
            boolean tzSet = false;
            TimeZone tz = TimeZone.getDefault();
            String tzName = tz != null ? tz.getID() : "America/Los_Angeles";
            try {
                oc.setSessionTimeZone(tzName);
                tzSet = true;
            }
            catch (SQLException ex) {
            }
            catch (IllegalArgumentException ex) {
                tzSet = true;
            }
            if (!tzSet) {
                Calendar c = tz != null ? Calendar.getInstance(tz) : Calendar.getInstance();
                int offset = c.get(16) + c.get(15);
                int minutes = offset / 60000;
                String fmt = MessageFormat.format("{0,number,00}:{1,number,00}", new Integer(minutes / 60), new Integer(minutes % 60));
                try {
                    oc.setSessionTimeZone(fmt);
                }
                catch (SQLException ex) {
                    DBLog.log((String)("Error setting Session TimeZone to either " + tzName + " or " + fmt), (Object[])new Object[0]);
                    DBLog.log((String)("  " + ex.getLocalizedMessage()), (Object[])new Object[0]);
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
            }
        }
    }

    static {
        Schema sys = new Schema(SYS);
        Schema mdsys = new Schema(MDSYS);
        Schema ordsys = new Schema(ORDSYS);
        sys.setProperty(BUILT_IN_SCHEMA, (Object)Boolean.TRUE);
        mdsys.setProperty(BUILT_IN_SCHEMA, (Object)Boolean.TRUE);
        ordsys.setProperty(BUILT_IN_SCHEMA, (Object)Boolean.TRUE);
        s_buitInSchemas.put(SYS, sys);
        s_buitInSchemas.put(MDSYS, mdsys);
        s_buitInSchemas.put(ORDSYS, ordsys);
    }

    protected static final void registerComplexType(DataTypeRegistry dtr, Class clz, Schema schema, String name, String spec) {
        ComplexType type = new ComplexType(name, schema);
        type.setSource(spec);
        dtr.registerComplexType(type, clz);
    }

    protected static final Schema getBuiltInSchema(String schemaName) {
        return (Schema)s_buitInSchemas.get(schemaName);
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        private static final String[] CTXSYS_INDEXTYPES = new String[]{"CONTEXT", "CTXCAT", "CTXRULE", "CTXPATH"};
        private static final String[] ORDSYS_INDEXTYPES = new String[]{"ORDIMAGEINDEX"};
        private static final String[] MDSYS_INDEXTYPES = new String[]{"SPATIAL_INDEX", "RTREE_INDEX"};

        public void registerDataTypes(DataTypeRegistry dtr) {
            dtr.registerDataType((DataType)new PredefinedDataType(1, "UROWID", "UROWID[(<size>)]", 1L, 4000L, 4000L, false, null), Oracle8i.class, JdbcDatabase.ANSI_SMALLINT);
        }

        public void registerComplexTypes(DataTypeRegistry dtr) {
            long millis = System.currentTimeMillis();
            Schema mdsys = Oracle8i.getBuiltInSchema(Oracle8i.MDSYS);
            Schema ordsys = Oracle8i.getBuiltInSchema(Oracle8i.ORDSYS);
            Oracle8i.registerComplexType(dtr, Oracle8i.class, mdsys, OracleTypesArb.getString(27), OracleTypesArb.getString(24));
            Oracle8i.registerComplexType(dtr, Oracle8i.class, ordsys, OracleTypesArb.getString(8), OracleTypesArb.getString(6));
            Oracle8i.registerComplexType(dtr, Oracle8i.class, ordsys, OracleTypesArb.getString(1), OracleTypesArb.getString(54));
            Oracle8i.registerComplexType(dtr, Oracle8i.class, ordsys, OracleTypesArb.getString(17), OracleTypesArb.getString(14));
            Oracle8i.registerComplexType(dtr, Oracle8i.class, ordsys, OracleTypesArb.getString(21), OracleTypesArb.getString(18));
            millis = System.currentTimeMillis() - millis;
            DBLog.log((String)"Registering Oracle8i built in complex types {0}ms", (Object[])new Object[]{Long.toString(millis)});
        }

        static {
            OracleDatabaseImpl.registerBuiltInIndextypes(Oracle8i.class, "CTXSYS", CTXSYS_INDEXTYPES);
            OracleDatabaseImpl.registerBuiltInIndextypes(Oracle8i.class, Oracle8i.ORDSYS, ORDSYS_INDEXTYPES);
            OracleDatabaseImpl.registerBuiltInIndextypes(Oracle8i.class, Oracle8i.MDSYS, MDSYS_INDEXTYPES);
        }

        Registerer() {
        }
    }
}

