/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Index;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.diff.DisplayProps;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.OpaqueFormatSpec;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLStorageProperties;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.db.ora.ddlgen.OracleRelationDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleTableDDLGenerator;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class OracleDDLAlterTable
extends OracleTableDDLGenerator {
    static final /* synthetic */ boolean $assertionsDisabled;
    private static final String DEFAULT_PCT_THRESHOLD = "50";

    public OracleDDLAlterTable(DBObjectProvider prov, ResultSet diffs) {
        super(prov);
    }

    @Override
    public Ddl getAlterStatement(SchemaObject schemaObject, ResultSet soDiff) {
        return this.getAlterTable((Table)schemaObject, soDiff);
    }

    protected void addProjectColumnClause(StringBuffer buf, String value) {
    }

    protected String renameColumn(ResultSet columnDiff) {
        return null;
    }

    protected String renameColumn(String oldName, String newName) {
        return null;
    }

    protected String renameConstraint(ResultSet conDiff) {
        return null;
    }

    protected String enableConstraint(ResultSet conDiff) {
        StringBuffer buf = new StringBuffer("MODIFY ");
        this.appendConstraintName(buf, conDiff.getName());
        buf.append(" ");
        if ("true".equals(DisplayProps.getBVal((ResultSet)conDiff.getAllObjectsMap().get("enabled")))) {
            buf.append("ENABLE");
        } else {
            buf.append("DISABLE");
        }
        return buf.toString();
    }

    private Ddl getAlterTable(Table table, ResultSet tableDiff) {
        String tableComment;
        Ddl ddl = new Ddl();
        ArrayList<String> columnChanges = new ArrayList<String>();
        ArrayList<String> columnComments = new ArrayList<String>();
        ArrayList<String> tableComments = new ArrayList<String>();
        HashMap<String, Object> tableAttributes = OracleDDLAlterTable.getAttributes(tableDiff, false);
        if (tableAttributes.containsKey("name")) {
            String name = (String)tableAttributes.get("name");
            StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
            buf.append(this.getSchemaDotName((DBObject)table));
            buf.append(" ").append("RENAME").append(" ").append("TO").append(" ");
            buf.append(this.m_prov.getExternalName(name));
            ddl.put("RENTAB", buf.toString());
        }
        if (this.isCommentDifferent(tableDiff) && ModelUtil.hasLength((String)(tableComment = this.createCommentOn("TABLE", this.getSchemaDotName((DBObject)table), (String)tableAttributes.get("Comment"))))) {
            tableComments.add(tableComment);
        }
        List changedColumns = this.getChanged(tableDiff, "columns");
        HashMap<String, ResultSet> modifyCollectionRetrieval = new HashMap<String, ResultSet>();
        List droppedCols = this.getDropped(tableDiff, "columns");
        List newCols = this.getNew(tableDiff, "columns");
        for (ResultSet columnDiff : changedColumns) {
            String renamebuf = null;
            boolean rename = false;
            Map colMods = columnDiff.getModifiedObjectMap();
            int modCount = colMods.size();
            if (colMods.containsKey("name")) {
                --modCount;
                rename = true;
                renamebuf = this.renameColumn(columnDiff);
            }
            if (colMods.containsKey("Comment")) {
                --modCount;
            }
            if (colMods.containsKey("OracleColumnProperties")) {
                ResultSet returnAsRS;
                --modCount;
                ResultSet oracleColumnProperties = (ResultSet)colMods.get("OracleColumnProperties");
                Map notSame = oracleColumnProperties.getNotSameObjectMap();
                if (notSame.containsKey("nestedTableProperties") && !(returnAsRS = (ResultSet)((ResultSet)notSame.get("nestedTableProperties")).getNotSameObjectMap().get("returnAs")).isSame()) {
                    modifyCollectionRetrieval.put(this.getQuotedName(columnDiff), returnAsRS);
                }
            }
            boolean recreated = false;
            if (rename && renamebuf == null) {
                droppedCols.add(columnDiff);
                newCols.add(columnDiff);
                recreated = true;
            } else if (rename && renamebuf != null) {
                StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
                buf.append(this.getSchemaDotName((DBObject)table));
                buf.append(" \n");
                buf.append(renamebuf).append(" ");
                columnChanges.add(buf.toString());
            }
            if (recreated || modCount <= 0) continue;
            StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
            buf.append(this.getSchemaDotName((DBObject)table));
            buf.append(" \n");
            HashMap<String, Object> columnAttributes = OracleDDLAlterTable.getAttributes(columnDiff, true);
            if (!rename || columnDiff.getModifiedObjectMap().size() > 1) {
                buf.append(this.modifyColumn(columnDiff, columnAttributes));
            }
            columnChanges.add(buf.toString());
        }
        HashSet<String> dropNames = new HashSet<String>();
        boolean renameAvailable = this.renameColumn("old", "new") != null;
        HashSet<String> columnNames = null;
        if (renameAvailable) {
            columnNames = new HashSet<String>(this.getAllNames(tableDiff, "columns"));
            for (Object obj : droppedCols) {
                dropNames.add(((ResultSet)obj).getName());
            }
        }
        HashMap<String, String> dropAndAdd = new HashMap<String, String>();
        for (Object obj : newCols) {
            ResultSet columnDiff = (ResultSet)obj;
            String name = ((ResultSet)obj).getName();
            if (dropNames.contains(name)) {
                String temporaryUniqueName = this.uniqueName(columnNames, name);
                dropAndAdd.put(name, temporaryUniqueName);
                name = temporaryUniqueName;
            }
            HashMap<String, Object> columnAttributes = OracleDDLAlterTable.getAttributes(columnDiff, true);
            StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
            buf.append(this.getSchemaDotName((DBObject)table));
            buf.append(" \n");
            buf.append(this.addColumn(name, columnDiff, columnAttributes));
            columnChanges.add(buf.toString());
        }
        for (Object obj : droppedCols) {
            ResultSet columnDiff = (ResultSet)obj;
            StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
            buf.append(this.getSchemaDotName((DBObject)table));
            buf.append(" \n");
            buf.append(this.dropColumn(columnDiff));
            columnChanges.add(buf.toString());
        }
        for (String name : dropAndAdd.keySet()) {
            String tempName = (String)dropAndAdd.get(name);
            String rename = this.renameColumn(tempName, name);
            if (rename == null) continue;
            StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
            buf.append(this.getSchemaDotName((DBObject)table));
            buf.append(" \n");
            buf.append(rename);
            columnChanges.add(buf.toString());
        }
        if (modifyCollectionRetrieval.size() > 0) {
            columnChanges.add(this.getModifyCollectionRetrieval(table, modifyCollectionRetrieval));
        }
        if (this.hasColumnComments(tableDiff)) {
            List cols = this.getColumns(tableDiff);
            for (ResultSet columnDiff : cols) {
                if (!this.isCommentDifferent(columnDiff) || this.isDropped(columnDiff)) continue;
                HashMap<String, Object> columnAttributes = OracleDDLAlterTable.getAttributes(columnDiff, true);
                columnComments.add(this.createCommentOn("COLUMN", this.getSchemaDotName((DBObject)table) + "." + this.getQuotedName(columnDiff), (String)columnAttributes.get("Comment"), this.isNew(columnDiff) ^ true));
            }
        }
        ddl.put("ACO", columnChanges);
        ddl.put("CMC", columnComments);
        ddl.put("CMT", tableComments);
        ArrayList<String> uniqueConstraintChanges = new ArrayList<String>();
        ArrayList<String> foreignConstraintChanges = new ArrayList<String>();
        ArrayList<String> checkConstraintChanges = new ArrayList<String>();
        List additionalConstraints = this.getNew(tableDiff, "constraints");
        List changedConstraints = this.getChanged(tableDiff, "constraints");
        List droppedConstraints = this.getDropped(tableDiff, "constraints");
        for (ResultSet constraintDiff : changedConstraints) {
            int modcnt = 0;
            String renamebuf = null;
            if (constraintDiff.getModifiedObjectMap().containsKey("name")) {
                renamebuf = this.renameConstraint(constraintDiff);
                ++modcnt;
            }
            String enablebuf = null;
            if (constraintDiff.getModifiedObjectMap().containsKey("enabled")) {
                enablebuf = this.enableConstraint(constraintDiff);
                ++modcnt;
            }
            if ((renamebuf != null || enablebuf != null) && constraintDiff.getModifiedObjectMap().size() == modcnt) {
                int i = 0;
                while (i < modcnt) {
                    StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
                    buf.append(this.getSchemaDotName((DBObject)table));
                    buf.append(" \n");
                    if (i == 0 && renamebuf != null) {
                        buf.append(renamebuf);
                    } else {
                        buf.append(enablebuf);
                    }
                    String constraintType = this.getConstraintType(constraintDiff);
                    if (constraintType.equals("FKConstraint")) {
                        foreignConstraintChanges.add(buf.toString());
                    } else if (constraintType.equals("CheckConstraint")) {
                        checkConstraintChanges.add(buf.toString());
                    } else {
                        uniqueConstraintChanges.add(buf.toString());
                    }
                    ++i;
                }
                continue;
            }
            droppedConstraints.add(constraintDiff);
            additionalConstraints.add(constraintDiff);
        }
        for (ResultSet constraintDiff : droppedConstraints) {
            StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
            buf.append(this.getSchemaDotName((DBObject)table));
            buf.append(" \n");
            buf.append(this.dropConstraint(constraintDiff));
            String constraintType = this.getConstraintType(constraintDiff);
            if (constraintType.equals("FKConstraint")) {
                foreignConstraintChanges.add(buf.toString());
                continue;
            }
            if (constraintType.equals("CheckConstraint")) {
                checkConstraintChanges.add(buf.toString());
                continue;
            }
            uniqueConstraintChanges.add(buf.toString());
        }
        for (ResultSet constraintDiff : additionalConstraints) {
            StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
            buf.append(this.getSchemaDotName((DBObject)table));
            buf.append(" \n");
            buf.append(this.addConstraint((Relation)table, constraintDiff));
            String constraintType = this.getConstraintType(constraintDiff);
            if (constraintType.equals("FKConstraint")) {
                foreignConstraintChanges.add(buf.toString());
                continue;
            }
            if (constraintType.equals("CheckConstraint")) {
                checkConstraintChanges.add(buf.toString());
                continue;
            }
            uniqueConstraintChanges.add(buf.toString());
        }
        ddl.put("CONUK", uniqueConstraintChanges);
        ddl.put("CONFK", foreignConstraintChanges);
        ddl.put("CONCC", checkConstraintChanges);
        List changedIndexes = this.getChanged(tableDiff, "indexes");
        List droppedIndexes = this.getDropped(tableDiff, "indexes");
        List addedIndexes = this.getNew(tableDiff, "indexes");
        OracleBaseGenerator alterIndexGen = null;
        if (changedIndexes.size() > 0) {
            alterIndexGen = (OracleBaseGenerator)this.getAlterDDLGenerator("INDEX");
        }
        ArrayList<String> indexChanges = new ArrayList<String>();
        for (ResultSet indexDiff : changedIndexes) {
            int alter;
            int n = alter = alterIndexGen == null ? 2 : alterIndexGen.getUpdateAction(indexDiff);
            if (alter == 2) {
                droppedIndexes.add(indexDiff);
                addedIndexes.add(indexDiff);
                continue;
            }
            Index index = (Index)indexDiff.a();
            Ddl change = alterIndexGen.getAlterStatement((SchemaObject)index, indexDiff);
            indexChanges.addAll(change.getArrayList("IND"));
        }
        ArrayList<String> indexDrops = new ArrayList<String>();
        for (ResultSet indexDiff : droppedIndexes) {
            Index index = (Index)indexDiff.a();
            Ddl drop = this.m_indexGen.getDeleteDDL((SchemaObject)index, false);
            indexDrops.add(drop.get("DROP"));
        }
        for (ResultSet indexDiff : addedIndexes) {
            Index index = (Index)indexDiff.b();
            Ddl create = this.m_indexGen.getCreateDDL((SchemaObject)index, false, false);
            indexChanges.add(create.get("IND"));
        }
        ddl.put("DROP", indexDrops);
        ddl.put("IND", indexChanges);
        ArrayList<String> tabDDL = new ArrayList<String>();
        if (tableAttributes.containsKey("compression")) {
            StringBuffer sb = new StringBuffer();
            sb.append(OracleRelationDDLGenerator.ALTER_TABLE).append(this.getSchemaDotName((DBObject)table)).append(" ");
            String val = (String)tableAttributes.get("compression");
            if ("true".equals(val)) {
                sb.append("COMPRESS");
            } else {
                sb.append("NOCOMPRESS");
            }
            tabDDL.add(sb.toString());
        }
        if (tableAttributes.containsKey("parallel")) {
            StringBuffer sb = new StringBuffer();
            sb.append(OracleRelationDDLGenerator.ALTER_TABLE).append(this.getSchemaDotName((DBObject)table)).append(" ");
            String val = (String)tableAttributes.get("parallel");
            if ("1".equals(val)) {
                val = null;
            }
            if (val == null) {
                sb.append("NOPARALLEL");
            } else {
                sb.append("PARALLEL");
                if (!"0".equals(val)) {
                    sb.append(" ").append(val);
                }
            }
            tabDDL.add(sb.toString());
        }
        ResultSet ospRS = (ResultSet)tableDiff.getAllObjectsMap().get("OracleStorageProperties");
        StringBuffer alterContext = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE).append(this.getSchemaDotName((DBObject)table));
        tabDDL.addAll(OracleAlterDDLStorageProperties.getAlterStorageProperties(ospRS, this.m_prov, (SchemaObject)table, alterContext.toString()));
        if (tabDDL.size() > 0) {
            ddl.put("TAB", tabDDL);
        }
        this.alterExternalTableProperties(ddl, table, tableDiff);
        if (table.getProperty("TableType") == Table.TableType.INDEX_ORGANIZED) {
            this.alterIndexOrganizedTableProperties(ddl, table, tableDiff);
        }
        this.alterOracleTablePartitions(ddl, table, tableDiff);
        this.alterColumnProperties(ddl, table, tableDiff);
        return ddl;
    }

    private String getModifyCollectionRetrieval(Table table, Map<String, ResultSet> mcrs) {
        StringBuffer result = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
        result.append(this.getSchemaDotName((DBObject)table));
        for (String colName : mcrs.keySet()) {
            ResultSet returnAsRS = mcrs.get(colName);
            String returnAS = DisplayProps.getBVal(returnAsRS);
            result.append("\n").append("  ").append("MODIFY").append(" ").append("NESTED TABLE").append(" ").append(colName).append(" ").append("RETURN").append(" ").append("AS").append(" ").append(returnAS);
        }
        return result.toString();
    }

    private void alterIndexOrganizedTableProperties(Ddl ddl, Table table, ResultSet tableDiff) {
        ResultSet iotRS = (ResultSet)tableDiff.getAllObjectsMap().get("OracleIndexOrganizedTableProperties");
        if (iotRS != null) {
            ResultSet rs;
            ResultSet rs2;
            StringBuffer alterTable = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE).append(this.getSchemaDotName((DBObject)table));
            Map changedProperties = iotRS.getNotSameObjectMap();
            ArrayList<String> alterStatements = new ArrayList<String>();
            if (changedProperties.containsKey("overflowable") && "true".equals(DisplayProps.getBVal(rs2 = (ResultSet)changedProperties.get("overflowable")))) {
                StringBuffer buf = new StringBuffer(alterTable).append(" ").append("ADD").append(" ").append("OVERFLOW");
                alterStatements.add(buf.toString());
            }
            if (changedProperties.containsKey("overflowProperties") && (rs = (ResultSet)changedProperties.get("overflowProperties")) != null) {
                StringBuffer alterClauses = new StringBuffer();
                StringBuffer moveClauses = new StringBuffer();
                Map overflowPropertiesMap = rs.getNotSameObjectMap();
                if (overflowPropertiesMap != null && overflowPropertiesMap.size() > 0) {
                    OracleAlterDDLStorageProperties.getSegmentAttributeClauses(overflowPropertiesMap, alterClauses, moveClauses, (SchemaObject)table, true, this.m_prov);
                }
                if (alterClauses.length() > 0) {
                    StringBuffer buf = new StringBuffer(alterTable).append(" ").append("OVERFLOW").append(alterClauses);
                    alterStatements.add(buf.toString());
                }
                if (moveClauses.length() > 0) {
                    StringBuffer buf = new StringBuffer(alterTable).append(" ").append("MOVE").append(" ").append("OVERFLOW").append(moveClauses);
                    alterStatements.add(buf.toString());
                }
            }
            if (changedProperties.containsKey("pctThreshold") || changedProperties.containsKey("includeColumn")) {
                DBObjectID colID;
                String colName;
                StringBuffer buf = new StringBuffer(alterTable);
                ResultSet rs3 = (ResultSet)changedProperties.get("pctThreshold");
                if (rs3 != null) {
                    String pctThreshold = ModelUtil.hasLength((String)DisplayProps.getBVal(rs3)) ? DisplayProps.getBVal(rs3) : DEFAULT_PCT_THRESHOLD;
                    buf.append(" ").append("PCTTHRESHOLD").append(" ").append(pctThreshold);
                }
                if ((rs3 = (ResultSet)changedProperties.get("includeColumn")) != null && ModelUtil.hasLength((String)(colName = DBUtil.getDBObjectName((DBObjectID)(colID = (DBObjectID)rs3.b()))))) {
                    buf.append(" ").append("INCLUDING").append(" ").append(colName);
                }
                if (buf.length() != alterTable.length()) {
                    alterStatements.add(buf.toString());
                }
            }
            if (changedProperties.containsKey("mapped") || changedProperties.containsKey("keyCompression")) {
                StringBuffer buf = new StringBuffer(alterTable).append(" ").append("MOVE");
                int initLength = buf.length();
                ResultSet rs4 = (ResultSet)changedProperties.get("mapped");
                if (rs4 != null) {
                    if ("false".equals(DisplayProps.getBVal(rs4))) {
                        buf.append(" ").append("NO").append("MAPPING");
                    } else {
                        buf.append(" ").append("MAPPING").append(" ").append("TABLE");
                    }
                }
                if ((rs4 = (ResultSet)changedProperties.get("keyCompression")) != null && ModelUtil.hasLength((String)DisplayProps.getBVal(rs4))) {
                    buf.append(" ").append(DisplayProps.getBVal(rs4));
                }
                if (buf.length() != initLength) {
                    alterStatements.add(buf.toString());
                }
            }
            if (alterStatements.size() > 0) {
                ddl.put("IOT", alterStatements);
            }
        }
    }

    static {
        $assertionsDisabled = OracleDDLAlterTable.class.desiredAssertionStatus() ^ true;
    }

    private void alterExternalTableProperties(Ddl ddl, Table table, ResultSet tableDiff) {
        ResultSet oetpRS = (ResultSet)tableDiff.getAllObjectsMap().get("OracleExternalTableProperties");
        if (oetpRS != null) {
            StringBuffer buf = new StringBuffer();
            Map changedProperties = oetpRS.getModifiedObjectMap();
            ResultSet rs = (ResultSet)changedProperties.get("rejectLimit");
            if (rs != null) {
                String rejectLimit = DisplayProps.getBVal(rs);
                buf.append("REJECT LIMIT").append(" ").append(rejectLimit).append(" \n");
            }
            if ((rs = (ResultSet)changedProperties.get("projectColumn")) != null) {
                this.addProjectColumnClause(buf, DisplayProps.getBVal(rs));
            }
            ResultSet resultSet = rs = (rs = (ResultSet)changedProperties.get("accessParameters")) != null ? rs : (ResultSet)changedProperties.get("accessUsingClob");
            if (rs != null) {
                OracleExternalTableProperties props = (OracleExternalTableProperties)rs.b();
                if (!$assertionsDisabled && props == null) {
                    throw new AssertionError();
                }
                if (props != null) {
                    Object accessParameters = props.getAccessParameters();
                    if (accessParameters != null) {
                        buf.append("ACCESS PARAMETERS");
                        if (props.isAccessUsingClob()) {
                            buf.append(" ").append("USING").append(" ").append("CLOB");
                        }
                        String val = null;
                        if (accessParameters instanceof SQLQuery) {
                            SQLQuery subquery = (SQLQuery)accessParameters;
                            val = subquery.getSQLText();
                        } else if (accessParameters instanceof OpaqueFormatSpec) {
                            OpaqueFormatSpec spec = (OpaqueFormatSpec)accessParameters;
                            val = spec.getSpec();
                        } else {
                            val = accessParameters.toString();
                        }
                        buf.append(" \n").append("(").append(" \n").append("  ").append(val).append(" \n").append(")").append(" \n");
                    } else {
                        buf.append("ACCESS PARAMETERS").append("(").append(")").append(" \n");
                    }
                }
            }
            if ((rs = (ResultSet)changedProperties.get("defaultDirectory")) != null) {
                String dirName;
                OracleExternalTableProperties props = (OracleExternalTableProperties)rs.b();
                if (!$assertionsDisabled && props == null) {
                    throw new AssertionError();
                }
                if (props != null && ModelUtil.hasLength((String)(dirName = DBUtil.getDBObjectName((DBObjectID)props.getDefaultDirectory())))) {
                    buf.append("DEFAULT").append(" ").append("DIRECTORY").append(" ").append(this.m_prov.getExternalName(dirName)).append(" \n");
                }
            }
            if ((rs = (ResultSet)changedProperties.get("locationSpecifiers")) != null) {
                List locationSpecifiers = (List)rs.b();
                boolean first = true;
                StringBuffer location = new StringBuffer("LOCATION").append("(");
                for (OracleExternalTableProperties.LocationSpecifier locSpec : locationSpecifiers) {
                    String loc;
                    if (locSpec == null) continue;
                    String string = loc = locSpec.getSpecifier() != null ? locSpec.getSpecifier() : "";
                    if (!first) {
                        location.append(",").append(" ");
                    }
                    first = false;
                    String dirName = DBUtil.getDBObjectName((DBObjectID)locSpec.getDirectory());
                    if (ModelUtil.hasLength((String)dirName)) {
                        location.append(this.m_prov.getExternalName(dirName)).append(":");
                    }
                    location.append("'").append(loc).append("'");
                }
                location.append(")").append(" \n");
                buf.append(location);
            }
            if (buf.length() > 0) {
                StringBuffer alterTable = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
                alterTable.append(this.getSchemaDotName((DBObject)table)).append(" \n").append(buf);
                ddl.put("OET", alterTable.toString());
            }
        }
    }

    private String getDataTypeDDL(HashMap columnAttributes) {
        return (String)columnAttributes.get("dataTypeUsage");
    }

    private String addColumn(ResultSet columnDiff, HashMap columnAttributes) {
        String name = columnDiff.getName();
        return this.addColumn(name, columnDiff, columnAttributes);
    }

    private String addColumn(String name, ResultSet columnDiff, HashMap columnAttributes) {
        StringBuffer buf = new StringBuffer();
        buf.append("ADD (");
        buf.append("\"" + name + "\"" + " ");
        buf.append(this.getDataTypeDDL(columnAttributes));
        if (columnAttributes.containsKey("default")) {
            buf.append(this.getDefault(columnDiff, (String)columnAttributes.get("default")));
        }
        if (columnAttributes.containsKey("notNull") && columnAttributes.get("notNull").equals("true")) {
            buf.append(" NOT NULL");
        }
        buf.append(")\n");
        String collType = "";
        DataTypeUsage dtu = ((Column)columnDiff.b()).getDataTypeUsage();
        if (dtu instanceof ObjectTypeUsage) {
            ComplexType typ = null;
            try {
                typ = (ComplexType)dtu.getDataTypeID().resolveID();
            }
            catch (DBException e) {
                // empty catch block
            }
            if (typ != null) {
                collType = typ.getCollectionType();
            }
        }
        if ("BLOB".equalsIgnoreCase(this.getDataTypeDDL(columnAttributes)) || "CLOB".equalsIgnoreCase(this.getDataTypeDDL(columnAttributes)) || "NCLOB".equalsIgnoreCase(this.getDataTypeDDL(columnAttributes)) || "VARYING ARRAY".equalsIgnoreCase(collType)) {
            LOBDescriptor ld = LOBDescriptor.findLOBDescriptorForColumn((Column)((Column)columnDiff.b()));
            if (ld != null) {
                buf.append(this.createLOBDescriptor(ld, (Column)columnDiff.b()));
            }
        } else {
            OracleNestedTableProperties ntp;
            OracleColumnProperties ocp = (OracleColumnProperties)((Column)columnDiff.b()).getProperty("OracleColumnProperties");
            if (ocp != null && (ntp = ocp.getNestedTableProperties()) != null) {
                buf.append("    ").append("NESTED TABLE").append(" ").append("\"" + columnDiff.getName() + "\"");
                buf.append(" ").append("STORE").append(" ").append("AS");
                buf.append(" ").append(this.m_prov.getExternalName(ntp.getTableName()));
                buf.append(" ").append("RETURN").append(" ").append("AS");
                buf.append(" ").append(ntp.getReturnAs());
                buf.append("\n");
            }
        }
        return buf.toString();
    }

    private String getQuotedName(ResultSet rs) {
        return "\"" + rs.getName() + "\"";
    }

    protected String getQuotedOnlineName(ResultSet colOrConDiff) {
        Map allObjectMap = colOrConDiff.getAllObjectsMap();
        ResultSet nameRS = (ResultSet)allObjectMap.get("name");
        String droppedConstraintName = DisplayProps.getAVal(nameRS);
        return "\"" + droppedConstraintName + "\"";
    }

    private String modifyColumn(ResultSet columnDiff, HashMap columnAttributes) {
        StringBuffer buf = new StringBuffer();
        if (columnDiff.isModified()) {
            Map colChanges = columnDiff.getModifiedObjectMap();
            buf.append("MODIFY").append(" ").append("(");
            buf.append(this.getQuotedName(columnDiff));
            if (colChanges.containsKey("dataTypeUsage")) {
                buf.append(" ");
                buf.append(this.getDataTypeDDL(columnAttributes));
            }
            if (colChanges.containsKey("default")) {
                buf.append(this.getDefault(columnDiff, (String)columnAttributes.get("default")));
            }
            if (colChanges.containsKey("notNull") && columnAttributes.containsKey("notNull")) {
                if (Boolean.toString(true).equals(columnAttributes.get("notNull"))) {
                    buf.append(" ").append("NOT");
                }
                buf.append(" ").append("NULL");
            }
            buf.append(")").append("\n");
        }
        return buf.toString();
    }

    private String getDefault(ResultSet columnDiff, String def) {
        StringBuffer buf = new StringBuffer();
        ResultSet defrs = (ResultSet)columnDiff.getAllObjectsMap().get("default");
        if (ModelUtil.hasLength((String)def)) {
            ResultSet dturs = (ResultSet)columnDiff.getAllObjectsMap().get("dataTypeUsage");
            buf.append(" ").append("DEFAULT").append(" ").append(def);
        } else if (ModelUtil.hasLength((String)DisplayProps.getAVal(defrs))) {
            buf.append(" ").append("DEFAULT").append(" ").append("NULL");
        }
        return buf.toString();
    }

    private String dropColumn(ResultSet columnDiff) {
        StringBuffer buf = new StringBuffer();
        buf.append("DROP COLUMN ");
        buf.append(this.getQuotedOnlineName(columnDiff));
        buf.append("\n");
        return buf.toString();
    }

    private String addConstraint(Relation table, ResultSet constraintDiff) {
        StringBuffer buf = new StringBuffer();
        HashMap<String, Object> constraintDiffs = OracleDDLAlterTable.getAttributes(constraintDiff, true);
        buf.append("ADD ");
        this.appendConstraintName(buf, constraintDiff.getName());
        buf.append(this.getConsTypeText(constraintDiff) + " ");
        String constraintType = this.getConstraintType(constraintDiff);
        if (constraintType.equals("CheckConstraint")) {
            buf.append("\n").append("(").append("\n");
            String cc = (String)constraintDiffs.get("checkCondition");
            cc = cc.trim().replace('\n', ' ');
            buf.append(cc);
            buf.append("\n").append(")");
        } else {
            buf.append(this.getColumnList(constraintDiff, "columns"));
            if (constraintType.equals("FKConstraint")) {
                int deleteMode;
                String referencedSchema = (String)constraintDiffs.get("ReferencedSchema");
                String referencedTable = (String)constraintDiffs.get("ReferencedRelation");
                if (ModelUtil.hasLength((String)referencedTable)) {
                    buf.append(" REFERENCES ");
                    if (ModelUtil.hasLength((String)referencedSchema)) {
                        buf.append(this.m_prov.getExternalName(referencedSchema));
                        buf.append(".");
                    }
                    buf.append(this.m_prov.getExternalName(referencedTable));
                    buf.append(" ");
                    buf.append(this.getColumnList(constraintDiff, "ReferencedColumn"));
                }
                if ((deleteMode = Integer.parseInt((String)constraintDiffs.get("deleteMode"))) == 1) {
                    buf.append("\n").append("ON").append(" ").append("DELETE").append(" ").append("CASCADE");
                } else if (deleteMode == 2) {
                    buf.append("\n").append("ON").append(" ").append("DELETE").append(" ").append("SET").append(" ").append("NULL");
                }
            }
        }
        if (constraintDiffs.containsKey("enabled")) {
            boolean enabled = "true".equals(constraintDiffs.get("enabled"));
            buf.append(" ");
            buf.append(enabled ? "ENABLE" : "DISABLE");
        }
        buf.append("\n");
        return buf.toString();
    }

    private String dropConstraint(ResultSet constraintDiff) {
        StringBuffer buf = new StringBuffer();
        buf.append("DROP CONSTRAINT ");
        buf.append(this.getQuotedOnlineName(constraintDiff));
        buf.append("\n");
        return buf.toString();
    }

    private String getColumnList(ResultSet constraintDiff, String tagName) {
        StringBuffer buf = new StringBuffer("\n(\n");
        ResultSet cols = (ResultSet)constraintDiff.getAllObjectsMap().get(tagName);
        HashMap<String, String> keyCols = new HashMap<String, String>();
        Iterator ci = cols.getBList().iterator();
        int position = 0;
        while (ci.hasNext()) {
            ResultSet col = (ResultSet)ci.next();
            String name = col.getName();
            Object b = col.b();
            if (b instanceof String) {
                name = (String)b;
            }
            keyCols.put(String.valueOf(position), name);
            ++position;
        }
        int i = 0;
        while (keyCols.containsKey(String.valueOf(i))) {
            if (i > 0) {
                buf.append(",").append("\n");
            }
            buf.append("\"").append((String)keyCols.get(String.valueOf(i))).append("\"");
            ++i;
        }
        buf.append("\n").append(")");
        return buf.toString();
    }

    private String getConsTypeText(ResultSet rs) {
        String nodeType;
        String result = null;
        Constraint con = (Constraint)rs.a();
        if (con == null) {
            con = (Constraint)rs.b();
        }
        if ((nodeType = con.getConstraintType()).equals("CheckConstraint")) {
            result = "CHECK";
        } else if (nodeType.equals("FKConstraint")) {
            result = "FOREIGN KEY";
        } else if (nodeType.equals("PKConstraint")) {
            result = "PRIMARY KEY";
        } else if (nodeType.equals("UniqueConstraint")) {
            result = "UNIQUE";
        }
        return result;
    }

    private List getDropped(ResultSet tableDiff, String listType) {
        Map tableMap;
        ResultSet list;
        List result = new ArrayList();
        if (this.getNodeType(tableDiff).equals("TABLE") && (list = (ResultSet)(tableMap = tableDiff.getAllObjectsMap()).get(listType)) != null) {
            result = list.getAonlyList();
        }
        return result;
    }

    private boolean isNew(ResultSet r) {
        return r.inBbutNotA();
    }

    private boolean isDropped(ResultSet r) {
        return r.inAbutNotB();
    }

    private boolean hasDroppedColumns(ResultSet tableDiff) {
        boolean result = this.getDropped(tableDiff, "columns").size() > 0;
        return result;
    }

    private boolean hasDroppedConstraints(ResultSet tableDiff) {
        boolean result = this.getDropped(tableDiff, "constraints").size() > 0;
        return result;
    }

    private List getNew(ResultSet tableDiff, String listType) {
        Map tableAttrs;
        ResultSet list;
        List result = new ArrayList();
        if (tableDiff.a() instanceof Table && (list = (ResultSet)(tableAttrs = tableDiff.getAllObjectsMap()).get(listType)) != null) {
            result = list.getBonlyList();
        }
        return result;
    }

    private boolean hasAdditionalX(ResultSet tableDiff, String listType) {
        boolean result = this.getNew(tableDiff, listType).size() > 0;
        return result;
    }

    private boolean hasAdditionalColumns(ResultSet tableDiff) {
        return this.hasAdditionalX(tableDiff, "columns");
    }

    private boolean hasAdditionalConstraints(ResultSet tableDiff) {
        return this.hasAdditionalX(tableDiff, "constraints");
    }

    private boolean hasColumnComments(ResultSet tableDiff) {
        ResultSet cols;
        boolean result = false;
        if (tableDiff.a() instanceof Table && (cols = (ResultSet)tableDiff.getAllObjectsMap().get("columns")) != null) {
            for (ResultSet col : cols.getAllObjectsList()) {
                if (!this.isCommentDifferent(col)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private List<String> getAllNames(ResultSet tableDiff, String listType) {
        ResultSet list;
        ArrayList<String> result = new ArrayList<String>();
        if (tableDiff.a() instanceof Table && (list = (ResultSet)tableDiff.getAllObjectsMap().get(listType)) != null) {
            for (ResultSet rs : list.getAllObjectsList()) {
                result.add(rs.getName());
            }
        }
        return result;
    }

    private List getChanged(ResultSet tableDiff, String listType) {
        ResultSet list;
        List result = new ArrayList();
        if (tableDiff.a() instanceof Table && (list = (ResultSet)tableDiff.getAllObjectsMap().get(listType)) != null) {
            result = list.getModifiedObjectList();
        }
        return result;
    }

    private boolean hasChangedColumn(ResultSet tableDiff) {
        boolean result = this.getChanged(tableDiff, "columns").size() > 0;
        return result;
    }

    private boolean isCommentDifferent(ResultSet diff) {
        boolean result = false;
        Map attrs = diff.getNotSameObjectMap();
        if (attrs.containsKey("Comment")) {
            result = true;
        }
        return result;
    }

    private List getConstraints(ResultSet tableDiff) {
        ResultSet cons = (ResultSet)tableDiff.getAllObjectsMap().get("constraints");
        return cons.getAllObjectsList();
    }

    private List getColumns(ResultSet tableDiff) {
        ResultSet cols = (ResultSet)tableDiff.getAllObjectsMap().get("columns");
        return cols.getAllObjectsList();
    }

    private String getConstraintType(ResultSet rm) {
        Constraint c = null;
        if (rm.a() != null && rm.a() instanceof Constraint) {
            c = (Constraint)rm.a();
        } else if (rm.b() != null && rm.b() instanceof Constraint) {
            c = (Constraint)rm.b();
        }
        if (!$assertionsDisabled && c == null) {
            throw new AssertionError();
        }
        return c.getConstraintType();
    }

    private String getNodeType(ResultSet node) {
        int dot;
        Object o = node.a();
        if (o == null) {
            o = node.b();
        }
        String nodeType = null;
        if (o instanceof DBObject) {
            nodeType = ((DBObject)o).getType();
        }
        if ((dot = nodeType.lastIndexOf(".")) > -1) {
            nodeType = nodeType.substring(dot + 1);
        }
        return nodeType;
    }

    private void alterColumnProperties(Ddl ddl, Table table, ResultSet tableDiff) {
        ArrayList<String> alterStatements = new ArrayList<String>();
        ResultSet rs = (ResultSet)tableDiff.getModifiedObjectMap().get("columns");
        if (rs != null) {
            ArrayList changedColList = (ArrayList)rs.getModifiedObjectList();
            int i = 0;
            while (i < changedColList.size()) {
                ResultSet colRS = (ResultSet)changedColList.get(i);
                ResultSet colPropRS = (ResultSet)colRS.getAllObjectsMap().get("OracleColumnProperties");
                if (colPropRS != null) {
                    ResultSet colLOBPropRS = (ResultSet)colPropRS.getAllObjectsMap().get("LOBProperties");
                    if (colLOBPropRS == null) {
                        colLOBPropRS = (ResultSet)colPropRS.getAllObjectsMap().get("VAProperties");
                    }
                    ResultSet colNTPropRS = (ResultSet)colPropRS.getAllObjectsMap().get("OracleNestedTableProperties");
                    if (colLOBPropRS != null) {
                        Map mapLD = colLOBPropRS.getAllObjectsMap();
                        LOBDescriptor newLD = (LOBDescriptor)colLOBPropRS.b();
                        if (newLD != null) {
                            Column theColumn = (Column)colRS.b();
                            if (mapLD.containsKey("LOBSegName") || mapLD.containsKey("storageEnabledInRow") || mapLD.containsKey("chunk") || mapLD.containsKey("storage") && ((ResultSet)mapLD.get("storage")).getNotSameObjectMap().containsKey("tablespace")) {
                                StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
                                buf.append(this.getSchemaDotName((DBObject)table)).append(" ").append("MOVE").append("\n").append(this.createLOBDescriptor(newLD, theColumn));
                                alterStatements.add(buf.toString());
                            } else {
                                String colType;
                                String colName = this.m_prov.getExternalName(theColumn.getName());
                                boolean isLOB = LOBDescriptor.isLOBColumn((DBObjectID)theColumn.getID());
                                String string = colType = isLOB ? "LOB" : "VARRAY";
                                if (isLOB) {
                                    colName = "(" + colName + ")";
                                }
                                StringBuffer buf = new StringBuffer(OracleRelationDDLGenerator.ALTER_TABLE);
                                buf.append(this.getSchemaDotName((DBObject)table));
                                buf.append(" ").append("MODIFY").append("\n").append("    ").append(colType).append(" ").append(colName).append("\n").append("    ").append("(");
                                if (mapLD.containsKey("pctVersion") && DisplayProps.getBVal((ResultSet)mapLD.get("pctVersion")) != null) {
                                    buf.append("\n").append("      ").append("PCTVERSION").append(" ").append(DisplayProps.getBVal((ResultSet)mapLD.get("pctVersion")));
                                }
                                if (mapLD.containsKey("retention") && DisplayProps.getBVal((ResultSet)mapLD.get("retention")) != null) {
                                    buf.append("\n").append("      ").append("RETENTION");
                                }
                                if (mapLD.containsKey("freepools") && DisplayProps.getBVal((ResultSet)mapLD.get("freepools")) != null) {
                                    buf.append("\n").append("      ").append("FREEPOOLS").append(" ").append(DisplayProps.getBVal((ResultSet)mapLD.get("freepools")));
                                }
                                Boolean changedLogging = null;
                                if (mapLD.containsKey("storage") && ((ResultSet)mapLD.get("storage")).getNotSameObjectMap().containsKey("logging")) {
                                    changedLogging = newLD.getStorage().getLogging();
                                }
                                if (mapLD.containsKey("cache") || changedLogging != null) {
                                    buf.append("\n").append("      ").append(newLD.getCache());
                                    if (changedLogging != null) {
                                        buf.append(" ").append(changedLogging != false ? "LOGGING" : "NOLOGGING");
                                    }
                                }
                                if (mapLD.containsKey("storage")) {
                                    OracleStorageProperties osp = newLD.getStorage();
                                    Map changedStorageMap = ((ResultSet)mapLD.get("storage")).getNotSameObjectMap();
                                    this.UpdateOracleStorageClause(osp, changedStorageMap, buf);
                                }
                                buf.append("\n").append("    ").append(")");
                                alterStatements.add(buf.toString());
                            }
                            ddl.put("LOBP", alterStatements);
                        }
                    }
                    if (colNTPropRS != null) {
                        // empty if block
                    }
                }
                ++i;
            }
        }
    }

    private void UpdateOracleStorageClause(OracleStorageProperties osp, Map changedStorageMap, StringBuffer ddl) {
        OracleStorageProperties.BufferModes bufferpool;
        Integer freelistgroups;
        Integer freelists;
        Integer pctincrease;
        Integer maxextents;
        Integer minextents;
        StringBuffer buf = new StringBuffer();
        Integer next = osp.getNextExtent();
        if (next != null && changedStorageMap.containsKey("nextExtent")) {
            buf.append("        ").append("NEXT").append(" ").append(OracleDDLAlterTable.integerAsKorM(next)).append("\n");
        }
        if ((minextents = osp.getMinExtent()) != null && changedStorageMap.containsKey("minExtent")) {
            buf.append("        ").append("MINEXTENTS").append(" ").append(minextents.toString()).append("\n");
        }
        if ((maxextents = osp.getMaxExtent()) != null && changedStorageMap.containsKey("maxExtent")) {
            buf.append("        ").append("MAXEXTENTS").append(" " + (maxextents == Integer.MAX_VALUE ? "UNLIMITED" : maxextents.toString())).append("\n");
        }
        if ((pctincrease = osp.getPercentIncrease()) != null && changedStorageMap.containsKey("percentIncrease")) {
            buf.append("        ").append("PCTINCREASE").append(" ").append(pctincrease.toString()).append("\n");
        }
        if ((freelists = osp.getFreelists()) != null && changedStorageMap.containsKey("freelists")) {
            buf.append("        ").append("FREELISTS").append(" ").append(freelists.toString()).append("\n");
        }
        if ((freelistgroups = osp.getFreelistGroups()) != null && changedStorageMap.containsKey("freelistGroups")) {
            buf.append("        ").append("FREELIST").append(" ").append("GROUPS").append(" ").append(freelistgroups.toString()).append("\n");
        }
        if ((bufferpool = osp.getBufferMode()) != null && changedStorageMap.containsKey("bufferMode")) {
            buf.append("        ").append("BUFFER_POOL").append(" ").append(bufferpool).append("\n");
        }
        if (buf.length() > 0) {
            ddl.append("\n").append("      ").append("STORAGE").append("\n").append("      ").append("(").append("\n").append(buf).append("      ").append(")");
        }
    }

    private String uniqueName(HashSet existingNames, String base) {
        String result = base;
        int suffix = 0;
        while (existingNames.contains(result)) {
            result = base + ++suffix;
        }
        existingNames.add(result);
        return result;
    }
}

