/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import java.util.Arrays;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DDLGenerator;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.ReconcileHelper;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.ora.OracleDDLAlterTable;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLIndex;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLMatView;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLMatViewLog;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLSequence;
import oracle.javatools.db.ora.ddlgen.OracleAlterDDLTrigger;
import oracle.javatools.db.ora.ddlgen.OracleBaseGenerator;
import oracle.javatools.db.ora.ddlgen.OracleDBLinkDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleIndexDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleMatViewDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleMatViewLogDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleSequenceDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleSourceDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleSynonymDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleTableDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleTriggerDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleTypeDDLGenerator;
import oracle.javatools.db.ora.ddlgen.OracleViewDDLGenerator;

@Deprecated
public class OracleDDLGenerator
extends OracleBaseGenerator {
    public OracleDDLGenerator(DBObjectProvider prov) {
        super(prov);
        this.registerDDLGenerator("DATABASE LINK", (DDLGenerator)new OracleDBLinkDDLGenerator(prov));
        this.registerDDLGenerator("INDEX", (DDLGenerator)new OracleIndexDDLGenerator(prov));
        this.registerDDLGenerator("MATERIALIZED VIEW", (DDLGenerator)new OracleMatViewDDLGenerator(prov));
        this.registerDDLGenerator("MATERIALIZED VIEW LOG", (DDLGenerator)new OracleMatViewLogDDLGenerator(prov));
        this.registerDDLGenerator("SEQUENCE", (DDLGenerator)new OracleSequenceDDLGenerator(prov));
        this.registerDDLGenerator("SYNONYM", (DDLGenerator)new OracleSynonymDDLGenerator(prov));
        this.registerDDLGenerator("TABLE", (DDLGenerator)new OracleTableDDLGenerator(prov));
        this.registerDDLGenerator("TRIGGER", (DDLGenerator)new OracleTriggerDDLGenerator(prov));
        this.registerDDLGenerator("VIEW", (DDLGenerator)new OracleViewDDLGenerator(prov));
        this.registerDDLGenerator("TYPE", (DDLGenerator)new OracleTypeDDLGenerator(prov));
        this.registerDDLGenerator("PACKAGE", (DDLGenerator)new OracleSourceDDLGenerator(prov));
        this.registerDDLGenerator("PROCEDURE", (DDLGenerator)new OracleSourceDDLGenerator(prov));
        this.registerDDLGenerator("FUNCTION", (DDLGenerator)new OracleSourceDDLGenerator(prov));
        this.registerAlterDDLGenerator("TABLE", (DDLGenerator)new OracleDDLAlterTable(prov, null));
        this.registerAlterDDLGenerator("MATERIALIZED VIEW", (DDLGenerator)new OracleAlterDDLMatView(prov, null));
        this.registerAlterDDLGenerator("MATERIALIZED VIEW LOG", (DDLGenerator)new OracleAlterDDLMatViewLog(prov, null));
        this.registerAlterDDLGenerator("SEQUENCE", (DDLGenerator)new OracleAlterDDLSequence(prov, null));
        this.registerAlterDDLGenerator("INDEX", (DDLGenerator)new OracleAlterDDLIndex(prov, null));
        this.registerAlterDDLGenerator("TRIGGER", (DDLGenerator)new OracleAlterDDLTrigger(prov, null));
    }

    public Ddl getCreateDDL(SchemaObject dbObject, boolean replace, boolean cascade) {
        return this.getCreateDDL(new SchemaObject[]{dbObject}, replace, cascade);
    }

    public Ddl getCreateDDL(SchemaObject[] dbObjects, boolean replace, boolean cascade) {
        Ddl result = new Ddl();
        int i = 0;
        while (i < dbObjects.length) {
            SchemaObject dbObject = dbObjects[i];
            if (dbObject != null) {
                DDLGenerator g;
                String type = dbObject.getType();
                if (replace) {
                    try {
                        String originalName = null;
                        Object originalId = DBUtil.getOriginalID((DBObject)dbObject);
                        originalName = originalId instanceof DBObjectID ? DBUtil.getDBObjectName((DBObjectID)((DBObjectID)originalId)) : (String)originalId;
                        SchemaObject existingObject = this.m_prov.getObject(type, dbObject.getSchema(), originalName);
                        if (existingObject != null && "VIEW" != type && "SYNONYM" != type && !(dbObject instanceof SourceObject)) {
                            result.append(this.getDeleteDDL(existingObject, cascade));
                        }
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                }
                if ((g = this.getDDLGenerator(type)) != null) {
                    result.append(g.getCreateDDL(dbObject, replace, cascade));
                }
            }
            ++i;
        }
        result.append(this.generateSpoolCommands());
        return result;
    }

    public Ddl getDeleteDDL(SchemaObject dbObject, boolean cascade) {
        return this.getDeleteDDL(new SchemaObject[]{dbObject}, cascade);
    }

    public Ddl getDeleteDDL(SchemaObject[] dbObjects, boolean cascade) {
        Ddl dropDdl = new Ddl();
        int i = 0;
        while (i < dbObjects.length) {
            SchemaObject dbObject = dbObjects[i];
            String type = dbObject.getType();
            DDLGenerator g = this.getDDLGenerator(type);
            if (g != null) {
                dropDdl.append(g.getDeleteDDL(dbObject, cascade));
            }
            ++i;
        }
        dropDdl.append(this.generateSpoolCommands());
        return dropDdl;
    }

    public Ddl[] getUpdateDDL(SchemaObject dbMaster, SchemaObject dbUpdatable) {
        return this.getUpdateDDL(new SchemaObject[]{dbMaster}, new SchemaObject[]{dbUpdatable});
    }

    public Ddl[] getUpdateDDL(SchemaObject[] dbMaster, SchemaObject[] dbUpdatable) {
        DiffEngine de;
        DiffContext dc;
        ResultSet rs;
        ArrayList<Ddl> ddlArray = new ArrayList<Ddl>();
        ArrayList<SchemaObject> adbm = new ArrayList<SchemaObject>();
        ArrayList<SchemaObject> adbu = new ArrayList<SchemaObject>();
        int i = 0;
        while (i < dbMaster.length) {
            String type = null;
            type = dbUpdatable[i] != null ? dbUpdatable[i].getType() : dbMaster[i].getType();
            DDLGenerator g = this.getDDLGenerator(type);
            Ddl[] ddla = g.getUpdateDDL(dbMaster[i], dbUpdatable[i]);
            if (ddla != null) {
                ddlArray.add(ddla[0]);
            } else if (dbUpdatable[i] != null) {
                adbm.add(dbMaster[i]);
                adbu.add(dbUpdatable[i]);
            }
            ++i;
        }
        if (adbm.size() > 0 && !(rs = (dc = (de = ReconcileHelper.getDiffEngine()).diff(adbm.toArray(), adbu.toArray())).getResult()).isSame()) {
            Ddl[] ddl = this.getUpdateDDL(rs, false, false);
            ddlArray.addAll(Arrays.asList(ddl));
        }
        Ddl[] ddla = new Ddl[]{};
        return ddlArray.toArray(ddla);
    }

    public void setCreatePrompts(boolean value) {
        super.setCreatePrompts(value);
        ArrayList allgens = new ArrayList();
        allgens.addAll(this.getDDLGenerators());
        allgens.addAll(this.getAlterDDLGenerators());
        for (OracleBaseGenerator obg : allgens) {
            if (obg instanceof OracleDDLGenerator) continue;
            obg.setCreatePrompts(value);
        }
    }

    public void setSpooling(String filename) {
        super.setSpooling(filename);
        ArrayList allgens = new ArrayList();
        allgens.addAll(this.getDDLGenerators());
        allgens.addAll(this.getAlterDDLGenerators());
        for (OracleBaseGenerator obg : allgens) {
            if (obg instanceof OracleDDLGenerator) continue;
            obg.setSpooling(filename);
        }
    }

    public void setPrefixSchemaName(boolean value) {
        super.setPrefixSchemaName(value);
        ArrayList allgens = new ArrayList();
        allgens.addAll(this.getDDLGenerators());
        allgens.addAll(this.getAlterDDLGenerators());
        for (OracleBaseGenerator obg : allgens) {
            if (obg instanceof OracleDDLGenerator) continue;
            obg.setPrefixSchemaName(value);
        }
    }
}

