/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import oracle.i18n.util.OraSQLUtil;
import oracle.javatools.db.BaseDatabaseDescriptor;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gDDLGenerator;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.Oracle9iR2DDLGenerator;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.db.ora.ddl.OracleDDLGenerator;
import oracle.javatools.db.ora.validators.DatabaseLinkValidator;
import oracle.javatools.db.ora.validators.DirectoryValidator;
import oracle.javatools.db.ora.validators.ExternalTablePropsValidator;
import oracle.javatools.db.ora.validators.IOTPropertiesValidator;
import oracle.javatools.db.ora.validators.IndexPartitionValidator;
import oracle.javatools.db.ora.validators.IndexPartitionsValidator;
import oracle.javatools.db.ora.validators.LOBDescriptorValidator;
import oracle.javatools.db.ora.validators.MaterializedViewLogValidator;
import oracle.javatools.db.ora.validators.MaterializedViewValidator;
import oracle.javatools.db.ora.validators.OracleColumnValidator;
import oracle.javatools.db.ora.validators.OracleConstraintValidator;
import oracle.javatools.db.ora.validators.OracleIndexValidator;
import oracle.javatools.db.ora.validators.OracleTableValidator;
import oracle.javatools.db.ora.validators.TablePartitionValidator;
import oracle.javatools.db.ora.validators.TablePartitionsValidator;
import oracle.javatools.db.validators.ObjectTypeValidator;
import oracle.javatools.db.validators.PackageValidator;
import oracle.javatools.db.validators.PlSqlValidator;
import oracle.javatools.db.validators.SequenceValidator;
import oracle.javatools.db.validators.SynonymValidator;
import oracle.javatools.db.validators.TriggerValidator;
import oracle.javatools.db.validators.ViewValidator;
import oracle.javatools.util.ModelUtil;
import oracle.sql.CharacterSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseDescriptor
extends BaseDatabaseDescriptor {
    public static final String FEATURE_ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN = "ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN";
    public static final char QUOTE_IDENTIFIER = '\"';
    private static final int MAX_NAME_LEN = 30;
    private static final int MAX_DATABASE_LINK_NAME_LEN = 128;
    private static final int MAX_JAVA_NAME_LEN = 4000;
    private static final char PERIOD = '.';
    private static final String ALLOWED_CHARS = "_$#";
    private static final Set RESERVED_WORDS = new HashSet<String>(Arrays.asList("ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "DUAL", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MLSLABEL", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"));
    private CharacterSet m_databaseCharset;
    private String m_databaseCharsetName;
    private Database m_database;
    private Class m_databaseClass;

    public OracleDatabaseDescriptor(Class databaseClass) {
        this.m_databaseClass = databaseClass;
    }

    public OracleDatabaseDescriptor(Database database, String charsetName, CharacterSet charset) {
        this.m_database = database;
        this.m_databaseClass = database.getClass();
        this.m_databaseCharsetName = charsetName;
        this.m_databaseCharset = charset;
    }

    public int getCasePolicy() {
        return 2;
    }

    public Class getDatabaseClass() {
        return this.m_databaseClass;
    }

    public boolean supportsFeature(String feature) {
        return "LOB PARAMETERS".equals(feature) || "STORAGE OPTIONS".equals(feature) || "COLUMN SEQUENCES".equals(feature) || "TABLE PARTITIONING".equals(feature) && Oracle8.class.isAssignableFrom(this.m_databaseClass) && !Oracle10gR2XE.class.isAssignableFrom(this.m_databaseClass) && this.isPartitioningEnabled() || "GLOBAL HASH INDEX PARTITIONING".equals(feature) && Oracle10g.class.isAssignableFrom(this.m_databaseClass) && !Oracle10gR2XE.class.isAssignableFrom(this.m_databaseClass) && this.isPartitioningEnabled() || "BITMAP INDEXING".equals(feature) && !Oracle10gR2XE.class.isAssignableFrom(this.m_databaseClass) || FEATURE_ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN.equals(feature) && Oracle10g.class.isAssignableFrom(this.m_databaseClass) || "FREEPOOLS".equals(feature) && Oracle9i.class.isAssignableFrom(this.m_databaseClass) || "RETENTION".equals(feature) && Oracle9i.class.isAssignableFrom(this.m_databaseClass);
    }

    public void validateEncoding(String string, Object property) throws ValidationException {
        if (this.m_databaseCharset != null) {
            try {
                this.m_databaseCharset.convert(string);
            }
            catch (SQLException sqe) {
                throw new ValidationException(null, DBArb.format((int)84, (Object)string, (Object)this.m_databaseCharsetName));
            }
        }
    }

    public String getIdentifierQuoteString() {
        return "\"";
    }

    public int getMaxNameLength(String type) {
        return OracleDatabaseDescriptor.getMaxIndentifierLength(type);
    }

    public void validateName(String type, String externalName) throws InvalidNameException {
        OracleDatabaseDescriptor.validateIdentifier(type, externalName);
        if (ModelUtil.hasLength((String)this.m_databaseCharsetName)) {
            try {
                if (!OraSQLUtil.isValidIdentifier((String)externalName, (String)this.m_databaseCharsetName)) {
                    throw new InvalidNameException(null, DBArb.format((int)279, (Object)externalName, (Object)this.m_databaseCharsetName));
                }
            }
            catch (UnsupportedEncodingException e) {
                DBLog.getLogger().log(Level.WARNING, e.getMessage());
            }
            String internalName = this.getInternalName(externalName, type);
            if (this.m_databaseCharset.encodedByteLength(internalName) > this.getMaxNameLength(type)) {
                throw new InvalidNameException(null, DBArb.format((int)10, (Object)externalName));
            }
        } else if (this.getIdeCharset() != null) {
            try {
                if (!this.canEncode(externalName)) {
                    throw new InvalidNameException(null, DBArb.format((int)279, (Object)externalName, (Object)this.getIdeCharset().name()));
                }
                String internalName = this.getInternalName(externalName, type);
                byte[] bytes = internalName.getBytes(this.getIdeCharset().name());
                if (bytes.length > this.getMaxNameLength(type)) {
                    throw new InvalidNameException(null, DBArb.format((int)10, (Object)externalName));
                }
            }
            catch (UnsupportedEncodingException e) {
                String m = e.getMessage();
            }
        }
    }

    public String getExternalName(String name, String objectType) {
        if (ModelUtil.hasLength((String)name) && "DATABASE LINK".equals(objectType)) {
            boolean isQuotedName;
            String externalName = "";
            int length = name.length();
            boolean bl = isQuotedName = name.charAt(0) == '\"' && name.indexOf(34, 1) == length - 1;
            if (isQuotedName) {
                return name;
            }
            int searchFor = name.charAt(0) == '\"' ? 34 : 46;
            int startIdx = 0;
            while (startIdx < length) {
                int srchIdx = startIdx + (searchFor == 34 ? 1 : 0);
                int endIdx = name.indexOf(searchFor, srchIdx);
                int n = endIdx > -1 ? endIdx + (searchFor == 34 ? 1 : 0) : (endIdx = length);
                if (startIdx == endIdx) {
                    return name;
                }
                String component = name.substring(startIdx, endIdx);
                externalName = externalName + (this.isValidName("DATABASE LINK", component) ? component : '\"' + component + '\"');
                startIdx = endIdx + 1;
                if (startIdx == length) {
                    return name;
                }
                if (startIdx >= length) continue;
                externalName = externalName + '.';
                int n2 = searchFor = name.charAt(startIdx) == '\"' ? 34 : 46;
            }
            return this.isValidName("DATABASE LINK", externalName) ? externalName : name;
        }
        return super.getExternalName(name, objectType);
    }

    public String getInternalName(String name, String objectType) {
        if (ModelUtil.hasLength((String)name) && "DATABASE LINK".equals(objectType)) {
            return name.toUpperCase().replaceAll(String.valueOf('\"'), "");
        }
        return super.getInternalName(name, objectType);
    }

    private static void validateIdentifier(String type, String identifier) throws InvalidNameException {
        String string = identifier = identifier == null ? "" : identifier.trim();
        if ("DATABASE LINK".equals(type)) {
            OracleDatabaseDescriptor.validateDbLinkName(identifier);
        } else if (!"XML SCHEMA".equals(type)) {
            OracleDatabaseDescriptor.validateIdentifier((String)identifier, (char)'\"', (int)OracleDatabaseDescriptor.getMaxIndentifierLength(type), (String)ALLOWED_CHARS, (String)String.valueOf('\"'), (boolean)true, (Set)RESERVED_WORDS, (int)2);
        }
    }

    public static boolean isValidOracleIdentifier(String name) {
        try {
            OracleDatabaseDescriptor.validateIdentifier(null, name);
        }
        catch (InvalidNameException ine) {
            boolean bl = false;
            return bl;
        }
        return true;
    }

    public static int getMaxIndentifierLength(String type) {
        return "DATABASE LINK".equals(type) ? 128 : ("JAVA CLASS".equals(type) || "JAVA SOURCE".equals(type) || "JAVA RESOURCE".equals(type) ? 4000 : 30);
    }

    private static void validateDbLinkName(String identifier) throws InvalidNameException {
        boolean isQuotedName;
        String link = identifier.replaceAll("\"", "");
        if (link.length() < 1) {
            throw new InvalidNameException(null, DBArb.getString((int)201));
        }
        if (link.length() > 128) {
            throw new InvalidNameException(null, DBArb.format((int)10, (Object)identifier));
        }
        int length = identifier.length();
        boolean bl = isQuotedName = identifier.charAt(0) == '\"' && identifier.indexOf(34, 1) == length - 1;
        if (isQuotedName) {
            identifier = identifier.substring(1, length - 1);
            length = identifier.length();
        }
        int searchFor = identifier.charAt(0) == '\"' ? 34 : 46;
        int startIdx = 0;
        while (startIdx < length) {
            int srchIdx = startIdx + (searchFor == 34 ? 1 : 0);
            int endIdx = identifier.indexOf(searchFor, srchIdx);
            int n = endIdx > -1 ? endIdx + (searchFor == 34 ? 1 : 0) : (endIdx = length);
            if (startIdx == endIdx || endIdx < length && identifier.charAt(endIdx) != '.') {
                throw new InvalidNameException(null, DBArb.format((int)72, (Object)identifier));
            }
            String component = identifier.substring(startIdx, endIdx);
            OracleDatabaseDescriptor.validateDbLinkNameComponent(isQuotedName ? '\"' + component + '\"' : component);
            startIdx = endIdx + 1;
            if (startIdx == length) {
                throw new InvalidNameException(null, DBArb.format((int)72, (Object)identifier));
            }
            if (startIdx >= length) continue;
            int n2 = searchFor = identifier.charAt(startIdx) == '\"' ? 34 : 46;
        }
    }

    private boolean canEncode(String name) {
        boolean canEncode = true;
        Charset cs = this.getIdeCharset();
        if (cs != null) {
            try {
                CharsetEncoder charsetEncoder = cs.newEncoder();
                if (charsetEncoder != null) {
                    canEncode = charsetEncoder.canEncode(name);
                }
            }
            catch (UnsupportedOperationException uoe) {
                DBLog.getLogger().log(DBLog.getTraceLogLevel(), "charset " + cs.displayName() + " doesn't support encoding.");
            }
            catch (IllegalStateException ise) {
                DBLog.getLogger().log(Level.WARNING, "can't use encoder to test name", ise);
            }
        }
        return canEncode;
    }

    private static void validateDbLinkNameComponent(String component) throws InvalidNameException {
        boolean isQuoted;
        boolean bl = isQuoted = component.charAt(0) == '\"' && component.indexOf(34, 1) == component.length() - 1;
        if (isQuoted) {
            component = component.substring(1, component.length() - 1);
        }
        int i = 0;
        while (i < component.length()) {
            char c = component.charAt(i);
            if (c == '\"' || !Character.isLetterOrDigit(c) && ALLOWED_CHARS.indexOf(c) < 0 && (!isQuoted || c != '.')) {
                throw new InvalidNameException(null, DBArb.format((int)353, (Object)component));
            }
            ++i;
        }
        if (!isQuoted) {
            if (!Character.isLetter(component.charAt(0))) {
                throw new InvalidNameException(null, DBArb.format((int)5, (Object)component));
            }
            if (RESERVED_WORDS.contains(component.toUpperCase())) {
                throw new InvalidNameException(null, DBArb.format((int)305, (Object)component.toUpperCase()));
            }
        }
    }

    private boolean isPartitioningEnabled() {
        if (this.m_database instanceof OracleDatabaseImpl) {
            return ((OracleDatabaseImpl)this.m_database).supportsPartitioning();
        }
        return true;
    }

    @Override
    public Map<String, DBObjectValidator> getValidators(Class<? extends Database> dbImpl, DBObjectProvider pro) {
        Map<String, DBObjectValidator> v = super.getValidators(dbImpl, pro);
        v.put("COLUMN", new OracleColumnValidator(pro));
        v.put("TABLE", new OracleTableValidator(pro));
        v.put("INDEX", new OracleIndexValidator(pro));
        v.put("CONSTRAINT", new OracleConstraintValidator(pro));
        v.put("SYNONYM", new SynonymValidator(pro));
        v.put("SEQUENCE", new SequenceValidator(pro));
        v.put("VIEW", new ViewValidator(pro));
        v.put("MATERIALIZED VIEW", new MaterializedViewValidator(pro));
        v.put("MATERIALIZED VIEW LOG", new MaterializedViewLogValidator(pro));
        v.put("TRIGGER", new TriggerValidator(pro));
        if (!OracleLite.class.isAssignableFrom(dbImpl)) {
            v.put("PACKAGE", new PackageValidator(pro));
            v.put("PROCEDURE", new PlSqlValidator(pro));
            v.put("FUNCTION", new PlSqlValidator(pro));
            v.put("IOT PROPERTIES", new IOTPropertiesValidator(pro));
            v.put("EXTERNAL TABLE PROPERTIES", new ExternalTablePropsValidator(pro));
            v.put("PARTITION MODEL", new TablePartitionsValidator(pro));
            v.put("PARTITION", new TablePartitionValidator(pro));
            v.put("LOB DESCRIPTOR", new LOBDescriptorValidator(pro));
            v.put("INDEX PARTITION MODEL", new IndexPartitionsValidator(pro));
            v.put("INDEX PARTITION", new IndexPartitionValidator(pro));
            v.put("TYPE", new ObjectTypeValidator(pro));
            v.put("DIRECTORY", new DirectoryValidator(pro));
            v.put("DATABASE LINK", new DatabaseLinkValidator(pro));
        }
        return v;
    }

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        OracleDDLGenerator ddlgen = new OracleDDLGenerator(this.m_databaseClass, pro);
        if (Oracle10g.class.isAssignableFrom(this.m_databaseClass)) {
            ddlgen.setOldGenerator(new Oracle10gDDLGenerator(pro));
        } else if (Oracle9iR2.class.isAssignableFrom(this.m_databaseClass)) {
            ddlgen.setOldGenerator(new Oracle9iR2DDLGenerator(pro));
        } else {
            ddlgen.setOldGenerator(new oracle.javatools.db.ora.OracleDDLGenerator(pro));
        }
        return ddlgen;
    }
}

