/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.Oracle10gR2XE;
import oracle.javatools.db.ora.Oracle11g;
import oracle.javatools.db.ora.Oracle8;
import oracle.javatools.db.ora.Oracle8i;
import oracle.javatools.db.ora.Oracle9i;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleDatabaseDescriptor;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.util.ModelUtil;
import oracle.sql.CharacterSet;

public class OracleDatabaseFactory
extends DatabaseFactory.DatabaseCreator {
    private static boolean _autocommit = true;
    private Map<String, DatabaseDescriptor> m_descriptors;
    private static final String VERSION_PATTERN = "[0-9]+\\.[0-9.]*";

    private void $init$() {
        this.m_descriptors = new HashMap<String, DatabaseDescriptor>();
    }

    public OracleDatabaseFactory() {
        this.$init$();
        this.registerTypes();
    }

    private void registerTypes() {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        dtr.registerProvider((DataTypeRegistry.Registerer)new OracleLite.Registerer(), OracleLite.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new OracleDatabaseImpl.Registerer(), OracleDatabaseImpl.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new Oracle8.Registerer(), Oracle8.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new Oracle8i.Registerer(), Oracle8i.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new Oracle9i.Registerer(), Oracle9i.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new Oracle9iR2.Registerer(), Oracle9iR2.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new Oracle10g.Registerer(), Oracle10g.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new Oracle10gR2.Registerer(), Oracle10gR2.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new Oracle10gR2XE.Registerer(), Oracle10gR2XE.class);
        dtr.registerProvider((DataTypeRegistry.Registerer)new Oracle11g.Registerer(), Oracle11g.class);
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Database db) {
        String charsetName;
        if (db instanceof OracleDatabaseImpl && ModelUtil.hasLength((String)(charsetName = ((OracleDatabaseImpl)db).getNLSSessionValue("NLS_CHARACTERSET")))) {
            int charsetID = Integer.valueOf(((OracleDatabaseImpl)db).getNLSSessionValue("NLS_CHARSET_ID"));
            return new OracleDatabaseDescriptor(db, charsetName, CharacterSet.make((int)charsetID));
        }
        return super.getDatabaseDescriptorImpl(db);
    }

    public DatabaseDescriptor getDatabaseDescriptorImpl(Class providerClass) {
        if (OracleDatabase.class.isAssignableFrom(providerClass)) {
            DatabaseDescriptor descriptor = this.m_descriptors.get(providerClass.getName());
            if (descriptor == null) {
                descriptor = new OracleDatabaseDescriptor(providerClass);
                this.m_descriptors.put(providerClass.getName(), descriptor);
            }
            return descriptor;
        }
        return null;
    }

    public Database createDatabaseImpl(String connStore, String connName, Connection conn) {
        BaseOracleDatabase db = null;
        switch (OracleDatabaseFactory.getType(conn)) {
            case -1: {
                db = null;
                break;
            }
            case 1: {
                db = new Oracle8(connStore, connName, conn);
                break;
            }
            case 2: {
                db = new Oracle8i(connStore, connName, conn);
                break;
            }
            case 3: {
                db = new Oracle9i(connStore, connName, conn);
                break;
            }
            case 4: {
                db = new Oracle9iR2(connStore, connName, conn);
                break;
            }
            case 5: {
                db = new Oracle10g(connStore, connName, conn);
                break;
            }
            case 6: {
                db = new Oracle10gR2(connStore, connName, conn);
                break;
            }
            case 7: {
                db = new Oracle10gR2XE(connStore, connName, conn);
                break;
            }
            case 8: {
                db = new Oracle11g(connStore, connName, conn);
                break;
            }
            case 9: {
                db = new OracleLite(connStore, connName, conn);
                break;
            }
            default: {
                db = new OracleDatabaseImpl(connStore, connName, conn);
                break;
            }
        }
        if (db != null) {
            this.initDB((Database)db);
        }
        return db;
    }

    private void initDB(Database db) {
        Connection co = db.getConnection();
        try {
            co.setAutoCommit(_autocommit);
        }
        catch (SQLException ex) {
            DBLog.log((String)ex.getMessage(), (Object[])new Object[0]);
        }
    }

    public static void setDefaultAutocommit(boolean autocommit) {
        _autocommit = autocommit;
    }

    public static boolean isDefaultAutocommit() {
        return _autocommit;
    }

    public static boolean isOracleDatabase(Connection conn) {
        int type = OracleDatabaseFactory.getType(conn);
        return type > -1 && type <= 8;
    }

    private static boolean isExpressEdition(String ver) {
        return ver.indexOf("Express Edition") >= 0;
    }

    private static int getType(Connection conn) {
        int type = -1;
        if (conn != null) {
            try {
                DatabaseMetaData dmd = conn.getMetaData();
                String dbName = dmd.getDatabaseProductName();
                if (ModelUtil.hasLength((String)dbName)) {
                    if (dbName.startsWith("Oracle Lite") || dbName.startsWith("Oracle9i Lite")) {
                        type = 9;
                    } else if (dbName.startsWith("Personal Oracle") || dbName.startsWith("Oracle") && !dbName.startsWith("Oracle Rdb")) {
                        type = 0;
                        String ver = dmd.getDatabaseProductVersion();
                        int[] version = OracleDatabaseFactory.getOracleMajorMinorVersion(ver);
                        if (version != null && version.length == 2) {
                            int major = version[0];
                            int minor = version[1];
                            if (major < 8) {
                                type = 0;
                            } else if (major == 8) {
                                type = minor >= 1 ? 2 : 1;
                            } else if (major == 9) {
                                type = minor >= 2 ? 4 : 3;
                            } else if (major == 10) {
                                type = minor < 2 ? 5 : (OracleDatabaseFactory.isExpressEdition(ver) ? 7 : 6);
                            } else if (major == 11) {
                                type = 8;
                            }
                        }
                    }
                }
            }
            catch (SQLException sqlx) {
                // empty catch block
            }
        }
        return type;
    }

    public static int[] getOracleMajorMinorVersion(String dbVersion) {
        if (ModelUtil.hasLength((String)dbVersion)) {
            String num;
            Pattern pattern = Pattern.compile(VERSION_PATTERN);
            Matcher matcher = pattern.matcher(dbVersion);
            String string = num = matcher.find() ? matcher.group() : null;
            if (ModelUtil.hasLength((String)num)) {
                int major = 8;
                int minor = 0;
                int idx = num.indexOf(46);
                if (idx != -1) {
                    try {
                        major = Integer.parseInt(num.substring(0, idx));
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    int start = idx + 1;
                    idx = num.indexOf(46, start);
                    if (idx != -1) {
                        try {
                            minor = Integer.parseInt(num.substring(start, idx));
                        }
                        catch (NumberFormatException ex) {
                            // empty catch block
                        }
                    }
                }
                return new int[]{major, minor};
            }
        }
        return null;
    }
}

