/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Database;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.StatementWrapper;
import oracle.javatools.db.compilation.CompilationErrorInfo;
import oracle.javatools.db.compilation.CompilationResults;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DateDataType;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Indextype;
import oracle.javatools.db.ora.IndextypeBuilder;
import oracle.javatools.db.ora.OracleNumberDataType;
import oracle.javatools.db.ora.OracleTriggerBuilder;
import oracle.javatools.db.ora.PlSqlSourceBuilder;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.util.ModelUtil;
import oracle.jdbc.driver.OracleConnection;

public class OracleDatabaseImpl
extends BaseOracleDatabase {
    public static final String BUILTIN_INDEXTYPE_SCHEMA_CTXSYS = "CTXSYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_EFXSYS = "EFXSYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_MDSYS = "MDSYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_ORDSYS = "ORDSYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_SYS = "SYS";
    public static final String BUILTIN_INDEXTYPE_SCHEMA_XDB = "XDB";
    public static final String[] BUILTIN_INDEXTYPE_SCHEMA_NAMES = new String[]{"CTXSYS", "EFXSYS", "MDSYS", "ORDSYS", "SYS", "XDB"};
    private static final String PRIVS_QUERY = "SELECT /*OracleDatabaseImpl.ALL_PRIVS_QUERY*/\n       PRIVILEGE FROM SESSION_PRIVS";
    private static final String ROLES_QUERY = "SELECT /*OracleDatabaseImpl.ALL_ROLES_QUERY*/\n       ROLE FROM SESSION_ROLES";
    private static final String PARTITIONING_QUERY = "SELECT /*OracleDatabaseImpl.ALL_PARTITIONING_QUERY*/\n       VALUE FROM V$OPTION WHERE PARAMETER='Partitioning'";
    private static final String NLS_PARAMS_QUERY = "select /*OracleDatabaseImpl.ALL_NLS_PARAMS_QUERY*/\n       s.parameter, s.value \nfrom  nls_session_parameters s \nunion all \nselect d.parameter, d.value \nfrom  nls_database_parameters d \nwhere not exists (select 1 from nls_session_parameters s2 \n                  where   s2.parameter = d.parameter) \nunion all \nselect 'NLS_CHARSET_ID' parameter, to_char(NLS_CHARSET_ID(charset.value)) value\nfrom (select value\n      from nls_database_parameters\n      where parameter = 'NLS_CHARACTERSET') charset \n";
    private Boolean m_partitioning;
    private Boolean m_debugInfo;
    private Map<String, String> m_nlsParams;
    private static String s_api_version = null;
    private static final String ERRORS_QUERY = "SELECT /*OracleDatabaseImpl.ALL_ERRORS_QUERY*/\n       LINE, POSITION, REPLACE(TEXT, CHR(10), ' '), 'ERROR' FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ORDER BY LINE, POSITION";
    private static final String ERRORS_QUERY_10G = "SELECT /*OracleDatabaseImpl.ALL_ERRORS_QUERY_10G*/\n       LINE, POSITION, REPLACE(TEXT, CHR(10), ' '), ATTRIBUTE FROM SYS.ALL_ERRORS A WHERE A.NAME = ? AND A.TYPE = ? AND A.OWNER = ? ORDER BY LINE, POSITION";
    private static final String SET_WARNINGS_FLAG = "BEGIN /*OracleDatabaseImpl.ALL_SET_WARNINGS_FLAG*/\n       DBMS_WARNING.ADD_WARNING_SETTING_CAT( ?, ? , ? ); END;";
    private static final String ENABLE_DEBUG = "ALTER /*OracleDatabaseImpl.ALL_ENABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = TRUE";
    private static final String DISABLE_DEBUG = "ALTER /*OracleDatabaseImpl.ALL_DISABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = FALSE";
    private static final Map<String, Map<String, Indextype[]>> s_builtinIndextypes = new HashMap<String, Map<String, Indextype[]>>();

    OracleDatabaseImpl(String storeName, String connName, Connection conn) {
        super(storeName, connName, conn);
        Schema currSchema = this.getCurrentSchema();
        this.setSQLTraceOnIfReqd(this.getConnection());
        HashSet roles = new HashSet();
        currSchema.setProperty("USER ROLES", roles);
        QueryWrapper rolesWrap = new QueryWrapper((Database)this, ROLES_QUERY);
        1 rolesRun = new 1(this, roles, rolesWrap);
        try {
            rolesWrap.executeQuery((QueryWrapper.QueryRunnable)rolesRun);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Could not load roles for database " + this.getConnectionName(), dbe.getCause() == null ? dbe : dbe.getCause());
        }
        HashSet privs = new HashSet();
        currSchema.setProperty("USER PRIVS", privs);
        QueryWrapper privsWrap = this.newQueryWrapper(PRIVS_QUERY, new Object[0]);
        2 privsRun = new 2(this, privs, privsWrap);
        try {
            privsWrap.executeQuery((QueryWrapper.QueryRunnable)privsRun);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Could not load privs for database " + this.getConnectionName(), dbe.getCause() == null ? dbe : dbe.getCause());
        }
    }

    public int getOracleDatabaseType() {
        return 0;
    }

    public String getDatabaseType() {
        return "Oracle Database";
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean supportsPartitioning() {
        if (this.m_partitioning == null) {
            this.checkPartitioning();
        }
        return this.m_partitioning;
    }

    public String getNLSSessionValue(String parameter) {
        if (this.m_nlsParams == null) {
            this.m_nlsParams = new HashMap<String, String>();
            QueryWrapper wrap = new QueryWrapper((Database)this, NLS_PARAMS_QUERY);
            3 r = new 3(this, wrap);
            try {
                wrap.executeQuery((QueryWrapper.QueryRunnable)r);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Cannot retrieve nls session params", dbe);
            }
        }
        return this.m_nlsParams.get(parameter);
    }

    private void checkPartitioning() {
        QueryWrapper wrap = this.newQueryWrapper(PARTITIONING_QUERY, new Object[0]);
        4 r = new 4(this, wrap);
        try {
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        }
        catch (DBException dbe) {
            DBLog.getLogger().log(Level.WARNING, "Could not query whether database " + this.getConnectionName() + " supports partitioning", dbe);
            this.m_partitioning = Boolean.FALSE;
        }
    }

    protected void registerBuilders() {
        super.registerBuilders();
        this.registerBuilder("TRIGGER", (DBObjectBuilder)new OracleTriggerBuilder(this));
        this.registerBuilder("FUNCTION", (DBObjectBuilder)new PlSqlSourceBuilder(this, "FUNCTION"));
        this.registerBuilder("PROCEDURE", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PROCEDURE"));
        this.registerBuilder("PACKAGE", (DBObjectBuilder)new PlSqlSourceBuilder(this, "PACKAGE"));
        this.registerBuilder("INDEXTYPE", (DBObjectBuilder)new IndextypeBuilder(this));
    }

    protected boolean hasRole(String role) {
        Schema currSchema = this.getCurrentSchema();
        if (currSchema != null) {
            Set roles = (Set)currSchema.getProperty("USER ROLES");
            return roles != null && roles.contains(role);
        }
        return false;
    }

    protected boolean hasPrivilege(String priv) {
        Schema currSchema = this.getCurrentSchema();
        if (currSchema != null) {
            Set privs = (Set)currSchema.getProperty("USER PRIVS");
            return privs != null && privs.contains(priv);
        }
        return false;
    }

    public void close() {
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public CompilationResults submitDatabaseSource(String schemaName, String text) {
        results = new CompilationResults();
        lexer = PlsqlParser.createSqlLexer();
        lexer.setTextBuffer(TextBufferFactory.createReadTextBuffer((String)text));
        token = lexer.createLexerToken();
        schema = null;
        name = null;
        type = null;
        hasCreate = false;
        foundDot = false;
        identifierPos = -1;
        block37: while (true) {
            tkn = lexer.lex(token);
            start = token.getStartOffset();
            end = token.getEndOffset();
            txt = lexer.getTextBuffer().getString(start, end - start);
            switch (tkn) {
                case 392: {
                    type = "FUNCTION";
                    continue block37;
                }
                case 752: {
                    type = "PROCEDURE";
                    continue block37;
                }
                case 702: {
                    type = "PACKAGE";
                    continue block37;
                }
                case 975: {
                    type = "TYPE";
                    continue block37;
                }
                case 188: {
                    if ("PACKAGE".equals(type)) {
                        type = "PACKAGE BODY";
                        continue block37;
                    }
                    if (!"TYPE".equals(type)) continue block37;
                    type = "TYPE BODY";
                    continue block37;
                }
                case 1112: {
                    type = "TRIGGER";
                    continue block37;
                }
                case 0: 
                case 80: 
                case 160: 
                case 815: 
                case 1050: 
                case 1080: {
                    break block37;
                }
                case 48: 
                case 49: {
                    continue block37;
                }
                case 1058: {
                    hasCreate = true;
                    continue block37;
                }
                case 801: 
                case 1094: {
                    continue block37;
                }
                default: {
                    if (name != null) {
                        if (!foundDot) break block37;
                        schema = name;
                    } else {
                        identifierPos = start;
                    }
                    name = this.getInternalName(txt);
                    foundDot = false;
                    continue block37;
                }
                case 72: {
                    foundDot = true;
                    if (name != null) continue block37;
                    DBLog.log((String)"Oops! Dot found before name", (Object[])new Object[0]);
                    continue block37;
                }
            }
            break;
        }
        if (schema == null) {
            schema = schemaName;
            if (ModelUtil.areDifferent((Object)this.getCurrentSchema().getName(), (Object)schema) && identifierPos != -1) {
                buf = new StringBuilder(text.length() + 40);
                buf.append(text.substring(0, identifierPos));
                buf.append(this.getExternalName(schemaName));
                buf.append('.');
                buf.append(text.substring(identifierPos));
                text = buf.toString();
            }
        }
        if (!hasCreate) {
            text = "CREATE OR REPLACE " + text;
        }
        opts = (settings = GlobalSettings.getInstance()) == null ? null : settings.getPlSqlCompilerOptions();
        v0 = debugInfo = opts == null ? Boolean.FALSE : Boolean.valueOf(opts.isGeneratePlSqlDebugInfo());
        if (ModelUtil.areDifferent((Object)this.m_debugInfo, (Object)debugInfo)) {
            this.m_debugInfo = debugInfo;
            this.generateDebugInfo();
        }
        this.setWarningFlags(opts);
        conn = this.getConnection();
        var31_21 = this.getConnection();
        synchronized (var31_21) {
            block49: {
                stmt = null;
                try {
                    try {
                        stmt = conn.createStatement();
                        try {
                            try {
                                stmt.setEscapeProcessing(false);
                                stmt.execute(text);
                            }
                            catch (SQLException ex) {
                                results.setSubmitFailed(true);
                                throw ex;
                            }
                        }
                        finally {
                            try {
                                stmt.close();
                            }
                            catch (Exception e) {}
                        }
                        wrap2 = this.newQueryWrapper(this.getErrorQuery(), new Object[]{name, type, schema});
                        r = new 5(this, results, wrap2);
                        try {
                            wrap2.executeQuery((QueryWrapper.QueryRunnable)r);
                        }
                        catch (DBException dbe) {
                            cause = dbe.getCause();
                            if (cause instanceof SQLException) {
                                throw (SQLException)cause;
                            }
                            dbe.printStackTrace();
                        }
                        break block49;
                    }
                    catch (SQLException sqlEx) {
                        ** while (sqlEx != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        results.addError(new CompilationErrorInfo(0, 0, sqlEx.getMessage()));
                        sqlEx = sqlEx.getNextException();
                        continue;
lbl123:
                        // 1 sources

                        break block49;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                finally {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception e) {}
                    }
                }
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void generateDebugInfo() {
        var6_2 = conn = this.getConnection();
        synchronized (var6_2) {
            block15: {
                stmt = null;
                try {
                    try {
                        stmt = conn.createStatement();
                        stmt.executeUpdate(this.m_debugInfo != false ? "ALTER /*OracleDatabaseImpl.ALL_ENABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = TRUE" : "ALTER /*OracleDatabaseImpl.ALL_DISABLE_DEBUG*/\n       SESSION SET PLSQL_DEBUG = FALSE");
                        break block15;
                    }
                    catch (SQLException sqlEx) {
                        ** while (sqlEx != null)
                    }
lbl-1000:
                    // 1 sources

                    {
                        DBLog.log((String)sqlEx.getLocalizedMessage(), (Object[])new Object[0]);
                        sqlEx = sqlEx.getNextException();
                        continue;
lbl16:
                        // 1 sources

                        break block15;
                    }
                    catch (Exception ex) {
                        DBLog.logStackTrace((Throwable)ex);
                    }
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void setWarningFlags(PlSqlCompilerOptions opts) {
        if (this.getOracleDatabaseType() >= 5 && opts != null) {
            var8_3 = conn = this.getConnection();
            synchronized (var8_3) {
                block17: {
                    stmt = null;
                    try {
                        try {
                            stmt = conn.prepareCall("BEGIN /*OracleDatabaseImpl.ALL_SET_WARNINGS_FLAG*/\n       DBMS_WARNING.ADD_WARNING_SETTING_CAT( ?, ? , ? ); END;");
                            var9_5 = PlSqlCompilerOptions.WarningCategory.values();
                            var10_6 = 0;
                            while (var10_6 < var9_5.length) {
                                category = var9_5[var10_6];
                                value = opts.getWarningValue(category);
                                if (value != null) {
                                    stmt.setString(1, category.name());
                                    stmt.setString(2, value.name());
                                    stmt.setString(3, "SESSION");
                                    stmt.execute();
                                }
                                ++var10_6;
                            }
                            break block17;
                        }
                        catch (SQLException sqlEx) {
                            ** while (sqlEx != null)
                        }
lbl-1000:
                        // 1 sources

                        {
                            DBLog.log((String)sqlEx.getLocalizedMessage(), (Object[])new Object[0]);
                            sqlEx = sqlEx.getNextException();
                            continue;
lbl28:
                            // 1 sources

                        }
                    }
                    finally {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Exception ex) {}
                        }
                    }
                }
            }
        }
    }

    private String getErrorQuery() {
        return this.getOracleDatabaseType() >= 5 ? ERRORS_QUERY_10G : ERRORS_QUERY;
    }

    protected void reconnected(Connection c) {
        this.setSQLTraceOnIfReqd(c);
    }

    public static String[] listBuiltInIndextypeSchemas(Class providerClass) {
        HashSet<String> schemas = new HashSet<String>();
        while (providerClass != null && !providerClass.equals(Object.class)) {
            Map<String, Indextype[]> indextypeMap = s_builtinIndextypes.get(providerClass.getName());
            if (indextypeMap != null) {
                schemas.addAll(indextypeMap.keySet());
            }
            providerClass = providerClass.getSuperclass();
        }
        return schemas.toArray(new String[schemas.size()]);
    }

    public static Indextype[] listBuiltInIndextypes(Class providerClass, String schemaName) {
        if (OracleDatabaseImpl.isBuiltInIndextypeSchema(schemaName)) {
            while (providerClass != null && !providerClass.equals(Object.class)) {
                Indextype[] indextypes;
                Map<String, Indextype[]> indextypeMap = s_builtinIndextypes.get(providerClass.getName());
                if (indextypeMap != null && (indextypes = indextypeMap.get(schemaName)) != null) {
                    return indextypes;
                }
                providerClass = providerClass.getSuperclass();
            }
        }
        return new Indextype[0];
    }

    protected static void registerBuiltInIndextypes(Class providerClass, String schemaName, String[] indextypeNames) {
        Indextype[] its = new Indextype[indextypeNames.length];
        Schema schema = new Schema(schemaName);
        int i = 0;
        while (i < indextypeNames.length) {
            its[i] = new Indextype(indextypeNames[i], schema);
            its[i].setID((DBObjectID)new ReferenceID((DBObject)its[i]));
            ++i;
        }
        Map<String, Indextype[]> indextypeMap = s_builtinIndextypes.get(providerClass.getName());
        if (indextypeMap == null) {
            indextypeMap = new HashMap<String, Indextype[]>();
            s_builtinIndextypes.put(providerClass.getName(), indextypeMap);
        }
        indextypeMap.put(schemaName, its);
    }

    private static boolean isBuiltInIndextypeSchema(String schemaName) {
        String[] stringArray = BUILTIN_INDEXTYPE_SCHEMA_NAMES;
        int n = 0;
        while (n < stringArray.length) {
            String name = stringArray[n];
            if (name.equals(schemaName)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String getAPIVersionForSQLTrace() {
        String ade_view_root;
        if (s_api_version == null && ModelUtil.hasLength((String)(ade_view_root = System.getenv("ADE_VIEW_ROOT")))) {
            FileReader fr = null;
            try {
                fr = new FileReader(ade_view_root + "/ade_info.vmd");
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            BufferedReader br = new BufferedReader(fr);
            String record = null;
            try {
                while ((record = br.readLine()) != null) {
                    if (record.startsWith("VIEW_LABEL")) {
                        s_api_version = record.substring(record.indexOf(" ")).trim();
                    }
                    if (!record.startsWith("VIEW_TRANS_NAME")) continue;
                    String txn = record.substring(record.indexOf(" ")).trim();
                    if (ModelUtil.areDifferent((Object)txn, (Object)"NONE")) {
                        s_api_version = s_api_version + "/" + txn;
                    }
                    break;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return s_api_version;
    }

    public static void setAPIVersionForSQLTrace(String v) {
        s_api_version = v;
    }

    private void setSQLTraceOnIfReqd(Connection c) {
        String dbSqlTraceProp = System.getProperty("db-sqltrace");
        if (ModelUtil.hasLength((String)dbSqlTraceProp)) {
            String[] actualConnParts = new String[]{};
            if (c instanceof OracleConnection) {
                Properties p = ((OracleConnection)c).getProperties();
                String s = (String)p.get("database") + ":" + ((String)p.get("user")).toLowerCase();
                actualConnParts = s.split(":");
            }
            String[] propParts = dbSqlTraceProp.split(",");
            boolean doThisConnection = false;
            String activity = null;
            int i = 0;
            while (i < propParts.length && !doThisConnection) {
                String[] propSubParts = propParts[i].split(":");
                activity = propSubParts[0];
                String[] propConnParts = new String[4];
                int j = 0;
                while (j < propSubParts.length - 1 && j < propConnParts.length) {
                    propConnParts[j] = propSubParts[j + 1];
                    ++j;
                }
                while (j < 4) {
                    propConnParts[j] = "";
                    ++j;
                }
                propConnParts[3] = propConnParts[3].toLowerCase();
                doThisConnection = true;
                j = 0;
                while (j < actualConnParts.length && j < 4) {
                    if (!propConnParts[j].equals("")) {
                        if (j == 0) {
                            String shorter = propConnParts[j].length() > actualConnParts[j].length() ? actualConnParts[j] : propConnParts[j];
                            String longer = propConnParts[j].length() > actualConnParts[j].length() ? propConnParts[j] : actualConnParts[j];
                            shorter = shorter + '.';
                            if (!(longer = longer + '.').startsWith(shorter)) {
                                doThisConnection = false;
                                break;
                            }
                        } else if (!propConnParts[j].equals(actualConnParts[j])) {
                            doThisConnection = false;
                            break;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (doThisConnection) {
                StatementWrapper x = new StatementWrapper((Database)this, new String[]{"ALTER SESSION SET SQL_TRACE=TRUE"});
                try {
                    x.execute();
                }
                catch (DBException e) {
                    // empty catch block
                }
                String query = "SELECT /* :DB-API:" + this.getUserName() + ":" + activity + ":" + OracleDatabaseImpl.getAPIVersionForSQLTrace() + ":" + " */ 1 FROM DUAL";
                QueryWrapper y = new QueryWrapper((Database)this, query);
                try {
                    y.execute();
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
    }

    static void wa$m_partitioning(OracleDatabaseImpl oracleDatabaseImpl, Boolean bl) {
        oracleDatabaseImpl.m_partitioning = bl;
    }

    static Map ra$m_nlsParams(OracleDatabaseImpl oracleDatabaseImpl) {
        return oracleDatabaseImpl.m_nlsParams;
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Set v$roles;
        private final /* synthetic */ QueryWrapper v$rolesWrap;
        final /* synthetic */ OracleDatabaseImpl this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    this.v$roles.add(rs.getString(1));
                }
            }
            catch (SQLException ex) {
                this.v$rolesWrap.throwDBException(ex);
            }
        }

        public 1(OracleDatabaseImpl oracleDatabaseImpl, Set set, QueryWrapper queryWrapper) {
            this.v$rolesWrap = queryWrapper;
            this.v$roles = set;
            this.this$0 = oracleDatabaseImpl;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Set v$privs;
        private final /* synthetic */ QueryWrapper v$privsWrap;
        final /* synthetic */ OracleDatabaseImpl this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    this.v$privs.add(rs.getString(1));
                }
            }
            catch (SQLException ex) {
                this.v$privsWrap.throwDBException(ex);
            }
        }

        public 2(OracleDatabaseImpl oracleDatabaseImpl, Set set, QueryWrapper queryWrapper) {
            this.v$privsWrap = queryWrapper;
            this.v$privs = set;
            this.this$0 = oracleDatabaseImpl;
        }
    }

    final class 3
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleDatabaseImpl this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    OracleDatabaseImpl.ra$m_nlsParams(this.this$0).put(rs.getString(1), rs.getString(2));
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException(sqe);
            }
        }

        public 3(OracleDatabaseImpl oracleDatabaseImpl, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.this$0 = oracleDatabaseImpl;
        }
    }

    final class 4
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleDatabaseImpl this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    OracleDatabaseImpl.wa$m_partitioning(this.this$0, Boolean.valueOf(rs.getString(1)));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException(ex);
            }
        }

        public 4(OracleDatabaseImpl oracleDatabaseImpl, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.this$0 = oracleDatabaseImpl;
        }
    }

    final class 5
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ CompilationResults v$results;
        private final /* synthetic */ QueryWrapper v$wrap2;
        final /* synthetic */ OracleDatabaseImpl this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    int line = rs.getInt(1);
                    int col = rs.getInt(2);
                    String errMsg = rs.getString(3);
                    String attr = rs.getString(4);
                    boolean error = "ERROR".equals(attr);
                    this.v$results.addError(new CompilationErrorInfo(line, col, errMsg, error ^ true));
                }
            }
            catch (SQLException sqlEx) {
                this.v$wrap2.throwDBException(sqlEx);
            }
        }

        public 5(OracleDatabaseImpl oracleDatabaseImpl, CompilationResults compilationResults, QueryWrapper queryWrapper) {
            this.v$wrap2 = queryWrapper;
            this.v$results = compilationResults;
            this.this$0 = oracleDatabaseImpl;
        }
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dtr) {
            NumericDataType.MinMaxValue MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "9.9999999999999999999999999999999999999e+125", 2);
            NumericDataType.MinMaxValue MIN_MAX_INT = new NumericDataType.MinMaxValue("-99999999999999999999999999999999999999", "99999999999999999999999999999999999999", 0);
            OracleNumberDataType DATATYPE_NUMBER = new OracleNumberDataType(1);
            NumericDataType DATATYPE_FLOAT = new NumericDataType(1, "FLOAT", "FLOAT[(<precision>)]", 1L, (long)126, new Long(126), false, null, MIN_MAX_FLOAT);
            CharacterDataType DATATYPE_VARCHAR2 = new CharacterDataType(1, "VARCHAR2", "VARCHAR2(<size>)", 1L, 4000L, (long)20, true, null);
            CharacterDataType DATATYPE_CHAR = new CharacterDataType(1, "CHAR", "CHAR[(<size>)]", 1L, 2000L, 1L, false, null);
            CharacterDataType DATATYPE_LONG = new CharacterDataType(1, "LONG", 1L, Integer.MAX_VALUE);
            BinaryDataType DATATYPE_RAW = new BinaryDataType(1, "RAW", "RAW(<size>)", 1L, 2000L, (long)20, true, null);
            BinaryDataType DATATYPE_LONG_RAW = new BinaryDataType(1, "LONG RAW", 1L, Integer.MAX_VALUE);
            PredefinedDataType DATATYPE_ROWID = new PredefinedDataType(1, "ROWID");
            DateDataType DATATYPE_DATE = new DateDataType(1, "DATE");
            dtr.registerDataType((DataType)DATATYPE_CHAR, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_DATE, OracleDatabaseImpl.class, JdbcDatabase.ANSI_DATE);
            dtr.registerDataType((DataType)DATATYPE_FLOAT, OracleDatabaseImpl.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)DATATYPE_LONG, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER);
            dtr.registerDataType((DataType)DATATYPE_LONG_RAW, OracleDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class, JdbcDatabase.ANSI_NUMERIC);
            dtr.registerDataType((DataType)DATATYPE_RAW, OracleDatabaseImpl.class);
            dtr.registerDataType((DataType)DATATYPE_ROWID, OracleDatabaseImpl.class, JdbcDatabase.ANSI_REAL);
            dtr.registerDataType((DataType)DATATYPE_VARCHAR2, OracleDatabaseImpl.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dtr.registerSynonym("CHARACTER", (DataType)DATATYPE_CHAR, OracleDatabaseImpl.class);
            dtr.registerSynonym("CHAR VARYING", (DataType)DATATYPE_VARCHAR2, OracleDatabaseImpl.class);
            dtr.registerSynonym("CHARACTER VARYING", (DataType)DATATYPE_VARCHAR2, OracleDatabaseImpl.class);
            dtr.registerSynonym("LONG VARCHAR", (DataType)DATATYPE_LONG, OracleDatabaseImpl.class);
            dtr.registerSynonym("VARCHAR", (DataType)DATATYPE_VARCHAR2, OracleDatabaseImpl.class);
            dtr.registerSynonym("DEC", (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym("DECIMAL", (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym("NUMERIC", (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            NumericDataType SYNONYM_INT = new NumericDataType(1, "INT", MIN_MAX_INT);
            NumericDataType SYNONYM_INTEGER = new NumericDataType(1, "INTEGER", MIN_MAX_INT);
            NumericDataType SYNONYM_SMALLINT = new NumericDataType(1, "SMALLINT", MIN_MAX_INT);
            NumericDataType SYNONYM_REAL = new NumericDataType(1, "REAL", MIN_MAX_FLOAT);
            NumericDataType SYNONYM_DOUBLE_PRECISION = new NumericDataType(1, "DOUBLE PRECISION", MIN_MAX_FLOAT);
            dtr.registerSynonym((DataType)SYNONYM_INT, (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_INTEGER, (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_SMALLINT, (DataType)DATATYPE_NUMBER, OracleDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_REAL, (DataType)DATATYPE_FLOAT, OracleDatabaseImpl.class);
            dtr.registerSynonym((DataType)SYNONYM_DOUBLE_PRECISION, (DataType)DATATYPE_FLOAT, OracleDatabaseImpl.class);
        }

        Registerer() {
        }
    }
}

