/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTableBuilder;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleIndexBuilder
extends OracleDBObjectBuilder {
    private static String BITMAP;
    private static String NORMAL;
    private static String DOMAIN;
    private static String UNIQUE;
    private String m_matViewUsingIndexIndexName;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void $init$() {
        this.m_matViewUsingIndexIndexName = null;
    }

    public OracleIndexBuilder(BaseOracleDatabase db) {
        super(db, "INDEX");
        this.$init$();
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        Index idx = new Index(name, schema);
        idx.setID(id);
        return idx;
    }

    protected boolean canBuildMultipleObjects() {
        return true;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        Index i = (Index)object;
        SchemaObject parent = this.getParent(i);
        if (parent == null) {
            this.fillInLonelyIndex(i);
        } else if (parent instanceof Table) {
            OracleTableBuilder tb = (OracleTableBuilder)this.getDatabase().getBuilderForType("TABLE");
            tb.buildObjectComponent((SchemaObject)((Table)parent), "INDEX");
        }
    }

    private SchemaObject getParent(Index index) throws DBException {
        BaseOracleDatabase db;
        Schema s;
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_INDEX_TAB_QUERY*/\n       TABLE_NAME, TABLE_OWNER, TABLE_TYPE FROM ALL_INDEXES WHERE OWNER = ? AND INDEX_NAME = ? AND GENERATED = 'N'", index.getSchema(), index);
        String[] details = new String[3];
        1 r = new 1(this, details, wrap, index);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        String tabName = details[0];
        String tabOwner = details[1];
        String tabType = details[2];
        if (ModelUtil.hasLength((String)tabOwner) && ModelUtil.hasLength((String)tabName) && ModelUtil.hasLength((String)tabType) && (s = (db = this.getDatabase()).getSchema(tabOwner)) != null) {
            SchemaObject obj = db.getObject(tabType, s, tabName);
            if (obj == null && "TABLE".equals(tabType)) {
                obj = db.getObject("MATERIALIZED VIEW", s, tabName);
            }
            return obj;
        }
        return null;
    }

    private void fillInLonelyIndex(Index i) {
    }

    protected void fillInIndexes(SchemaObject parent) throws DBException {
        HashMap<String, Index> nameMap = new HashMap<String, Index>();
        this.fillInBaseDefinitionsForTable(parent, nameMap);
        if (nameMap.size() > 0) {
            this.fillInExpressionsForTable(parent, nameMap);
            if (parent instanceof Table) {
                Table table = (Table)parent;
                Collection<Index> indexes = nameMap.values();
                this.removeSystemIndexes((Relation)table, indexes);
                Index[] idxArray = indexes.toArray(new Index[indexes.size()]);
                Arrays.sort(idxArray, DBUtil.getNameComparator());
                table.setIndexes(idxArray);
                if (this.getDatabase().getOracleDatabaseType() != 9) {
                    this.fillInPartitions(table);
                }
            }
        }
        this.updateTimestamp(parent, true);
    }

    private void fillInBaseDefinitionsForTable(SchemaObject parent, Map<String, Index> indexes) throws DBException {
        Schema tableOwner = parent.getSchema();
        boolean isDefaultUser = tableOwner == null || tableOwner.getName().equals(this.getDatabase().getUserName());
        String query = this.getTableIndexesQuery(isDefaultUser);
        String parentType = parent.getType();
        if (parent instanceof MaterializedView) {
            parentType = "TABLE";
        }
        QueryWrapper wrap = this.newQueryWrapper(query, parent.getSchema(), parentType, parent);
        2 r = new 2(this, parent, indexes, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private void fillInPartitions(Table table) throws DBException {
        Index[] indexArray = table.getIndexes();
        int n = 0;
        while (n < indexArray.length) {
            Index index = indexArray[n];
            String indexName = index.getName();
            QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_TYPE_QUERY*/\n       partitioning_type, subpartitioning_type, locality, partition_count\nfrom   all_part_indexes api\nwhere  api.owner = ?\nand    api.index_name = ?\n", index.getSchema(), indexName);
            3 r = new 3(this, index, wrap, table);
            wrap.executeQuery((QueryWrapper.QueryRunnable)r);
            ++n;
        }
    }

    private DBObjectID[] getGlobalPartitionColumns(Index index) throws DBException {
        ArrayList columnIDs = new ArrayList();
        Table table = index.getTable();
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_INDEX_PARTITION_COLUMNS_QUERY*/\n       column_name\nfrom   all_part_key_columns apk1\nwhere  apk1.owner = ?\nand    apk1.name = ?\nand    apk1.object_type = 'INDEX'\norder by apk1.column_position", index.getSchema(), index);
        4 r = new 4(this, columnIDs, table, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        return columnIDs.toArray(new DBObjectID[columnIDs.size()]);
    }

    private void fillInIndexPartitions(Index index) throws DBException {
        OracleIndexPartitions oip = (OracleIndexPartitions)index.getProperty("OracleIndexPartitions");
        OracleIndexPartitions.PartitionType partitionType = oip.getPartitionType();
        Map<String, OracleIndexPartitions> subpartitionsMap = partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP ? this.getSubpartitions(index) : null;
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_INDEX_PARTITIONS_QUERY*/\n       TABLESPACE_NAME, PCT_FREE, null PCT_USED, INI_TRANS, MAX_TRANS,\n       INITIAL_EXTENT, NEXT_EXTENT, MIN_EXTENT min_extents, MAX_EXTENT max_extents,\n       PCT_INCREASE, FREELISTS, FREELIST_GROUPS, LOGGING, BUFFER_POOL,\n       COMPRESSION, PARTITION_NAME, HIGH_VALUE, PARAMETERS\nfrom   all_ind_partitions aip\nwhere  aip.index_owner = ?\nand    aip.index_name  = ?\norder by aip.partition_position", index.getSchema(), index);
        5 r = new 5(this, oip, partitionType, subpartitionsMap, wrap, index);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private Map<String, OracleIndexPartitions> getSubpartitions(Index index) throws DBException {
        HashMap<String, OracleIndexPartitions> map = new HashMap<String, OracleIndexPartitions>();
        QueryWrapper wrap = this.newQueryWrapper("select /*OracleDictionaryQueries.ALL_INDEX_SUBPARTITIONS_QUERY*/\n       PARTITION_NAME, SUBPARTITION_NAME, TABLESPACE_NAME, HIGH_VALUE\nfrom   ALL_IND_SUBPARTITIONS\nwhere  INDEX_OWNER = ?\nand    INDEX_NAME  = ?\norder by PARTITION_NAME, SUBPARTITION_POSITION", index.getSchema(), index);
        6 r = new 6(this, map, wrap, index);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        return map;
    }

    private void setSubpartitionIDs(IndexPartition ip) {
        OracleIndexPartitions subpartitions = ip.getSubpartitions();
        if (subpartitions != null) {
            NameBasedID parid = new NameBasedID((DBObject)subpartitions, ip.getID());
            subpartitions.setID((DBObjectID)parid);
            IndexPartition[] indexPartitionArray = subpartitions.getPartitions();
            int n = 0;
            while (n < indexPartitionArray.length) {
                IndexPartition sp = indexPartitionArray[n];
                sp.setID((DBObjectID)new NameBasedID((DBObject)sp, (DBObjectID)parid));
                ++n;
            }
        }
    }

    static {
        $assertionsDisabled = OracleIndexBuilder.class.desiredAssertionStatus() ^ true;
        BITMAP = "BITMAP";
        NORMAL = "NORMAL";
        DOMAIN = "DOMAIN";
        UNIQUE = "UNIQUE";
    }

    private void fillInExpressionsForTable(SchemaObject parent, Map<String, Index> indexes) throws DBException {
        ArrayList indexCols = new ArrayList();
        QueryWrapper wrap = this.newQueryWrapper(this.getIndexColumnQuery(), parent.getSchema(), parent);
        7 r = new 7(this, indexCols, wrap, parent);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        Map<String, Map<Long, String>> idxExpressions = null;
        for (IndexColumnQueryResult stuff : indexCols) {
            Constraint c;
            String idxName = stuff.idxName;
            String colName = stuff.colName;
            Long colPosn = stuff.colPosn;
            String colDesc = stuff.colDesc;
            Index index = indexes.get(idxName);
            if (index == null) continue;
            if (parent instanceof Relation && (c = ((Relation)parent).getConstraint(index.getName())) instanceof ColumnConstraint) {
                Column[] cols = ((ColumnConstraint)c).getColumns();
                IndexObject[] exps = new IndexObject[cols.length];
                int i = 0;
                while (i < cols.length) {
                    exps[i] = new IndexObject();
                    ColumnUsage cu = new ColumnUsage(cols[i].getID());
                    exps[i].setExpression((SQLFragment)cu);
                    ++i;
                }
                index.setColumnExpressions(exps);
                index = null;
            }
            if (index == null || !(parent instanceof Relation)) continue;
            SQLFragment expression = null;
            if (stuff.isAllIndExp == 1) {
                if (idxExpressions == null) {
                    idxExpressions = this.getIndexExpressionsForTable(parent);
                }
                Map columnMap = (Map)idxExpressions.get(idxName);
                if (!($assertionsDisabled || columnMap != null && columnMap.containsKey(colPosn))) {
                    throw new AssertionError((Object)"Missing column expression");
                }
                expression = OracleIndexBuilder.createExpression((String)columnMap.get(colPosn), (Relation)parent, (DBObjectProvider)this.getDatabase());
            } else {
                expression = OracleIndexBuilder.createExpression(this.getDatabase().getExternalName(colName), (Relation)parent, (DBObjectProvider)this.getDatabase());
            }
            if (index.getIndexType() == Index.IndexType.DOMAIN) {
                colDesc = null;
            }
            IndexObject io = new IndexObject(expression, colDesc);
            index.addColumnExpression(io);
        }
    }

    private Map<String, Map<Long, String>> getIndexExpressionsForTable(SchemaObject parent) throws DBException {
        HashMap<String, Map<Long, String>> idxExpressions = new HashMap<String, Map<Long, String>>();
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_INDEX_EXPRESSION_PER_TAB_QUERY*/\n       index_name, column_position, column_expression  FROM sys.all_ind_expressions WHERE table_owner = ? AND table_name = ? ", parent.getSchema(), parent);
        8 r = new 8(this, idxExpressions, wrap, parent);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        return idxExpressions;
    }

    public static SQLFragment createExpression(String exp, Relation parent, DBObjectProvider pro) {
        if (ModelUtil.hasLength((String)exp)) {
            Column c = parent.getColumn(pro.getInternalName(exp));
            if (c != null && c.getID() != null) {
                ColumnUsage cu = new ColumnUsage(c.getID());
                cu.setProvider(pro);
                return cu;
            }
            SQLQueryBuilder b = SQLQueryBuilderFactory.createBuilder((DBObjectProvider)pro, (Schema)parent.getSchema());
            if (b instanceof AbstractSQLQueryBuilder) {
                AbstractSQLQueryBuilder builder = (AbstractSQLQueryBuilder)b;
                try {
                    builder.setSingleRelation(parent);
                    builder.buildQuery("SELECT " + exp + " FROM " + parent.getName());
                    SelectObject so = builder.getSQLQuery().getSelectObjects()[0];
                    SQLFragment frag = so.getExpression();
                    so.setExpression(null);
                    frag.setParent(null);
                    OracleIndexBuilder.resetFromObjectIDs(frag);
                    SQLFragment sQLFragment = frag;
                    return sQLFragment;
                }
                catch (SQLQueryException e) {
                    boolean i = false;
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
        }
        return new SimpleSQLFragment(exp);
    }

    private static void resetFromObjectIDs(SQLFragment frag) {
        if (frag instanceof ColumnUsage) {
            ((ColumnUsage)frag).setFromObjectID(null);
        }
        DBObject[] dBObjectArray = frag.getOwnedObjects();
        int n = 0;
        while (n < dBObjectArray.length) {
            DBObject kid = dBObjectArray[n];
            if (kid instanceof SQLFragment) {
                OracleIndexBuilder.resetFromObjectIDs((SQLFragment)kid);
            }
            ++n;
        }
    }

    private String getIndexColumnQuery() {
        int databaseType = this.getDatabase().getOracleDatabaseType();
        return databaseType == 9 ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_COLUMN_PER_TAB_QUERY*/\n       INDEX_NAME, COLUMN_NAME, COLUMN_POSITION, NULL, 0 FROM SYS.ALL_IND_COLUMNS WHERE TABLE_OWNER = ? AND TABLE_NAME = ? ORDER BY INDEX_NAME, COLUMN_POSITION" : "SELECT /*OracleDictionaryQueries.ALL_INDEX_COLUMN_PER_TAB_QUERY*/\n       c.index_name, c.column_name, c.column_position, c.descend,   ( SELECT 1     FROM   sys.all_ind_expressions e     WHERE  e.index_name  = c.index_name     AND    e.index_owner = c.index_owner     AND    e.column_position = c.column_position ) col_expr_exists FROM sys.all_ind_columns c  WHERE c.table_owner = ? AND c.table_name  = ? ORDER BY c.index_name, c.column_position ";
    }

    private String getTableIndexesQuery(boolean isDefaultUser) {
        int databaseType = this.getDatabase().getOracleDatabaseType();
        return databaseType == 9 ? " SELECT /*OracleDictionaryQueries.ALL_INDEX_OLITE_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER, null OBJECT_ID,       i.UNIQUENESS, 'NORMAL', null, null, null, null, null, null,        null TABLESPACE_NAME, null PCT_FREE, null PCT_USED, null INI_TRANS, null MAX_TRANS,\n       null INITIAL_EXTENT, null NEXT_EXTENT, null MIN_EXTENTS, null MAX_EXTENTS, null PCT_INCREASE,\n       null FREELISTS, null FREELIST_GROUPS, null LOGGING, null BUFFER_POOL\n FROM ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ?" : (isDefaultUser ? "SELECT /*OracleDictionaryQueries.ALL_INDEX_PER_TAB_QUERY*/\n       i.INDEX_NAME, i.OWNER,       (select object_id from all_objects where object_name = i.index_name and owner = i.owner and object_type = 'INDEX') OBJECT_ID,       i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME, i.PARAMETERS, i.DOMIDX_OPSTATUS, i.DEGREE, i.PREFIX_LENGTH,        i.TABLESPACE_NAME, i.PCT_FREE, null PCT_USED, i.INI_TRANS, i.MAX_TRANS,\n       i.INITIAL_EXTENT, i.NEXT_EXTENT, i.MIN_EXTENTS, i.MAX_EXTENTS, i.PCT_INCREASE,\n       i.FREELISTS, i.FREELIST_GROUPS, i.LOGGING, i.BUFFER_POOL\nFROM ALL_INDEXES i WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ? AND GENERATED = 'N'" : " SELECT /*OracleDictionaryQueries.ALL_INDEX_PER_TAB_OTHER_USER_QUERY*/\n       i.INDEX_NAME, i.OWNER, null OBJECT_ID,       i.UNIQUENESS, i.INDEX_TYPE, i.ITYP_OWNER, i.ITYP_NAME, i.PARAMETERS, i.DOMIDX_OPSTATUS, i.DEGREE, i.PREFIX_LENGTH,        i.TABLESPACE_NAME, i.PCT_FREE, null PCT_USED, i.INI_TRANS, i.MAX_TRANS,\n       i.INITIAL_EXTENT, i.NEXT_EXTENT, i.MIN_EXTENTS, i.MAX_EXTENTS, i.PCT_INCREASE,\n       i.FREELISTS, i.FREELIST_GROUPS, i.LOGGING, i.BUFFER_POOL\n FROM ALL_INDEXES i  WHERE TABLE_OWNER = ? AND TABLE_TYPE = ? AND TABLE_NAME = ? AND GENERATED = 'N' ");
    }

    private void setIndexType(Index index, String uniqueness, String indexType, String itypOwner, String itypName, String itypParameters, String domIdxopStatus) {
        if (UNIQUE.equals(uniqueness)) {
            index.setIndexType(Index.IndexType.UNIQUE);
        } else if (indexType != null && indexType.contains(BITMAP)) {
            index.setIndexType(Index.IndexType.BITMAP);
        } else if (indexType != null && indexType.contains(NORMAL)) {
            index.setIndexType(Index.IndexType.NORMAL);
        } else if (DOMAIN.equals(indexType)) {
            index.setIndexType(Index.IndexType.DOMAIN);
            index.setDomainIndextype((DBObjectID)new ReferenceID("INDEXTYPE", itypOwner, itypName));
            index.setDomainIndextypeParameters(itypParameters);
            index.setDomainIndextypeOpStatus(domIdxopStatus);
        }
    }

    private void removeSystemIndexes(Relation parent, Collection<Index> indexes) throws DBException {
        Iterator<Index> idx = indexes.iterator();
        while (idx.hasNext()) {
            Index index = idx.next();
            Constraint c = parent.getConstraint(index.getName());
            if (c != null) {
                if (!c.isEnabled()) continue;
                idx.remove();
                continue;
            }
            if (parent instanceof MaterializedView && this.m_matViewUsingIndexIndexName != null && index.getName().equals(this.m_matViewUsingIndexIndexName)) {
                idx.remove();
                continue;
            }
            IndexObject[] expressions = index.getColumnExpressions();
            boolean sysColumnBasedIndex = false;
            int i = 0;
            while (i < expressions.length && !sysColumnBasedIndex) {
                String expression;
                String string = expression = expressions[i].getExpression() != null ? expressions[i].getExpression().getSQLText() : null;
                if (expression != null) {
                    try {
                        for (String[] nameComponents : ParserUtils.getColumnNames((String)expression, (ParserUtils.ExpressionType)ParserUtils.ExpressionType.ARITHMETIC)) {
                            if (!nameComponents[0].startsWith("SYS_NC")) continue;
                            idx.remove();
                            sysColumnBasedIndex = true;
                            break;
                        }
                    }
                    catch (SQLQueryException e) {
                        throw new DBException((DBObject)index, DBArb.format((int)117, (Object[])new Object[]{index.getName(), expression}));
                    }
                }
                ++i;
            }
        }
    }

    public void setMatViewUsingIndexIndexName(String matViewUsingIndexIndexName) {
        this.m_matViewUsingIndexIndexName = matViewUsingIndexIndexName;
    }

    static void mav$setSubpartitionIDs(OracleIndexBuilder oracleIndexBuilder, IndexPartition indexPartition) {
        oracleIndexBuilder.setSubpartitionIDs(indexPartition);
    }

    static DBObjectID[] mav$getGlobalPartitionColumns(OracleIndexBuilder oracleIndexBuilder, Index index) {
        return oracleIndexBuilder.getGlobalPartitionColumns(index);
    }

    static void mav$fillInIndexPartitions(OracleIndexBuilder oracleIndexBuilder, Index index) {
        oracleIndexBuilder.fillInIndexPartitions(index);
    }

    static void mav$markAsBuilt(OracleIndexBuilder oracleIndexBuilder, AbstractSchemaObject abstractSchemaObject) {
        oracleIndexBuilder.markAsBuilt(abstractSchemaObject);
    }

    static void mav$setIndexType(OracleIndexBuilder oracleIndexBuilder, Index index, String string, String string2, String string3, String string4, String string5, String string6) {
        oracleIndexBuilder.setIndexType(index, string, string2, string3, string4, string5, string6);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ String[] v$details;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Index v$index;
        final /* synthetic */ OracleIndexBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$details[0] = rs.getString(1);
                    this.v$details[1] = rs.getString(2);
                    this.v$details[2] = rs.getString(3);
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$index, sqe);
            }
        }

        public 1(OracleIndexBuilder oracleIndexBuilder, String[] stringArray, QueryWrapper queryWrapper, Index index) {
            this.v$index = index;
            this.v$wrap = queryWrapper;
            this.v$details = stringArray;
            this.this$0 = oracleIndexBuilder;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ SchemaObject v$parent;
        private final /* synthetic */ Map v$indexes;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleIndexBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String idxName = rs.getString(1);
                    String owner = rs.getString(2);
                    Schema s = this.this$0.getDatabase().getSchema(owner);
                    Index index = (Index)this.this$0.getDatabase().findObject("INDEX", s, idxName);
                    if (index == null) {
                        int idInt = rs.getInt(3);
                        DBObjectID id = this.this$0.getDatabase().createID(s, idxName, "INDEX", rs.wasNull() ? null : Integer.valueOf(idInt));
                        index = (Index)this.this$0.createObject(idxName, s, id);
                        this.this$0.getDatabase().cacheObject((SchemaObject)index, true);
                    }
                    if (index == null) continue;
                    OracleIndexBuilder.mav$markAsBuilt(this.this$0, (AbstractSchemaObject)index);
                    String uniqueness = rs.getString(4);
                    String indexType = rs.getString(5);
                    String itypOwner = rs.getString(6);
                    String itypName = rs.getString(7);
                    String itypParameters = rs.getString(8);
                    String domIdxOpStatus = rs.getString(9);
                    String degree = rs.getString(10);
                    String prefix_length = rs.getString(11);
                    OracleIndexBuilder.mav$setIndexType(this.this$0, index, uniqueness, indexType, itypOwner, itypName, itypParameters, domIdxOpStatus);
                    int parallelDegree = ModelUtil.hasLength((String)degree) ? ("DEFAULT".equals(degree) ? 0 : Integer.decode(degree)) : 1;
                    index.setParallelDegree(parallelDegree);
                    if (ModelUtil.hasLength((String)prefix_length)) {
                        index.setKeyCompression(Integer.valueOf(prefix_length));
                    } else {
                        index.setKeyCompression(null);
                    }
                    OracleStorageProperties osp = OracleTableBuilder.getSegmentAttributeProperties(rs);
                    index.setProperty("OracleStorageProperties", (Object)osp);
                    index.setColumnExpressions(null);
                    if (this.v$parent instanceof Table) {
                        index.setTable((Table)this.v$parent);
                    }
                    this.v$indexes.put(idxName, index);
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$parent, sqe);
            }
        }

        public 2(OracleIndexBuilder oracleIndexBuilder, SchemaObject schemaObject, Map map, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$indexes = map;
            this.v$parent = schemaObject;
            this.this$0 = oracleIndexBuilder;
        }
    }

    final class 3
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Index v$index;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Table v$table;
        final /* synthetic */ OracleIndexBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String partitioningType = rs.getString("PARTITIONING_TYPE");
                    String subpartitioningType = rs.getString("SUBPARTITIONING_TYPE");
                    String locality = rs.getString("LOCALITY");
                    String partitionCount = rs.getString("PARTITION_COUNT");
                    if ("SYSTEM".equals(partitioningType)) continue;
                    OracleIndexPartitions oip = new OracleIndexPartitions();
                    this.v$index.setProperty("OracleIndexPartitions", (Object)oip);
                    NameBasedID id = new NameBasedID((DBObject)oip, this.v$index.getID());
                    oip.setID((DBObjectID)id);
                    OracleIndexPartitions.PartitionType partitionType = this.v$index.getIndexType() == Index.IndexType.DOMAIN ? OracleIndexPartitions.PartitionType.DOMAIN : ("GLOBAL".equals(locality) ? OracleIndexPartitions.PartitionType.valueOf((String)(locality + '_' + partitioningType)) : ("HASH".equals(partitioningType) ? OracleIndexPartitions.PartitionType.LOCAL_HASH : ("NONE".equals(subpartitioningType) ? OracleIndexPartitions.PartitionType.LOCAL_OTHER : OracleIndexPartitions.PartitionType.LOCAL_COMP)));
                    oip.setPartitionType(partitionType);
                    if ("GLOBAL".equals(locality)) {
                        oip.setGlobalPartitionColumns(OracleIndexBuilder.mav$getGlobalPartitionColumns(this.this$0, this.v$index));
                        Integer guantity = partitionCount != null || partitionCount != "" ? Integer.decode(partitionCount) : 0;
                        if ("HASH".equals(partitioningType) && guantity > 0 && oip.getName().startsWith("SYS_P")) {
                            oip.setGlobalHashQuantity(guantity);
                        }
                    }
                    OracleIndexBuilder.mav$fillInIndexPartitions(this.this$0, this.v$index);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$table, ex);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }

        public 3(OracleIndexBuilder oracleIndexBuilder, Index index, QueryWrapper queryWrapper, Table table) {
            this.v$table = table;
            this.v$wrap = queryWrapper;
            this.v$index = index;
            this.this$0 = oracleIndexBuilder;
        }
    }

    final class 4
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ List v$columnIDs;
        private final /* synthetic */ Table v$table;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleIndexBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String columnName = rs.getString(1);
                    this.v$columnIDs.add(new NameBasedID("COLUMN", columnName, this.v$table.getID()));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$table, ex);
            }
        }

        public 4(OracleIndexBuilder oracleIndexBuilder, List list, Table table, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$table = table;
            this.v$columnIDs = list;
            this.this$0 = oracleIndexBuilder;
        }
    }

    final class 5
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ OracleIndexPartitions v$oip;
        private final /* synthetic */ OracleIndexPartitions.PartitionType v$partitionType;
        private final /* synthetic */ Map v$subpartitionsMap;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Index v$index;
        final /* synthetic */ OracleIndexBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String name = rs.getString("PARTITION_NAME");
                    IndexPartition ip = new IndexPartition(name, this.v$oip);
                    this.v$oip.addPartition(ip);
                    NameBasedID id = new NameBasedID((DBObject)ip, this.v$oip.getID());
                    ip.setID((DBObjectID)id);
                    if (this.v$partitionType == OracleIndexPartitions.PartitionType.LOCAL_COMP || this.v$partitionType == OracleIndexPartitions.PartitionType.LOCAL_OTHER) {
                        String compression = rs.getString("COMPRESSION");
                        Boolean keyCompression = rs.wasNull() || !ModelUtil.hasLength((String)compression) ? null : Boolean.valueOf("ENABLED".equals(compression));
                        ip.setKeyCompression(keyCompression);
                    }
                    if (this.v$partitionType == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                        String highValue = rs.getString("HIGH_VALUE");
                        ip.setValuesLessThan(highValue);
                    }
                    if (this.v$partitionType == OracleIndexPartitions.PartitionType.GLOBAL_HASH || this.v$partitionType == OracleIndexPartitions.PartitionType.LOCAL_HASH) {
                        String tablespaceName = rs.getString("TABLESPACE_NAME");
                        if (ModelUtil.hasLength((String)tablespaceName)) {
                            OracleStorageProperties osp = new OracleStorageProperties();
                            ip.setSegmentAttributes(osp);
                            osp.setTablespace(tablespaceName);
                        }
                    } else if (this.v$partitionType == OracleIndexPartitions.PartitionType.DOMAIN) {
                        ip.setDomainParameters(rs.getString("PARAMETERS"));
                    } else {
                        ip.setSegmentAttributes(OracleTableBuilder.getSegmentAttributeProperties(rs));
                    }
                    if (this.v$subpartitionsMap == null || !this.v$subpartitionsMap.containsKey(name)) continue;
                    ip.setSubpartitions((OracleIndexPartitions)this.v$subpartitionsMap.get(name));
                    OracleIndexBuilder.mav$setSubpartitionIDs(this.this$0, ip);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$index, ex);
            }
        }

        public 5(OracleIndexBuilder oracleIndexBuilder, OracleIndexPartitions oracleIndexPartitions, OracleIndexPartitions.PartitionType partitionType, Map map, QueryWrapper queryWrapper, Index index) {
            this.v$index = index;
            this.v$wrap = queryWrapper;
            this.v$subpartitionsMap = map;
            this.v$partitionType = partitionType;
            this.v$oip = oracleIndexPartitions;
            this.this$0 = oracleIndexBuilder;
        }
    }

    final class 6
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Map v$map;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ Index v$index;
        final /* synthetic */ OracleIndexBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            String currentPartitionName = null;
            OracleIndexPartitions subpartitions = null;
            try {
                while (rs.next()) {
                    String name = rs.getString("PARTITION_NAME");
                    if (!name.equals(currentPartitionName)) {
                        subpartitions = new OracleIndexPartitions(OracleIndexPartitions.PartitionType.SUBPARTITION);
                        this.v$map.put(name, subpartitions);
                        currentPartitionName = name;
                    }
                    IndexPartition sp = new IndexPartition(rs.getString("SUBPARTITION_NAME"), subpartitions);
                    subpartitions.addPartition(sp);
                    name = rs.getString("TABLESPACE_NAME");
                    if (!ModelUtil.hasLength((String)name)) continue;
                    OracleStorageProperties osp = new OracleStorageProperties();
                    sp.setSegmentAttributes(osp);
                    osp.setTablespace(name);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$index, ex);
            }
        }

        public 6(OracleIndexBuilder oracleIndexBuilder, Map map, QueryWrapper queryWrapper, Index index) {
            this.v$index = index;
            this.v$wrap = queryWrapper;
            this.v$map = map;
            this.this$0 = oracleIndexBuilder;
        }
    }

    final class 7
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Collection v$indexCols;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ SchemaObject v$parent;
        final /* synthetic */ OracleIndexBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    this.v$indexCols.add(this.this$0.new IndexColumnQueryResult(rs, null));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$parent, ex);
            }
        }

        public 7(OracleIndexBuilder oracleIndexBuilder, Collection collection, QueryWrapper queryWrapper, SchemaObject schemaObject) {
            this.v$parent = schemaObject;
            this.v$wrap = queryWrapper;
            this.v$indexCols = collection;
            this.this$0 = oracleIndexBuilder;
        }
    }

    final class 8
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Map v$idxExpressions;
        private final /* synthetic */ QueryWrapper v$wrap;
        private final /* synthetic */ SchemaObject v$parent;
        final /* synthetic */ OracleIndexBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String idxName = rs.getString(1);
                    Long colPosn = new Long(rs.getInt(2));
                    String colExpr = rs.getString(3);
                    HashMap<Long, String> columnMap = (HashMap<Long, String>)this.v$idxExpressions.get(idxName);
                    if (columnMap == null) {
                        columnMap = new HashMap<Long, String>();
                        this.v$idxExpressions.put(idxName, columnMap);
                    }
                    columnMap.put(colPosn, colExpr);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$parent, ex);
            }
        }

        public 8(OracleIndexBuilder oracleIndexBuilder, Map map, QueryWrapper queryWrapper, SchemaObject schemaObject) {
            this.v$parent = schemaObject;
            this.v$wrap = queryWrapper;
            this.v$idxExpressions = map;
            this.this$0 = oracleIndexBuilder;
        }
    }

    private class IndexColumnQueryResult {
        String idxName;
        String colName;
        Long colPosn;
        String colDesc;
        int isAllIndExp;

        private IndexColumnQueryResult(ResultSet rs) throws SQLException {
            this.idxName = rs.getString(1);
            this.colName = rs.getString(2);
            this.colPosn = new Long(rs.getInt(3));
            this.colDesc = rs.getString(4);
            this.isAllIndExp = rs.getInt(5);
        }

        public String toString() {
            return "\n" + this.idxName + " " + this.colName + " " + this.colPosn + " " + this.colDesc + " " + this.isAllIndExp + "\n";
        }

        IndexColumnQueryResult(ResultSet resultSet, 7 var3_3) {
            this(resultSet);
        }
    }
}

