/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.BinaryDataType;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.ora.BaseOracleDatabase;

public class OracleLite
extends BaseOracleDatabase {
    public static final String ORACLE_LITE_DATABASE_TYPE = "Oracle Lite";
    public static final String[] OLITE_SCHEMA_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM"};
    public static final String[] OLITE_OBJECT_TYPES = new String[]{"TABLE", "VIEW", "SEQUENCE", "SYNONYM", "INDEX"};

    OracleLite(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    public int getOracleDatabaseType() {
        return 9;
    }

    public String getDatabaseType() {
        return ORACLE_LITE_DATABASE_TYPE;
    }

    public boolean supportsJava() {
        return false;
    }

    public boolean supportsPartitioning() {
        return false;
    }

    protected Schema createSchema(Connection conn) {
        try {
            Schema schema = this.createSchema(conn.getMetaData().getUserName());
            return schema;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    protected boolean isSupportedType(String type) {
        return OracleLite.isOLiteType(type);
    }

    static boolean isOLiteType(String type) {
        int i = 0;
        while (i < OLITE_OBJECT_TYPES.length) {
            if (OLITE_OBJECT_TYPES[i].equalsIgnoreCase(type)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static class Registerer
    extends DataTypeRegistry.Registerer {
        public void registerDataTypes(DataTypeRegistry dtr) {
            NumericDataType BIGINT = new NumericDataType(65535, "BIGINT", NumericDataType.MIN_MAX_BIGINT);
            NumericDataType INTEGER = new NumericDataType(65535, "INTEGER", NumericDataType.MIN_MAX_INT);
            NumericDataType SMALLINT = new NumericDataType(65535, "SMALLINT", NumericDataType.MIN_MAX_SMALLINT);
            NumericDataType TINYINT = new NumericDataType(65535, "TINYINT", NumericDataType.MIN_MAX_SIGNED_TINYINT);
            NumericDataType DECIMAL = new NumericDataType(65535, "DECIMAL", "DECIMAL[(<precision>[, <scale>])]", 0L, (long)38, null, false, 0L, null, BaseOracleDatabase.LONG_0, false, null, null);
            NumericDataType NUMERIC = new NumericDataType(65535, "NUMERIC", "NUMERIC[(<precision>[, <scale>])]", 0L, (long)38, null, false, 0L, null, BaseOracleDatabase.LONG_0, false, null, null);
            NumericDataType NUMBER = new NumericDataType(65535, "NUMBER", "NUMBER[(<precision>[, <scale>])]", 0L, (long)38, null, false, 0L, null, BaseOracleDatabase.LONG_0, false, null, null);
            NumericDataType DOUBLE = new NumericDataType(65535, "DOUBLE", new NumericDataType.MinMaxValue("1.0E-308", "1.0E+308", 2));
            NumericDataType FLOAT = new NumericDataType(65535, "FLOAT", "FLOAT[(<precision>)]", 1L, (long)53, null, false, null, new NumericDataType.MinMaxValue("1.0E-308", "1.0E+308", 2));
            NumericDataType REAL = new NumericDataType(65535, "REAL", new NumericDataType.MinMaxValue("1.0E-38", "1.0E+38", 2));
            dtr.registerDataType((DataType)BIGINT, OracleLite.class, JdbcDatabase.ANSI_BIGINT);
            dtr.registerDataType((DataType)INTEGER, OracleLite.class, JdbcDatabase.ANSI_INTEGER);
            dtr.registerDataType((DataType)SMALLINT, OracleLite.class, JdbcDatabase.ANSI_SMALLINT);
            dtr.registerDataType((DataType)TINYINT, OracleLite.class, JdbcDatabase.ANSI_SMALLINT);
            dtr.registerDataType((DataType)DECIMAL, OracleLite.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)NUMERIC, OracleLite.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)NUMBER, OracleLite.class, JdbcDatabase.ANSI_DECIMAL);
            dtr.registerDataType((DataType)DOUBLE, OracleLite.class, JdbcDatabase.ANSI_DOUBLE_PRECISION);
            dtr.registerDataType((DataType)FLOAT, OracleLite.class, JdbcDatabase.ANSI_FLOAT);
            dtr.registerDataType((DataType)REAL, OracleLite.class, JdbcDatabase.ANSI_REAL);
            dtr.registerSynonym("DEC", (DataType)DECIMAL, OracleLite.class);
            dtr.registerSynonym("INT", (DataType)INTEGER, OracleLite.class);
            dtr.registerSynonym("DOUBLE PRECISION", (DataType)DOUBLE, OracleLite.class);
            CharacterDataType CHAR = new CharacterDataType(65535, "CHAR", "CHAR[(<size>)]", 1L, 4096L, 1L, false, null);
            CharacterDataType LONG = new CharacterDataType(65535, "LONG", 1L, 2000000000L);
            CharacterDataType VARCHAR = new CharacterDataType(65535, "VARCHAR", "VARCHAR(<size>)", 1L, 4096L, 4096L, true, null);
            CharacterDataType VARCHAR2 = new CharacterDataType(65535, "VARCHAR2", "VARCHAR2(<size>)", 1L, 4096L, 4096L, true, null);
            CharacterDataType LONG_VARCHAR = new CharacterDataType(65535, "LONG VARCHAR", "LONG VARCHAR[(<size>)]", 1L, 2000000000L, 2000000000L, false, null);
            CharacterDataType CLOB = new CharacterDataType(1, "CLOB", 1L, 2000000000L);
            dtr.registerDataType((DataType)CHAR, OracleLite.class, JdbcDatabase.ANSI_CHAR);
            dtr.registerDataType((DataType)LONG, OracleLite.class, JdbcDatabase.ANSI_CLOB);
            dtr.registerDataType((DataType)CLOB, OracleLite.class, JdbcDatabase.ANSI_CLOB);
            dtr.registerDataType((DataType)VARCHAR, OracleLite.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dtr.registerDataType((DataType)VARCHAR2, OracleLite.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dtr.registerDataType((DataType)LONG_VARCHAR, OracleLite.class, JdbcDatabase.ANSI_CHARACTER_VARYING);
            dtr.registerSynonym("CHARACTER", (DataType)CHAR, OracleLite.class);
            DataTypeAttribute fractionalPrecision = new DataTypeAttribute("precision", 368, 0L, BaseOracleDatabase.LONG_6, BaseOracleDatabase.LONG_6, false);
            PredefinedDataType DATE = new PredefinedDataType(65535, "DATE");
            PredefinedDataType TIME = new PredefinedDataType(65535, "TIME", "TIME[(<precision>)]", new DataTypeAttribute[]{fractionalPrecision});
            PredefinedDataType TIMESTAMP = new PredefinedDataType(65535, "TIMESTAMP", "TIMESTAMP[(<precision>)]", new DataTypeAttribute[]{fractionalPrecision});
            dtr.registerDataType((DataType)DATE, OracleLite.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)TIME, OracleLite.class, JdbcDatabase.ANSI_TIMESTAMP);
            dtr.registerDataType((DataType)TIMESTAMP, OracleLite.class, JdbcDatabase.ANSI_TIMESTAMP);
            BinaryDataType BINARY = new BinaryDataType(1, "BINARY", "BINARY[(<size>)]", 0L, 4096L, 4096L, false, null);
            BinaryDataType VARBINARY = new BinaryDataType(1, "VARBINARY", "VARBINARY[(<size>)]", 0L, 4096L, 4096L, false, null);
            BinaryDataType RAW = new BinaryDataType(1, "RAW", "RAW[(<size>)]", 0L, 4096L, 4096L, false, null);
            BinaryDataType LONG_RAW = new BinaryDataType(1, "LONG RAW", "LONG RAW[(<size>)]", 1L, 2000000000L, 2000000000L, false, null);
            BinaryDataType LONG_VARBINARY = new BinaryDataType(1, "LONG VARBINARY", "LONG VARBINARY[(<size>)]", 1L, 2000000000L, 2000000000L, false, null);
            BinaryDataType BLOB2 = new BinaryDataType(1, "BLOB", 1L, 2000000000L);
            BinaryDataType ROWID = new BinaryDataType(1, "ROWID");
            BinaryDataType BIT = new BinaryDataType(1, "BIT");
            dtr.registerDataType((DataType)BINARY, OracleLite.class);
            dtr.registerDataType((DataType)VARBINARY, OracleLite.class);
            dtr.registerDataType((DataType)RAW, OracleLite.class);
            dtr.registerDataType((DataType)LONG_RAW, OracleLite.class);
            dtr.registerDataType((DataType)LONG_VARBINARY, OracleLite.class);
            dtr.registerDataType((DataType)BLOB2, OracleLite.class, JdbcDatabase.ANSI_BLOB);
            dtr.registerDataType((DataType)ROWID, OracleLite.class);
            dtr.registerDataType((DataType)BIT, OracleLite.class, JdbcDatabase.ANSI_BIT);
        }

        Registerer() {
        }
    }
}

