/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.PlSqlSourceBuilder;

class OracleObjectTypeBuilder
extends PlSqlSourceBuilder {
    private static final int TQ_SELECT_TYPECODE = 1;
    private static final int TQ_SELECT_COLLTYPE = 2;

    public OracleObjectTypeBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
        if (!"TYPE".equals(type)) {
            throw new IllegalArgumentException("Illegal object type: " + type);
        }
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        super.fillInObject(object);
        ComplexType type = (ComplexType)object;
        QueryWrapper wrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_OBJECT_TYPE_ORACLE8_QUERY*/\n       T.TYPECODE ,      (SELECT CT.COLL_TYPE         FROM ALL_COLL_TYPES CT         WHERE CT.OWNER = T.OWNER         AND CT.TYPE_NAME = T.TYPE_NAME) COLLTYPE FROM   ALL_TYPES T WHERE  T.OWNER = ? AND T.TYPE_NAME = ? ", type.getSchema(), type);
        1 r = new 1(this, type, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ ComplexType v$type;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleObjectTypeBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    String typeString = rs.getString(1);
                    this.v$type.setTypeCode(typeString);
                    String collTypeString = rs.getString(2);
                    if (collTypeString == null) {
                        collTypeString = "";
                    }
                    this.v$type.setCollectionType(collTypeString);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$type, ex);
            }
        }

        public 1(OracleObjectTypeBuilder oracleObjectTypeBuilder, ComplexType complexType, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$type = complexType;
            this.this$0 = oracleObjectTypeBuilder;
        }
    }
}

