/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.CheckConstraint;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class OracleRelationBuilder
extends OracleDBObjectBuilder {
    private static final String ORACLE8i_NOT_NULL_COND = "\"{0}\" IS NOT NULL";
    private static final String ORACLE7_NOT_NULL_COND = "{0} IS NOT NULL";
    private static final char PK_TYPE = 'P';
    private static final char FK_TYPE = 'R';
    private static final char UNIQUE_TYPE = 'U';
    private static final char CHECK_TYPE = 'C';

    protected OracleRelationBuilder(BaseOracleDatabase db, String type) {
        super(db, type);
    }

    protected void fillInObject(SchemaObject obj) throws DBException {
        Relation rel = (Relation)obj;
        if (this.needsBuilding((AbstractSchemaObject)rel, "Comment")) {
            this.fillInComment(rel);
        }
        if (this.needsBuilding((AbstractSchemaObject)rel, "COLUMN")) {
            this.fillInColumns(rel);
        }
        if (this.needsBuilding((AbstractSchemaObject)rel, "CONSTRAINT")) {
            this.fillInConstraints(rel);
        }
    }

    protected void fillInComment(Relation rel) throws DBException {
        QueryWrapper wrap = rel instanceof MaterializedView && this.getProvider() instanceof Oracle10g ? this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_MVIEW_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_MVIEW_COMMENTS WHERE OWNER = ? AND MVIEW_NAME = ?", rel.getSchema(), rel) : (rel instanceof MaterializedView ? this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?", rel.getSchema(), rel, "TABLE") : this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_TABLE_COMMENT_QUERY*/\n       COMMENTS FROM SYS.ALL_TAB_COMMENTS WHERE OWNER = ? AND TABLE_NAME = ? AND TABLE_TYPE = ?", rel.getSchema(), rel, this.getObjectType()));
        1 r = new 1(this, rel, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    protected void fillInColumns(Relation relation) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        int databaseType = db.getOracleDatabaseType();
        String query = OracleRelationBuilder.getColumnQuery(databaseType);
        relation.setColumns(new Column[0]);
        HashMap<Column, String> complexCols = new HashMap<Column, String>();
        QueryWrapper wrap = this.newQueryWrapper(query, relation.getSchema(), relation);
        2 r = new 2(this, relation, complexCols, db, wrap);
        wrap.executeQuery(100, (QueryWrapper.QueryRunnable)r);
        if (complexCols.size() > 0) {
            this.populateComplexColumnTypes(relation, complexCols);
        }
    }

    private void populateComplexColumnTypes(Relation relation, Map<Column, String> complexCols) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        for (Map.Entry<Column, String> entry : complexCols.entrySet()) {
            Column col = entry.getKey();
            String typeName = entry.getValue();
            DataType dataType = null;
            try {
                int split = typeName.indexOf(46);
                String schemaName = typeName.substring(0, split);
                String objName = typeName.substring(split + 1, typeName.length());
                dataType = (ComplexType)db.getObject("TYPE", new Schema(schemaName), objName);
                if (dataType == null) {
                    DBObject o;
                    Synonym s = (Synonym)db.getObject("SYNONYM", new Schema(schemaName), objName);
                    if (s == null) {
                        s = (Synonym)db.getObject("SYNONYM", new Schema("PUBLIC"), objName);
                    }
                    if (s != null && s.getReference() != null && (o = s.getReference().resolveID()) instanceof DataType) {
                        dataType = (DataType)o;
                    }
                }
            }
            catch (DBException dbe) {
                DBLog.logStackTrace((Throwable)dbe);
            }
            if (dataType == null) {
                dataType = db.getDataType(typeName);
            }
            dataType.getProperty("test");
            HashMap attributes = new HashMap();
            if (dataType instanceof ComplexType && ((ComplexType)dataType).getCollectionType().equals("TABLE")) {
                QueryWrapper cuWrap = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_COLUMN_NESTED_TAB_QUERY*/\n       ANT.TABLE_NAME NESTED_TABLE \n,      TRIM(ANT.RETURN_TYPE) \nFROM   ALL_NESTED_TABLES ANT \nWHERE  ANT.OWNER = ? \nAND    ANT.PARENT_TABLE_NAME = ? \nAND    ANT.PARENT_TABLE_COLUMN = ? \n", relation.getSchema(), relation, col);
                3 r = new 3(this, col, cuWrap);
                cuWrap.executeQuery((QueryWrapper.QueryRunnable)r);
            }
            col.setDataTypeUsage(dataType.createUsage(attributes));
        }
    }

    private boolean isCharType(String typeName) {
        return typeName.equals("CHAR") || typeName.equals("NCHAR") || typeName.equals("VARCHAR2") || typeName.equals("NVARCHAR2");
    }

    private void fillInConstraints(Relation relation) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        String query = OracleRelationBuilder.getConstraintQuery(db.getOracleDatabaseType());
        if (!db.getDefaultSchema().equals((Object)relation.getSchema())) {
            Pattern p1 = Pattern.compile("USER_CONSTRAINTS", 2);
            query = p1.matcher(query).replaceAll("ALL_CONSTRAINTS");
            Pattern p2 = Pattern.compile("USER_CONS_COLUMNS", 2);
            query = p2.matcher(query).replaceAll("ALL_CONS_COLUMNS");
        }
        QueryWrapper wrap = this.newQueryWrapper(query, relation.getSchema(), relation);
        4 r = new 4(this, relation, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private static int _translateDeleteAction(String action) {
        int result = 0;
        if ("CASCADE".equals(action)) {
            result = 1;
        } else if ("SET NULL".equals(action)) {
            result = 2;
        }
        return result;
    }

    private static String getColumnQuery(int type) {
        String query = null;
        switch (type) {
            case 9: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_OLITE_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER(+) \nAND   C.TABLE_NAME = CMT.TABLE_NAME(+) \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME(+) \nORDER BY COLUMN_ID \n";
                break;
            }
            case 0: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE7_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, null,        DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE,        DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null FROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
                break;
            }
            case 1: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, DATA_LENGTH, DATA_DEFAULT, COMMENTS, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? \nAND   C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
                break;
            }
            case 2: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_ORACLE8i_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, CHAR_COL_DECL_LENGTH, DATA_DEFAULT, COMMENTS, null \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID \n";
                break;
            }
            default: {
                query = "SELECT /*OracleDictionaryQueries.ALL_COLUMN_QUERY*/\n       C.COLUMN_NAME, DATA_TYPE, DATA_TYPE_OWNER, \n       DATA_LENGTH, DATA_PRECISION, DATA_SCALE, NULLABLE, \n       DEFAULT_LENGTH, CHAR_LENGTH, DATA_DEFAULT, COMMENTS \n    , decode(CHAR_USED, 'B', 'BYTE', 'C', 'CHAR', null) \nFROM SYS.ALL_TAB_COLUMNS C, SYS.ALL_COL_COMMENTS CMT \nWHERE C.OWNER = ? AND C.TABLE_NAME = ? \nAND   C.OWNER = CMT.OWNER \nAND   C.TABLE_NAME = CMT.TABLE_NAME \nAND   C.COLUMN_NAME = CMT.COLUMN_NAME \nORDER BY COLUMN_ID\n";
                break;
            }
        }
        return query;
    }

    private static String getConstraintQuery(int type) {
        return type == 9 ? "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_OLITE_QUERY*/\n        A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER, \n        A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, 'GENERATED NAME' GENERATED, \n        B.COLUMN_NAME,  \n        ( SELECT D.CONSTRAINT_TYPE  \n          FROM SYS.ALL_CONSTRAINTS D  \n          WHERE D.OWNER = A.R_OWNER  \n          AND   D.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME  ) ref_constraint_type, \n        null                                               ref_relation_object_id, \n        ( SELECT 'TABLE' \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_TABLES      BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.TABLE_NAME \n         UNION\n          SELECT 'VIEW' \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_VIEWS       BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_type,\n        ( SELECT AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_TABLES     BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.TABLE_NAME \n         UNION\n          SELECT AA.TABLE_NAME \n          FROM SYS.ALL_CONSTRAINTS AA \n             , SYS.ALL_VIEWS       BB \n          WHERE AA.OWNER = A.R_OWNER  \n          AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME \n          AND   AA.OWNER = BB.OWNER  \n          AND   AA.TABLE_NAME = BB.VIEW_NAME           ) ref_relation_name\nFROM SYS.ALL_CONSTRAINTS  A,  \n     SYS.ALL_CONS_COLUMNS B  \nWHERE A.OWNER           = ?  \nAND   A.TABLE_NAME      = ?  \nAND   A.OWNER           = B.OWNER  \nAND   A.CONSTRAINT_NAME = B.CONSTRAINT_NAME  \nORDER BY B.POSITION \n" : "SELECT /*OracleDictionaryQueries.ALL_CONSTRAINT_ENTERPRISE_QUERY*/\n        A.CONSTRAINT_NAME, A.CONSTRAINT_TYPE, A.SEARCH_CONDITION, A.R_OWNER,  \n       A.R_CONSTRAINT_NAME, A.DELETE_RULE, A.STATUS, A.GENERATED, B.COLUMN_NAME, \n       ( SELECT D.CONSTRAINT_TYPE \n         FROM  SYS.ALL_CONSTRAINTS D \n         WHERE D.OWNER = A.R_OWNER \n         AND   D.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ref_constraint_type, \n       ( SELECT D.TABLE_NAME \n         FROM  SYS.ALL_CONSTRAINTS D \n         WHERE D.OWNER = A.R_OWNER \n         AND   D.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ref_relation_name, \n       ( SELECT (SELECT BB.OBJECT_ID \n                 FROM SYS.ALL_OBJECTS BB \n                 WHERE AA.OWNER = BB.OWNER \n                 AND   AA.TABLE_NAME = BB.OBJECT_NAME \n                 AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n         FROM SYS.ALL_CONSTRAINTS AA \n         WHERE AA.OWNER = A.R_OWNER \n         AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME ) ref_relation_object_id, \n       ( SELECT (SELECT BB.OBJECT_TYPE \n                 FROM SYS.ALL_OBJECTS BB \n                 WHERE AA.OWNER = BB.OWNER \n                 AND   AA.TABLE_NAME = BB.OBJECT_NAME \n                 AND   BB.OBJECT_TYPE IN ('TABLE', 'VIEW') ) \n         FROM SYS.ALL_CONSTRAINTS AA \n         WHERE AA.OWNER = A.R_OWNER \n         AND   AA.CONSTRAINT_NAME = A.R_CONSTRAINT_NAME)  ref_relation_type \nFROM SYS.USER_CONSTRAINTS  A, \n     SYS.USER_CONS_COLUMNS B \nWHERE   A.OWNER           = ? \nAND     A.TABLE_NAME      = ? \nAND     A.OWNER           = B.OWNER \nAND     A.CONSTRAINT_NAME = B.CONSTRAINT_NAME \nORDER BY B.POSITION  \n";
    }

    private static String getNotNullText(int type) {
        String query = null;
        switch (type) {
            case 0: 
            case 1: 
            case 9: {
                query = ORACLE7_NOT_NULL_COND;
                break;
            }
            default: {
                query = ORACLE8i_NOT_NULL_COND;
                break;
            }
        }
        return query;
    }

    protected void fillInObjectComponent(SchemaObject object, String key) throws DBException {
        Relation rel = (Relation)object;
        if (key.equals("COLUMN")) {
            this.fillInColumns(rel);
        } else if (key.equals("CONSTRAINT")) {
            this.fillInConstraints(rel);
        } else if (key.equals("Comment")) {
            this.fillInComment(rel);
        } else {
            super.fillInObjectComponent(object, key);
        }
    }

    static String maS$getNotNullText(int n) {
        return OracleRelationBuilder.getNotNullText(n);
    }

    static int maS$_translateDeleteAction(String string) {
        return OracleRelationBuilder._translateDeleteAction(string);
    }

    static boolean mav$isCharType(OracleRelationBuilder oracleRelationBuilder, String string) {
        return oracleRelationBuilder.isCharType(string);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Relation v$rel;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleRelationBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    String com = rs.getString(1);
                    com = ModelUtil.hasLength((String)com) ? com : null;
                    this.v$rel.setProperty("Comment", (Object)com);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$rel, ex);
            }
        }

        public 1(OracleRelationBuilder oracleRelationBuilder, Relation relation, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$rel = relation;
            this.this$0 = oracleRelationBuilder;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Relation v$relation;
        private final /* synthetic */ Map v$complexCols;
        private final /* synthetic */ BaseOracleDatabase v$db;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleRelationBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                while (rs.next()) {
                    String colName = rs.getString(1);
                    Column col = new Column(colName);
                    this.v$relation.addColumn(col);
                    String typeName = rs.getString(2);
                    String typeOwner = rs.getString(3);
                    if (!rs.wasNull()) {
                        typeName = typeOwner + "." + typeName;
                    }
                    col.setNotNull(rs.getString(7).equals("N"));
                    String defValue = rs.getString(10);
                    if (defValue != null) {
                        defValue = defValue.trim();
                    }
                    col.setDefault((Object)defValue);
                    String cmt = rs.getString(11);
                    col.setProperty("Comment", (Object)cmt);
                    col.setID((DBObjectID)new NameBasedID((DBObject)col, this.v$relation.getID()));
                    if (typeName != null && typeName.indexOf(46) >= 0) {
                        this.v$complexCols.put(col, typeName);
                        continue;
                    }
                    DataType dataType = this.v$db.getDataType(typeName);
                    if (dataType == null) continue;
                    long length = rs.getLong(5);
                    Long precision = rs.wasNull() ? null : new Long(length);
                    length = OracleRelationBuilder.mav$isCharType(this.this$0, typeName) ? rs.getLong(9) : rs.getLong(4);
                    Long size = rs.wasNull() ? null : new Long(length);
                    Long scale = new Long(rs.getLong(6));
                    scale = rs.wasNull() ? null : scale;
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("name", typeName);
                    attributes.put("size", DataTypeHelper.getAttributeValue((Object)size, (DataType)dataType, (String)"size"));
                    attributes.put("precision", DataTypeHelper.getAttributeValue((Object)precision, (DataType)dataType, (String)"precision"));
                    attributes.put("scale", DataTypeHelper.getAttributeValue((Object)scale, (DataType)dataType, (String)"scale"));
                    attributes.put("unit", rs.getString(12));
                    col.setDataTypeUsage(dataType.createUsage(attributes));
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$relation, ex);
            }
        }

        public 2(OracleRelationBuilder oracleRelationBuilder, Relation relation, Map map, BaseOracleDatabase baseOracleDatabase, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$db = baseOracleDatabase;
            this.v$complexCols = map;
            this.v$relation = relation;
            this.this$0 = oracleRelationBuilder;
        }
    }

    final class 3
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Column v$col;
        private final /* synthetic */ QueryWrapper v$cuWrap;
        final /* synthetic */ OracleRelationBuilder this$0;

        public void processResultSet(ResultSet curs) throws DBException {
            try {
                if (curs.next()) {
                    OracleColumnProperties ocp = new OracleColumnProperties();
                    OracleNestedTableProperties ntp = new OracleNestedTableProperties();
                    ntp.setTableName(curs.getString(1));
                    ntp.setReturnAs(curs.getString(2));
                    ocp.setNestedTableProperties(ntp);
                    this.v$col.setProperty("OracleColumnProperties", (Object)ocp);
                }
            }
            catch (SQLException e) {
                this.v$cuWrap.throwDBException(e);
            }
        }

        public 3(OracleRelationBuilder oracleRelationBuilder, Column column, QueryWrapper queryWrapper) {
            this.v$cuWrap = queryWrapper;
            this.v$col = column;
            this.this$0 = oracleRelationBuilder;
        }
    }

    final class 4
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Relation v$relation;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleRelationBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                HashMap<String, ConstraintData> data = new HashMap<String, ConstraintData>();
                while (rs.next()) {
                    String conName = rs.getString(1);
                    ConstraintData con = (ConstraintData)data.get(conName);
                    if (con == null) {
                        con = this.this$0.new ConstraintData(conName, rs);
                        data.put(conName, con);
                    }
                    String colName = rs.getString(9);
                    if (ConstraintData.mav$isInvisibleFK(con)) {
                        ConstraintData.wa$m_ignore(con, true);
                    }
                    if (colName.startsWith("SYS_NC")) {
                        ConstraintData.wa$m_ignore(con, true);
                        continue;
                    }
                    if (rs.wasNull()) continue;
                    ConstraintData.mav$addColumn(con, colName);
                }
                ArrayList<Constraint> cons = new ArrayList<Constraint>(data.size());
                for (ConstraintData cd : data.values()) {
                    Constraint con;
                    if (ConstraintData.ra$m_ignore(cd) || (con = ConstraintData.mav$createConstraint(cd, this.v$relation)) == null) continue;
                    cons.add(con);
                }
                this.v$relation.setConstraints(cons.toArray(new Constraint[cons.size()]));
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$relation, ex);
            }
        }

        public 4(OracleRelationBuilder oracleRelationBuilder, Relation relation, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$relation = relation;
            this.this$0 = oracleRelationBuilder;
        }
    }

    private class ConstraintData {
        private String m_cName;
        private char m_cType;
        private String m_cond;
        private String m_rSchemaName;
        private String m_rConstraintName;
        private String m_rRelationType;
        private String m_rRelationName;
        private Object m_rRelationObjectID;
        private int m_dRule;
        private boolean m_status;
        private boolean m_generated;
        private List<String> m_cols;
        private boolean m_ignore;

        private void $init$() {
            this.m_cols = new ArrayList<String>();
            this.m_ignore = false;
        }

        ConstraintData(String name, ResultSet rs) throws SQLException {
            this.$init$();
            this.m_cName = name;
            String cType = rs.getString("CONSTRAINT_TYPE");
            this.m_cType = ModelUtil.hasLength((String)cType) ? cType.charAt(0) : (char)'\u0000';
            switch (this.m_cType) {
                case 'C': {
                    this.m_cond = rs.getString("SEARCH_CONDITION");
                    break;
                }
                case 'P': 
                case 'U': {
                    break;
                }
                case 'R': {
                    this.m_rSchemaName = rs.getString("R_OWNER");
                    this.m_rConstraintName = rs.getString("R_CONSTRAINT_NAME");
                    this.m_rRelationObjectID = rs.getObject("ref_relation_object_id");
                    this.m_rRelationType = rs.getString("ref_relation_type");
                    this.m_rRelationName = rs.getString("ref_relation_name");
                    this.m_dRule = OracleRelationBuilder.maS$_translateDeleteAction(rs.getString("DELETE_RULE"));
                    break;
                }
                default: {
                    this.m_cType = '\u0000';
                }
            }
            String enabled = rs.getString("STATUS");
            this.m_status = "ENABLED".equals(enabled);
            String generated = rs.getString("GENERATED");
            this.m_generated = "GENERATED NAME".equals(generated);
        }

        private boolean isInvisibleFK() {
            return this.m_cType == 'R' && !this.isVisibleFK();
        }

        private boolean isVisibleFK() {
            return this.m_rSchemaName != null && this.m_rRelationName != null && this.m_rRelationType != null;
        }

        private void addColumn(String cName) {
            this.m_cols.add(cName);
        }

        private Constraint createConstraint(Relation relation) throws SQLException, DBException {
            CheckConstraint con = null;
            switch (this.m_cType) {
                case 'C': {
                    con = this.createCheckConstraint(relation);
                    break;
                }
                case 'P': 
                case 'U': {
                    con = this.createUniqueConstraint(relation);
                    break;
                }
                case 'R': {
                    con = this.createFK(relation);
                    break;
                }
                default: {
                    con = null;
                }
            }
            if (con != null) {
                BaseOracleDatabase db = OracleRelationBuilder.this.getDatabase();
                con.setID((DBObjectID)new NameBasedID((DBObject)con, relation.getID()));
                con.setEnabled(this.m_status);
            }
            return con;
        }

        private CheckConstraint createCheckConstraint(Relation relation) {
            String colName;
            Column col;
            if (this.m_cond == null) {
                return null;
            }
            this.m_cond = this.m_cond.trim();
            if (this.m_generated && this.m_cols.size() == 1 && (col = relation.getColumn(colName = this.m_cols.get(0))) != null && col.isNotNull() && MessageFormat.format(OracleRelationBuilder.maS$getNotNullText(OracleRelationBuilder.this.getDatabase().getOracleDatabaseType()), colName).equals(this.m_cond)) {
                return null;
            }
            CheckConstraint con = new CheckConstraint(this.m_cName, relation);
            con.setCheckCondition(this.m_cond);
            return con;
        }

        private void setConstraintColumns(ColumnConstraint con, Relation relation) {
            DBObjectID relID = relation.getID();
            if (relID == null) {
                String[] colNames = this.m_cols.toArray(new String[this.m_cols.size()]);
                int count = 0;
                Column[] cols = new Column[colNames.length];
                int i = 0;
                while (i < colNames.length) {
                    Column col = relation.getColumn(colNames[i]);
                    if (col != null) {
                        cols[count++] = col;
                    }
                    ++i;
                }
                if (count < cols.length) {
                    Column[] tmp = cols;
                    cols = new Column[count];
                    System.arraycopy(tmp, 0, cols, 0, count);
                }
                con.setColumns(cols);
            } else {
                DBObjectID[] ids = new DBObjectID[this.m_cols.size()];
                int i = 0;
                while (i < ids.length) {
                    ids[i] = new NameBasedID("COLUMN", this.m_cols.get(i), relID);
                    ++i;
                }
                con.setColumnIDs(ids);
            }
        }

        private UniqueConstraint createUniqueConstraint(Relation relation) {
            PKConstraint con = this.m_cType == 'P' ? new PKConstraint(this.m_cName, relation) : new UniqueConstraint(this.m_cName, relation);
            this.setConstraintColumns((ColumnConstraint)con, relation);
            return con;
        }

        private FKConstraint createFK(Relation relation) throws SQLException, DBException {
            FKConstraint fk = new FKConstraint(this.m_cName, relation);
            this.setConstraintColumns((ColumnConstraint)fk, relation);
            fk.setDeleteMode(this.m_dRule);
            BaseOracleDatabase database = OracleRelationBuilder.this.getDatabase();
            if (this.isVisibleFK()) {
                Schema refSchema = database.getSchema(this.m_rSchemaName);
                DBObjectID refRelationID = database.createID(refSchema, this.m_rRelationName, this.m_rRelationType, this.m_rRelationObjectID);
                NameBasedID refConstraintID = new NameBasedID("CONSTRAINT", this.m_rConstraintName, refRelationID);
                fk.setReferenceID((DBObjectID)refConstraintID);
            }
            return fk;
        }

        static boolean mav$isInvisibleFK(ConstraintData constraintData) {
            return constraintData.isInvisibleFK();
        }

        static void wa$m_ignore(ConstraintData constraintData, boolean bl) {
            constraintData.m_ignore = bl;
        }

        static void mav$addColumn(ConstraintData constraintData, String string) {
            constraintData.addColumn(string);
        }

        static boolean ra$m_ignore(ConstraintData constraintData) {
            return constraintData.m_ignore;
        }

        static Constraint mav$createConstraint(ConstraintData constraintData, Relation relation) {
            return constraintData.createConstraint(relation);
        }
    }
}

