/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;

class OracleSequenceBuilder
extends OracleDBObjectBuilder {
    OracleSequenceBuilder(BaseOracleDatabase db) {
        super(db, "SEQUENCE");
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        Sequence seq = new Sequence(name, schema);
        seq.setID(id);
        return seq;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        Sequence seq = (Sequence)object;
        QueryWrapper wrap = this.newQueryWrapper(this.getNameQuery(), seq.getSchema(), seq);
        1 r = new 1(this, seq, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
    }

    private void createSequence(Sequence seq, BigDecimal min, BigDecimal max, BigDecimal inc, String cycle, String order, BigDecimal cache, BigDecimal last) {
        BigInteger biMin = min == null ? null : min.toBigInteger();
        BigInteger biMax = max == null ? null : max.toBigInteger();
        BigInteger biInc = inc == null ? null : inc.toBigInteger();
        BigInteger biLast = last == null ? null : last.toBigInteger();
        BigInteger biCache = null;
        if (cache.intValue() == 0) {
            seq.setCacheFlag(Boolean.valueOf(false));
        } else {
            seq.setCacheFlag(Boolean.valueOf(true));
            biCache = cache.toBigInteger();
        }
        seq.setMinValue(biMin);
        seq.setMaxValue(biMax);
        seq.setIncrementBy(biInc);
        seq.setCycleFlag(Boolean.valueOf("Y".equalsIgnoreCase(cycle)));
        seq.setOrderFlag(Boolean.valueOf("Y".equalsIgnoreCase(order)));
        seq.setCacheSize(biCache);
        seq.setLastNumber(biLast);
    }

    private String getNameQuery() {
        return this.getDatabase().getOracleDatabaseType() == 9 ? "SELECT /*OracleDictionaryQueries.ALL_OLITE_SEQUENCE_QUERY*/\n       MIN_VALUE, MAX_VALUE, INCREMENT_BY, NULL, NULL, NULL, NULL FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ?" : "SELECT /*OracleDictionaryQueries.ALL_ORACLE_SEQUENCE_QUERY*/\n       MIN_VALUE, MAX_VALUE, INCREMENT_BY, CYCLE_FLAG, ORDER_FLAG, CACHE_SIZE, LAST_NUMBER FROM SYS.ALL_SEQUENCES S WHERE SEQUENCE_OWNER = ? AND SEQUENCE_NAME = ? ";
    }

    static void mav$createSequence(OracleSequenceBuilder oracleSequenceBuilder, Sequence sequence, BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, String string, String string2, BigDecimal bigDecimal4, BigDecimal bigDecimal5) {
        oracleSequenceBuilder.createSequence(sequence, bigDecimal, bigDecimal2, bigDecimal3, string, string2, bigDecimal4, bigDecimal5);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Sequence v$seq;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleSequenceBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    BigDecimal min = rs.getBigDecimal(1);
                    BigDecimal max = rs.getBigDecimal(2);
                    BigDecimal inc = rs.getBigDecimal(3);
                    String cycle = rs.getString(4);
                    String order = rs.getString(5);
                    BigDecimal cache = rs.getBigDecimal(6);
                    BigDecimal last = rs.getBigDecimal(7);
                    OracleSequenceBuilder.mav$createSequence(this.this$0, this.v$seq, min, max, inc, cycle, order, cache, last);
                }
            }
            catch (SQLException ex) {
                this.v$wrap.throwDBException((DBObject)this.v$seq, ex);
            }
        }

        public 1(OracleSequenceBuilder oracleSequenceBuilder, Sequence sequence, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$seq = sequence;
            this.this$0 = oracleSequenceBuilder;
        }
    }
}

