/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.QueryWrapper;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Synonym;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.OracleDBObjectBuilder;
import oracle.javatools.db.ora.OracleLite;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

class OracleSynonymBuilder
extends OracleDBObjectBuilder {
    OracleSynonymBuilder(BaseOracleDatabase db) {
        super(db, "SYNONYM");
    }

    public SchemaObject createObject(String name, Schema schema, DBObjectID id) {
        Synonym syn = new Synonym(name, schema, null);
        syn.setID(id);
        syn.setPublic(ModelUtil.areEqual((Object)this.getDatabase().getPublicSchema(), (Object)schema));
        return syn;
    }

    protected void fillInObject(SchemaObject object) throws DBException {
        Synonym synonym = (Synonym)object;
        Holder firstQueryWorked = new Holder((Object)false);
        QueryWrapper wrap = this.getQueryWrapper(synonym);
        1 r = new 1(this, firstQueryWorked, synonym, wrap);
        wrap.executeQuery((QueryWrapper.QueryRunnable)r);
        if (!((Boolean)firstQueryWorked.get()).booleanValue()) {
            QueryWrapper wrap2 = this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_NAME_AND_TYPE_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, S.DB_LINK  FROM  SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ? ", synonym.getSchema(), synonym);
            2 r2 = new 2(this, synonym, wrap2);
            wrap2.executeQuery((QueryWrapper.QueryRunnable)r2);
        }
    }

    private void populateSynonym(Synonym synonym, String refSchemaName, String refObjectName, String refDatabaseLink, String refObjectType, Object refobjectID) throws DBException {
        BaseOracleDatabase db = this.getDatabase();
        Schema refSchema = refSchemaName == null ? null : db.getSchema(refSchemaName);
        ReferenceID refID = refobjectID == null ? new ReferenceID(null, refSchema, refObjectName, refDatabaseLink) : db.createID(refSchema, refObjectName, refObjectType, refobjectID);
        synonym.setReference((DBObjectID)refID);
    }

    private QueryWrapper getQueryWrapper(Synonym synonym) {
        if (this.getDatabase() instanceof OracleLite) {
            return this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_OLITE_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, 'TABLE', NULL, S.DB_LINK  FROM  SYS.ALL_TABLES REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.TABLE_NAME UNION\n SELECT S.TABLE_OWNER, S.TABLE_NAME, 'VIEW', NULL, S.DB_LINK  FROM  SYS.ALL_VIEWS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.VIEW_NAME", synonym.getSchema(), synonym, synonym.getSchema(), synonym);
        }
        return this.newQueryWrapper("SELECT /*OracleDictionaryQueries.ALL_SYNONYM_REF_OBJECT_QUERY*/\n       S.TABLE_OWNER, S.TABLE_NAME, REF.OBJECT_TYPE, REF.OBJECT_ID,        S.DB_LINK  FROM  SYS.ALL_OBJECTS REF, SYS.ALL_SYNONYMS S  WHERE S.OWNER        = ?  AND   S.SYNONYM_NAME = ?  AND   S.TABLE_OWNER  = REF.OWNER AND   S.TABLE_NAME   = REF.OBJECT_NAME", synonym.getSchema(), synonym);
    }

    static void mav$populateSynonym(OracleSynonymBuilder oracleSynonymBuilder, Synonym synonym, String string, String string2, String string3, String string4, Object object) {
        oracleSynonymBuilder.populateSynonym(synonym, string, string2, string3, string4, object);
    }

    final class 1
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Holder v$firstQueryWorked;
        private final /* synthetic */ Synonym v$synonym;
        private final /* synthetic */ QueryWrapper v$wrap;
        final /* synthetic */ OracleSynonymBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    this.v$firstQueryWorked.set((Object)true);
                    String refSchemaName = rs.getString(1);
                    String refObjectName = rs.getString(2);
                    String refObjectType = rs.getString(3);
                    Object refobjectID = rs.getObject(4);
                    String refDatabaseLink = rs.getString(5);
                    OracleSynonymBuilder.mav$populateSynonym(this.this$0, this.v$synonym, refSchemaName, refObjectName, refDatabaseLink, refObjectType, refobjectID);
                }
            }
            catch (SQLException sqe) {
                this.v$wrap.throwDBException((DBObject)this.v$synonym, sqe);
            }
        }

        public 1(OracleSynonymBuilder oracleSynonymBuilder, Holder holder, Synonym synonym, QueryWrapper queryWrapper) {
            this.v$wrap = queryWrapper;
            this.v$synonym = synonym;
            this.v$firstQueryWorked = holder;
            this.this$0 = oracleSynonymBuilder;
        }
    }

    final class 2
    implements QueryWrapper.QueryRunnable {
        private final /* synthetic */ Synonym v$synonym;
        private final /* synthetic */ QueryWrapper v$wrap2;
        final /* synthetic */ OracleSynonymBuilder this$0;

        public void processResultSet(ResultSet rs) throws DBException {
            try {
                if (rs.next()) {
                    String refSchemaName = rs.getString(1);
                    String refObjectName = rs.getString(2);
                    String refDatabaseLink = rs.getString(3);
                    OracleSynonymBuilder.mav$populateSynonym(this.this$0, this.v$synonym, refSchemaName, refObjectName, refDatabaseLink, null, null);
                }
            }
            catch (SQLException ex) {
                this.v$wrap2.throwDBException((DBObject)this.v$synonym, ex);
            }
        }

        public 2(OracleSynonymBuilder oracleSynonymBuilder, Synonym synonym, QueryWrapper queryWrapper) {
            this.v$wrap2 = queryWrapper;
            this.v$synonym = synonym;
            this.this$0 = oracleSynonymBuilder;
        }
    }
}

